/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.opplugin.validate.activity.template;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.tdc.oatr.common.bo.gridtemplate.GridBlockInfo;
import kd.tdc.oatr.common.bo.talentmap.MapBlockRatioInfo;
import kd.tdc.oatr.common.bo.talentmap.TalentMapConfigInfo;
import kd.tdc.oatr.common.constants.enums.ActivityStatusEnum;
import kd.tdc.oatr.common.constants.enums.MapAxisValueTypeEnum;

public class ReviewActivityTplTalMapValidator
extends HRDataBaseValidator {
    private static final String TYPE_NUMBER_VALUE_ERROR = "numberValueError";
    private static final String TYPE_NUMBER_PERCENT_OVER = "numberPercentOver";
    private static final String TYPE_DIVIDE_SCALE_OVER_LENGTH_ERROR = "divideScaleOverLengthError";
    private static final String TYPE_RATIO_OVER_LENGTH_ERROR = "ratioOverLengthError";
    private static final String TYPE_DIVIDE_SCALE_REPEAT_ERROR = "divideScaleRepeatError";
    private static final String TYPE_NUMBER_SIZE_ERROR = "numberSizeError";
    private static final String TYPE_NAME_OVER_LENGTH_ERROR = "nameOverLengthError";
    private static final String TYPE_DESC_OVER_LENGTH_ERROR = "descOverLengthError";

    public void validate() {
        ExtendedDataEntity[] dataEntities;
        super.validate();
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            DynamicObject entityObj = dataEntity.getDataEntity();
            String formId = dataEntity.getDataEntity().getDataEntityType().getName();
            ArrayList activityFormIdList = Lists.newArrayListWithExpectedSize((int)5);
            activityFormIdList.add("oatr_reviewactivity");
            activityFormIdList.add("oatr_colreviewactivity");
            if (formId.equals("oatr_reviewactivitytpl") && this.tplShouldDoValidate(entityObj)) {
                this.tplMustInputValidate(dataEntity);
            } else if (activityFormIdList.contains(formId) && this.actShouldDoValidate(entityObj)) {
                this.actvMustInputValidate(dataEntity);
            }
            this.valueEffectiveValidate(dataEntity);
        }
    }

    private void tplMustInputValidate(ExtendedDataEntity dataEntity) {
        DynamicObjectCollection talentMapEntry = dataEntity.getDataEntity().getDynamicObjectCollection("talentmapentry");
        ArrayList emptyValueFields = Lists.newArrayList();
        ArrayList validateFields = Lists.newArrayListWithExpectedSize((int)10);
        validateFields.add("referstrategy");
        validateFields.add("gridtemplate");
        validateFields.add("xaxisdim");
        validateFields.add("yaxisdim");
        this.validateBasicInfoIsEmpty(talentMapEntry, validateFields, emptyValueFields);
        this.validateTalentMapInfoIsEmpty(talentMapEntry, emptyValueFields);
        this.setMustInputErrorMsg(dataEntity, emptyValueFields);
    }

    private void actvMustInputValidate(ExtendedDataEntity dataEntity) {
        DynamicObjectCollection talentMapEntry = dataEntity.getDataEntity().getDynamicObjectCollection("talentmapentry");
        ArrayList emptyValueFields = Lists.newArrayList();
        ArrayList validateFields = Lists.newArrayListWithExpectedSize((int)10);
        validateFields.add("gridtemplate");
        validateFields.add("xaxisdim");
        validateFields.add("yaxisdim");
        this.validateBasicInfoIsEmpty(talentMapEntry, validateFields, emptyValueFields);
        this.validateTalentMapInfoIsEmpty(talentMapEntry, emptyValueFields);
        this.setMustInputErrorMsg(dataEntity, emptyValueFields);
    }

    private boolean tplShouldDoValidate(DynamicObject templateDy) {
        boolean enable = templateDy.getBoolean("enable");
        return enable || this.getOperateKey().equals("enable");
    }

    private boolean actShouldDoValidate(DynamicObject templateDy) {
        if (this.getOperateKey().equals("start")) {
            return true;
        }
        String activityStatus = templateDy.getString("activitystatus");
        return HRStringUtils.equals((String)activityStatus, (String)ActivityStatusEnum.GOING.getCode());
    }

    private void setMustInputErrorMsg(ExtendedDataEntity dataEntity, List<String> emptyValueFields) {
        if (CollectionUtils.isEmpty(emptyValueFields)) {
            return;
        }
        String referStrategyName = ResManager.loadKDString((String)"\u201c\u662f\u5426\u5141\u8bb8\u5728\u76d8\u70b9\u6d3b\u52a8\u4e2d\u8c03\u6574\u201d", (String)"ReviewActivityTplTalentMapValidator_1", (String)"tdc-oatr-opplugin", (Object[])new Object[0]);
        String gridTemplateName = ResManager.loadKDString((String)"\u201c\u5bab\u683c\u7c7b\u578b\u201d", (String)"ReviewActivityTplTalentMapValidator_2", (String)"tdc-oatr-opplugin", (Object[])new Object[0]);
        String xAxisDimName = ResManager.loadKDString((String)"\u201c\u6a2a\u8f74\u201d", (String)"ReviewActivityTplTalentMapValidator_3", (String)"tdc-oatr-opplugin", (Object[])new Object[0]);
        String yAxisDimName = ResManager.loadKDString((String)"\u201c\u7eb5\u8f74\u201d", (String)"ReviewActivityTplTalentMapValidator_4", (String)"tdc-oatr-opplugin", (Object[])new Object[0]);
        String divideScaleName = ResManager.loadKDString((String)"\u201c\u5212\u7ebf\u6807\u51c6\u201d", (String)"ReviewActivityTplTalentMapValidator_5", (String)"tdc-oatr-opplugin", (Object[])new Object[0]);
        String customNumberName = ResManager.loadKDString((String)"\u201c\u5bab\u683c\u5e8f\u53f7\u201d", (String)"ReviewActivityTplTalentMapValidator_11", (String)"tdc-oatr-opplugin", (Object[])new Object[0]);
        String gridName = ResManager.loadKDString((String)"\u201c\u5bab\u683c\u540d\u79f0\u201d", (String)"ReviewActivityTplTalentMapValidator_12", (String)"tdc-oatr-opplugin", (Object[])new Object[0]);
        StringBuilder emptyNames = new StringBuilder();
        String dotChar = ResManager.loadKDString((String)"\u3001", (String)"ReviewActivityTplTalentMapValidator_15", (String)"tdc-oatr-opplugin", (Object[])new Object[0]);
        if (emptyValueFields.contains("referstrategy")) {
            emptyNames.append(referStrategyName).append(dotChar);
        }
        if (emptyValueFields.contains("gridtemplate")) {
            emptyNames.append(gridTemplateName).append(dotChar);
        }
        if (emptyValueFields.contains("xaxisdim")) {
            emptyNames.append(xAxisDimName).append(dotChar);
        }
        if (emptyValueFields.contains("yaxisdim")) {
            emptyNames.append(yAxisDimName).append(dotChar);
        }
        if (emptyValueFields.contains("divideScale")) {
            emptyNames.append(divideScaleName).append(dotChar);
        }
        if (emptyValueFields.contains("customNumber")) {
            emptyNames.append(customNumberName).append(dotChar);
        }
        if (emptyValueFields.contains("gridName")) {
            emptyNames.append(gridName).append(dotChar);
        }
        if (HRStringUtils.isNotEmpty((String)emptyNames.toString())) {
            emptyNames.deleteCharAt(emptyNames.length() - 1);
            String errorMsg = ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199{0}\u3002", (String)"ReviewActivityTplTalentMapValidator_0", (String)"tdc-oatr-opplugin", (Object[])new Object[]{emptyNames.toString()});
            this.addErrorMessage(dataEntity, errorMsg);
        }
    }

    private void validateBasicInfoIsEmpty(DynamicObjectCollection talentMapEntry, List<String> validateFields, List<String> emptyValueFields) {
        boolean isReferStrategyEmpty = false;
        boolean isGridTemplateEmpty = false;
        boolean isxAxisDimEmpty = false;
        boolean isyAxisDimEmpty = false;
        for (DynamicObject entry : talentMapEntry) {
            String referStrategy = entry.getString("referstrategy");
            if (validateFields.contains("referstrategy") && !isReferStrategyEmpty && HRStringUtils.isEmpty((String)referStrategy)) {
                emptyValueFields.add("referstrategy");
                isReferStrategyEmpty = true;
            }
            DynamicObject gridTemplate = entry.getDynamicObject("gridtemplate");
            if (validateFields.contains("gridtemplate") && !isGridTemplateEmpty && HRObjectUtils.isEmpty((Object)gridTemplate)) {
                emptyValueFields.add("gridtemplate");
                isGridTemplateEmpty = true;
            }
            DynamicObject xAxisDim = entry.getDynamicObject("xaxisdim");
            if (validateFields.contains("xaxisdim") && !isxAxisDimEmpty && HRObjectUtils.isEmpty((Object)xAxisDim)) {
                emptyValueFields.add("xaxisdim");
                isxAxisDimEmpty = true;
            }
            DynamicObject yAxisDim = entry.getDynamicObject("yaxisdim");
            if (!validateFields.contains("yaxisdim") || isyAxisDimEmpty || !HRObjectUtils.isEmpty((Object)yAxisDim)) continue;
            emptyValueFields.add("yaxisdim");
            isyAxisDimEmpty = true;
        }
    }

    private void validateTalentMapInfoIsEmpty(DynamicObjectCollection talentMapEntry, List<String> emptyValueFields) {
        boolean scaleValueIsEmpty = false;
        for (DynamicObject mapEntry : talentMapEntry) {
            List gridBlocks;
            String[] values;
            if (scaleValueIsEmpty) break;
            String talentMapConfigData = mapEntry.getString("talentmapconfig_tag");
            if (HRStringUtils.isEmpty((String)talentMapConfigData)) continue;
            TalentMapConfigInfo talentMapConfigInfo = (TalentMapConfigInfo)SerializationUtils.fromJsonString((String)talentMapConfigData, TalentMapConfigInfo.class);
            for (String value : values = talentMapConfigInfo.getxAxisInfo().getDivideScale().getValues()) {
                if (!HRStringUtils.isEmpty((String)value)) continue;
                emptyValueFields.add("divideScale");
                scaleValueIsEmpty = true;
                break;
            }
            for (String value : values = talentMapConfigInfo.getyAxisInfo().getDivideScale().getValues()) {
                if (scaleValueIsEmpty) break;
                if (!HRStringUtils.isEmpty((String)value)) continue;
                emptyValueFields.add("divideScale");
                scaleValueIsEmpty = true;
            }
            if (CollectionUtils.isEmpty((Collection)(gridBlocks = talentMapConfigInfo.getGridData().getGridBlocks()))) {
                return;
            }
            boolean customNumberIsEmpty = false;
            boolean gridNameIsEmpty = false;
            for (GridBlockInfo gridBlock : gridBlocks) {
                String customNumber = gridBlock.getCustomNumber();
                String gridName = gridBlock.getName().getText();
                if (!customNumberIsEmpty && HRStringUtils.isEmpty((String)customNumber)) {
                    emptyValueFields.add("customNumber");
                    customNumberIsEmpty = true;
                    continue;
                }
                if (gridNameIsEmpty || !HRStringUtils.isEmpty((String)gridName)) continue;
                emptyValueFields.add("gridName");
                gridNameIsEmpty = true;
            }
        }
    }

    private void valueEffectiveValidate(ExtendedDataEntity dataEntity) {
        DynamicObjectCollection talentMapEntry = dataEntity.getDataEntity().getDynamicObjectCollection("talentmapentry");
        if (talentMapEntry.isEmpty()) {
            return;
        }
        ArrayList customErrorType = Lists.newArrayListWithExpectedSize((int)10);
        this.validateTalentMapInfoEffective(talentMapEntry, customErrorType);
        this.setEffectiveErrorMsg(dataEntity, customErrorType);
    }

    private void setEffectiveErrorMsg(ExtendedDataEntity dataEntity, List<String> customErrorType) {
        String numberValueErrorMsg = ResManager.loadKDString((String)"\u6570\u5b57\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"ReviewActivityTplTalentMapValidator_6", (String)"tdc-oatr-opplugin", (Object[])new Object[0]);
        String divideScaleOverLengthErrorMsg = ResManager.loadKDString((String)"\u5b57\u6bb5\u201c\u5212\u7ebf\u6807\u51c6\u201d\u8f93\u5165\u957f\u5ea6\u8d85\u51fa\u9650\u5b9a\u8303\u56f4\u3002", (String)"ReviewActivityTplTalentMapValidator_7", (String)"tdc-oatr-opplugin", (Object[])new Object[0]);
        String divideScaleRepeatErrorMsg = ResManager.loadKDString((String)"\u5212\u7ebf\u6807\u51c6\u91cd\u590d\u3002", (String)"ReviewActivityTplTalentMapValidator_16", (String)"tdc-oatr-opplugin", (Object[])new Object[0]);
        String ratioOverLengthErrorMsg = ResManager.loadKDString((String)"\u5b57\u6bb5\u201c\u5206\u5e03\u6bd4\u4f8b\u201d\u8f93\u5165\u957f\u5ea6\u8d85\u51fa\u9650\u5b9a\u8303\u56f4\u3002", (String)"ReviewActivityTplTalentMapValidator_10", (String)"tdc-oatr-opplugin", (Object[])new Object[0]);
        String numberSizeErrorMsg = ResManager.loadKDString((String)"\u8bf7\u6309\u4ece\u5c0f\u5230\u5927\u7684\u987a\u5e8f\u8f93\u5165\u5212\u7ebf\u6807\u51c6\u503c\u3002", (String)"ReviewActivityTplTalentMapValidator_8", (String)"tdc-oatr-opplugin", (Object[])new Object[0]);
        String numberPercentOverMsg = ResManager.loadKDString((String)"\u5b57\u6bb5\u201c\u5206\u5e03\u6bd4\u4f8b\u201d\u603b\u6bd4\u4f8b\u4e0d\u80fd\u8d85\u8fc7100%\u3002", (String)"ReviewActivityTplTalentMapValidator_9", (String)"tdc-oatr-opplugin", (Object[])new Object[0]);
        String gridNameOverLengthErrorMsg = ResManager.loadKDString((String)"\u5b57\u6bb5\u201c\u5bab\u683c\u540d\u79f0\u201d\u8f93\u5165\u957f\u5ea6\u8d85\u51fa\u9650\u5b9a\u8303\u56f4\u3002", (String)"ReviewActivityTplTalentMapValidator_13", (String)"tdc-oatr-opplugin", (Object[])new Object[0]);
        String gridDescOverLengthErrorMsg = ResManager.loadKDString((String)"\u5b57\u6bb5\u201c\u5bab\u683c\u63cf\u8ff0\u201d\u8f93\u5165\u957f\u5ea6\u8d85\u51fa\u9650\u5b9a\u8303\u56f4\u3002", (String)"ReviewActivityTplTalentMapValidator_14", (String)"tdc-oatr-opplugin", (Object[])new Object[0]);
        if (customErrorType.contains(TYPE_NUMBER_VALUE_ERROR)) {
            this.addErrorMessage(dataEntity, numberValueErrorMsg);
            return;
        }
        if (customErrorType.contains(TYPE_DIVIDE_SCALE_OVER_LENGTH_ERROR)) {
            this.addErrorMessage(dataEntity, divideScaleOverLengthErrorMsg);
        }
        if (customErrorType.contains(TYPE_DIVIDE_SCALE_REPEAT_ERROR)) {
            this.addErrorMessage(dataEntity, divideScaleRepeatErrorMsg);
        }
        if (customErrorType.contains(TYPE_RATIO_OVER_LENGTH_ERROR)) {
            this.addErrorMessage(dataEntity, ratioOverLengthErrorMsg);
        }
        if (customErrorType.contains(TYPE_NUMBER_SIZE_ERROR)) {
            this.addErrorMessage(dataEntity, numberSizeErrorMsg);
        }
        if (customErrorType.contains(TYPE_NUMBER_PERCENT_OVER)) {
            this.addErrorMessage(dataEntity, numberPercentOverMsg);
        }
        if (customErrorType.contains(TYPE_NAME_OVER_LENGTH_ERROR)) {
            this.addErrorMessage(dataEntity, gridNameOverLengthErrorMsg);
        }
        if (customErrorType.contains(TYPE_DESC_OVER_LENGTH_ERROR)) {
            this.addErrorMessage(dataEntity, gridDescOverLengthErrorMsg);
        }
    }

    private void validateTalentMapInfoEffective(DynamicObjectCollection talentMapEntry, List<String> customErrorType) {
        for (DynamicObject mapEntry : talentMapEntry) {
            String talentMapConfigData = mapEntry.getString("talentmapconfig_tag");
            if (HRStringUtils.isEmpty((String)talentMapConfigData)) continue;
            TalentMapConfigInfo talentMapConfigInfo = (TalentMapConfigInfo)SerializationUtils.fromJsonString((String)talentMapConfigData, TalentMapConfigInfo.class);
            String type = talentMapConfigInfo.getxAxisInfo().getValueType().getType();
            String[] values = talentMapConfigInfo.getxAxisInfo().getDivideScale().getValues();
            this.valueTypeValidator(customErrorType, type, values);
            type = talentMapConfigInfo.getyAxisInfo().getValueType().getType();
            values = talentMapConfigInfo.getyAxisInfo().getDivideScale().getValues();
            this.valueTypeValidator(customErrorType, type, values);
            MapBlockRatioInfo[] ratioInfos = talentMapConfigInfo.getDistributionRatio().getValues();
            this.ratioValidator(customErrorType, ratioInfos);
            List gridBlocks = talentMapConfigInfo.getGridData().getGridBlocks();
            this.nameDescValidator(customErrorType, gridBlocks);
        }
    }

    private void nameDescValidator(List<String> customErrorType, List<GridBlockInfo> gridBlocks) {
        if (CollectionUtils.isEmpty(gridBlocks)) {
            return;
        }
        boolean nameOverLength = false;
        boolean descOverLength = false;
        for (GridBlockInfo gridBlock : gridBlocks) {
            String gridName = gridBlock.getName().getText();
            String gridDesc = gridBlock.getDesc().getText();
            if (!nameOverLength && HRStringUtils.isNotEmpty((String)gridName) && gridName.length() > 100) {
                customErrorType.add(TYPE_NAME_OVER_LENGTH_ERROR);
                nameOverLength = true;
                continue;
            }
            if (descOverLength || !HRStringUtils.isNotEmpty((String)gridDesc) || gridDesc.length() <= 255) continue;
            customErrorType.add(TYPE_DESC_OVER_LENGTH_ERROR);
            descOverLength = true;
        }
    }

    private void ratioValidator(List<String> customErrorType, MapBlockRatioInfo[] ratioInfos) {
        String[] values = new String[1];
        double sum = 0.0;
        for (MapBlockRatioInfo ratioInfo : ratioInfos) {
            String[] splitNumber;
            String valueOnlyNum;
            String ratio = ratioInfo.getRatio().replace("%", "");
            if (HRStringUtils.isEmpty((String)ratio)) continue;
            values[0] = ratio;
            boolean isNum = this.validateIsNumber(values);
            if (!isNum) {
                customErrorType.add(TYPE_NUMBER_VALUE_ERROR);
                return;
            }
            double percentVal = Double.parseDouble(ratio);
            if ((sum += percentVal) > 100.0) {
                customErrorType.add(TYPE_NUMBER_PERCENT_OVER);
            }
            if ((valueOnlyNum = ratio.replace(".", "")).length() > 23) {
                customErrorType.add(TYPE_RATIO_OVER_LENGTH_ERROR);
            }
            if ((splitNumber = ratio.split("\\.")).length != 2 || splitNumber[1].length() <= 2) continue;
            customErrorType.add(TYPE_RATIO_OVER_LENGTH_ERROR);
        }
    }

    private void valueTypeValidator(List<String> customErrorType, String type, String[] values) {
        if (type.equals(MapAxisValueTypeEnum.SCORE.getValue())) {
            this.scoreValueValidate(values, customErrorType);
        }
        if (type.equals(MapAxisValueTypeEnum.PERCENT.getValue())) {
            this.percentValueValidate(customErrorType, values);
        }
        if (type.equals(MapAxisValueTypeEnum.GRADE.getValue())) {
            this.gradeValueValidate(customErrorType, values);
        }
    }

    private void gradeValueValidate(List<String> customErrorType, String[] values) {
        boolean isPass = this.validateValueLength(values, MapAxisValueTypeEnum.GRADE);
        if (!isPass) {
            customErrorType.add(TYPE_DIVIDE_SCALE_OVER_LENGTH_ERROR);
        }
        if (!(isPass = this.validateValueIsRepeat(values))) {
            customErrorType.add(TYPE_DIVIDE_SCALE_REPEAT_ERROR);
        }
    }

    private boolean validateValueIsRepeat(String[] values) {
        ArrayList<String> valueList = new ArrayList<String>(values.length);
        for (String value : values) {
            if (!value.contains(",") && HRStringUtils.isNotEmpty((String)value)) {
                valueList.add(value);
                continue;
            }
            String[] mulValues = value.split(",");
            valueList.addAll(Arrays.asList(mulValues));
            valueList.removeIf(HRStringUtils::isEmpty);
        }
        HashSet valueSet = new HashSet(valueList);
        return valueSet.size() >= valueList.size();
    }

    private void percentValueValidate(List<String> customErrorType, String[] values) {
        String[] newValues = (String[])Arrays.stream(values).map(value -> value.replace("%", "")).toArray(String[]::new);
        boolean isNum = this.validateIsNumber(newValues);
        if (!isNum) {
            customErrorType.add(TYPE_NUMBER_VALUE_ERROR);
            return;
        }
        boolean isPass = this.validateValueLength(newValues, MapAxisValueTypeEnum.PERCENT);
        if (!isPass) {
            customErrorType.add(TYPE_DIVIDE_SCALE_OVER_LENGTH_ERROR);
        }
        if (!(isPass = this.validateNumberSmallToLarge(newValues))) {
            customErrorType.add(TYPE_NUMBER_SIZE_ERROR);
        }
    }

    private void scoreValueValidate(String[] values, List<String> customErrorType) {
        boolean isNum = this.validateIsNumber(values);
        if (!isNum) {
            customErrorType.add(TYPE_NUMBER_VALUE_ERROR);
            return;
        }
        boolean isPass = this.validateValueLength(values, MapAxisValueTypeEnum.SCORE);
        if (!isPass) {
            customErrorType.add(TYPE_DIVIDE_SCALE_OVER_LENGTH_ERROR);
        }
        if (!(isPass = this.validateNumberSmallToLarge(values))) {
            customErrorType.add(TYPE_NUMBER_SIZE_ERROR);
        }
    }

    private boolean validateValueLength(String[] values, MapAxisValueTypeEnum valueType) {
        if (HRStringUtils.equals((String)valueType.getValue(), (String)MapAxisValueTypeEnum.SCORE.getValue())) {
            for (String value : values) {
                if (HRStringUtils.isEmpty((String)value)) continue;
                String valueOnlyNum = value.replace(".", "");
                if (valueOnlyNum.length() > 23) {
                    return false;
                }
                String[] splitNumber = value.split("\\.");
                if (splitNumber.length != 2 || splitNumber[1].length() <= 4) continue;
                return false;
            }
            return true;
        }
        if (HRStringUtils.equals((String)valueType.getValue(), (String)MapAxisValueTypeEnum.PERCENT.getValue())) {
            for (String value : values) {
                if (HRStringUtils.isEmpty((String)value)) continue;
                String valueOnlyNum = value.replace(".", "");
                if (valueOnlyNum.length() > 23) {
                    return false;
                }
                String[] splitNumber = value.split("\\.");
                if (splitNumber.length != 2 || splitNumber[1].length() <= 2) continue;
                return false;
            }
            return true;
        }
        if (HRStringUtils.equals((String)valueType.getValue(), (String)MapAxisValueTypeEnum.GRADE.getValue())) {
            for (String value : values) {
                if (HRStringUtils.isEmpty((String)value) || value.length() <= 100) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    private boolean validateNumberSmallToLarge(String[] values) {
        double lastNum = 0.0;
        for (String value : values) {
            if (HRStringUtils.isEmpty((String)value)) continue;
            double currentValue = Double.parseDouble(value);
            if (currentValue <= lastNum) {
                return false;
            }
            lastNum = currentValue;
        }
        return true;
    }

    private boolean validateIsNumber(String[] values) {
        for (String value : values) {
            boolean numeric = StringUtils.isNumeric((String)value);
            if (numeric) continue;
            return false;
        }
        return true;
    }
}

