/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.opplugin.validate.calibrate;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.tdc.oatr.common.constants.enums.CalibrateSessionStatusEnum;

public class CalibrateDeleteValidator
extends HRDataBaseValidator {
    public void validate() {
        super.validate();
        OperateOption option = this.getOption();
        String collaborationFlag = option.getVariableValue("collaboration_flag");
        Arrays.stream(this.getDataEntities()).forEach(extendedDataEntity -> {
            String calibrateStatus;
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            DynamicObjectCollection organizerColl = dataEntity.getDynamicObjectCollection("organizers");
            Set organizers = organizerColl.stream().map(organizer -> organizer.getLong("fbasedataid.id")).collect(Collectors.toSet());
            if (HRStringUtils.equals((String)collaborationFlag, (String)"1") && !organizers.contains(RequestContext.get().getCurrUserId())) {
                String errorMsg = ResManager.loadKDString((String)"\u53ea\u6709\u6d3b\u52a8\u7ba1\u7406\u5458\u53ca\u6821\u51c6\u4f1a\u7ec4\u7ec7\u8005\u53ef\u64cd\u4f5c\u5220\u9664\u3002", (String)"CalibrateDeleteValidator_1", (String)"tdc-oatr-opplugin", (Object[])new Object[0]);
                this.addFatalErrorMessage((ExtendedDataEntity)extendedDataEntity, errorMsg);
            }
            if (!HRStringUtils.equals((String)(calibrateStatus = dataEntity.getString("calibratestatus")), (String)CalibrateSessionStatusEnum.WAIT_START.getCode())) {
                String errorMsg = ResManager.loadKDString((String)"\u4ec5\u53ef\u5220\u9664\u72b6\u6001\u4e3a\u201c\u5f85\u542f\u52a8\u201d\u7684\u6821\u51c6\u4f1a\u3002", (String)"CalibrateDeleteValidator_0", (String)"tdc-oatr-opplugin", (Object[])new Object[0]);
                this.addFatalErrorMessage((ExtendedDataEntity)extendedDataEntity, errorMsg);
            }
        });
    }
}

