/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.opplugin.validate.calibrate;

import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.tdc.oatr.bussiness.ServiceFactory;
import kd.tdc.oatr.bussiness.domain.activity.ReviewActivityService;
import kd.tdc.oatr.bussiness.domain.calibrate.CalibrateSessionService;
import kd.tdc.oatr.common.constants.enums.ActivityStatusEnum;
import org.apache.commons.lang3.StringUtils;

public class CalibrateSaveValidator
extends HRDataBaseValidator {
    private static final ReviewActivityService activityService = (ReviewActivityService)ServiceFactory.getService(ReviewActivityService.class);
    private static final CalibrateSessionService calibrateSessionService = (CalibrateSessionService)ServiceFactory.getService(CalibrateSessionService.class);

    public void validate() {
        for (ExtendedDataEntity extendedData : this.getDataEntities()) {
            long id;
            DynamicObject dbCalibrateSession;
            String calibrateStatus;
            DataEntityState dataEntityState;
            long currUserId;
            DynamicObjectCollection organizers;
            Set organizerIds;
            DynamicObject dataEntity = extendedData.getDataEntity();
            String opName = this.getOption().getVariableValue("opName");
            String collaborationFlag = this.getOption().getVariableValue("collaboration_flag", null);
            if (StringUtils.isNotEmpty((CharSequence)collaborationFlag) && "1".equals(collaborationFlag) && !(organizerIds = (organizers = dataEntity.getDynamicObjectCollection("organizers")).stream().map(obj -> obj.getLong("fbasedataid_id")).collect(Collectors.toSet())).contains(currUserId = RequestContext.get().getCurrUserId())) {
                this.addErrorMessage(extendedData, String.format(ResManager.loadKDString((String)"\u53ea\u6709\u6d3b\u52a8\u7ba1\u7406\u5458\u53ca\u6821\u51c6\u4f1a\u7ec4\u7ec7\u8005\u53ef\u64cd\u4f5c%s\u3002", (String)"CalibrateSaveValidator_3", (String)"tdc-oatr-opplugin", (Object[])new Object[0]), opName));
            }
            if ((dataEntityState = dataEntity.getDataEntityState()).getFromDatabase() && !"A".equals(calibrateStatus = (dbCalibrateSession = calibrateSessionService.getCalibrateSession((Object)(id = dataEntity.getLong("id")))).getString("calibratestatus")) && !"B".equals(calibrateStatus)) {
                this.addErrorMessage(extendedData, String.format(ResManager.loadKDString((String)"\u4ec5\u53ef\u4fdd\u5b58\u72b6\u6001\u4e3a\u201c\u5f85\u542f\u52a8\u201d\u3001\u201c\u8fdb\u884c\u4e2d\u201d\u7684\u6821\u51c6\u4f1a\u3002", (String)"CalibrateSaveValidator_0", (String)"tdc-oatr-opplugin", (Object[])new Object[0]), opName));
            }
            long activityId = dataEntity.getLong("reviewactivity.id");
            DynamicObject reviewActivity = activityService.getReviewActivity((Object)activityId);
            String activityStatus = reviewActivity.getString("activitystatus");
            if (ActivityStatusEnum.WAIT_START.getCode().equals(activityStatus) || ActivityStatusEnum.GOING.getCode().equals(activityStatus)) continue;
            this.addErrorMessage(extendedData, String.format(ResManager.loadKDString((String)"\u76d8\u70b9\u6d3b\u52a8\u72b6\u6001\u4e3a\u201c\u5f85\u542f\u52a8\u201d\u3001\u201c\u8fdb\u884c\u4e2d\u201d\uff0c\u624d\u80fd%s\u3002", (String)"CalibrateSaveValidator_1", (String)"tdc-oatr-opplugin", (Object[])new Object[0]), opName));
        }
    }
}

