/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.opplugin.validate.calibrate;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.tdc.oatr.bussiness.ServiceFactory;
import kd.tdc.oatr.bussiness.application.CalibrateSessionApplicationService;

public class CalibrateSessionOnlineCalibrateValidator
extends HRDataBaseValidator {
    private final CalibrateSessionApplicationService sessionApplicationService = (CalibrateSessionApplicationService)ServiceFactory.getService(CalibrateSessionApplicationService.class);

    public void validate() {
        super.validate();
        OperateOption option = this.getOption();
        String collaborationFlag = option.getVariableValue("collaboration_flag");
        Arrays.stream(this.getDataEntities()).forEach(extendedDataEntity -> {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            DynamicObjectCollection organizerColl = dataEntity.getDynamicObjectCollection("organizers");
            Set organizers = organizerColl.stream().map(organizer -> organizer.getLong("fbasedataid.id")).collect(Collectors.toSet());
            if (HRStringUtils.equals((String)collaborationFlag, (String)"1") && !organizers.contains(RequestContext.get().getCurrUserId())) {
                String errorMsg = ResManager.loadKDString((String)"\u53ea\u6709\u6d3b\u52a8\u7ba1\u7406\u5458\u53ca\u6821\u51c6\u4f1a\u7ec4\u7ec7\u8005\u53ef\u8fdb\u884c\u5728\u7ebf\u6821\u51c6\u3002", (String)"CalibrateSessionOnlineCalibrateValidator_0", (String)"tdc-oatr-opplugin", (Object[])new Object[0]);
                this.addFatalErrorMessage((ExtendedDataEntity)extendedDataEntity, errorMsg);
            }
            long sessionId = dataEntity.getLong("id");
            boolean isTalentMapExists = this.sessionApplicationService.validateWaitStartTalentMap(sessionId);
            String errorMsg = ResManager.loadKDString((String)"\u5bab\u683c\u5730\u56fe\u5df2\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u88ab\u5176\u4ed6\u4eba\u5220\u9664\u4e86\uff0c\u8bf7\u5728\u6821\u51c6\u4f1a\u4e2d\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"CalibrateSessionOnlineCalibrateValidator_1", (String)"tdc-oatr-opplugin", (Object[])new Object[0]);
            if (!isTalentMapExists) {
                this.addFatalErrorMessage((ExtendedDataEntity)extendedDataEntity, errorMsg);
            }
        });
    }
}

