/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.opplugin.validate.configure.gridtemplate;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.tdc.oatr.common.bo.gridtemplate.GridBlockInfo;
import kd.tdc.oatr.common.bo.gridtemplate.GridConfigInfo;

public class GridTemplateSaveValidator
extends HRDataBaseValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities;
        super.validate();
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            DynamicObject gridTemplateDy = dataEntity.getDataEntity();
            String gridConfigData = gridTemplateDy.getString("gridconfig_tag");
            GridConfigInfo gridConfigInfo = (GridConfigInfo)SerializationUtils.fromJsonString((String)gridConfigData, GridConfigInfo.class);
            this.validateGridNameIsEmpty(dataEntity, gridConfigInfo);
            this.validateIsOverLength(dataEntity, gridConfigInfo);
        }
    }

    private void validateGridNameIsEmpty(ExtendedDataEntity dataEntity, GridConfigInfo gridConfigInfo) {
        List gridBlocks = gridConfigInfo.getGridBlocks();
        boolean isExistsEmptyName = gridBlocks.stream().anyMatch(gridBlockInfo -> HRStringUtils.isEmpty((String)gridBlockInfo.getName().getText()));
        if (isExistsEmptyName) {
            String errorMsg = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5bab\u683c\u540d\u79f0\u201d\u3002", (String)"GridTemplateSaveValidator_0", (String)"tdc-oatr-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(dataEntity, errorMsg);
        }
    }

    private void validateIsOverLength(ExtendedDataEntity dataEntity, GridConfigInfo gridConfigInfo) {
        List gridBlocks = gridConfigInfo.getGridBlocks();
        for (GridBlockInfo gridBlock : gridBlocks) {
            String errorMsg;
            String number = gridBlock.getCustomNumber();
            if (gridBlock.getName().getText().length() > 100) {
                errorMsg = ResManager.loadKDString((String)"\u5b57\u6bb5\u201c{0}\u53f7\u5bab\u683c\u540d\u79f0\u201d\u8f93\u5165\u957f\u5ea6\u8d85\u51fa\u9650\u5b9a\u8303\u56f4[0,{1}]\u3002", (String)"GridTemplateSaveValidator_1", (String)"tdc-oatr-opplugin", (Object[])new Object[]{number, 100});
                this.addErrorMessage(dataEntity, errorMsg);
            }
            if (gridBlock.getDesc().getText().length() <= 255) continue;
            errorMsg = ResManager.loadKDString((String)"\u5b57\u6bb5\u201c{0}\u53f7\u5bab\u683c\u63cf\u8ff0\u201d\u8f93\u5165\u957f\u5ea6\u8d85\u51fa\u9650\u5b9a\u8303\u56f4[0,{1}]\u3002", (String)"GridTemplateSaveValidator_2", (String)"tdc-oatr-opplugin", (Object[])new Object[]{number, 255});
            this.addErrorMessage(dataEntity, errorMsg);
        }
    }
}

