/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.opplugin.validate.reviewobj;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.tdc.oatr.common.constants.enums.ActivityStatusEnum;
import kd.tdc.oatr.common.constants.enums.CalibrateSessionStatusEnum;

public class ReviewObjectDeleteValidator
extends HRDataBaseValidator {
    private HRBaseServiceHelper ONLINECALIBRATION_HELPER = new HRBaseServiceHelper("oatr_onlinecalibration");

    public void validate() {
        super.validate();
        List ids = Arrays.stream(this.getDataEntities()).map(extendedDataEntity -> extendedDataEntity.getDataEntity().getLong("id")).collect(Collectors.toList());
        QFilter reviewObjectQF = new QFilter("reviewobject.id", "in", ids);
        QFilter calibrateStatusQF = new QFilter("calibratesession.calibratestatus", "=", (Object)CalibrateSessionStatusEnum.END.getCode());
        DynamicObject[] onlineCalibrations = this.ONLINECALIBRATION_HELPER.query("id,reviewobject.id", new QFilter[]{reviewObjectQF, calibrateStatusQF});
        Set reviewObjs = Arrays.stream(onlineCalibrations).map(onlineCalibration -> onlineCalibration.getLong("reviewobject.id")).collect(Collectors.toSet());
        Arrays.stream(this.getDataEntities()).forEach(extendedDataEntity -> {
            String errorMsg;
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            String activityStatus = dataEntity.getString("reviewactivity.activitystatus");
            if (!HRStringUtils.equals((String)activityStatus, (String)ActivityStatusEnum.WAIT_START.getCode()) && !HRStringUtils.equals((String)activityStatus, (String)ActivityStatusEnum.GOING.getCode())) {
                errorMsg = ResManager.loadKDString((String)"\u76d8\u70b9\u6d3b\u52a8\u72b6\u6001\u4e3a\u201c\u8fdb\u884c\u4e2d\u201d\u3001\u201c\u5f85\u542f\u52a8\u201d\uff0c\u624d\u80fd\u5220\u9664\u76d8\u70b9\u5bf9\u8c61\u3002", (String)"ReviewObjectDeleteValidator_0", (String)"tdc-oatr-opplugin", (Object[])new Object[0]);
                this.addFatalErrorMessage((ExtendedDataEntity)extendedDataEntity, errorMsg);
            }
            if (reviewObjs.contains(dataEntity.getLong("id"))) {
                errorMsg = ResManager.loadKDString((String)"\u4eba\u5458\u5df2\u5b58\u5728\u6821\u51c6\u6570\u636e\uff0c\u4e0d\u652f\u6301\u5220\u9664\uff0c\u53ef\u64cd\u4f5c\u7ec8\u6b62\u76d8\u70b9\u3002", (String)"ReviewObjectDeleteValidator_1", (String)"tdc-oatr-opplugin", (Object[])new Object[0]);
                this.addFatalErrorMessage((ExtendedDataEntity)extendedDataEntity, errorMsg);
            }
        });
    }
}

