/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.opplugin.validate.reviewobj;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.tdc.oatr.bussiness.ServiceFactory;
import kd.tdc.oatr.bussiness.queryservice.ReviewEmpEvalQueryService;
import kd.tdc.oatr.bussiness.queryservice.ReviewToolQueryService;
import kd.tdc.oatr.common.constants.enums.ObjectStatusEnum;
import kd.tdc.oatr.opplugin.activity.reviewobj.ReviewObjectOperate;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ReviewObjectInviteEmpFillQuestionValidator
extends HRDataBaseValidator
implements ReviewObjectOperate {
    public void validate() {
        super.validate();
        String activityId = this.getOption().getVariableValue("reviewactivity");
        DynamicObject reviewActivity = ((ReviewToolQueryService)ServiceFactory.getService(ReviewToolQueryService.class)).getReviewToolByActivityId(Long.parseLong(activityId));
        DynamicObjectCollection innerToolCol = reviewActivity.getDynamicObjectCollection("entryentity_inner");
        Map<Long, Set<Long>> groupToolMap = ReviewObjectInviteEmpFillQuestionValidator.getGroupToolMap(innerToolCol);
        ExtendedDataEntity[] extendedDataEntities = this.getDataEntities();
        List ids = Arrays.stream(extendedDataEntities).map(obj -> obj.getDataEntity().getLong("id")).collect(Collectors.toList());
        Map reviewObjectLastQuestion = ((ReviewEmpEvalQueryService)ServiceFactory.getService(ReviewEmpEvalQueryService.class)).getReviewObjectLastQuestion(ids);
        Map dataExistMap = this.getDataExistMap(this.getDataEntities());
        for (ExtendedDataEntity extendedData : extendedDataEntities) {
            long reviewObjectId;
            DynamicObject questionObj;
            DynamicObject dataEntity = extendedData.getDataEntity();
            String dataNoExistMsg = this.validateDataDelete(dataEntity, dataExistMap);
            if (StringUtils.isNotEmpty((CharSequence)dataNoExistMsg)) {
                this.addErrorMessage(extendedData, dataNoExistMsg);
                continue;
            }
            long groupId = dataEntity.getLong("reviewgroup.id");
            Set<Long> toolIds = groupToolMap.get(groupId);
            if (CollectionUtils.isEmpty(toolIds)) {
                this.addErrorMessage(extendedData, ResManager.loadKDString((String)"\u8be5\u5458\u5de5\u6240\u5c5e\u7684\u76d8\u70b9\u7ec4\u65e0\u53ef\u7528\u7684\u5458\u5de5\u95ee\u5377\u3002", (String)"ReviewObjectInviteEmpFillEvalValidator_0", (String)"tdc-oatr-opplugin", (Object[])new Object[0]));
            }
            if ((questionObj = (DynamicObject)reviewObjectLastQuestion.get(reviewObjectId = dataEntity.getLong("id"))) != null && questionObj.getString("evalstatus").equals("A")) {
                this.addErrorMessage(extendedData, ResManager.loadKDString((String)"\u8be5\u5458\u5de5\u6b63\u5728\u8fdb\u884c\u5458\u5de5\u95ee\u5377\u586b\u5199\uff0c\u8bf7\u52ff\u91cd\u590d\u9080\u8bf7\u3002", (String)"ReviewObjectInviteEmpFillEvalValidator_1", (String)"tdc-oatr-opplugin", (Object[])new Object[0]));
            }
            String reviewStatus = dataEntity.getString("reviewstatus");
            if (ObjectStatusEnum.STOP_REVIEW.getCode().equals(reviewStatus) || ObjectStatusEnum.ACTIVITY_STOP.getCode().equals(reviewStatus)) {
                this.addErrorMessage(extendedData, ResManager.loadKDString((String)"\u8be5\u5458\u5de5\u76d8\u70b9\u5df2\u7ec8\u6b62\u3002", (String)"ReviewObjectInviteEmpFillEvalValidator_2", (String)"tdc-oatr-opplugin", (Object[])new Object[0]));
            }
            if (!ObjectStatusEnum.END.getCode().equals(reviewStatus)) continue;
            this.addErrorMessage(extendedData, ResManager.loadKDString((String)"\u8be5\u5458\u5de5\u76d8\u70b9\u5df2\u5b8c\u6210\u3002", (String)"ReviewObjectInviteEmpFillEvalValidator_3", (String)"tdc-oatr-opplugin", (Object[])new Object[0]));
        }
    }

    private static Map<Long, Set<Long>> getGroupToolMap(DynamicObjectCollection innerToolCol) {
        HashMap groupToolMap = Maps.newHashMapWithExpectedSize((int)innerToolCol.size());
        for (DynamicObject toolEntry : innerToolCol) {
            DynamicObjectCollection groupCol = toolEntry.getDynamicObjectCollection("inner_reviewgroup");
            long questionId = toolEntry.getLong("questionnaire.id");
            for (DynamicObject dynamicObject : groupCol) {
                long groupId = dynamicObject.getLong("fbasedataid_id");
                Set tools = (Set)groupToolMap.get(groupId);
                if (CollectionUtils.isEmpty((Collection)tools)) {
                    tools = Sets.newHashSetWithExpectedSize((int)4);
                    groupToolMap.put(groupId, tools);
                }
                if (questionId != 1010L) continue;
                tools.add(questionId);
            }
        }
        return groupToolMap;
    }
}

