/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.opplugin.validate.reviewobj;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.tdc.oatr.bussiness.ServiceFactory;
import kd.tdc.oatr.bussiness.queryservice.ReviewSuperiorEvalQueryService;
import kd.tdc.oatr.bussiness.queryservice.ReviewToolQueryService;
import kd.tdc.oatr.common.constants.enums.ObjectStatusEnum;
import kd.tdc.oatr.common.utils.JsonUtils;
import kd.tdc.oatr.opplugin.activity.reviewobj.ReviewObjectOperate;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ReviewObjectInviteSuperiorFillQuestionValidator
extends HRDataBaseValidator
implements ReviewObjectOperate {
    ReviewToolQueryService toolQueryService = (ReviewToolQueryService)ServiceFactory.getService(ReviewToolQueryService.class);
    ReviewSuperiorEvalQueryService superiorEvalQueryService = (ReviewSuperiorEvalQueryService)ServiceFactory.getService(ReviewSuperiorEvalQueryService.class);

    private static Map<Long, Set<Long>> getGroupToolMap(DynamicObjectCollection innerToolCol) {
        HashMap groupToolMap = Maps.newHashMapWithExpectedSize((int)innerToolCol.size());
        for (DynamicObject toolEntry : innerToolCol) {
            DynamicObjectCollection groupCol = toolEntry.getDynamicObjectCollection("inner_reviewgroup");
            long questionId = toolEntry.getLong("questionnaire.id");
            for (DynamicObject dynamicObject : groupCol) {
                long groupId = dynamicObject.getLong("fbasedataid_id");
                Set tools = (Set)groupToolMap.get(groupId);
                if (CollectionUtils.isEmpty((Collection)tools)) {
                    tools = Sets.newHashSetWithExpectedSize((int)4);
                    groupToolMap.put(groupId, tools);
                }
                if (questionId != 1020L) continue;
                tools.add(questionId);
            }
        }
        return groupToolMap;
    }

    public void validate() {
        super.validate();
        OperateOption option = this.getOption();
        if (!option.containsVariable("pop_submit")) {
            return;
        }
        String activityId = this.getOption().getVariableValue("reviewactivity");
        DynamicObject reviewActivity = this.toolQueryService.getReviewToolByActivityId(Long.parseLong(activityId));
        DynamicObjectCollection innerToolCol = reviewActivity.getDynamicObjectCollection("entryentity_inner");
        Map<Long, Set<Long>> groupToolMap = ReviewObjectInviteSuperiorFillQuestionValidator.getGroupToolMap(innerToolCol);
        ExtendedDataEntity[] extendedDataEntities = this.getDataEntities();
        List ids = Arrays.stream(extendedDataEntities).map(obj -> obj.getDataEntity().getLong("id")).collect(Collectors.toList());
        Map reviewObjectLastQuestion = this.superiorEvalQueryService.getReviewObjectLastQuestion(ids);
        Map dataExistMap = this.getDataExistMap(this.getDataEntities());
        String opPopData = this.getOption().getVariableValue("op_pop_data", null);
        Map superiorMap = (Map)JsonUtils.toObject((String)opPopData, (TypeReference)new TypeReference<Map<Long, Set<Long>>>(){});
        for (ExtendedDataEntity extendedData : extendedDataEntities) {
            DynamicObjectCollection superiors;
            DynamicObject dataEntity = extendedData.getDataEntity();
            String dataNoExistMsg = this.validateDataDelete(dataEntity, dataExistMap);
            if (StringUtils.isNotEmpty((CharSequence)dataNoExistMsg)) {
                this.addErrorMessage(extendedData, dataNoExistMsg);
                continue;
            }
            long groupId = dataEntity.getLong("reviewgroup.id");
            Set<Long> toolIds = groupToolMap.get(groupId);
            if (CollectionUtils.isEmpty(toolIds)) {
                this.addErrorMessage(extendedData, ResManager.loadKDString((String)"\u8be5\u5458\u5de5\u6240\u5c5e\u7684\u76d8\u70b9\u7ec4\u65e0\u53ef\u7528\u7684\u4e0a\u7ea7\u95ee\u5377\u3002", (String)"ReviewObjectInviteEmpFillEvalValidator_5", (String)"tdc-oatr-opplugin", (Object[])new Object[0]));
            }
            this.superiorQuestionValidate(reviewObjectLastQuestion, superiorMap, extendedData, dataEntity);
            String reviewStatus = dataEntity.getString("reviewstatus");
            if (ObjectStatusEnum.STOP_REVIEW.getCode().equals(reviewStatus) || ObjectStatusEnum.ACTIVITY_STOP.getCode().equals(reviewStatus)) {
                this.addErrorMessage(extendedData, ResManager.loadKDString((String)"\u8be5\u5458\u5de5\u76d8\u70b9\u5df2\u7ec8\u6b62\u3002", (String)"ReviewObjectInviteEmpFillEvalValidator_2", (String)"tdc-oatr-opplugin", (Object[])new Object[0]));
            }
            if (ObjectStatusEnum.END.getCode().equals(reviewStatus)) {
                this.addErrorMessage(extendedData, ResManager.loadKDString((String)"\u8be5\u5458\u5de5\u76d8\u70b9\u5df2\u5b8c\u6210\u3002", (String)"ReviewObjectInviteEmpFillEvalValidator_3", (String)"tdc-oatr-opplugin", (Object[])new Object[0]));
            }
            if (!CollectionUtils.isEmpty((Collection)(superiors = dataEntity.getDynamicObjectCollection("supereval")))) continue;
            this.addErrorMessage(extendedData, ResManager.loadKDString((String)"\u9009\u4e2d\u6570\u636e\u65e0\u4e0a\u7ea7\u8bc4\u4ef7\u4eba\uff0c\u53ef\u901a\u8fc7\u3010\u4fee\u6539\u8bc4\u4ef7\u4eba\u3011\u64cd\u4f5c\u8fdb\u884c\u6570\u636e\u4fee\u6539\u3002", (String)"ReviewObjectInviteEmpFillEvalValidator_4", (String)"tdc-oatr-opplugin", (Object[])new Object[0]));
        }
        this.getOption().setVariableValue("op_pop_data", JsonUtils.toString((Object)superiorMap));
    }

    private void superiorQuestionValidate(Map<Long, Set<DynamicObject>> reviewObjectLastQuestion, Map<Long, Set<Long>> superiorMap, ExtendedDataEntity extendedData, DynamicObject dataEntity) {
        List waitSubmitObjs;
        long reviewObjectId = dataEntity.getLong("id");
        Set<DynamicObject> questionObjs = reviewObjectLastQuestion.get(reviewObjectId);
        if (CollectionUtils.isNotEmpty(questionObjs) && CollectionUtils.isNotEmpty(waitSubmitObjs = questionObjs.stream().filter(obj -> "A".equals(obj.getString("evalstatus"))).collect(Collectors.toList()))) {
            List<Long> waitSubmitEvaluatorIds = waitSubmitObjs.stream().map(obj -> obj.getLong("evaluator.id")).collect(Collectors.toList());
            Set<Long> selectSuperiorEvaluatorIds = superiorMap.get(reviewObjectId);
            if (CollectionUtils.isNotEmpty(selectSuperiorEvaluatorIds)) {
                waitSubmitEvaluatorIds.forEach(selectSuperiorEvaluatorIds::remove);
                if (CollectionUtils.isEmpty(selectSuperiorEvaluatorIds)) {
                    String superiorNames = waitSubmitObjs.stream().map(obj -> obj.getString("evaluator.name")).collect(Collectors.joining("\u3001"));
                    this.addErrorMessage(extendedData, String.format(ResManager.loadKDString((String)"\u4e0a\u7ea7%s\u6b63\u5728\u8fdb\u884c\u4e0a\u7ea7\u8bc4\u4ef7\u95ee\u5377\u586b\u5199\uff0c\u8bf7\u52ff\u91cd\u590d\u9080\u8bf7\u3002", (String)"ReviewObjectInviteSuperiorFillQuestionValidator_1", (String)"tdc-oatr-opplugin", (Object[])new Object[0]), superiorNames));
                }
            }
        }
    }
}

