/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.opplugin.validate.reviewobj;

import com.google.common.collect.Lists;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.tdc.oatr.bussiness.ServiceFactory;
import kd.tdc.oatr.bussiness.application.ReviewActivityApplicationService;
import kd.tdc.oatr.bussiness.domain.reviewobjct.ReviewObjectService;
import kd.tdc.oatr.bussiness.queryservice.ReviewActivityQueryService;
import kd.tdc.tdcs.bussiness.license.TDCSCertCommonHelper;
import org.apache.commons.lang3.StringUtils;

public class ReviewObjectJoinValidator
extends HRDataBaseValidator {
    private static final ReviewObjectService objectService = (ReviewObjectService)ServiceFactory.getService(ReviewObjectService.class);
    private static final ReviewActivityQueryService activityService = (ReviewActivityQueryService)ServiceFactory.getService(ReviewActivityQueryService.class);
    private static final ReviewActivityApplicationService activityAppService = (ReviewActivityApplicationService)ServiceFactory.getService(ReviewActivityApplicationService.class);

    public void validate() {
        super.validate();
        List objIds = Arrays.stream(this.getDataEntities()).map(obj -> obj.getDataEntity().getLong("id")).collect(Collectors.toList());
        ReviewObjectService service = (ReviewObjectService)ServiceFactory.getService(ReviewObjectService.class);
        DynamicObject[] reviewObjects = service.listReviewObject(objIds);
        Map reviewObjectMap = Arrays.stream(reviewObjects).collect(HashMap::new, (m, obj) -> m.put(obj.getLong("id"), obj.getDynamicObject("reviewgroup")), HashMap::putAll);
        String activityIdStr = this.getOption().getVariableValue("reviewactivity");
        long activityId = Long.parseLong(activityIdStr);
        DynamicObject[] reviewObjArr = objectService.listJoinedReviewObjects(activityId);
        Set joinedReviewObjs = Arrays.stream(reviewObjArr).map(obj -> obj.getLong("id")).collect(Collectors.toSet());
        DynamicObject reviewActivity = activityService.getReviewActivity((Object)activityId);
        boolean reviewActivityIng = activityService.getReviewActivityIng(reviewActivity);
        List orgIds = activityAppService.getActivityAdminorgIds(reviewActivity);
        DynamicObject[] talentFilesByPersonScope = activityAppService.listActivityTalentFilesByPersonScope(reviewActivity.getString("perscopefilter_tag"), orgIds);
        Set personScopeTalentFileIds = Arrays.stream(talentFilesByPersonScope).map(obj -> obj.getLong("id")).collect(Collectors.toSet());
        ArrayList haveBusinessPersonList = Lists.newArrayList();
        for (ExtendedDataEntity extendedData : this.getDataEntities()) {
            DynamicObject dataEntity = extendedData.getDataEntity();
            String name = dataEntity.getString("name");
            long objId = dataEntity.getLong("id");
            DynamicObject joinedGroup = (DynamicObject)reviewObjectMap.get(objId);
            if (joinedReviewObjs.contains(objId) || joinedGroup != null) {
                String groupName = joinedGroup.getString("name");
                this.addErrorMessage(extendedData, String.format(ResManager.loadKDString((String)"%1$s\u5df2\u52a0\u5165\u76d8\u70b9\u7ec4\uff1a%2$s\u3002", (String)"ReviewObjectJoinValidator_0", (String)"tdc-oatr-opplugin", (Object[])new Object[0]), name, groupName));
                haveBusinessPersonList.add(dataEntity.getLong("person_id"));
            }
            if (!StringUtils.equals((CharSequence)dataEntity.getString("talentfile.datastatus"), (CharSequence)"1")) {
                this.addErrorMessage(extendedData, MessageFormat.format(ResManager.loadKDString((String)"{0}\u7684\u4eba\u4e8b\u4e8b\u52a1\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u81f3\u3010\u76d8\u70b9\u4eba\u5458\u8303\u56f4\u914d\u7f6e\u3011\u4e2d\u70b9\u51fb\u201c\u83b7\u53d6\u8303\u56f4\u4e0b\u4eba\u5458\u201d\uff0c\u66f4\u65b0\u4eba\u5458\u4fe1\u606f\u3002", (String)"ReviewObjectJoinValidator_3", (String)"tdc-oatr-opplugin", (Object[])new Object[0]), name));
                haveBusinessPersonList.add(dataEntity.getLong("person_id"));
            } else if (!personScopeTalentFileIds.contains(dataEntity.getLong("talentfile.id"))) {
                this.addErrorMessage(extendedData, String.format(ResManager.loadKDString((String)"%s\u4e0d\u7b26\u5408\u8be5\u76d8\u70b9\u6d3b\u52a8\u7684\u4eba\u5458\u8303\u56f4\u89c4\u5219\u3002", (String)"ReviewObjectJoinValidator_2", (String)"tdc-oatr-opplugin", (Object[])new Object[0]), name));
                haveBusinessPersonList.add(dataEntity.getLong("person_id"));
            }
            if (reviewActivityIng) continue;
            this.addErrorMessage(extendedData, ResManager.loadKDString((String)"\u76d8\u70b9\u6d3b\u52a8\u72b6\u6001\u4e3a\u201c\u8fdb\u884c\u4e2d\u201d\u3001\u201c\u5f85\u542f\u52a8\u201d\uff0c\u624d\u80fd\u6dfb\u52a0\u76d8\u70b9\u5bf9\u8c61\u3002", (String)"ReviewObjectJoinValidator_1", (String)"tdc-oatr-opplugin", (Object[])new Object[0]));
            haveBusinessPersonList.add(dataEntity.getLong("person_id"));
        }
        this.certValidate(this.getDataEntities(), haveBusinessPersonList);
    }

    private void certValidate(ExtendedDataEntity[] extendedDataEntities, List<Long> haveBusinessPersonList) {
        if (null == extendedDataEntities || extendedDataEntities.length == 0) {
            return;
        }
        List<Long> personIdList = Arrays.stream(extendedDataEntities).map(extendedDataEntity -> extendedDataEntity.getDataEntity().getLong("person_id")).collect(Collectors.toList());
        personIdList.removeAll(haveBusinessPersonList);
        if (CollectionUtils.isEmpty(personIdList)) {
            return;
        }
        Map certResultMap = TDCSCertCommonHelper.verifyCertByPersonId((String)"32J2T2KEXE6T", (String)"oatr_reviewobject", personIdList);
        Object state = certResultMap.get("STATE");
        if ("NORMAL".equals(state)) {
            return;
        }
        if ("FORBID".equals(state)) {
            Map data = (Map)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString(certResultMap.get("DATA")), Map.class);
            String message = data.get("message") == null ? "" : data.get("message").toString();
            Map<Long, ExtendedDataEntity> personMappingMap = Arrays.stream(extendedDataEntities).collect(Collectors.toMap(extendedDataEntity -> extendedDataEntity.getDataEntity().getLong("person_id"), extendedDataEntity -> extendedDataEntity, (v1, v2) -> v1));
            personIdList.forEach(personId -> this.addFatalErrorMessage((ExtendedDataEntity)personMappingMap.get(personId), message));
            return;
        }
        if ("FAIL".equals(state)) {
            Map<Long, ExtendedDataEntity> personMappingMap = Arrays.stream(extendedDataEntities).collect(Collectors.toMap(extendedDataEntity -> extendedDataEntity.getDataEntity().getLong("person_id"), extendedDataEntity -> extendedDataEntity, (v1, v2) -> v1));
            List nExistIdList = (List)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString(certResultMap.get("NEXISTID")), ArrayList.class);
            List exceptIdList = (List)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString(certResultMap.get("EXCEPTID")), ArrayList.class);
            ArrayList allFailList = Lists.newArrayList();
            if (!CollectionUtils.isEmpty((Collection)nExistIdList)) {
                allFailList.addAll(nExistIdList);
            }
            if (!CollectionUtils.isEmpty((Collection)exceptIdList)) {
                allFailList.addAll(exceptIdList);
            }
            if (!CollectionUtils.isEmpty((Collection)allFailList)) {
                allFailList.forEach(failId -> {
                    if (!(failId instanceof Long)) {
                        return;
                    }
                    ExtendedDataEntity extendedDataEntity = (ExtendedDataEntity)personMappingMap.get(failId);
                    DynamicObject person = extendedDataEntity.getDataEntity().getDynamicObject("person");
                    if (null == person) {
                        return;
                    }
                    this.addFatalErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"{0}\u8bb8\u53ef\u6821\u9a8c\u5f02\u5e38\uff0c\u65e0\u6cd5\u6267\u884c\u8be5\u64cd\u4f5c\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u786e\u8ba4\u8bb8\u53ef\u4fe1\u606f\u3002", (String)"ReviewObjectJoinValidator_4", (String)"tdc-oatr-opplugin", (Object[])new Object[]{person.getString("name")}));
                });
            }
        }
    }
}

