/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.formplugin.web.activity;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDyObjectPropUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.tdc.oatr.bussiness.ServiceFactory;
import kd.tdc.oatr.bussiness.application.ReviewTalentMapConfigApplicationService;
import kd.tdc.oatr.bussiness.domain.calibrate.OnlineCalibrationDomainService;
import kd.tdc.oatr.bussiness.domain.reviewobjct.ReviewObjectService;
import kd.tdc.oatr.bussiness.queryservice.ReviewActivityQueryService;
import kd.tdc.oatr.common.constants.enums.CalibrateSessionStatusEnum;
import kd.tdc.oatr.common.constants.enums.ObjectStatusEnum;
import kd.tdc.oatr.common.utils.JsonUtils;
import kd.tdc.oatr.common.utils.PermItemName;
import kd.tdc.oatr.common.utils.ReviewPermUtils;
import kd.tdc.oatr.formplugin.web.activity.detail.ReviewActivityDetailCommon;
import kd.tdc.oatr.formplugin.web.common.FormBizChangeUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class CalibrateSessionEdit
extends HRDataBaseEdit
implements ReviewActivityDetailCommon {
    private static final String DO_NOTHING_PREVIEW = "donothing_preview";
    private static final String DO_NOTHING_JOIN_OBJ = "donothing_joinobj";
    private static final String DO_NOTHING_REMOVE_OBJ = "donothing_removeobj";
    private static final ReviewTalentMapConfigApplicationService mapService = (ReviewTalentMapConfigApplicationService)ServiceFactory.getService(ReviewTalentMapConfigApplicationService.class);
    private static final ReviewObjectService reviewObjectService = (ReviewObjectService)ServiceFactory.getService(ReviewObjectService.class);
    private static final ReviewActivityQueryService activityService = (ReviewActivityQueryService)ServiceFactory.getService(ReviewActivityQueryService.class);
    private static final OnlineCalibrationDomainService onlineCalibrationDomainService = (OnlineCalibrationDomainService)ServiceFactory.getService(OnlineCalibrationDomainService.class);
    public static final String BILLHEAD_FLEX = "billhead_flex";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setTalentFieldComboItems();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ((DO_NOTHING_PREVIEW.equals(operateKey) || "save".equals(operateKey)) && !this.validateTalentMapExists()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bab\u683c\u5730\u56fe\u5df2\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u88ab\u5176\u4ed6\u4eba\u5220\u9664\u4e86\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"CalibrateSessionEdit_4", (String)"tdc-oatr-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("talentmap", null);
            this.setTalentFieldComboItems();
            args.setCancel(true);
        }
        OperateOption option = operate.getOption();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String collaborationFlag = (String)formShowParameter.getCustomParam("collaboration_flag");
        boolean hasCalibrationPerm = ReviewPermUtils.getInstance().hasPerm("oatr_calibratesession");
        if (!hasCalibrationPerm) {
            String entityName = ResManager.loadKDString((String)"\u6821\u51c6\u4f1a", (String)"ReviewActivityEdit_7", (String)"tdc-oatr-formplugin", (Object[])new Object[0]);
            String noPermTip = ReviewPermUtils.getInstance().getNoPermTip(entityName, PermItemName.QUERY.getName());
            this.getView().showErrorNotification(noPermTip);
            args.setCancel(true);
            return;
        }
        if ("save".equals(operateKey)) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObjectCollection reviewObjEntry = dataEntity.getDynamicObjectCollection("entryentity");
            List reviewObjIds = reviewObjEntry.stream().map(obj -> obj.getLong("reviewobject_id")).collect(Collectors.toList());
            DynamicObject[] dbReviewObjs = reviewObjectService.listReviewObject(reviewObjIds);
            Set dbReviewObjIds = Arrays.stream(dbReviewObjs).map(obj -> obj.getLong("id")).collect(Collectors.toSet());
            reviewObjIds.removeIf(obj -> !dbReviewObjIds.contains(obj));
            option.setVariableValue("activityId", formShowParameter.getCustomParam("activityId").toString());
            option.setVariableValue("reviewObjIds", JsonUtils.toString(reviewObjIds));
            option.setVariableValue("talentmap", dataEntity.getString("talentmap"));
            option.setVariableValue("opName", ResManager.loadKDString((String)"\u4fee\u6539", (String)"CalibrateSessionEdit_0", (String)"tdc-oatr-formplugin", (Object[])new Object[0]));
        }
        if (DO_NOTHING_JOIN_OBJ.equals(operateKey)) {
            option.setVariableValue("collaboration_flag", collaborationFlag);
            option.setVariableValue("opName", ResManager.loadKDString((String)"\u6dfb\u52a0", (String)"CalibrateSessionEdit_1", (String)"tdc-oatr-formplugin", (Object[])new Object[0]));
        }
        if (DO_NOTHING_REMOVE_OBJ.equals(operateKey)) {
            int[] selectRows = this.getSelectRows();
            if (selectRows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ReviewObjectInviteSuperiorFillEvalPopPlugin_0", (String)"tdc-oatr-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            option.setVariableValue("collaboration_flag", collaborationFlag);
            option.setVariableValue("opName", ResManager.loadKDString((String)"\u79fb\u9664", (String)"CalibrateSessionEdit_2", (String)"tdc-oatr-formplugin", (Object[])new Object[0]));
        }
    }

    private boolean validateTalentMapExists() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String status = dataEntity.getString("calibratestatus");
        if (CalibrateSessionStatusEnum.WAIT_START.getCode().equals(status)) {
            String talentMapIdStr = this.getModel().getDataEntity().getString("talentmap");
            Map talentMapNameMap = mapService.getTalentMapName(this.getActivityLongId(this.getView()));
            return talentMapNameMap.containsKey(talentMapIdStr);
        }
        return true;
    }

    private void setTalentFieldComboItems() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String calibrateStatus = dataEntity.getString("calibratestatus");
        Map<String, String> talentMapName = new HashMap(0);
        if (!HRStringUtils.equals((String)calibrateStatus, (String)CalibrateSessionStatusEnum.WAIT_START.getCode())) {
            String talentMapId = dataEntity.getString("talentmap");
            if (HRStringUtils.isNotEmpty((String)talentMapId)) {
                String xAxisDimName = HRDyObjectPropUtil.getName((DynamicObject)dataEntity.getDynamicObject("xaxisdim"));
                String yAxisDimName = HRDyObjectPropUtil.getName((DynamicObject)dataEntity.getDynamicObject("yaxisdim"));
                if (HRStringUtils.isNotEmpty((String)xAxisDimName) && HRStringUtils.isNotEmpty((String)yAxisDimName)) {
                    String mapName2 = MessageFormat.format("{0}+{1}", xAxisDimName, yAxisDimName);
                    talentMapName.put(talentMapId, mapName2);
                }
            }
        } else {
            talentMapName = mapService.getTalentMapName(this.getActivityLongId(this.getView()));
        }
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl("talentmap");
        ArrayList comboItems = Lists.newArrayListWithExpectedSize((int)talentMapName.size());
        talentMapName.forEach((mapId, mapName) -> comboItems.add(new ComboItem(new LocaleString(mapName), mapId)));
        comboEdit.setComboItems((List)comboItems);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if ("talentmap".equals(name)) {
            String newValue = (String)e.getChangeSet()[0].getNewValue();
            if (HRStringUtils.isNotEmpty((String)newValue) && !this.validateTalentMapExists()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bab\u683c\u5730\u56fe\u5df2\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u88ab\u5176\u4ed6\u4eba\u5220\u9664\u4e86\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"CalibrateSessionEdit_4", (String)"tdc-oatr-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("talentmap", null);
                this.setTalentFieldComboItems();
            }
            this.showPreviewLabel(newValue);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (DO_NOTHING_REMOVE_OBJ.equals(callBackId) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("pop_submit", "1");
            this.getView().invokeOperation(DO_NOTHING_REMOVE_OBJ, operateOption);
        }
    }

    private void showPreviewLabel(String talentMapValue) {
        this.getView().setVisible(Boolean.valueOf(StringUtils.isNotEmpty((CharSequence)talentMapValue)), new String[]{"previewmap"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue("reviewactivity", this.getActivityId(this.getView()));
        this.getView().setVisible(Boolean.FALSE, new String[]{BILLHEAD_FLEX});
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        long id = dataEntity.getLong("id");
        DynamicObject[] onlineCalibrationObjs = onlineCalibrationDomainService.queryReviewByCalibration(id);
        Map<Long, DynamicObject> reviewObjMap = Arrays.stream(onlineCalibrationObjs).collect(Collectors.toMap(obj -> obj.getLong("reviewobject.id"), Function.identity(), (k1, k2) -> k1));
        this.setEntryReviewObjectValue(reviewObjMap);
        String status = dataEntity.getString("calibratestatus");
        if (!CalibrateSessionStatusEnum.WAIT_START.getCode().equals(status)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"talentmap"});
        }
        this.showBillHead();
    }

    private void showBillHead() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setHasRight(true);
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.getOpenStyle().setTargetKey(BILLHEAD_FLEX);
        formShowParameter.setFormId("oatr_calibratesessionhead");
        formShowParameter.setCustomParam("name", (Object)dataEntity.getString("name"));
        formShowParameter.setCustomParam("number", (Object)dataEntity.getString("number"));
        formShowParameter.setCustomParam("status", (Object)dataEntity.getString("calibratestatus"));
        Long activityId = this.getActivityLongId(this.getView());
        DynamicObject reviewActivity = activityService.getReviewActivity((Object)activityId);
        formShowParameter.setCustomParam("activityname", (Object)reviewActivity.getString("name"));
        Date startDate = reviewActivity.getDate("startdate");
        Date endDate = reviewActivity.getDate("endDate");
        String activityTime = HRDateTimeUtils.formatDate((Date)startDate) + " ~ " + HRDateTimeUtils.formatDate((Date)endDate);
        formShowParameter.setCustomParam("activitytime", (Object)activityTime);
        formShowParameter.setCustomParam("activitydesc", (Object)reviewActivity.getString("description"));
        this.getView().showForm(formShowParameter);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.showPreviewLabel(this.getModel().getDataEntity().getString("talentmap"));
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        OperationStatus status = formShowParameter.getStatus();
        if (OperationStatus.VIEW == status) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"joinobj_lbl", "removeobj_lbl"});
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        AbstractOperate operate;
        super.afterDoOperation(afterDoOperationEventArgs);
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (DO_NOTHING_PREVIEW.equals(operateKey) && operationResult.isSuccess()) {
            String talentMapStr = this.getModel().getDataEntity().getString("talentmap");
            long talentMapId = Long.parseLong(talentMapStr);
            this.showTalentMap(talentMapId);
        }
        if (DO_NOTHING_JOIN_OBJ.equals(operateKey) && operationResult.isSuccess()) {
            ListShowParameter showListForm = ShowFormHelper.createShowListForm((String)"oatr_reviewobjectf7", (boolean)true);
            showListForm.setFormId("oatr_reviewgrouptreelistf7");
            showListForm.setCustomParam("activityId", this.getActivityId(this.getView()));
            showListForm.setCustomParam("activityId", this.getActivityId(this.getView()));
            showListForm.setCustomParam("collaboration_flag", this.getView().getFormShowParameter().getCustomParam("collaboration_flag"));
            showListForm.getOpenStyle().setShowType(ShowType.Modal);
            showListForm.setCloseCallBack(new CloseCallBack((IFormPlugin)this, DO_NOTHING_JOIN_OBJ));
            List qFilters = showListForm.getListFilterParameter().getQFilters();
            qFilters.add(new QFilter("reviewstatus", "in", (Object)Lists.newArrayList((Object[])new String[]{ObjectStatusEnum.WAIT_START.getCode(), ObjectStatusEnum.GOING_UNCHECK.getCode(), ObjectStatusEnum.GOING_CHECK.getCode()})));
            Object[] joinedObjIds = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity").stream().map(obj -> obj.getLong("reviewobject.id")).toArray();
            showListForm.setSelectedRows(joinedObjIds);
            this.getView().showForm((FormShowParameter)showListForm);
        }
        if (DO_NOTHING_REMOVE_OBJ.equals(operateKey) && operationResult.isSuccess()) {
            operate = (AbstractOperate)afterDoOperationEventArgs.getSource();
            OperateOption option = operate.getOption();
            List allErrorOrValidateInfo = operationResult.getAllErrorOrValidateInfo();
            if (!option.containsVariable("pop_submit")) {
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u4f60\u5df2\u9009\u4e2d%s\u6761\u8bb0\u5f55\uff0c\u79fb\u9664\u540e\u5c06\u4e0d\u53ef\u6062\u590d\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"CalibrateSessionEdit_3", (String)"tdc-oatr-formplugin", (Object[])new Object[0]), this.getSelectRows().length), "", MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(DO_NOTHING_REMOVE_OBJ, (IFormPlugin)this));
            } else if (operationResult.isSuccess() || CollectionUtils.isEmpty((Collection)allErrorOrValidateInfo)) {
                int[] selectRows = this.getSelectRows();
                this.getModel().deleteEntryRows("entryentity", selectRows);
            }
        }
        if ("save".equals(operateKey)) {
            if (operationResult.isSuccess()) {
                operate = (AbstractOperate)afterDoOperationEventArgs.getSource();
                String reviewObjIdStr = operate.getOption().getVariableValue("reviewObjIds");
                List reviewObjIds = (List)JsonUtils.toObject((String)reviewObjIdStr, (TypeReference)new TypeReference<List<Long>>(){});
                this.setEntryReviewObjectValue(reviewObjIds.toArray());
                this.getView().setVisible(Boolean.TRUE, new String[]{BILLHEAD_FLEX});
                this.showBillHead();
            } else {
                Map<Long, DynamicObject> reviewObjEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity").stream().collect(Collectors.toMap(obj -> obj.getLong("reviewobject_id"), obj -> obj.getDynamicObject("reviewobject")));
                this.setEntryReviewObjectValue(reviewObjEntry);
            }
        }
    }

    private void showTalentMap(long talentMapId) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("oatr_previewtalentmap");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        OpenStyle openStyle = formShowParameter.getOpenStyle();
        openStyle.setShowType(ShowType.Modal);
        Object pkValue = this.getModel().getDataEntity().getPkValue();
        formShowParameter.setCustomParam("calibrateSessionId", pkValue);
        formShowParameter.setCustomParam("mapEntryId", (Object)talentMapId);
        formShowParameter.setCustomParam("activityId", this.getActivityId(this.getView()));
        this.getView().showForm(formShowParameter);
    }

    private int[] getSelectRows() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        return entryGrid.getSelectRows();
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection listSelectedRows;
        Object[] selReviewObjIds;
        DynamicObject[] existObjs;
        Object[] existObjIds;
        Object returnData;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (DO_NOTHING_JOIN_OBJ.equals(actionId) && (returnData = closedCallBackEvent.getReturnData()) != null && ArrayUtils.isNotEmpty((Object[])(existObjIds = (Long[])Arrays.stream(existObjs = reviewObjectService.listReviewObject((List)Lists.newArrayList((Object[])(selReviewObjIds = (Long[])(listSelectedRows = (ListSelectedRowCollection)returnData).stream().map(obj -> (Long)obj.getPrimaryKeyValue()).toArray(Long[]::new))))).filter(obj -> this.checkReviewStatus(obj.getString("reviewstatus"))).map(obj -> obj.getLong("id")).toArray(Long[]::new)))) {
            this.setEntryReviewObjectValue(existObjIds);
        }
    }

    private boolean checkReviewStatus(String status) {
        return ObjectStatusEnum.WAIT_START.getCode().equals(status) || ObjectStatusEnum.GOING_UNCHECK.getCode().equals(status) || ObjectStatusEnum.GOING_CHECK.getCode().equals(status);
    }

    private void setEntryReviewObjectValue(Object[] selReviewObjIds) {
        if (ArrayUtils.isNotEmpty((Object[])selReviewObjIds)) {
            this.getModel().deleteEntryData("entryentity");
            TableValueSetter tableValueSetter = new TableValueSetter(new String[0]);
            for (Object selReviewObjId : selReviewObjIds) {
                tableValueSetter.addField("reviewobject", new Object[]{selReviewObjId});
            }
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.batchCreateNewEntryRow("entryentity", tableValueSetter);
            this.getModel().setDataChanged(false);
        }
    }

    private void setEntryReviewObjectValue(Map<Long, DynamicObject> selReviewObjIds) {
        if (MapUtils.isNotEmpty(selReviewObjIds)) {
            this.getModel().deleteEntryData("entryentity");
            TableValueSetter tableValueSetter = new TableValueSetter(new String[0]);
            selReviewObjIds.forEach((objId, obj) -> {
                tableValueSetter.addField("reviewobject", new Object[]{objId});
                DynamicObject person = obj.getDynamicObject("person");
                if (person != null) {
                    tableValueSetter.addField("picturefield", new Object[]{person.get("headsculpture")});
                }
            });
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.batchCreateNewEntryRow("entryentity", tableValueSetter);
            this.getModel().setDataChanged(false);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        FormBizChangeUtils.setBizChanged(this.getModel().getDataEntity(true), "reviewobject");
    }
}

