/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.formplugin.web.activity;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.TextProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDyObjectPropUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.tdc.oatr.bussiness.ServiceFactory;
import kd.tdc.oatr.bussiness.application.CalibrateSessionApplicationService;
import kd.tdc.oatr.bussiness.application.ReviewTalentMapConfigApplicationService;
import kd.tdc.oatr.bussiness.queryservice.CalibrateSessionQueryService;
import kd.tdc.oatr.bussiness.queryservice.OnlineCalibrationQueryService;
import kd.tdc.oatr.bussiness.queryservice.ReviewActivityQueryService;
import kd.tdc.oatr.common.constants.enums.ActivityStatusEnum;
import kd.tdc.oatr.common.constants.enums.CalibrateSessionStatusEnum;
import kd.tdc.oatr.common.utils.PermItemName;
import kd.tdc.oatr.common.utils.ReviewPermUtils;
import kd.tdc.oatr.formplugin.web.activity.detail.ReviewActivityDetailCommon;

public class CalibrateSessionList
extends HRDataBaseList
implements ReviewActivityDetailCommon {
    private static final ReviewActivityQueryService reviewActivityQueryService = (ReviewActivityQueryService)ServiceFactory.getService(ReviewActivityQueryService.class);
    private static final HRBaseServiceHelper REVIEWGROUP_REPOSITORY = new HRBaseServiceHelper("oatr_reviewgroup");
    private static final HRBaseServiceHelper CALIBRATE_SESSION_HELPER = new HRBaseServiceHelper("oatr_calibratesession");
    private final ReviewTalentMapConfigApplicationService mapService = (ReviewTalentMapConfigApplicationService)ServiceFactory.getService(ReviewTalentMapConfigApplicationService.class);
    private final CalibrateSessionApplicationService sessionApplicationService = (CalibrateSessionApplicationService)ServiceFactory.getService(CalibrateSessionApplicationService.class);
    private final CalibrateSessionQueryService calSessionQueryService = (CalibrateSessionQueryService)ServiceFactory.getService(CalibrateSessionQueryService.class);
    private final OnlineCalibrationQueryService onlineCalibrationQueryService = (OnlineCalibrationQueryService)ServiceFactory.getService(OnlineCalibrationQueryService.class);
    private static final String[] tblArray = new String[]{"tbldel", "tblnew"};
    private static final Set<String> permitOpKey = Sets.newHashSet((Object[])new String[]{"onlinecalibratese", "new", "delete"});

    public void setFilter(SetFilterEvent setFilterEvent) {
        super.setFilter(setFilterEvent);
        List qFilters = setFilterEvent.getQFilters();
        qFilters.add(new QFilter("reviewactivity.id", "=", this.getActivityId(this.getView())));
        if (HRStringUtils.equals((String)((String)this.getView().getFormShowParameter().getCustomParam("collaboration_flag")), (String)"1")) {
            qFilters.add(new QFilter("organizers.fbasedataid.id", "in", (Object)RequestContext.get().getCurrUserId()));
        }
        setFilterEvent.setOrderBy("modifytime desc");
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Long activityId = (Long)parameter.getCustomParam("activityId");
        if (reviewActivityQueryService.getReviewActivityEnd((Object)activityId)) {
            this.getView().setVisible(Boolean.valueOf(false), tblArray);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        QFilter activityQF;
        QFilter statusQFilter;
        QFilter userQFilter;
        boolean hasObjectPerm;
        ReviewActivityQueryService service;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Long activityId = (Long)parameter.getCustomParam("activityId");
        if (HRStringUtils.equals((String)operateKey, (String)"delete") && Objects.nonNull(activityId) && (service = (ReviewActivityQueryService)ServiceFactory.getService(ReviewActivityQueryService.class)).getReviewActivityEnd((Object)activityId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u76d8\u70b9\u6d3b\u52a8\u72b6\u6001\u4e3a\u201c\u8fdb\u884c\u4e2d\u201d\uff0c\u624d\u80fd\u5220\u9664\u6821\u51c6\u4f1a\u3002", (String)"CalibrateSessionList_0", (String)"tdc-oatr-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (HRStringUtils.equals((String)operateKey, (String)"new") && Objects.nonNull(activityId)) {
            service = (ReviewActivityQueryService)ServiceFactory.getService(ReviewActivityQueryService.class);
            DynamicObject reviewActivity = service.getReviewActivity((Object)activityId);
            if (!HRStringUtils.equals((String)ActivityStatusEnum.GOING.getCode(), (String)reviewActivity.getString("activitystatus"))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u76d8\u70b9\u6d3b\u52a8\u72b6\u6001\u4e3a\u201c\u8fdb\u884c\u4e2d\u201d\uff0c\u624d\u80fd\u65b0\u589e\u6821\u51c6\u4f1a\u3002", (String)"CalibrateSessionList_1", (String)"tdc-oatr-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
        if (HRStringUtils.equals((String)"onlinecalibratese", (String)operateKey) && !(hasObjectPerm = ReviewPermUtils.getInstance().hasPerm("oatr_onlinecalibration"))) {
            String entityName = ResManager.loadKDString((String)"\u5728\u7ebf\u6821\u51c6", (String)"ReviewActivityColList_5", (String)"tdc-oatr-formplugin", (Object[])new Object[0]);
            String noPermTip = ReviewPermUtils.getInstance().getNoPermTip(entityName, PermItemName.QUERY.getName());
            this.getView().showErrorNotification(noPermTip);
            args.setCancel(true);
            return;
        }
        if (HRStringUtils.equals((String)"delete", (String)operateKey) || HRStringUtils.equals((String)"onlinecalibratese", (String)operateKey)) {
            operate.getOption().setVariableValue("collaboration_flag", (String)this.getView().getFormShowParameter().getCustomParam("collaboration_flag"));
        }
        if (HRStringUtils.equals((String)((String)this.getView().getFormShowParameter().getCustomParam("collaboration_flag")), (String)"1") && !REVIEWGROUP_REPOSITORY.isExists(new QFilter[]{userQFilter = new QFilter("entryentity.collaborator", "=", (Object)RequestContext.get().getCurrUserId()), statusQFilter = new QFilter("entryentity.colstatus", "=", (Object)"1"), activityQF = new QFilter("reviewactivity.id", "=", (Object)activityId)}) && permitOpKey.contains(operateKey)) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u4f60\u7684\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u5237\u65b0\u6216\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"ReviewActivityColList_0", (String)"tdc-oatr-formplugin", (Object[])new Object[0]), MessageBoxOptions.None);
            args.setCancel(true);
            return;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String opKey = afterDoOperationEventArgs.getOperateKey();
        if (HRStringUtils.equals((String)opKey, (String)"onlinecalibratese")) {
            OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
            if (operationResult == null || !operationResult.isSuccess()) {
                return;
            }
            this.showOnlineCalibrationListView();
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent event) {
        QFilter activityQF;
        QFilter statusQFilter;
        QFilter userQFilter;
        BillShowParameter billShowParameter = event.getParameter();
        Long activityId = this.getActivityLongId(this.getView());
        super.beforeShowBill(event);
        if (HRStringUtils.equals((String)((String)this.getView().getFormShowParameter().getCustomParam("collaboration_flag")), (String)"1") && !REVIEWGROUP_REPOSITORY.isExists(new QFilter[]{userQFilter = new QFilter("entryentity.collaborator", "=", (Object)RequestContext.get().getCurrUserId()), statusQFilter = new QFilter("entryentity.colstatus", "=", (Object)"1"), activityQF = new QFilter("reviewactivity.id", "=", (Object)activityId)})) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u4f60\u7684\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u5237\u65b0\u6216\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"ReviewActivityColList_0", (String)"tdc-oatr-formplugin", (Object[])new Object[0]), MessageBoxOptions.None);
            event.setCancel(true);
            return;
        }
        if (!billShowParameter.getStatus().equals((Object)OperationStatus.ADDNEW)) {
            boolean reviewActivityEnd;
            Object calibrateSessionId = billShowParameter.getPkId();
            DynamicObject calibrateSession = CALIBRATE_SESSION_HELPER.queryOne("calibratestatus,organizers", calibrateSessionId);
            DynamicObjectCollection organizerColl = calibrateSession.getDynamicObjectCollection("organizers");
            Set organizers = organizerColl.stream().map(organizer -> organizer.getLong("fbasedataid.id")).collect(Collectors.toSet());
            if (HRStringUtils.equals((String)((String)this.getView().getFormShowParameter().getCustomParam("collaboration_flag")), (String)"1") && !organizers.contains(RequestContext.get().getCurrUserId())) {
                String errorMsg = ResManager.loadKDString((String)"\u53ea\u6709\u6d3b\u52a8\u7ba1\u7406\u7528\u6237\u53ca\u6821\u51c6\u4f1a\u7ec4\u7ec7\u8005\u53ef\u8fdb\u5165\u8be6\u60c5\u9875\u3002", (String)"CalibrateSessionList_2", (String)"tdc-oatr-formplugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(errorMsg);
                event.setCancel(true);
                return;
            }
            String name = calibrateSession.getString("name");
            billShowParameter.setCaption(name);
            if (HRStringUtils.equals((String)calibrateSession.getString("calibratestatus"), (String)CalibrateSessionStatusEnum.END.getCode())) {
                billShowParameter.setStatus(OperationStatus.VIEW);
            }
            if (reviewActivityEnd = reviewActivityQueryService.getReviewActivityEnd((Object)activityId)) {
                billShowParameter.setStatus(OperationStatus.VIEW);
            }
        }
        BillShowParameter parameter = event.getParameter();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        customParams.forEach((arg_0, arg_1) -> ((BillShowParameter)parameter).setCustomParam(arg_0, arg_1));
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        CalibrateSessionListDataProvider listDataProvider = new CalibrateSessionListDataProvider((AbstractFormPlugin)this);
        args.setListDataProvider((IListDataProvider)listDataProvider);
    }

    public void packageData(PackageDataEvent evt) {
        super.packageData(evt);
        AbstractColumnDesc abstractColumnDesc = (AbstractColumnDesc)evt.getSource();
        String key = abstractColumnDesc.getFieldKey();
        Map talentMapName = (Map)JSON.parseObject((String)this.getPageCache().get("talentMapName"), Map.class);
        Map sessionTalentMapName = (Map)JSON.parseObject((String)this.getPageCache().get("sessionTalentMapName"), Map.class);
        if (HRStringUtils.equals((String)key, (String)"talentmap")) {
            String pkId = evt.getRowData().getString("id");
            String mapName = (String)sessionTalentMapName.get(pkId);
            if (HRStringUtils.isNotEmpty((String)mapName)) {
                evt.setFormatValue((Object)mapName);
                return;
            }
            evt.setFormatValue(talentMapName.get(evt.getRowData().getString("talentmap")));
        }
        if (HRStringUtils.equals((String)key, (String)"adjustnum")) {
            DynamicObject rowData = evt.getRowData();
            if (rowData.getDataEntityType().getProperties().containsKey((Object)key)) {
                evt.setFormatValue((Object)rowData.getString(key));
            } else {
                evt.setFormatValue((Object)"0");
            }
        }
    }

    public void beforePackageData(BeforePackageDataEvent e) {
        super.beforePackageData(e);
        Long activityId = this.getActivityLongId(this.getView());
        Map talentMapName = this.mapService.getTalentMapName(activityId);
        Map sessionTalentMapName = this.sessionApplicationService.getSessionTalentMapName(activityId);
        this.getPageCache().put("talentMapName", JSONObject.toJSONString((Object)talentMapName));
        this.getPageCache().put("sessionTalentMapName", JSONObject.toJSONString((Object)sessionTalentMapName));
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (HRStringUtils.equals((String)"onlineCalClose", (String)actionId) && (returnData = closedCallBackEvent.getReturnData()) != null) {
            String pageId = returnData.toString();
            this.removeOpenViewPageIdCache(pageId);
        }
    }

    private void showOnlineCalibrationListView() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("oatr_onlinecaldetail");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        Map<String, Object> customParams = this.getCustomParams();
        showParameter.setCustomParams(customParams);
        showParameter.setCaption(this.getOnlineCaption());
        Map<String, String> pageIdMap = this.getHasOpenViewPageIdFormCache();
        String pageIdCache = pageIdMap.get(this.getCalibrateSessionId());
        if (HRStringUtils.isNotEmpty((String)pageIdCache)) {
            showParameter.setPageId(pageIdCache);
        } else {
            this.addOpenViewPageIdCache(showParameter.getPageId());
        }
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "onlineCalClose"));
        this.getView().showForm(showParameter);
    }

    private String getOnlineCaption() {
        String calibrateSessionId = this.getCalibrateSessionId();
        DynamicObject calibrateSession = this.calSessionQueryService.getCalibrateSession(Long.valueOf(Long.parseLong(calibrateSessionId)));
        String activityName = HRDyObjectPropUtil.getName((DynamicObject)calibrateSession.getDynamicObject("reviewactivity"));
        String sessionName = HRDyObjectPropUtil.getName((DynamicObject)calibrateSession);
        return MessageFormat.format("{0}-{1}", activityName, sessionName);
    }

    private Map<String, Object> getCustomParams() {
        HashMap customParams = Maps.newHashMapWithExpectedSize((int)5);
        Object flag = this.getView().getFormShowParameter().getCustomParam("collaboration_flag");
        Object activityId = this.getView().getFormShowParameter().getCustomParam("activityId");
        if (activityId != null) {
            customParams.put("activityId", activityId);
        }
        customParams.put("calSessionId", this.getCalibrateSessionId());
        customParams.put("collaboration_flag", flag);
        return customParams;
    }

    private Map<String, String> getHasOpenViewPageIdFormCache() {
        String hasOpenViewPageIdStr = this.getPageCache().get("hasOpenViewPageId");
        if (HRStringUtils.isEmpty((String)hasOpenViewPageIdStr)) {
            return new HashMap<String, String>(0);
        }
        return (Map)SerializationUtils.fromJsonString((String)hasOpenViewPageIdStr, Map.class);
    }

    private void addOpenViewPageIdCache(String pageId) {
        String calibrateSessionId;
        String hasOpenViewPageIdStr = this.getPageCache().get("hasOpenViewPageId");
        Map<String, String> pageIdMap = new HashMap(16);
        if (HRStringUtils.isNotEmpty((String)hasOpenViewPageIdStr)) {
            pageIdMap = (Map)SerializationUtils.fromJsonString((String)hasOpenViewPageIdStr, Map.class);
        }
        if (HRStringUtils.isNotEmpty((String)(calibrateSessionId = this.getCalibrateSessionId()))) {
            pageIdMap.put(calibrateSessionId, pageId);
        }
        this.getPageCache().put("hasOpenViewPageId", SerializationUtils.toJsonString(pageIdMap));
    }

    private void removeOpenViewPageIdCache(String pageId) {
        String hasOpenViewPageIdStr = this.getPageCache().get("hasOpenViewPageId");
        if (HRStringUtils.isEmpty((String)hasOpenViewPageIdStr)) {
            return;
        }
        Map pageIdMap = (Map)SerializationUtils.fromJsonString((String)hasOpenViewPageIdStr, Map.class);
        pageIdMap.values().removeIf(value -> value.equals(pageId));
        this.getPageCache().put("hasOpenViewPageId", SerializationUtils.toJsonString((Object)pageIdMap));
    }

    private String getCalibrateSessionId() {
        BillList billList = (BillList)this.getControl("billlistap");
        long arrangeRecordId = (Long)billList.getCurrentSelectedRowInfo().getPrimaryKeyValue();
        return String.valueOf(arrangeRecordId);
    }

    private class CalibrateSessionListDataProvider
    extends ListDataProvider {
        private final AbstractFormPlugin plugin;

        public CalibrateSessionListDataProvider(AbstractFormPlugin plugin) {
            this.plugin = plugin;
        }

        public DynamicObjectCollection getData(int start, int limit) {
            DynamicObjectCollection pageData = super.getData(start, limit);
            List sessionIds = pageData.stream().map(data -> data.getLong("id")).collect(Collectors.toList());
            Map sessionAdjustNumMap = CalibrateSessionList.this.onlineCalibrationQueryService.queryCalibrationSessionAdjustNum(sessionIds);
            String propertyKey = "adjustnum";
            for (DynamicObject pageDataRow : pageData) {
                Long sessionId;
                Integer adjustNum;
                if (!pageDataRow.getDataEntityType().getProperties().containsKey((Object)propertyKey)) {
                    TextProp prop = new TextProp();
                    prop.setName(propertyKey);
                    prop.setDbIgnore(true);
                    pageDataRow.getDynamicObjectType().registerSimpleProperty((DynamicSimpleProperty)prop);
                }
                pageDataRow.set(propertyKey, (Object)((adjustNum = (Integer)sessionAdjustNumMap.get(sessionId = Long.valueOf(pageDataRow.getLong("id")))) == null ? "0" : String.valueOf(adjustNum)));
            }
            return pageData;
        }
    }
}

