/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.formplugin.web.activity;

import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.FormShowParameter;
import kd.bos.mvc.form.FormDataModel;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.tdc.oatr.bussiness.ServiceFactory;
import kd.tdc.oatr.bussiness.application.ReviewActivityApplicationService;
import kd.tdc.oatr.bussiness.domain.reviewgroup.ReviewGroupService;
import kd.tdc.oatr.bussiness.domain.reviewobjct.ReviewObjectService;
import kd.tdc.oatr.common.bo.CollaboratorObject;

public class CollaboratorPopupPlugin
extends HRDynamicFormBasePlugin {
    private static final ReviewObjectService reviewObjectService = (ReviewObjectService)ServiceFactory.getService(ReviewObjectService.class);
    private static final ReviewActivityApplicationService reviewApplicationService = (ReviewActivityApplicationService)ServiceFactory.getService(ReviewActivityApplicationService.class);
    private static final ReviewGroupService reviewGroupService = (ReviewGroupService)ServiceFactory.getService(ReviewGroupService.class);

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setEntryValue();
    }

    private void setEntryValue() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        long activityId = (Long)formShowParameter.getCustomParam("reviewactivity");
        DynamicObject[] reviewObjs = reviewObjectService.listJoinedReviewObjects(activityId);
        DynamicObject[] reviewGroups = reviewGroupService.listReviewGroupByActivity((Object)activityId);
        Map collaboratorGroupListMap = Arrays.stream(reviewGroups).collect(Collectors.groupingBy(obj -> obj.getLong("entryentity.collaborator"), Collectors.mapping(obj -> obj.getLong("id"), Collectors.toList())));
        List collaboratorObjects = reviewApplicationService.getCollaboratorObjects(reviewObjs, reviewGroups);
        Map<Long, Long> collObjNum = collaboratorObjects.stream().collect(Collectors.groupingBy(CollaboratorObject::getCollId, Collectors.counting()));
        DynamicObject[] groupObjs = reviewGroupService.listReviewGroupByCollId((Object)activityId);
        Map collObjMap = Arrays.stream(groupObjs).filter(obj -> obj.getLong("entryentity.collaborator") != 0L).collect(Collectors.toMap(obj -> obj.getLong("entryentity.collaborator"), Function.identity(), (k1, k2) -> k1));
        TableValueSetter tableValueSetter = new TableValueSetter(new String[0]);
        collObjMap.forEach((colId, collObj) -> {
            tableValueSetter.addField("user", new Object[]{colId});
            Long objNum = collObjNum.getOrDefault(colId, 0L);
            tableValueSetter.addField("reviewobjnum", new Object[]{objNum});
            Object colstatus = collObj.get("entryentity.colstatus");
            Object adminorg = collObj.get("entryentity.adminorg");
            Object position = collObj.get("entryentity.position");
            Object job = collObj.get("entryentity.job");
            Object std_position = collObj.get("entryentity.std_position");
            tableValueSetter.addField("status", new Object[]{colstatus});
            tableValueSetter.addField("adminorg", new Object[]{adminorg});
            tableValueSetter.addField("position", new Object[]{position});
            tableValueSetter.addField("job", new Object[]{job});
            tableValueSetter.addField("stdposition", new Object[]{std_position});
        });
        FormDataModel model = (FormDataModel)this.getModel();
        model.batchCreateNewEntryRow("entryentity", tableValueSetter);
        int i = 0;
        for (Long userId : collObjMap.keySet()) {
            List groupIds = collaboratorGroupListMap.get(userId);
            model.setValue("reviewgroup", (Object)groupIds.toArray(), i);
            ++i;
        }
    }
}

