/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.formplugin.web.activity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.param.AppParam;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRDyObjectPropUtil;
import kd.hr.hbp.common.util.HRImageUrlUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.sdk.tdc.oatr.onlinecalibrate.IOnlineCalibrationMapExtService;
import kd.sdk.tdc.oatr.onlinecalibrate.IValidateOnlineCalibration;
import kd.tdc.oatr.bussiness.ServiceFactory;
import kd.tdc.oatr.bussiness.application.OnlineCalibrationApplicationService;
import kd.tdc.oatr.bussiness.batchconfirm.activity.OnlineCalibrationFormService;
import kd.tdc.oatr.bussiness.queryservice.CalibrateSessionQueryService;
import kd.tdc.oatr.bussiness.queryservice.OnlineCalibrationQueryService;
import kd.tdc.oatr.bussiness.queryservice.ReviewActivityQueryService;
import kd.tdc.oatr.bussiness.queryservice.ReviewObjectQueryService;
import kd.tdc.oatr.bussiness.queryservice.ReviewTalentMapQueryService;
import kd.tdc.oatr.common.bo.gridtemplate.GridBlockInfo;
import kd.tdc.oatr.common.bo.onlinecalibration.CalibrateBoardInfo;
import kd.tdc.oatr.common.bo.onlinecalibration.CalibrateBoardItemInfo;
import kd.tdc.oatr.common.bo.onlinecalibration.CalibratePath;
import kd.tdc.oatr.common.bo.onlinecalibration.CalibratePathHis;
import kd.tdc.oatr.common.bo.onlinecalibration.CalibratePerson;
import kd.tdc.oatr.common.bo.onlinecalibration.GridCardInfo;
import kd.tdc.oatr.common.bo.onlinecalibration.GridPersonInfo;
import kd.tdc.oatr.common.bo.onlinecalibration.OnlineCalibrationInfo;
import kd.tdc.oatr.common.bo.onlinecalibration.PersonCardDimension;
import kd.tdc.oatr.common.bo.onlinecalibration.PersonCardInfo;
import kd.tdc.oatr.common.bo.onlinecalibration.PersonInfo;
import kd.tdc.oatr.common.bo.onlinecalibration.ShowCustomIcon;
import kd.tdc.oatr.common.bo.onlinecalibration.TalentMapInfo;
import kd.tdc.oatr.common.bo.talentmap.MapBlockRatioInfo;
import kd.tdc.oatr.common.bo.talentmap.TalentMapConfigInfo;
import kd.tdc.oatr.common.constants.enums.CalibrateSessionStatusEnum;
import kd.tdc.oatr.common.utils.ReviewPermUtils;
import org.apache.commons.lang.StringUtils;

public class OnlineCalibrationCalibrateList
extends HRDataBaseList {
    private static final Log LOG = LogFactory.getLog(OnlineCalibrationCalibrateList.class);
    private final CalibrateSessionQueryService calSessionQueryService = (CalibrateSessionQueryService)ServiceFactory.getService(CalibrateSessionQueryService.class);
    private final ReviewActivityQueryService activityQueryService = (ReviewActivityQueryService)ServiceFactory.getService(ReviewActivityQueryService.class);
    private final ReviewTalentMapQueryService talentMapQueryService = (ReviewTalentMapQueryService)ServiceFactory.getService(ReviewTalentMapQueryService.class);
    private final OnlineCalibrationQueryService onlineCalibrationQueryService = (OnlineCalibrationQueryService)ServiceFactory.getService(OnlineCalibrationQueryService.class);
    private final ReviewObjectQueryService reviewObjectQueryService = (ReviewObjectQueryService)ServiceFactory.getService(ReviewObjectQueryService.class);
    private final OnlineCalibrationApplicationService calibrationApplicationService = (OnlineCalibrationApplicationService)ServiceFactory.getService(OnlineCalibrationApplicationService.class);
    private final OnlineCalibrationFormService onlineCalibrationFormService = (OnlineCalibrationFormService)ServiceFactory.getService(OnlineCalibrationFormService.class);
    private static final String OP_INTERACT = "interact";
    private static final String OP_DO_FILTER = "dofilter";
    private static final String OP_RESET_FILTER = "resetfilter";
    private static final String OP_VIEW_FOR_PERM = "viewforperm";
    private static final String OP_TEMP_SAVE = "tempsave";
    private static final String OPTION_PARAM_EVENT_NAME = "eventName";
    private static final String OPTION_PARAM_EVENT_DATA = "eventData";
    private static final String EVENT_NAME_GET_PERSON_CARD_INFO = "getPersonCardInfo";
    private static final String EVENT_NAME_GET_GRID_CARD_INFO = "getGridCardInfo";
    private static final String EVENT_NAME_SHOW_TALENT_MAP = "showTalentMap";
    private static final String EVENT_NAME_UPDATE_PERSON_CARD = "updatePersonCard";
    private static final String EVENT_NAME_LOAD_FILTER_CONTENT = "loadFilterContent";
    private static final String EVENT_NAME_CHECK_VIEW_PERM = "checkViewPerm";
    private static final String CACHE_PERSON_ID_OF_CALIBRATION = "personIdOfCalibration";
    private static final String CACHE_PERSON_ID_TO_ONLINE_CAL_ID = "personIdToOnlineCalId";
    private static final String CACHE_GRID_PERSON_ID_MAP = "gridPersonIdMap";
    private static final String CACHE_PERSON_CARD_INFO_MAP = "personCardInfoMap";
    private static final String CACHE_IS_AUTO_SAVE_PARAM = "isAutoSaveParam";
    private static final String CACHE_TEMP_CALIBRATION_INFO = "tempCalibrationInfo";
    private static final String CONFIRM_REFRESH = "confirmrefresh";
    private static final String CONFIRM_CLOSE = "confirmclose";

    public void afterBindData(EventObject evt) {
        String currentView;
        super.afterBindData(evt);
        if (this.getPageCache().get(CACHE_IS_AUTO_SAVE_PARAM) == null) {
            boolean isAutoSaveParam = this.getIsAutoSaveParam();
            this.getPageCache().put(CACHE_IS_AUTO_SAVE_PARAM, String.valueOf(isAutoSaveParam));
        }
        if (HRStringUtils.equals((String)(currentView = this.getPageCache().get("currentView")), (String)"cardview") && evt.getSource() instanceof BillList) {
            this.initOnlineCalibrationView();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        String tempCalInfo = this.getPageCache().get(CACHE_TEMP_CALIBRATION_INFO);
        if (StringUtils.equals((String)operateKey, (String)"refresh") && HRStringUtils.isNotEmpty((String)tempCalInfo)) {
            if (this.isEditable()) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u5237\u65b0\uff1f\r\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"OnlineCalibrationCalibrateList_4", (String)"tdc-oatr-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CONFIRM_REFRESH));
                args.setCancel(true);
            } else {
                this.getPageCache().put(CACHE_TEMP_CALIBRATION_INFO, null);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        Map msgOfPersonMap;
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        FormOperate operate = (FormOperate)afterDoOperationEventArgs.getSource();
        OperateOption option = operate.getOption();
        String eventName = option.getVariableValue(OPTION_PARAM_EVENT_NAME, "");
        String eventArgString = option.getVariableValue(OPTION_PARAM_EVENT_DATA, "");
        if (HRStringUtils.equals((String)operateKey, (String)OP_INTERACT) && HRStringUtils.equals((String)eventName, (String)EVENT_NAME_UPDATE_PERSON_CARD)) {
            if (HRStringUtils.isEmpty((String)eventArgString)) {
                return;
            }
            boolean isPass = true;
            List errorMsg = this.onlineCalibrationFormService.validateCalibrate((AbstractFormPlugin)this);
            if (!errorMsg.isEmpty()) {
                this.onlineCalibrationFormService.showCalibrateErrorMsg(errorMsg, ResManager.loadKDString((String)"\u6821\u51c6", (String)"OnlineCalibrationCalibrateList_9", (String)"tdc-oatr-formplugin", (Object[])new Object[0]), (AbstractFormPlugin)this);
                this.getPageCache().put(CACHE_TEMP_CALIBRATION_INFO, null);
                isPass = false;
            }
            PersonCardInfo personCardInfo = (PersonCardInfo)SerializationUtils.fromJsonString((String)eventArgString, PersonCardInfo.class);
            HashMap personCardInfoMap = Maps.newHashMapWithExpectedSize((int)1);
            personCardInfoMap.put(personCardInfo.getPersonId(), personCardInfo);
            msgOfPersonMap = this.onlineCalibrationFormService.validateCalibratePerson((Map)personCardInfoMap, (AbstractFormPlugin)this);
            this.extendValidateCalibratePerson(msgOfPersonMap, personCardInfo.getPersonId());
            if (isPass && !CollectionUtils.isEmpty((Map)msgOfPersonMap)) {
                afterDoOperationEventArgs.getOperationResult().setShowMessage(false);
                String msg = (String)msgOfPersonMap.get(personCardInfo.getPersonId());
                if (HRStringUtils.isNotEmpty((String)msg)) {
                    this.getView().showErrorNotification(msg);
                }
                isPass = false;
            }
            CustomControl gridControl = (CustomControl)this.getView().getControl("customcontrolap");
            HashMap<String, Boolean> data = new HashMap<String, Boolean>(16);
            data.put("verification", isPass);
            Map<String, Object> mapData = this.getCustomEventParams(EVENT_NAME_UPDATE_PERSON_CARD);
            mapData.put("data", data);
            gridControl.setData(mapData);
            if (!isPass) {
                this.getView().addClientCallBack("refreshData");
                return;
            }
            if (operationResult != null && operationResult.isSuccess()) {
                this.calibrateSuccess(personCardInfo);
            }
        }
        if (operationResult != null && operationResult.isSuccess()) {
            BillList list;
            if (HRStringUtils.equals((String)operateKey, (String)OP_VIEW_FOR_PERM) && HRStringUtils.equals((String)eventName, (String)EVENT_NAME_CHECK_VIEW_PERM)) {
                CustomControl gridControl = (CustomControl)this.getView().getControl("customcontrolap");
                if (gridControl == null) {
                    return;
                }
                Map<String, Object> mapData = this.getCustomEventParams(EVENT_NAME_CHECK_VIEW_PERM);
                mapData.put("data", null);
                gridControl.setData(mapData);
            }
            if (HRStringUtils.equals((String)operateKey, (String)OP_DO_FILTER)) {
                List<QFilter> filters = this.getListQueryFilters(OP_DO_FILTER);
                list = (BillList)this.getView().getControl("billlistap");
                list.setClientQueryFilterParameter(new FilterParameter(filters, null));
                list.refresh();
            }
            if (HRStringUtils.equals((String)operateKey, (String)OP_RESET_FILTER)) {
                List<QFilter> filters = this.getListQueryFilters(OP_RESET_FILTER);
                list = (BillList)this.getView().getControl("billlistap");
                list.setClientQueryFilterParameter(new FilterParameter(filters, null));
                list.refresh();
            }
            if (HRStringUtils.equals((String)operateKey, (String)OP_TEMP_SAVE)) {
                BillList list2;
                String tempCalInfoStr = this.getPageCache().get(CACHE_TEMP_CALIBRATION_INFO);
                Map tempCalInfoMap = null;
                String successMsg = ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"OnlineCalibrationCalibrateList_8", (String)"tdc-oatr-formplugin", (Object[])new Object[0]);
                if (!HRStringUtils.isEmpty((String)tempCalInfoStr)) {
                    tempCalInfoMap = (Map)SerializationUtils.deSerializeFromBase64((String)tempCalInfoStr);
                    if (CollectionUtils.isEmpty((Map)tempCalInfoMap)) {
                        this.getView().showSuccessNotification(successMsg);
                        list2 = (BillList)this.getView().getControl("billlistap");
                        list2.refresh();
                        return;
                    }
                } else {
                    this.getView().showSuccessNotification(successMsg);
                    list2 = (BillList)this.getView().getControl("billlistap");
                    list2.refresh();
                    return;
                }
                List wholeMsgList = this.onlineCalibrationFormService.validateCalibrate((AbstractFormPlugin)this);
                if (!CollectionUtils.isEmpty((Collection)wholeMsgList)) {
                    afterDoOperationEventArgs.getOperationResult().setShowMessage(false);
                    this.onlineCalibrationFormService.showCalibrateErrorMsg(wholeMsgList, ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"OnlineCalibrationOperateList_12", (String)"tdc-oatr-formplugin", (Object[])new Object[0]), (AbstractFormPlugin)this);
                    this.getPageCache().put(CACHE_TEMP_CALIBRATION_INFO, null);
                    this.getView().invokeOperation("refresh");
                    return;
                }
                msgOfPersonMap = this.onlineCalibrationFormService.validateCalibratePerson(tempCalInfoMap, (AbstractFormPlugin)this);
                this.onlineCalibrationFormService.updateCalibrationInfo(tempCalInfoMap, (AbstractFormPlugin)this);
                if (!CollectionUtils.isEmpty((Map)msgOfPersonMap)) {
                    afterDoOperationEventArgs.getOperationResult().setShowMessage(false);
                    this.onlineCalibrationFormService.showValidateResult(msgOfPersonMap, (AbstractFormPlugin)this);
                } else {
                    this.getView().showSuccessNotification(successMsg);
                }
                this.getPageCache().put(CACHE_TEMP_CALIBRATION_INFO, null);
                BillList list3 = (BillList)this.getView().getControl("billlistap");
                list3.refresh();
                this.updateAdjustNumLabel();
            }
        }
    }

    private void extendValidateCalibratePerson(Map<String, String> msgOfPersonMap, String personIdStr) {
        if (!CollectionUtils.isEmpty(msgOfPersonMap)) {
            return;
        }
        Object activityIdObj = this.getView().getFormShowParameter().getCustomParam("activityId");
        Object sessionIdObj = this.getView().getFormShowParameter().getCustomParam("calSessionId");
        if (activityIdObj == null || sessionIdObj == null) {
            LOG.error("OnlineCalibrationCalibrateList.extendValidateCalibratePerson: param is error, activityIdObj={}, sessionIdObj={}", activityIdObj, sessionIdObj);
            return;
        }
        long calSessionId = Long.parseLong(sessionIdObj.toString());
        long activityId = Long.parseLong(activityIdObj.toString());
        long personId = Long.parseLong(personIdStr);
        HRPluginProxy pluginProxy = HRPlugInProxyFactory.create(null, IValidateOnlineCalibration.class, (String)"kd.sdk.tdc.oatr.onlinecalibrate.IValidateOnlineCalibration", null);
        pluginProxy.callReplaceIfPresent(plugin -> {
            String validateMsgResult;
            if (plugin != null && HRStringUtils.isNotEmpty((String)(validateMsgResult = plugin.validateCalibrationPerson(activityId, calSessionId, personId)))) {
                msgOfPersonMap.put(personIdStr, validateMsgResult);
            }
            return null;
        });
    }

    public void beforeClosed(BeforeClosedEvent evt) {
        IFormView parentView;
        super.beforeClosed(evt);
        String tempCalInfo = this.getPageCache().get(CACHE_TEMP_CALIBRATION_INFO);
        String confirmClose = this.getPageCache().get(CONFIRM_CLOSE);
        if (this.isEditable() && !StringUtils.equals((String)confirmClose, (String)"1") && HRStringUtils.isNotEmpty((String)tempCalInfo)) {
            evt.setCancel(true);
            HashMap btnNameMap = Maps.newHashMapWithExpectedSize((int)2);
            btnNameMap.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"OnlineCalibrationCalibrateList_6", (String)"tdc-oatr-formplugin", (Object[])new Object[0]));
            btnNameMap.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"OnlineCalibrationCalibrateList_7", (String)"tdc-oatr-formplugin", (Object[])new Object[0]));
            this.getView().showConfirm(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\r\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"OnlineCalibrationCalibrateList_5", (String)"tdc-oatr-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(CONFIRM_CLOSE), (Map)btnNameMap);
        } else if (this.getView().getFormShowParameter().getParentFormId().equals("oatr_onlinecaldetail") && (parentView = this.getView().getParentView()) != null) {
            parentView.close();
            this.getView().sendFormAction(this.getView().getParentView());
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (StringUtils.equals((String)callBackId, (String)CONFIRM_REFRESH) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            this.getPageCache().put(CACHE_TEMP_CALIBRATION_INFO, null);
            this.getView().invokeOperation("refresh");
        }
        if (StringUtils.equals((String)callBackId, (String)CONFIRM_CLOSE) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            this.getPageCache().put(CONFIRM_CLOSE, "1");
            this.getView().close();
        }
    }

    public void customEvent(CustomEventArgs eventArgs) {
        super.customEvent(eventArgs);
        String eventName = eventArgs.getEventName();
        String eventArgString = eventArgs.getEventArgs();
        if (HRStringUtils.equals((String)eventName, (String)EVENT_NAME_GET_PERSON_CARD_INFO)) {
            this.handleGetPersonCardInfoEvent(eventArgString);
            return;
        }
        if (HRStringUtils.equals((String)eventName, (String)EVENT_NAME_GET_GRID_CARD_INFO)) {
            this.handleGetGridCardInfoEvent(eventArgString);
            return;
        }
        if (HRStringUtils.equals((String)eventName, (String)EVENT_NAME_SHOW_TALENT_MAP)) {
            this.handleShowTalentMapEvent();
            return;
        }
        if (HRStringUtils.equals((String)eventName, (String)EVENT_NAME_UPDATE_PERSON_CARD)) {
            this.handleUpdatePersonCardEvent(eventName, eventArgString);
            return;
        }
        if (HRStringUtils.equals((String)eventName, (String)EVENT_NAME_LOAD_FILTER_CONTENT)) {
            this.showFilterFlexView();
            return;
        }
        if (HRStringUtils.equals((String)eventName, (String)EVENT_NAME_CHECK_VIEW_PERM)) {
            OperateOption option = OperateOption.create();
            option.setVariableValue(OPTION_PARAM_EVENT_NAME, eventName);
            option.setVariableValue(OPTION_PARAM_EVENT_DATA, eventArgString);
            this.getView().invokeOperation(OP_VIEW_FOR_PERM, option);
        }
    }

    public void clientCallBack(ClientCallBackEvent evt) {
        super.clientCallBack(evt);
        String name = evt.getName();
        if (HRStringUtils.equals((String)name, (String)"beginCalibrateAction")) {
            this.initOnlineCalibrationView();
        }
        if (HRStringUtils.equals((String)name, (String)"refreshData")) {
            BillList list = (BillList)this.getView().getControl("billlistap");
            list.refresh();
        }
    }

    private void initOnlineCalibrationView() {
        OnlineCalibrationInfo onlineCalibrationInfo = this.getOnlineCalibrationInfo();
        this.loadOnlineCalibrationView(onlineCalibrationInfo);
    }

    private OnlineCalibrationInfo getOnlineCalibrationInfo() {
        Object activityIdObj = this.getView().getFormShowParameter().getCustomParam("activityId");
        Object sessionIdObj = this.getView().getFormShowParameter().getCustomParam("calSessionId");
        if (activityIdObj == null || sessionIdObj == null) {
            LOG.error("OnlineCalibrationCalibrateList.getOnlineCalibrationInfo: param is error, activityIdObj={}, sessionIdObj={}", activityIdObj, sessionIdObj);
            return null;
        }
        Long calibrateSessionId = Long.valueOf(sessionIdObj.toString());
        Long activityId = Long.valueOf(activityIdObj.toString());
        DynamicObject calibrateSession = this.calSessionQueryService.getCalibrateSession(calibrateSessionId);
        DynamicObject reviewActivity = this.activityQueryService.getReviewActivity((Object)activityId);
        if (calibrateSession == null || reviewActivity == null) {
            LOG.error("OnlineCalibrationCalibrateList.getOnlineCalibrationInfo: query activity or calibrate session is error, calibrateSession={}, reviewActivity={}", (Object)HRDyObjectPropUtil.getId((DynamicObject)calibrateSession), (Object)HRDyObjectPropUtil.getId((DynamicObject)reviewActivity));
            return null;
        }
        List<Long> currentIds = this.getCurrentIdsFromList();
        DynamicObject[] onlineCalibrateData = this.onlineCalibrationQueryService.listOnlineCalibrationOriginalData(currentIds);
        this.cachePersonIdToOnlineCalibrationId(onlineCalibrateData);
        String calibrateStatus = calibrateSession.getString("calibratestatus");
        if (HRStringUtils.equals((String)calibrateStatus, (String)CalibrateSessionStatusEnum.WAIT_START.getCode())) {
            return this.getWaitStartOnlineCalibrationInfo(calibrateSession, reviewActivity, onlineCalibrateData);
        }
        if (HRStringUtils.equals((String)calibrateStatus, (String)CalibrateSessionStatusEnum.GOING.getCode()) || HRStringUtils.equals((String)calibrateStatus, (String)CalibrateSessionStatusEnum.END.getCode())) {
            return this.getGoingOnlineCalibrationInfo(calibrateSession, onlineCalibrateData);
        }
        LOG.error("OnlineCalibrationCalibrateList.getOnlineCalibrationInfo: calibrate session status is error, calibrateSessionId={}, activityId={}", (Object)calibrateSessionId, (Object)activityId);
        return null;
    }

    private void loadOnlineCalibrationView(OnlineCalibrationInfo calibrationInfo) {
        CustomControl gridControl = (CustomControl)this.getView().getControl("customcontrolap");
        if (gridControl == null) {
            return;
        }
        Map<String, Object> mapData = this.getCustomEventParams("loadData");
        String dataJsonStr = SerializationUtils.toJsonString((Object)calibrationInfo);
        mapData.put("data", SerializationUtils.fromJsonString((String)dataJsonStr, Map.class));
        this.extendPluginModifyMapData(mapData);
        gridControl.setData(mapData);
    }

    private void extendPluginModifyMapData(Map<String, Object> mapData) {
        HRPluginProxy pluginProxy = HRPlugInProxyFactory.create(null, IOnlineCalibrationMapExtService.class, (String)"kd.sdk.tdc.oatr.onlinecalibrate.IOnlineCalibrationMapExtService", null);
        pluginProxy.callReplaceIfPresent(plugin -> {
            if (plugin != null) {
                plugin.modifyCalibrationMapData(mapData);
            }
            return null;
        });
    }

    private void cachePersonIdToOnlineCalibrationId(DynamicObject[] onlineCalibrateData) {
        Map<String, String> personIdToOnlineCalIdMap = Arrays.stream(onlineCalibrateData).collect(Collectors.toMap(onlineCalibrate -> String.valueOf(onlineCalibrate.getLong("person.id")), onlineCalibrate -> String.valueOf(onlineCalibrate.getLong("id")), (v1, v2) -> v2));
        this.getPageCache().put(CACHE_PERSON_ID_TO_ONLINE_CAL_ID, SerializationUtils.toJsonString(personIdToOnlineCalIdMap));
    }

    private OnlineCalibrationInfo getWaitStartOnlineCalibrationInfo(DynamicObject calibrateSession, DynamicObject reviewActivity, DynamicObject[] onlineCalibrateData) {
        Long mapId;
        Object talentMapId = calibrateSession.get("talentmap");
        if (talentMapId == null || HRStringUtils.isEmpty((String)talentMapId.toString())) {
            LOG.error("OnlineCalibrationCalibrateList.getWaitStartOnlineCalibrationInfo: talentMapId is null");
            return null;
        }
        Long activityId = HRDyObjectPropUtil.getId((DynamicObject)reviewActivity);
        DynamicObject talentMapConfig = this.talentMapQueryService.getOneTalentMapConfig(activityId, mapId = Long.valueOf(talentMapId.toString()));
        if (HRObjectUtils.isEmpty((Object)talentMapConfig)) {
            LOG.error("OnlineCalibrationCalibrateList.getWaitStartOnlineCalibrationInfo: talentMap of activity is null");
            return null;
        }
        DynamicObjectCollection talentMapEntry = talentMapConfig.getDynamicObjectCollection("talentmapentry");
        if (talentMapEntry.isEmpty()) {
            LOG.error("OnlineCalibrationCalibrateList.getWaitStartOnlineCalibrationInfo: talentMapEntry is null");
            return null;
        }
        DynamicObject talentMap = (DynamicObject)talentMapEntry.get(0);
        String mapConfigData = talentMap.getString("talentmapconfig_tag");
        if (HRStringUtils.isEmpty((String)mapConfigData)) {
            LOG.error("OnlineCalibrationCalibrateList.getWaitStartOnlineCalibrationInfo: talentMap data is null");
            return null;
        }
        TalentMapConfigInfo talentMapConfigInfo = (TalentMapConfigInfo)SerializationUtils.fromJsonString((String)mapConfigData, TalentMapConfigInfo.class);
        String xAxisDimName = talentMap.getString("xaxisdim.name");
        String yAxisDimName = talentMap.getString("yaxisdim.name");
        talentMapConfigInfo.getxAxisInfo().setName(xAxisDimName);
        talentMapConfigInfo.getyAxisInfo().setName(yAxisDimName);
        List reviewObjIds = Arrays.stream(onlineCalibrateData).map(onlineCalibrate -> onlineCalibrate.getLong("reviewobject.id")).collect(Collectors.toList());
        DynamicObject[] reviewObjectData = this.reviewObjectQueryService.getReviewObjectData(reviewObjIds);
        String isRequireReason = calibrateSession.getString("calibratereason");
        String reasonWriteWay = calibrateSession.getString("writeway");
        Map calibrateBeforeResultMap = this.calibrationApplicationService.getCalibrateResultBefore(reviewObjectData, String.valueOf(mapId));
        long sessionId = calibrateSession.getLong("id");
        Map reviewObjectCalibrationHistory = this.calibrationApplicationService.queryCalibrationHistory(sessionId, talentMapId.toString(), reviewObjIds);
        OnlineCalibrationInfo onlineCalibrationInfo = new OnlineCalibrationInfo();
        Map<String, PersonCardInfo> personCardInfoMap = this.cacheWaitGridPersonCardInfo(onlineCalibrateData, talentMap, reviewObjectData, calibrateBeforeResultMap, reviewObjectCalibrationHistory);
        onlineCalibrationInfo.setRequireReason(HRStringUtils.equals((String)isRequireReason, (String)"1"));
        onlineCalibrationInfo.setMenu("card");
        ArrayList<ShowCustomIcon> showCustomIconList = new ArrayList<ShowCustomIcon>(10);
        int size = talentMapConfigInfo.getGridData().getGridBlocks().size();
        for (int i = 0; i < size; ++i) {
            ShowCustomIcon showCustomIcon = new ShowCustomIcon();
            showCustomIcon.setShowCustomIcon(false);
            showCustomIcon.setSysGridNumber(String.valueOf(i));
            showCustomIcon.setCustomIconPath("");
            showCustomIconList.add(showCustomIcon);
        }
        onlineCalibrationInfo.setShowCustomIcon(showCustomIconList);
        this.setWaitCalibrateBoardInfo(onlineCalibrationInfo, talentMapConfigInfo, calibrateBeforeResultMap);
        onlineCalibrationInfo.setCalibratedAscOrder(true);
        onlineCalibrationInfo.setCalibratedPerson(new CalibratePerson[0]);
        this.setWaitTalentMapInfo(onlineCalibrationInfo, talentMapConfigInfo, personCardInfoMap);
        onlineCalibrationInfo.setShowPopup(HRStringUtils.equals((String)reasonWriteWay, (String)"1"));
        return onlineCalibrationInfo;
    }

    private OnlineCalibrationInfo getGoingOnlineCalibrationInfo(DynamicObject calibrateSession, DynamicObject[] onlineCalibrateData) {
        TalentMapConfigInfo talentMapConfigInfo = this.getTalentMapInfoData(HRDyObjectPropUtil.getId((DynamicObject)calibrateSession));
        if (talentMapConfigInfo == null) {
            LOG.error("OnlineCalibrationCalibrateList.getGoingOnlineCalibrationInfo: talent map is null");
            return null;
        }
        String isRequireReason = calibrateSession.getString("calibratereason");
        String reasonWriteWay = calibrateSession.getString("writeway");
        Map<String, PersonCardInfo> personCardInfoMap = this.cacheGridPersonCardInfo(talentMapConfigInfo, calibrateSession, onlineCalibrateData);
        OnlineCalibrationInfo onlineCalibrationInfo = new OnlineCalibrationInfo();
        onlineCalibrationInfo.setRequireReason(HRStringUtils.equals((String)isRequireReason, (String)"1"));
        onlineCalibrationInfo.setMenu("card");
        ArrayList<ShowCustomIcon> showCustomIconList = new ArrayList<ShowCustomIcon>(10);
        int size = talentMapConfigInfo.getGridData().getGridBlocks().size();
        for (int i = 0; i < size; ++i) {
            ShowCustomIcon showCustomIcon = new ShowCustomIcon();
            showCustomIcon.setShowCustomIcon(false);
            showCustomIcon.setSysGridNumber(String.valueOf(i));
            showCustomIcon.setCustomIconPath("");
            showCustomIconList.add(showCustomIcon);
        }
        onlineCalibrationInfo.setShowCustomIcon(showCustomIconList);
        onlineCalibrationInfo.setCalibratedAscOrder(false);
        this.setCalibrateBoardInfo(onlineCalibrationInfo, talentMapConfigInfo, onlineCalibrateData);
        this.setCalibratedPerson(onlineCalibrationInfo, onlineCalibrateData, personCardInfoMap);
        this.setTalentMapInfo(onlineCalibrationInfo, talentMapConfigInfo, onlineCalibrateData, personCardInfoMap);
        onlineCalibrationInfo.setShowPopup(HRStringUtils.equals((String)reasonWriteWay, (String)"1"));
        return onlineCalibrationInfo;
    }

    private void handleUpdatePersonCardEvent(String eventName, String eventArgString) {
        if (HRStringUtils.isEmpty((String)eventArgString)) {
            return;
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue(OPTION_PARAM_EVENT_NAME, eventName);
        option.setVariableValue(OPTION_PARAM_EVENT_DATA, eventArgString);
        this.getView().invokeOperation(OP_INTERACT, option);
    }

    private void handleShowTalentMapEvent() {
        Object sessionIdObj = this.getView().getFormShowParameter().getCustomParam("calSessionId");
        Object activityIdObj = this.getView().getFormShowParameter().getCustomParam("activityId");
        String msg = ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u88ab\u5176\u4ed6\u4eba\u5220\u9664\u4e86\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"OnlineCalibrationOperateList_7", (String)"tdc-oatr-formplugin", (Object[])new Object[0]);
        if (activityIdObj == null || sessionIdObj == null) {
            this.getView().showErrorNotification(msg);
            return;
        }
        DynamicObject reviewActivity = this.activityQueryService.getReviewActivity((Object)Long.valueOf(activityIdObj.toString()));
        DynamicObject calibrateSession = this.calSessionQueryService.getCalibrateSession(Long.valueOf(Long.parseLong(sessionIdObj.toString())));
        if (reviewActivity == null || calibrateSession == null) {
            this.getView().showErrorNotification(msg);
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("oatr_previewtalentmap");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        OpenStyle openStyle = formShowParameter.getOpenStyle();
        openStyle.setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("calibrateSessionId", sessionIdObj);
        formShowParameter.setCustomParam("activityId", activityIdObj);
        this.getView().showForm(formShowParameter);
    }

    private void handleGetGridCardInfoEvent(String eventArgString) {
        if (HRStringUtils.isEmpty((String)eventArgString)) {
            return;
        }
        Map params = (Map)SerializationUtils.fromJsonString((String)eventArgString, Map.class);
        String gridNumber = (String)params.get("number");
        Map<String, List<String>> gridPersonIdMap = this.getGridPersonIdMapFormCache();
        Map<String, PersonCardInfo> personCardInfoMap = this.getPersonCardInfoMapFormCache();
        if (gridPersonIdMap.isEmpty() || personCardInfoMap.isEmpty()) {
            return;
        }
        List<String> personIdList = gridPersonIdMap.get(gridNumber);
        if (CollectionUtils.isEmpty(personIdList)) {
            return;
        }
        GridCardInfo gridCardInfo = new GridCardInfo();
        gridCardInfo.setGridNumber(gridNumber);
        PersonCardInfo[] personCardInfos = new PersonCardInfo[personIdList.size()];
        int index = 0;
        for (String personId : personIdList) {
            personCardInfos[index] = personCardInfoMap.get(personId);
            ++index;
        }
        gridCardInfo.setGridName(personCardInfos[0].getCalibratePath().getAfterCard());
        gridCardInfo.setPersonInfo(personCardInfos);
        this.showGridCardInfoView(gridCardInfo);
    }

    private void handleGetPersonCardInfoEvent(String eventArgString) {
        if (HRStringUtils.isEmpty((String)eventArgString)) {
            return;
        }
        PersonCardInfo personCardInfoReq = (PersonCardInfo)SerializationUtils.fromJsonString((String)eventArgString, PersonCardInfo.class);
        Map<String, PersonCardInfo> personCardInfoMap = this.getPersonCardInfoMapFormCache();
        if (personCardInfoMap.isEmpty()) {
            return;
        }
        PersonCardInfo personCardInfoResp = personCardInfoMap.get(String.valueOf(personCardInfoReq.getPersonId()));
        this.showPersonCardInfoView(personCardInfoResp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calibrateSuccess(PersonCardInfo personCardInfo) {
        boolean autoSaveParam;
        if (personCardInfo == null) {
            return;
        }
        String personId = personCardInfo.getPersonId();
        String autoSaveString = this.getPageCache().get(CACHE_IS_AUTO_SAVE_PARAM);
        boolean bl = autoSaveParam = HRStringUtils.isEmpty((String)autoSaveString) ? false : Boolean.parseBoolean(autoSaveString);
        if (!autoSaveParam) {
            String tempCalInfoStr = this.getPageCache().get(CACHE_TEMP_CALIBRATION_INFO);
            Map<String, PersonCardInfo> tempCalInfoMap = HRStringUtils.isNotEmpty((String)tempCalInfoStr) ? (Map)SerializationUtils.deSerializeFromBase64((String)tempCalInfoStr) : Maps.newHashMapWithExpectedSize((int)16);
            tempCalInfoMap.put(personId, personCardInfo);
            this.getPageCache().put(CACHE_TEMP_CALIBRATION_INFO, SerializationUtils.serializeToBase64(tempCalInfoMap));
            this.updateCachePersonInfo(personCardInfo);
        } else {
            String updateResult = "";
            try (TXHandle txhandle = TX.required((String)"OnlineCalibrationCalibrateList");){
                HashMap personCardInfoMap = Maps.newHashMapWithExpectedSize((int)1);
                personCardInfoMap.put(personCardInfo.getPersonId(), personCardInfo);
                updateResult = this.onlineCalibrationFormService.updateDBOnlineCalibrationInfo((Map)personCardInfoMap, (AbstractFormPlugin)this);
                if (HRStringUtils.isNotEmpty((String)updateResult)) {
                    this.onlineCalibrationFormService.recordCollaborationBusinessData((AbstractFormPlugin)this);
                    this.updateCachePersonInfo(personCardInfo);
                }
            }
            this.updateAdjustNumLabel();
        }
    }

    private void updateAdjustNumLabel() {
        Map<String, PersonCardInfo> personCardInfoMap = this.getPersonCardInfoMapFormCache();
        List calibratedPersonList = personCardInfoMap.values().stream().filter(personCardInfo -> {
            CalibratePath calibratePath = personCardInfo.getCalibratePath();
            return HRStringUtils.isNotEmpty((String)calibratePath.getAfterCard()) && !HRStringUtils.equals((String)calibratePath.getBeforeCard(), (String)calibratePath.getAfterCard());
        }).collect(Collectors.toList());
        Label adjustNumLbl = (Label)this.getView().getControl("adjustnum");
        adjustNumLbl.setText(String.valueOf(calibratedPersonList.size()));
    }

    private void updateCachePersonInfo(PersonCardInfo personCardInfo) {
        String afterCalibratePath;
        String gridNumberAft;
        List<String> personIdsAft;
        String personId = personCardInfo.getPersonId();
        if (HRStringUtils.isEmpty((String)personId)) {
            return;
        }
        Map<String, List<String>> gridPersonIdMap = this.getGridPersonIdMapFormCache();
        if (gridPersonIdMap.isEmpty()) {
            return;
        }
        for (Map.Entry<String, List<String>> personIdEntry : gridPersonIdMap.entrySet()) {
            if (!personIdEntry.getValue().contains(personId)) continue;
            personIdEntry.getValue().remove(personId);
            break;
        }
        if (CollectionUtils.isEmpty(personIdsAft = gridPersonIdMap.get(gridNumberAft = this.getGridNumberFormCalibratePath(afterCalibratePath = personCardInfo.getCalibratePath().getAfterCard())))) {
            personIdsAft = new ArrayList<String>(10);
            gridPersonIdMap.put(gridNumberAft, personIdsAft);
        }
        personIdsAft.add(0, personId);
        Map<String, PersonCardInfo> personCardInfoMap = this.getPersonCardInfoMapFormCache();
        if (personCardInfoMap.isEmpty()) {
            return;
        }
        PersonCardInfo personCardInfoCache = personCardInfoMap.get(personId);
        personCardInfoCache.setCalibratePath(personCardInfo.getCalibratePath());
        personCardInfoCache.setReason(personCardInfo.getReason());
        this.getPageCache().put(CACHE_GRID_PERSON_ID_MAP, SerializationUtils.toJsonString(gridPersonIdMap));
        this.getPageCache().put(CACHE_PERSON_CARD_INFO_MAP, SerializationUtils.toJsonString(personCardInfoMap));
    }

    private Map<String, PersonCardInfo> getPersonCardInfoMapFormCache() {
        String personCardInfoMapCacheStr = this.getPageCache().get(CACHE_PERSON_CARD_INFO_MAP);
        if (HRStringUtils.isEmpty((String)personCardInfoMapCacheStr)) {
            return new HashMap<String, PersonCardInfo>(0);
        }
        Map personCardObjMap = (Map)SerializationUtils.fromJsonString((String)personCardInfoMapCacheStr, Map.class);
        HashMap personCardInfoMap = Maps.newHashMapWithExpectedSize((int)personCardObjMap.size());
        for (Map.Entry perEntry : personCardObjMap.entrySet()) {
            String value = SerializationUtils.toJsonString(perEntry.getValue());
            personCardInfoMap.put(perEntry.getKey(), SerializationUtils.fromJsonString((String)value, PersonCardInfo.class));
        }
        return personCardInfoMap;
    }

    private Map<String, List<String>> getGridPersonIdMapFormCache() {
        String gridPersonIdMapCacheStr = this.getPageCache().get(CACHE_GRID_PERSON_ID_MAP);
        if (HRStringUtils.isEmpty((String)gridPersonIdMapCacheStr)) {
            return new HashMap<String, List<String>>(0);
        }
        return (Map)SerializationUtils.fromJsonString((String)gridPersonIdMapCacheStr, Map.class);
    }

    private Map<String, PersonCardInfo> cacheWaitGridPersonCardInfo(DynamicObject[] onlineCalibrateData, DynamicObject talentMap, DynamicObject[] reviewObjectData, Map<Long, String> calibrateBeforeResultMap, Map<Long, List<Map<String, String>>> reviewObjectCalibrationHistory) {
        HashMap gridPersonIdMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap personCardInfoMap = Maps.newHashMapWithExpectedSize((int)reviewObjectData.length);
        Map<Long, DynamicObject> reviewObjectMap = Arrays.stream(reviewObjectData).collect(Collectors.toMap(reviewObject -> reviewObject.getLong("person.id"), reviewObject -> reviewObject, (v1, v2) -> v2));
        for (DynamicObject calibrateDatum : onlineCalibrateData) {
            long personId = calibrateDatum.getLong("person.id");
            DynamicObject reviewObject2 = reviewObjectMap.get(personId);
            long reviewObjectId = reviewObject2.getLong("id");
            String calibrateBefore = calibrateBeforeResultMap.get(reviewObjectId);
            String gridNumber = this.getCalibratePositionNumber(calibrateBefore);
            if (HRStringUtils.isEmpty((String)gridNumber)) continue;
            List personIdList = (List)gridPersonIdMap.get(gridNumber);
            if (CollectionUtils.isEmpty((Collection)personIdList)) {
                personIdList = Lists.newArrayListWithExpectedSize((int)10);
                gridPersonIdMap.put(gridNumber, personIdList);
            }
            personIdList.add(String.valueOf(personId));
            String personName = calibrateDatum.getString("person.name");
            String personNumber = calibrateDatum.getString("person.number");
            String personHeadSculpture = calibrateDatum.getString("person.headsculpture");
            PersonCardInfo personCardInfo = new PersonCardInfo();
            personCardInfo.setPersonId(String.valueOf(personId));
            personCardInfo.setPersonName(personName);
            personCardInfo.setPersonNumber(personNumber);
            personCardInfo.setHeadSculpture(HRImageUrlUtil.getImageFullUrl((String)personHeadSculpture));
            personCardInfo.setCalibrated(false);
            CalibratePath calibratePath = new CalibratePath();
            calibratePath.setBeforeCard(this.calibrationApplicationService.transCalibratePositionToPath(calibrateBefore));
            calibratePath.setAfterCard(this.calibrationApplicationService.transCalibratePositionToPath(calibrateBefore));
            personCardInfo.setCalibratePath(calibratePath);
            personCardInfo.setReason("");
            String adminOrgName = reviewObject2.getString("adminorg.name");
            personCardInfo.setDepartment(adminOrgName);
            String jobName = OnlineCalibrationCalibrateList.getJobName(reviewObject2);
            personCardInfo.setJob(HRStringUtils.isEmpty((String)jobName) ? "" : jobName);
            String superEvalName = OnlineCalibrationCalibrateList.getSuperEvalName(reviewObject2);
            personCardInfo.setDirectSupervisor(superEvalName);
            List<PersonCardDimension> personCardDimensionList = this.setPerCardDimInfo(talentMap, reviewObject2);
            PersonCardDimension[] personCardDimensions = personCardDimensionList.toArray(new PersonCardDimension[0]);
            personCardInfo.setPerCardDims(personCardDimensions);
            List<Map<String, String>> hisList = reviewObjectCalibrationHistory.get(reviewObjectId);
            ArrayList<CalibratePathHis> calibratePathHisList = new ArrayList<CalibratePathHis>(10);
            if (hisList != null) {
                for (Map<String, String> hisMap : hisList) {
                    String sessionName = this.getStringData(hisMap.get("sessionName"));
                    String beforeCalibrate = this.getStringData(hisMap.get("beforeCalibrate"));
                    String calibrateResult = this.getStringData(hisMap.get("calibrateResult"));
                    String calibrateReason = this.getStringData(hisMap.get("calibrateReason"));
                    CalibratePathHis calibratePathHis = new CalibratePathHis();
                    calibratePathHis.setTitle(sessionName);
                    CalibratePath caliPath = new CalibratePath();
                    caliPath.setBeforeCard(this.getCalibratePositionNumber(beforeCalibrate));
                    caliPath.setAfterCard(this.getCalibratePositionNumber(calibrateResult));
                    calibratePathHis.setCalibratePath(caliPath);
                    calibratePathHis.setReason(calibrateReason);
                    calibratePathHisList.add(calibratePathHis);
                }
            }
            personCardInfo.setHistory(calibratePathHisList.toArray(new CalibratePathHis[0]));
            personCardInfo.setCalibrateImg(new String[0]);
            personCardInfoMap.put(personCardInfo.getPersonId(), personCardInfo);
        }
        this.getPageCache().put(CACHE_GRID_PERSON_ID_MAP, SerializationUtils.toJsonString((Object)gridPersonIdMap));
        this.getPageCache().put(CACHE_PERSON_CARD_INFO_MAP, SerializationUtils.toJsonString((Object)personCardInfoMap));
        return personCardInfoMap;
    }

    private String getStringData(String data) {
        if (HRStringUtils.isEmpty((String)data)) {
            return "";
        }
        return data;
    }

    private static String getSuperEvalName(DynamicObject reviewObject) {
        DynamicObjectCollection superEvalCollection = reviewObject.getDynamicObjectCollection("supereval");
        return superEvalCollection.stream().map(superEval -> HRDyObjectPropUtil.getName((DynamicObject)superEval.getDynamicObject("fbasedataid"))).collect(Collectors.joining(","));
    }

    private List<PersonCardDimension> setPerCardDimInfo(DynamicObject perCardDimObj, DynamicObject reviewObject) {
        DynamicObjectCollection perCardDimCollection = perCardDimObj.getDynamicObjectCollection("percarddim");
        ArrayList personCardDimensionList = Lists.newArrayListWithExpectedSize((int)perCardDimCollection.size());
        if (!CollectionUtils.isEmpty((Collection)perCardDimCollection)) {
            List perCardDimIds = perCardDimCollection.stream().map(perCardDim -> perCardDim.getLong("fbasedataid_id")).collect(Collectors.toList());
            DynamicObjectCollection dimensionEntryCollection = reviewObject.getDynamicObjectCollection("entryentity_dimension");
            for (DynamicObject dimensionEntry : dimensionEntryCollection) {
                DynamicObject dimension = dimensionEntry.getDynamicObject("dimension");
                long dimId = HRDyObjectPropUtil.getId((DynamicObject)dimension);
                if (!perCardDimIds.contains(dimId)) continue;
                String dimName = HRDyObjectPropUtil.getName((DynamicObject)dimension);
                String dimensionValue = dimensionEntry.getString("dimensionvalue");
                PersonCardDimension personCardDimension = new PersonCardDimension();
                personCardDimension.setDimName(dimName);
                personCardDimension.setDimValue(dimensionValue);
                personCardDimensionList.add(personCardDimension);
            }
        }
        return personCardDimensionList;
    }

    private static String getJobName(DynamicObject reviewObject) {
        String posPattern = reviewObject.getString("pospattern");
        String jobName = "";
        switch (posPattern) {
            case "0": {
                jobName = reviewObject.getString("stdposition.name");
                break;
            }
            case "1": {
                jobName = reviewObject.getString("position.name");
                break;
            }
            case "2": {
                jobName = reviewObject.getString("job.name");
                break;
            }
        }
        return jobName;
    }

    private void setWaitTalentMapInfo(OnlineCalibrationInfo onlineCalibrationInfo, TalentMapConfigInfo talentMapConfigInfo, Map<String, PersonCardInfo> personCardInfoMap) {
        TalentMapInfo talentMapInfo = new TalentMapInfo();
        talentMapInfo.setxAxisInfo(talentMapConfigInfo.getxAxisInfo());
        talentMapInfo.setyAxisInfo(talentMapConfigInfo.getyAxisInfo());
        talentMapInfo.setGridData(talentMapConfigInfo.getGridData());
        List gridBlocks = talentMapConfigInfo.getGridData().getGridBlocks();
        int gridSize = gridBlocks.size();
        GridPersonInfo[] gridPersonInfos = new GridPersonInfo[gridSize];
        Map<String, List<String>> gridPersonIdMap = this.getGridPersonIdMapFormCache();
        Map<String, String> gridNameMap = gridBlocks.stream().collect(Collectors.toMap(GridBlockInfo::getCustomNumber, gridBlock -> gridBlock.getName().getText(), (v1, v2) -> v1));
        List customNumberList = gridBlocks.stream().map(GridBlockInfo::getCustomNumber).collect(Collectors.toList());
        for (int i = 0; i < gridSize; ++i) {
            String gridNumber = (String)customNumberList.get(i);
            GridPersonInfo gridPersonInfo = new GridPersonInfo();
            gridPersonInfo.setGridNumber(gridNumber);
            gridPersonInfo.setGridName(gridNameMap.get(gridNumber));
            List<String> personIdList = gridPersonIdMap.get(gridNumber);
            if (CollectionUtils.isEmpty(personIdList)) {
                personIdList = new ArrayList<String>(0);
            }
            int calibrateSize = personIdList.size();
            ArrayList personInfoList = Lists.newArrayListWithExpectedSize((int)calibrateSize);
            for (int j = 0; j < calibrateSize; ++j) {
                String personId = personIdList.get(j);
                PersonCardInfo personCardInfo = personCardInfoMap.get(personId);
                if (personCardInfo == null) continue;
                PersonInfo personInfo = new PersonInfo();
                personInfo.setPersonId(String.valueOf(personId));
                personInfo.setPersonName(personCardInfo.getPersonName());
                personInfo.setPersonNumber(personCardInfo.getPersonNumber());
                personInfo.setHeadSculpture(personCardInfo.getHeadSculpture());
                personInfo.setCalibrated(false);
                personInfo.setCalibratePath(personCardInfo.getCalibratePath());
                personInfo.setReason("");
                personInfo.setDepartment(personCardInfo.getDepartment());
                personInfo.setJob(personCardInfo.getJob());
                personInfo.setDirectSupervisor(personCardInfo.getDirectSupervisor());
                personInfo.setPerCardDims(personCardInfo.getPerCardDims());
                personInfo.setHistory(personCardInfo.getHistory());
                personInfo.setCalibrateImg(personCardInfo.getCalibrateImg());
                personInfoList.add(personInfo);
            }
            gridPersonInfo.setPersonInfo(personInfoList.toArray(new PersonInfo[0]));
            gridPersonInfos[i] = gridPersonInfo;
        }
        talentMapInfo.setGridPersonInfo(gridPersonInfos);
        onlineCalibrationInfo.setTalentMapInfo(talentMapInfo);
    }

    private void setWaitCalibrateBoardInfo(OnlineCalibrationInfo onlineCalibrationInfo, TalentMapConfigInfo talentMapConfigInfo, Map<Long, String> calibrateBeforeResultMap) {
        Collection<String> calibrateBeforeResult = calibrateBeforeResultMap.values();
        Map<String, List<String>> beforeResultSizeMap = calibrateBeforeResult.stream().filter(HRStringUtils::isNotEmpty).collect(Collectors.groupingBy(this::getCalibratePositionNumber));
        int allSize = (int)calibrateBeforeResult.stream().filter(HRStringUtils::isNotEmpty).count();
        CalibrateBoardInfo calibrateBoardInfo = new CalibrateBoardInfo();
        Map<String, String> customNumberMap = talentMapConfigInfo.getGridData().getGridBlocks().stream().collect(Collectors.toMap(GridBlockInfo::getNumber, GridBlockInfo::getCustomNumber, (v1, v2) -> v2));
        MapBlockRatioInfo[] ratioInfos = talentMapConfigInfo.getDistributionRatio().getValues();
        int gridSize = ratioInfos.length;
        Map<String, String> radioInfoMap = Arrays.stream(ratioInfos).collect(Collectors.toMap(info -> (String)customNumberMap.get(info.getGridBlockNo()), MapBlockRatioInfo::getRatio, (v1, v2) -> v1));
        List customNumberList = talentMapConfigInfo.getGridData().getGridBlocks().stream().map(GridBlockInfo::getCustomNumber).collect(Collectors.toList());
        CalibrateBoardItemInfo[] data = new CalibrateBoardItemInfo[gridSize];
        for (int i = 0; i < gridSize; ++i) {
            CalibrateBoardItemInfo boardItemInfo = new CalibrateBoardItemInfo();
            String gridNumber = (String)customNumberList.get(i);
            boardItemInfo.setGridNumber(gridNumber);
            String adviseRatioStr = radioInfoMap.get(gridNumber);
            boardItemInfo.setAdviseRatio(this.formatPercentData(adviseRatioStr));
            BigDecimal beforeRadio = BigDecimal.ZERO;
            List<String> beforeSize = beforeResultSizeMap.get(gridNumber);
            if (!CollectionUtils.isEmpty(beforeSize)) {
                beforeRadio = new BigDecimal(beforeSize.size()).divide(new BigDecimal(allSize), 4, RoundingMode.HALF_UP);
            }
            boardItemInfo.setBeforeRatio(this.formatPercentData(beforeRadio));
            boardItemInfo.setAfterRatio("0.00%");
            data[i] = boardItemInfo;
        }
        calibrateBoardInfo.setData(data);
        onlineCalibrationInfo.setCalibrateBoard(calibrateBoardInfo);
    }

    private TalentMapConfigInfo getTalentMapInfoData(Long calibrateSessionId) {
        DynamicObject calibrateSession = this.calSessionQueryService.getCalibrateSession(calibrateSessionId);
        String talentMapConfig = calibrateSession.getString("talentmapconfig_tag");
        if (HRStringUtils.isEmpty((String)talentMapConfig)) {
            return null;
        }
        TalentMapConfigInfo mapConfigInfo = (TalentMapConfigInfo)SerializationUtils.fromJsonString((String)talentMapConfig, TalentMapConfigInfo.class);
        String xAxisDimName = calibrateSession.getString("xaxisdim.name");
        String yAxisDimName = calibrateSession.getString("yaxisdim.name");
        mapConfigInfo.getxAxisInfo().setName(xAxisDimName);
        mapConfigInfo.getyAxisInfo().setName(yAxisDimName);
        return mapConfigInfo;
    }

    private List<Long> getCurrentIdsFromList() {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection currentListAllRowCollection = billList.getCurrentListAllRowCollection();
        return currentListAllRowCollection.stream().map(row -> Long.valueOf(row.getPrimaryKeyValue().toString())).collect(Collectors.toList());
    }

    private Map<String, PersonCardInfo> cacheGridPersonCardInfo(TalentMapConfigInfo talentMapConfigInfo, DynamicObject calibrateSession, DynamicObject[] onlineCalibrateData) {
        Object activityIdObj = this.getView().getFormShowParameter().getCustomParam("activityId");
        Object sessionIdObj = this.getView().getFormShowParameter().getCustomParam("calSessionId");
        if (activityIdObj == null || sessionIdObj == null) {
            return new HashMap<String, PersonCardInfo>(0);
        }
        if (onlineCalibrateData.length == 0) {
            return new HashMap<String, PersonCardInfo>(0);
        }
        List calibratedData = Arrays.stream(onlineCalibrateData).filter(calibrateData -> HRStringUtils.isNotEmpty((String)calibrateData.getString("calibratebefore"))).collect(Collectors.toList());
        List reviewObjectIds = calibratedData.stream().map(calibrateDatum -> calibrateDatum.getLong("reviewobject.id")).collect(Collectors.toList());
        Object talentMapId = calibrateSession.get("talentmap");
        if (talentMapId == null) {
            talentMapId = "";
        }
        long sessionId = Long.parseLong(sessionIdObj.toString());
        Map reviewObjectCalibrationHistory = this.calibrationApplicationService.queryCalibrationHistory(sessionId, talentMapId.toString(), reviewObjectIds);
        Object[] reviewObjectData = this.reviewObjectQueryService.getReviewObjectData(reviewObjectIds);
        if (HRArrayUtils.isEmpty((Object[])reviewObjectData)) {
            return new HashMap<String, PersonCardInfo>(0);
        }
        Map<Long, DynamicObject> reviewObjectMap = Arrays.stream(reviewObjectData).collect(Collectors.toMap(reviewObject -> reviewObject.getLong("person.id"), reviewObject -> reviewObject, (v1, v2) -> v2));
        int gridSize = talentMapConfigInfo.getGridData().getGridBlocks().size();
        HashMap gridPersonIdMap = Maps.newHashMapWithExpectedSize((int)gridSize);
        HashMap personCardInfoMap = Maps.newHashMapWithExpectedSize((int)calibratedData.size());
        for (DynamicObject calibrateDatum2 : calibratedData) {
            String calibrateGridNumber;
            String gridNumber;
            Map tempCalInfoMap;
            long reviewObjectId = calibrateDatum2.getLong("reviewobject.id");
            long personId = calibrateDatum2.getLong("person.id");
            String personIdStr = String.valueOf(personId);
            String calibrateResult = calibrateDatum2.getString("calibrateresult");
            String calibrateBefore = calibrateDatum2.getString("calibratebefore");
            PersonCardInfo personCardInfo = null;
            String tempCalInfoStr = this.getPageCache().get(CACHE_TEMP_CALIBRATION_INFO);
            if (HRStringUtils.isNotEmpty((String)tempCalInfoStr) && (personCardInfo = (PersonCardInfo)(tempCalInfoMap = (Map)SerializationUtils.deSerializeFromBase64((String)tempCalInfoStr)).get(personIdStr)) != null) {
                calibrateResult = this.calibrationApplicationService.transCalibratePathToPosition(personCardInfo.getCalibratePath().getAfterCard());
                calibrateBefore = this.calibrationApplicationService.transCalibratePathToPosition(personCardInfo.getCalibratePath().getBeforeCard());
                calibrateDatum2.set("calibrateresult", (Object)calibrateResult);
                calibrateDatum2.set("calibratebefore", (Object)calibrateBefore);
            }
            if (HRStringUtils.isEmpty((String)(gridNumber = this.getCalibratePositionNumber(calibrateGridNumber = HRStringUtils.isEmpty((String)calibrateResult) ? calibrateBefore : calibrateResult)))) continue;
            List personIdList = (List)gridPersonIdMap.get(gridNumber);
            if (CollectionUtils.isEmpty((Collection)personIdList)) {
                personIdList = Lists.newArrayListWithExpectedSize((int)10);
                gridPersonIdMap.put(gridNumber, personIdList);
            }
            personIdList.add(personIdStr);
            if (personCardInfo != null) {
                personCardInfoMap.put(personIdStr, personCardInfo);
                continue;
            }
            String personName = calibrateDatum2.getString("person.name");
            String personNumber = calibrateDatum2.getString("person.number");
            String personHeadSculpture = calibrateDatum2.getString("person.headsculpture");
            String calibrateReason = calibrateDatum2.getString("calibratereason");
            personCardInfo = new PersonCardInfo();
            personCardInfo.setPersonId(personIdStr);
            personCardInfo.setPersonName(personName);
            personCardInfo.setPersonNumber(personNumber);
            personCardInfo.setHeadSculpture(HRImageUrlUtil.getImageFullUrl((String)personHeadSculpture));
            personCardInfo.setCalibrated(HRStringUtils.isNotEmpty((String)calibrateResult) && !HRStringUtils.equals((String)calibrateBefore, (String)calibrateResult));
            CalibratePath calibratePath = new CalibratePath();
            calibratePath.setBeforeCard(this.calibrationApplicationService.transCalibratePositionToPath(calibrateBefore));
            calibratePath.setAfterCard(this.calibrationApplicationService.transCalibratePositionToPath(HRStringUtils.isNotEmpty((String)calibrateResult) ? calibrateResult : calibrateBefore));
            personCardInfo.setCalibratePath(calibratePath);
            personCardInfo.setReason(calibrateReason);
            DynamicObject reviewObject2 = reviewObjectMap.get(personId);
            String adminOrgName = reviewObject2.getString("adminorg.name");
            String jobName = OnlineCalibrationCalibrateList.getJobName(reviewObject2);
            personCardInfo.setDepartment(adminOrgName);
            personCardInfo.setJob(HRStringUtils.isEmpty((String)jobName) ? "" : jobName);
            String superEvalName = OnlineCalibrationCalibrateList.getSuperEvalName(reviewObject2);
            personCardInfo.setDirectSupervisor(superEvalName);
            List<PersonCardDimension> personCardDimensionList = this.setPerCardDimInfo(calibrateSession, reviewObject2);
            PersonCardDimension[] personCardDimensions = personCardDimensionList.toArray(new PersonCardDimension[0]);
            personCardInfo.setPerCardDims(personCardDimensions);
            List hisList = (List)reviewObjectCalibrationHistory.get(reviewObjectId);
            ArrayList<CalibratePathHis> calibratePathHisList = new ArrayList<CalibratePathHis>(10);
            if (hisList != null) {
                for (Map hisMap : hisList) {
                    String sessionName = this.getStringData((String)hisMap.get("sessionName"));
                    String beforeCalibrateHis = this.getStringData((String)hisMap.get("beforeCalibrate"));
                    String calibrateResultHis = this.getStringData((String)hisMap.get("calibrateResult"));
                    String calibrateReasonHis = this.getStringData((String)hisMap.get("calibrateReason"));
                    CalibratePathHis calibratePathHis = new CalibratePathHis();
                    calibratePathHis.setTitle(sessionName);
                    CalibratePath caliPath = new CalibratePath();
                    caliPath.setBeforeCard(this.getCalibratePositionNumber(beforeCalibrateHis));
                    caliPath.setAfterCard(this.getCalibratePositionNumber(calibrateResultHis));
                    calibratePathHis.setCalibratePath(caliPath);
                    calibratePathHis.setReason(calibrateReasonHis);
                    calibratePathHisList.add(calibratePathHis);
                }
            }
            personCardInfo.setHistory(calibratePathHisList.toArray(new CalibratePathHis[0]));
            personCardInfo.setCalibrateImg(new String[0]);
            personCardInfoMap.put(personIdStr, personCardInfo);
        }
        this.getPageCache().put(CACHE_GRID_PERSON_ID_MAP, SerializationUtils.toJsonString((Object)gridPersonIdMap));
        this.getPageCache().put(CACHE_PERSON_CARD_INFO_MAP, SerializationUtils.toJsonString((Object)personCardInfoMap));
        return personCardInfoMap;
    }

    private void setTalentMapInfo(OnlineCalibrationInfo onlineCalibrationInfo, TalentMapConfigInfo talentMapConfigInfo, DynamicObject[] onlineCalibrateData, Map<String, PersonCardInfo> personCardInfoMap) {
        TalentMapInfo talentMapInfo = new TalentMapInfo();
        talentMapInfo.setxAxisInfo(talentMapConfigInfo.getxAxisInfo());
        talentMapInfo.setyAxisInfo(talentMapConfigInfo.getyAxisInfo());
        talentMapInfo.setGridData(talentMapConfigInfo.getGridData());
        List gridBlocks = talentMapConfigInfo.getGridData().getGridBlocks();
        int gridSize = gridBlocks.size();
        GridPersonInfo[] gridPersonInfos = new GridPersonInfo[gridSize];
        HashMap onlineCalibrateDataMap = Maps.newHashMapWithExpectedSize((int)gridSize);
        for (DynamicObject calibrateDatum : onlineCalibrateData) {
            String calibrateResult;
            String calibrateGridNumber;
            String gridNumber;
            String calibrateBefore = calibrateDatum.getString("calibratebefore");
            if (HRStringUtils.isEmpty((String)calibrateBefore) || HRStringUtils.isEmpty((String)(gridNumber = this.getCalibratePositionNumber(calibrateGridNumber = HRStringUtils.isEmpty((String)(calibrateResult = calibrateDatum.getString("calibrateresult"))) ? calibrateBefore : calibrateResult)))) continue;
            List calibrateDataList = (List)onlineCalibrateDataMap.get(gridNumber);
            if (CollectionUtils.isEmpty((Collection)calibrateDataList)) {
                calibrateDataList = Lists.newArrayListWithExpectedSize((int)10);
                onlineCalibrateDataMap.put(gridNumber, calibrateDataList);
            }
            calibrateDataList.add(calibrateDatum);
        }
        Map<String, String> gridNameMap = gridBlocks.stream().collect(Collectors.toMap(GridBlockInfo::getCustomNumber, gridBlock -> gridBlock.getName().getText(), (v1, v2) -> v1));
        List customNumberList = gridBlocks.stream().map(GridBlockInfo::getCustomNumber).collect(Collectors.toList());
        for (int i = 0; i < gridSize; ++i) {
            String gridNumber = (String)customNumberList.get(i);
            GridPersonInfo gridPersonInfo = new GridPersonInfo();
            gridPersonInfo.setGridNumber(gridNumber);
            gridPersonInfo.setGridName(gridNameMap.get(gridNumber));
            ArrayList calibrateDataList = (ArrayList)onlineCalibrateDataMap.get(gridNumber);
            if (CollectionUtils.isEmpty((Collection)calibrateDataList)) {
                calibrateDataList = new ArrayList(0);
            }
            int calibrateSize = calibrateDataList.size();
            ArrayList personInfoList = Lists.newArrayListWithExpectedSize((int)calibrateSize);
            for (DynamicObject calibrateData : calibrateDataList) {
                long personId = calibrateData.getLong("person.id");
                PersonCardInfo personCardInfo = personCardInfoMap.get(String.valueOf(personId));
                if (personCardInfo == null) continue;
                PersonInfo personInfo = new PersonInfo();
                personInfo.setPersonId(String.valueOf(personId));
                personInfo.setPersonName(personCardInfo.getPersonName());
                personInfo.setPersonNumber(personCardInfo.getPersonNumber());
                personInfo.setHeadSculpture(personCardInfo.getHeadSculpture());
                personInfo.setDepartment(personCardInfo.getDepartment());
                personInfo.setJob(personCardInfo.getJob());
                personInfo.setDirectSupervisor(personCardInfo.getDirectSupervisor());
                personInfo.setCalibrated(personCardInfo.isCalibrated());
                personInfo.setPerCardDims(personCardInfo.getPerCardDims());
                personInfo.setCalibratePath(personCardInfo.getCalibratePath());
                personInfo.setReason(personCardInfo.getReason());
                personInfo.setHistory(personCardInfo.getHistory());
                personInfo.setCalibrateImg(personCardInfo.getCalibrateImg());
                personInfoList.add(personInfo);
            }
            gridPersonInfo.setPersonInfo(personInfoList.toArray(new PersonInfo[0]));
            gridPersonInfos[i] = gridPersonInfo;
        }
        talentMapInfo.setGridPersonInfo(gridPersonInfos);
        onlineCalibrationInfo.setTalentMapInfo(talentMapInfo);
    }

    private String getCalibratePositionNumber(String calibratePosition) {
        if (HRStringUtils.isEmpty((String)calibratePosition)) {
            return "";
        }
        String[] split = calibratePosition.trim().split("-");
        if (split.length != 2) {
            return "";
        }
        return split[0];
    }

    private String getGridNumberFormCalibratePath(String calibratePath) {
        if (HRStringUtils.isEmpty((String)calibratePath)) {
            return "";
        }
        String[] split = calibratePath.trim().split("[()]");
        if (split.length != 2) {
            return "";
        }
        return split[1];
    }

    private void setCalibratedPerson(OnlineCalibrationInfo onlineCalibrationInfo, DynamicObject[] onlineCalibrateData, Map<String, PersonCardInfo> personCardInfoMap) {
        List calibratedData = Arrays.stream(onlineCalibrateData).filter(calibrateData -> HRStringUtils.isNotEmpty((String)calibrateData.getString("calibrateresult").trim()) && !HRStringUtils.equals((String)calibrateData.getString("calibrateresult").trim(), (String)calibrateData.getString("calibratebefore").trim())).collect(Collectors.toList());
        if (calibratedData.isEmpty()) {
            onlineCalibrationInfo.setCalibratedPerson(new CalibratePerson[0]);
            return;
        }
        int size = calibratedData.size();
        ArrayList calibratePersonList = Lists.newArrayListWithExpectedSize((int)size);
        for (int i = 0; i < size; ++i) {
            DynamicObject onlineCalibrate = (DynamicObject)calibratedData.get(i);
            long personId = onlineCalibrate.getLong("person.id");
            PersonCardInfo personCardInfo = personCardInfoMap.get(String.valueOf(personId));
            if (personCardInfo == null) continue;
            CalibratePerson calibratePerson = new CalibratePerson();
            calibratePerson.setPersonId(String.valueOf(personId));
            calibratePerson.setPersonName(personCardInfo.getPersonName());
            calibratePerson.setPersonNumber(personCardInfo.getPersonNumber());
            calibratePerson.setHeadSculpture(personCardInfo.getHeadSculpture());
            calibratePerson.setDepartment(personCardInfo.getDepartment());
            calibratePerson.setJob(personCardInfo.getJob());
            calibratePerson.setDirectSupervisor(personCardInfo.getDirectSupervisor());
            calibratePerson.setCalibrated(personCardInfo.isCalibrated());
            calibratePerson.setPerCardDims(personCardInfo.getPerCardDims());
            calibratePerson.setCalibratePath(personCardInfo.getCalibratePath());
            calibratePerson.setReason(personCardInfo.getReason());
            calibratePerson.setHistory(personCardInfo.getHistory());
            calibratePersonList.add(calibratePerson);
        }
        onlineCalibrationInfo.setCalibratedPerson(calibratePersonList.toArray(new CalibratePerson[0]));
    }

    private void setCalibrateBoardInfo(OnlineCalibrationInfo onlineCalibrationInfo, TalentMapConfigInfo talentMapConfigInfo, DynamicObject[] onlineCalibrateData) {
        CalibrateBoardInfo calibrateBoardInfo = new CalibrateBoardInfo();
        Map<String, String> customNumberMap = talentMapConfigInfo.getGridData().getGridBlocks().stream().collect(Collectors.toMap(GridBlockInfo::getNumber, GridBlockInfo::getCustomNumber, (v1, v2) -> v2));
        MapBlockRatioInfo[] ratioInfos = talentMapConfigInfo.getDistributionRatio().getValues();
        int gridSize = ratioInfos.length;
        Map<String, String> radioInfoMap = Arrays.stream(ratioInfos).collect(Collectors.toMap(info -> (String)customNumberMap.get(info.getGridBlockNo()), MapBlockRatioInfo::getRatio, (v1, v2) -> v1));
        Map<String, List<String>> beforeResultSizeMap = Arrays.stream(onlineCalibrateData).map(calibrateData -> calibrateData.getString("calibratebefore")).filter(HRStringUtils::isNotEmpty).collect(Collectors.groupingBy(this::getCalibratePositionNumber));
        Map<String, List<String>> gridPersonIdMap = this.getGridPersonIdMapFormCache();
        Collection<List<String>> personIdCollection = gridPersonIdMap.values();
        ArrayList allIds = Lists.newArrayListWithExpectedSize((int)10);
        for (List<String> idList : personIdCollection) {
            allIds.addAll(idList);
        }
        int allPersonSize = allIds.size();
        List customNumberList = talentMapConfigInfo.getGridData().getGridBlocks().stream().map(GridBlockInfo::getCustomNumber).collect(Collectors.toList());
        CalibrateBoardItemInfo[] data = new CalibrateBoardItemInfo[gridSize];
        for (int i = 0; i < gridSize; ++i) {
            CalibrateBoardItemInfo boardItemInfo = new CalibrateBoardItemInfo();
            String gridNumber = (String)customNumberList.get(i);
            boardItemInfo.setGridNumber(gridNumber);
            String adviseRatioStr = radioInfoMap.get(gridNumber);
            boardItemInfo.setAdviseRatio(this.formatPercentData(adviseRatioStr));
            BigDecimal beforeRadio = BigDecimal.ZERO;
            List<String> beforeSize = beforeResultSizeMap.get(gridNumber);
            if (!CollectionUtils.isEmpty(beforeSize)) {
                beforeRadio = new BigDecimal(beforeSize.size()).divide(new BigDecimal(allPersonSize), 4, RoundingMode.HALF_UP);
            }
            boardItemInfo.setBeforeRatio(this.formatPercentData(beforeRadio));
            List<String> perIds = gridPersonIdMap.get(gridNumber);
            BigDecimal afterRadio = BigDecimal.ZERO;
            if (!CollectionUtils.isEmpty(perIds)) {
                afterRadio = new BigDecimal(perIds.size()).divide(new BigDecimal(allPersonSize), 4, RoundingMode.HALF_UP);
            }
            boardItemInfo.setAfterRatio(this.formatPercentData(afterRadio));
            data[i] = boardItemInfo;
        }
        calibrateBoardInfo.setData(data);
        onlineCalibrationInfo.setCalibrateBoard(calibrateBoardInfo);
    }

    private String formatPercentData(String percent) {
        String result;
        NumberFormat numberFormat = NumberFormat.getPercentInstance();
        numberFormat.setMaximumFractionDigits(2);
        numberFormat.setMinimumFractionDigits(2);
        numberFormat.setGroupingUsed(false);
        try {
            Number number = numberFormat.parse(percent);
            result = numberFormat.format(number.doubleValue());
        }
        catch (ParseException exp) {
            result = "";
        }
        return result;
    }

    private String formatPercentData(BigDecimal percent) {
        NumberFormat numberFormat = NumberFormat.getPercentInstance();
        numberFormat.setMaximumFractionDigits(2);
        numberFormat.setMinimumFractionDigits(2);
        numberFormat.setGroupingUsed(false);
        return numberFormat.format(percent.doubleValue());
    }

    private void showPersonCardInfoView(PersonCardInfo personCardInfo) {
        CustomControl gridControl = (CustomControl)this.getView().getControl("customcontrolap");
        if (gridControl == null) {
            return;
        }
        Map<String, Object> mapData = this.getCustomEventParams(EVENT_NAME_GET_PERSON_CARD_INFO);
        mapData.put("data", personCardInfo);
        gridControl.setData(mapData);
    }

    private void showGridCardInfoView(GridCardInfo gridCardInfo) {
        CustomControl gridControl = (CustomControl)this.getView().getControl("customcontrolap");
        if (gridControl == null) {
            return;
        }
        Map<String, Object> mapData = this.getCustomEventParams(EVENT_NAME_GET_GRID_CARD_INFO);
        mapData.put("data", gridCardInfo);
        gridControl.setData(mapData);
    }

    private Map<String, Object> getCustomEventParams(String eventName) {
        HashMap mapData = Maps.newHashMapWithExpectedSize((int)10);
        mapData.put("code", 200);
        mapData.put("success", true);
        mapData.put(OPTION_PARAM_EVENT_NAME, eventName);
        mapData.put("eventStatus", "init");
        mapData.put("times", System.currentTimeMillis());
        mapData.put("pageStatus", "edit");
        if (!this.isEditable()) {
            mapData.put("pageStatus", "view");
        }
        return mapData;
    }

    private boolean isEditable() {
        String pageStatus = (String)this.getView().getFormShowParameter().getCustomParam("pageStatus");
        if (HRStringUtils.equals((String)pageStatus, (String)"view")) {
            return false;
        }
        boolean hasObjectPerm = ReviewPermUtils.getInstance().hasPerm("oatr_onlinecalibration", "4715a0df000000ac");
        if (!hasObjectPerm) {
            return false;
        }
        List errorMsg = this.onlineCalibrationFormService.validateCalibrate((AbstractFormPlugin)this);
        return errorMsg.isEmpty();
    }

    private void showFilterFlexView() {
        Object sessionIdObj = this.getView().getFormShowParameter().getCustomParam("calSessionId");
        if (sessionIdObj != null) {
            long sessionId = Long.parseLong(sessionIdObj.toString());
            DynamicObject[] onlineCalibrationData = this.onlineCalibrationQueryService.getOnlineCalibrationOriginalData(Long.valueOf(sessionId));
            List calibrationPersonIds = Arrays.stream(onlineCalibrationData).map(data -> data.getLong("person.id")).collect(Collectors.toList());
            this.getPageCache().put(CACHE_PERSON_ID_OF_CALIBRATION, SerializationUtils.toJsonString(calibrationPersonIds));
        }
        if (this.getPageCache().get("filterFlexPageId") != null) {
            String filterFlexPageId = this.getPageCache().get("filterFlexPageId");
            IFormView filterView = this.getView().getView(filterFlexPageId);
            if (filterView != null) {
                Map<String, List<QFilter>> fieldFilter = this.getFieldF7Filter();
                filterView.getFormShowParameter().setCustomParam("fieldFilter", (Object)SerializationUtils.serializeToBase64(fieldFilter));
                filterView.cacheFormShowParameter();
            }
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        String pageId = formShowParameter.getPageId();
        this.getPageCache().put("filterFlexPageId", pageId);
        formShowParameter.setFormId("oatr_onlinecalfilter");
        formShowParameter.setShowTitle(false);
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.getOpenStyle().setTargetKey("customcontrolap");
        HashMap customParams = Maps.newHashMapWithExpectedSize((int)1);
        customParams.put("elementId", "calibrate-filter-container-" + this.getView().getPageId());
        formShowParameter.getOpenStyle().setCustParam((Map)customParams);
        Map<String, List<QFilter>> fieldFilter = this.getFieldF7Filter();
        formShowParameter.setCustomParam("fieldFilter", (Object)SerializationUtils.serializeToBase64(fieldFilter));
        this.getView().showForm(formShowParameter);
    }

    private Map<String, List<QFilter>> getFieldF7Filter() {
        HashMap fieldFilter = Maps.newHashMapWithExpectedSize((int)2);
        String personIdOfCalibrationString = this.getPageCache().get(CACHE_PERSON_ID_OF_CALIBRATION);
        if (!HRStringUtils.isEmpty((String)personIdOfCalibrationString)) {
            List personIds = (List)SerializationUtils.fromJsonString((String)personIdOfCalibrationString, List.class);
            fieldFilter.computeIfAbsent("person", k -> Lists.newArrayListWithExpectedSize((int)1)).add(new QFilter("id", "in", (Object)personIds));
        }
        return fieldFilter;
    }

    private List<QFilter> getListQueryFilters(String opName) {
        Map<String, String> filterFieldMapping = this.getFilterFieldMapping();
        ArrayList filters = Lists.newArrayListWithExpectedSize((int)filterFieldMapping.size());
        String filterFlexPageId = this.getPageCache().get("filterFlexPageId");
        IFormView filterView = this.getView().getView(filterFlexPageId);
        if (HRStringUtils.isEmpty((String)filterFlexPageId) || filterView == null) {
            return filters;
        }
        IDataModel filterModel = filterView.getModel();
        for (Map.Entry<String, String> entry : filterFieldMapping.entrySet()) {
            DynamicObjectCollection baseDataCollection;
            String filterField = entry.getKey();
            String listField = entry.getValue();
            if (StringUtils.equals((String)opName, (String)OP_RESET_FILTER)) {
                filterModel.setValue(filterField, null);
                continue;
            }
            IDataEntityProperty property = filterModel.getProperty(filterField);
            if (!(property instanceof MulBasedataProp) || CollectionUtils.isEmpty((Collection)(baseDataCollection = (DynamicObjectCollection)filterModel.getValue(filterField)))) continue;
            ArrayList baseDataIdList = Lists.newArrayListWithExpectedSize((int)baseDataCollection.size());
            for (DynamicObject baseData : baseDataCollection) {
                DynamicObject baseDataValue = baseData.getDynamicObject("fbasedataid");
                baseDataIdList.add(baseDataValue.getLong("id"));
            }
            filters.add(new QFilter(listField, "in", (Object)baseDataIdList));
        }
        return filters;
    }

    private Map<String, String> getFilterFieldMapping() {
        LinkedHashMap filterFieldMapping = Maps.newLinkedHashMapWithExpectedSize((int)3);
        filterFieldMapping.put("person", "person.id");
        filterFieldMapping.put("adminorg", "reviewobject.adminorg.id");
        return filterFieldMapping;
    }

    private boolean getIsAutoSaveParam() {
        AppParam appParam = new AppParam("32J2T2KEXE6T", Long.valueOf(RequestContext.get().getOrgId()));
        Boolean paramIsAutoSave = (Boolean)SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam, (String)"isautosave");
        return paramIsAutoSave != null && paramIsAutoSave != false;
    }
}

