/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.formplugin.web.activity;

import java.text.MessageFormat;
import java.util.EventObject;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.operate.MutexHelper;
import kd.bos.list.ListShowParameter;
import kd.bos.mutex.AutoReleaseLock;
import kd.bos.mutex.impl.MutexLockInfo;
import kd.hr.hbp.common.util.HRDyObjectPropUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.tdc.oatr.bussiness.ServiceFactory;
import kd.tdc.oatr.bussiness.queryservice.CalibrateSessionQueryService;
import kd.tdc.oatr.common.constants.enums.CalibrateSessionStatusEnum;

public class OnlineCalibrationDetailPlugin
extends HRDynamicFormBasePlugin {
    private final CalibrateSessionQueryService calSessionQueryService = (CalibrateSessionQueryService)ServiceFactory.getService(CalibrateSessionQueryService.class);
    private static final String OP_CALIBRATE = "calibrate";

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams.isEmpty()) {
            return;
        }
        Object calSessionId = customParams.get("calSessionId");
        if (calSessionId == null) {
            return;
        }
        MutexLockInfo lockInfo = new MutexLockInfo();
        lockInfo.setEntityNumber("oatr_onlinecaldetail");
        lockInfo.setDataObjId(calSessionId.toString());
        lockInfo.setOperationKey(OP_CALIBRATE);
        lockInfo.setStrict(false);
        StringBuilder msg = new StringBuilder();
        boolean require = MutexHelper.require((IFormView)this.getView(), (MutexLockInfo)lockInfo, (StringBuilder)msg);
        if (!require) {
            this.getView().showMessage(msg.toString());
            this.getView().setStatus(OperationStatus.VIEW);
        } else {
            AutoReleaseLock.create().register(lockInfo.getDataObjId(), lockInfo.getEntityNumber(), lockInfo.getOperationKey());
            this.getView().setStatus(OperationStatus.EDIT);
        }
    }

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        this.loadOnlineCalibrationListView();
    }

    private void loadOnlineCalibrationListView() {
        ListShowParameter showListForm = ShowFormHelper.createShowListForm((String)"oatr_onlinecalibration", (boolean)true, (int)0, (boolean)false);
        showListForm.getOpenStyle().setShowType(ShowType.InContainer);
        showListForm.getOpenStyle().setTargetKey("onlinecalibrationflex");
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams.isEmpty()) {
            return;
        }
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (status.equals((Object)OperationStatus.VIEW)) {
            customParams.put("pageStatus", "view");
        } else {
            customParams.put("pageStatus", "edit");
        }
        Object calSessionId = customParams.get("calSessionId");
        if (calSessionId == null) {
            return;
        }
        DynamicObject calibrateSession = this.calSessionQueryService.getCalibrateSession(Long.valueOf(Long.parseLong(calSessionId.toString())));
        String calibrateStatus = calibrateSession.getString("calibratestatus");
        String talentMapKey = calibrateSession.getString("talentmap");
        customParams.put("calibrateStatus", calibrateStatus);
        customParams.put("talentMapKey", talentMapKey);
        if (HRStringUtils.equals((String)calibrateStatus, (String)CalibrateSessionStatusEnum.GOING.getCode()) || HRStringUtils.equals((String)calibrateStatus, (String)CalibrateSessionStatusEnum.END.getCode())) {
            String xDimName = HRDyObjectPropUtil.getName((DynamicObject)calibrateSession.getDynamicObject("xaxisdim"));
            String yDimName = HRDyObjectPropUtil.getName((DynamicObject)calibrateSession.getDynamicObject("yaxisdim"));
            String loadKDString = ResManager.loadKDString((String)"{0}+{1}\u843d\u4f4d", (String)"ReviewOnlineCalibrationList_0", (String)"tdc-oatr-formplugin", (Object[])new Object[0]);
            String columnName = MessageFormat.format(loadKDString, xDimName, yDimName);
            customParams.put("calibrateBeforeColumName", columnName);
        }
        showListForm.setCustomParams(customParams);
        showListForm.setCaption(calibrateSession.getString("name"));
        this.getView().showForm((FormShowParameter)showListForm);
    }

    public void beforeClosed(BeforeClosedEvent evt) {
        super.beforeClosed(evt);
        MutexHelper.release((IFormView)this.getView());
        this.getView().returnDataToParent((Object)this.getView().getPageId());
    }

    public void pageRelease(EventObject e) {
        super.pageRelease(e);
        MutexHelper.release((IFormView)this.getView());
    }
}

