/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.formplugin.web.activity;

import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.TextProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.DynamicTextListColumn;
import kd.bos.list.IListColumn;
import kd.bos.list.ListColumn;
import kd.bos.list.ListColumnGroup;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.mservice.HRMServiceResult;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRDyObjectPropUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.sdk.tdc.oatr.reviewobject.IDimensionOriginalValueExtendService;
import kd.tdc.oatr.bussiness.ServiceFactory;
import kd.tdc.oatr.bussiness.application.OnlineCalibrationApplicationService;
import kd.tdc.oatr.bussiness.queryservice.CalibrateSessionQueryService;
import kd.tdc.oatr.bussiness.queryservice.OnlineCalibrationQueryService;
import kd.tdc.oatr.bussiness.queryservice.ReviewEmpEvalQueryService;
import kd.tdc.oatr.bussiness.queryservice.ReviewObjectQueryService;
import kd.tdc.oatr.bussiness.queryservice.ReviewSuperiorEvalQueryService;
import kd.tdc.oatr.bussiness.queryservice.ReviewTalentMapQueryService;
import kd.tdc.oatr.bussiness.queryservice.ReviewToolQueryService;
import kd.tdc.oatr.common.constants.enums.CalibrateSessionStatusEnum;
import kd.tdc.tdcs.bussiness.formservice.FormCommonService;

public class OnlineCalibrationList
extends HRDataBaseList {
    private static final Log logger = LogFactory.getLog(OnlineCalibrationList.class);
    private final FormCommonService formCommonService = (FormCommonService)kd.tdc.tdcs.bussiness.ServiceFactory.getService(FormCommonService.class);
    private final ReviewTalentMapQueryService talentMapQueryService = (ReviewTalentMapQueryService)ServiceFactory.getService(ReviewTalentMapQueryService.class);
    private final ReviewToolQueryService toolQueryService = (ReviewToolQueryService)ServiceFactory.getService(ReviewToolQueryService.class);
    private final CalibrateSessionQueryService calSessionQueryService = (CalibrateSessionQueryService)ServiceFactory.getService(CalibrateSessionQueryService.class);
    private final OnlineCalibrationQueryService onlineCalibrationQueryService = (OnlineCalibrationQueryService)ServiceFactory.getService(OnlineCalibrationQueryService.class);
    private final ReviewObjectQueryService reviewObjectQueryService = (ReviewObjectQueryService)ServiceFactory.getService(ReviewObjectQueryService.class);
    private final ReviewEmpEvalQueryService reviewEmpEvalQueryService = (ReviewEmpEvalQueryService)ServiceFactory.getService(ReviewEmpEvalQueryService.class);
    private final ReviewSuperiorEvalQueryService reviewSuperiorEvalQueryService = (ReviewSuperiorEvalQueryService)ServiceFactory.getService(ReviewSuperiorEvalQueryService.class);
    private final OnlineCalibrationApplicationService calibrationApplicationService = (OnlineCalibrationApplicationService)ServiceFactory.getService(OnlineCalibrationApplicationService.class);
    private static final String LIST_FIELD_REVIEWOBJECT_ERRORMSG = "reviewobject.errormsg";
    private static final String LIST_FIELD_EMPQUESTION_NUM = "empquestionnum";
    private static final String LIST_FIELD_SUPERIOR_QUESTION_NUM = "superiorquestionnum";
    private static final String LIST_FIELD_PERSON_NAME = "person_name";
    private static final String LIST_COLUM_CALIBRATEBEFORE = "calibratebefore";
    private static final String LIST_COLUM_GROUP_CALIBRATERESULTBEFORE = "calibrateresultbefore";
    private static final String PREFIX_CALIBRATE_BEFORE = "be#";
    private static final String PREFIX_OUTER_TOOL_EVALUATION = "to#";
    private static final String OP_SHOW_QUESTION = "showquestion";
    private static final String PARAM_REVIEW_OBJ_ID_STR = "reviewObjIdStr";
    private static final String PARAM_FIELD_NAME = "fieldName";
    private static final String CACHE_EMP_QUESTION_NUM_INFO = "empQuestionNumInfo";
    private static final String CACHE_SUPERIOR_QUESTION_NUM_INFO = "superiorQuestionNumInfo";
    private static final String CACHE_CALIBRATION_REVIEW_OBJ_ID_MAP = "calibrationReviewObjIdMap";
    private static final String TAB_LISTVIEW = "tablistview";
    private static final String KEY_TABAP = "tabap";

    public void setFilter(SetFilterEvent evt) {
        super.setFilter(evt);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object calSessionIdObj = customParams.get("calSessionId");
        if (calSessionIdObj == null) {
            evt.getQFilters().add(new QFilter("id", "in", new ArrayList(0)));
            return;
        }
        long calSessionId = Long.parseLong(calSessionIdObj.toString());
        QFilter sessionFilter = new QFilter("calibratesession.id", "=", (Object)calSessionId);
        evt.getQFilters().add(sessionFilter);
        evt.setOrderBy("reviewobject.reviewgroup.number asc,reviewobject.company.number asc,reviewobject.adminorg.number asc,person.number asc");
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        this.setFixColumn(args);
        this.setCurrentCalibrateSessionName(args);
        DynamicObject activity = this.getActivity();
        this.createCalibrateResultBeforeColumns(args, activity);
        this.createReviewDimensionColumns(args, activity);
        this.createReviewToolColumns(args);
    }

    private void createReviewToolColumns(BeforeCreateListColumnsArgs args) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object activityIdObj = customParams.get("activityId");
        if (activityIdObj == null) {
            return;
        }
        ListColumnGroup questionColumnGroup = args.getListGroupColumns().stream().filter(columnsGroup -> HRStringUtils.equals((String)columnsGroup.getKey(), (String)"associateeval")).findFirst().orElseGet(ListColumnGroup::new);
        List columns = args.getListColumns();
        long activityId = Long.parseLong(activityIdObj.toString());
        DynamicObject reviewTool = this.toolQueryService.getReviewToolByActivityId(activityId);
        if (reviewTool == null) {
            if (HRCollUtil.isNotEmpty((Collection)questionColumnGroup.getItems())) {
                List itemKeys = questionColumnGroup.getItems().stream().map(item -> ((ListColumn)item).getListFieldKey()).collect(Collectors.toList());
                columns.removeIf(column -> itemKeys.contains(column.getListFieldKey()));
                args.getListGroupColumns().remove(questionColumnGroup);
            }
            return;
        }
        DynamicObjectCollection entryEntityInnerTools = reviewTool.getDynamicObjectCollection("entryentity_inner");
        if (HRCollUtil.isNotEmpty((Collection)entryEntityInnerTools) && HRCollUtil.isNotEmpty((Collection)questionColumnGroup.getItems())) {
            for (DynamicObject innerTool : entryEntityInnerTools) {
                DynamicObjectCollection innerReviewGroups = innerTool.getDynamicObjectCollection("inner_reviewgroup");
                String quesNumber = innerTool.getString("questionnaire.number");
                if (!HRCollUtil.isEmpty((Collection)innerReviewGroups)) continue;
                this.removeQuestionColumn(columns, questionColumnGroup, quesNumber);
            }
            if (HRCollUtil.isEmpty((Collection)questionColumnGroup.getItems())) {
                args.getListGroupColumns().remove(questionColumnGroup);
            }
        } else {
            List itemKeys = questionColumnGroup.getItems().stream().map(item -> ((ListColumn)item).getListFieldKey()).collect(Collectors.toList());
            columns.removeIf(column -> itemKeys.contains(column.getListFieldKey()));
            args.getListGroupColumns().remove(questionColumnGroup);
        }
        DynamicObjectCollection entryEntityOuterTools = reviewTool.getDynamicObjectCollection("entryentity_outer");
        this.cacheOuterToolName(entryEntityOuterTools);
        ArrayList<String> createToolTypeColumnKeys = new ArrayList<String>(entryEntityOuterTools.size());
        if (HRCollUtil.isNotEmpty((Collection)entryEntityOuterTools)) {
            int toolIndex = this.getSuperiorQuestionIndex(args);
            ListColumnGroup outerToolColumnGroup = new ListColumnGroup();
            outerToolColumnGroup.setKey("outertoolgroup");
            String columnGroupName = ResManager.loadKDString((String)"\u5173\u8054\u5de5\u5177", (String)"ReviewObjectDynamicColumnList_3", (String)"tdc-oatr-formplugin", (Object[])new Object[0]);
            outerToolColumnGroup.setName(new LocaleString(columnGroupName));
            outerToolColumnGroup.setParentViewKey("gridview");
            outerToolColumnGroup.setVisible(((ListColumnGroup)args.getListGroupColumns().get(0)).getVisible());
            for (DynamicObject toolEntry : entryEntityOuterTools) {
                DynamicObject outerTool;
                DynamicObjectCollection outerReviewGroups = toolEntry.getDynamicObjectCollection("outer_reviewgroup");
                if (HRCollUtil.isEmpty((Collection)outerReviewGroups) || (outerTool = toolEntry.getDynamicObject("outer_tool")) == null) continue;
                String toolTypeNumber = outerTool.getString("tooltype");
                if (HRStringUtils.isEmpty((String)toolTypeNumber)) {
                    toolTypeNumber = "30";
                }
                ComboProp toolTypeProp = (ComboProp)outerTool.getDataEntityType().getProperties().get((Object)"tooltype");
                String toolKey = "tooltype_" + toolTypeNumber;
                String toolTypeName = toolTypeProp.getItemByName(toolTypeNumber);
                if (createToolTypeColumnKeys.contains(toolKey)) continue;
                this.addNewDynamicTextColumn(columns, ++toolIndex, outerToolColumnGroup, toolKey, toolTypeName);
                createToolTypeColumnKeys.add(toolKey);
            }
            if (HRCollUtil.isNotEmpty((Collection)outerToolColumnGroup.getItems())) {
                args.getListGroupColumns().add(outerToolColumnGroup);
            }
        }
    }

    private int getSuperiorQuestionIndex(BeforeCreateListColumnsArgs args) {
        Optional<IListColumn> errorMsgOptional;
        List listColumns = args.getListColumns();
        int index = listColumns.indexOf((errorMsgOptional = listColumns.stream().filter(listColumn -> listColumn.getListFieldKey() != null && listColumn.getListFieldKey().equals(LIST_FIELD_SUPERIOR_QUESTION_NUM)).findFirst()).orElseGet(ListColumn::new));
        if (index != -1) {
            return index;
        }
        return listColumns.size() - 1;
    }

    private void cacheOuterToolName(DynamicObjectCollection entryEntityOuterTools) {
        if (HRCollUtil.isEmpty((Collection)entryEntityOuterTools)) {
            return;
        }
        HashMap outerToolNameMap = new HashMap(16);
        for (DynamicObject toolEntry : entryEntityOuterTools) {
            DynamicObject outerTool;
            DynamicObjectCollection outerReviewGroups = toolEntry.getDynamicObjectCollection("outer_reviewgroup");
            if (HRCollUtil.isEmpty((Collection)outerReviewGroups) || (outerTool = toolEntry.getDynamicObject("outer_tool")) == null) continue;
            String outerToolName = outerTool.getString("name");
            String toolTypeNumber = outerTool.getString("tooltype");
            if (HRStringUtils.isEmpty((String)toolTypeNumber)) {
                toolTypeNumber = "30";
            }
            List groupIds = outerReviewGroups.stream().map(groupEntry -> groupEntry.getLong("fbasedataid.id")).collect(Collectors.toList());
            for (Long groupId : groupIds) {
                ArrayList<String> nameList;
                HashMap<String, ArrayList<String>> toolNameMap = (HashMap<String, ArrayList<String>>)outerToolNameMap.get(String.valueOf(groupId));
                if (toolNameMap == null) {
                    toolNameMap = new HashMap<String, ArrayList<String>>(16);
                }
                if (HRCollUtil.isEmpty((Collection)(nameList = (ArrayList<String>)toolNameMap.get(toolTypeNumber)))) {
                    nameList = new ArrayList<String>(10);
                }
                nameList.add(outerToolName);
                toolNameMap.put(toolTypeNumber, nameList);
                outerToolNameMap.put(String.valueOf(groupId), toolNameMap);
            }
        }
        if (!outerToolNameMap.isEmpty()) {
            this.getPageCache().put("groupToolNameMap", SerializationUtils.toJsonString(outerToolNameMap));
        }
    }

    private void removeQuestionColumn(List<IListColumn> columns, ListColumnGroup questionColumnGroup, String quesNumber) {
        if (HRStringUtils.equals((String)quesNumber, (String)"1010_S")) {
            columns.removeIf(column -> HRStringUtils.equals((String)column.getListFieldKey(), (String)LIST_FIELD_EMPQUESTION_NUM));
            questionColumnGroup.getItems().removeIf(control -> HRStringUtils.equals((String)control.getKey(), (String)LIST_FIELD_EMPQUESTION_NUM));
        } else if (HRStringUtils.equals((String)quesNumber, (String)"1020_S")) {
            columns.removeIf(column -> HRStringUtils.equals((String)column.getListFieldKey(), (String)LIST_FIELD_SUPERIOR_QUESTION_NUM));
            questionColumnGroup.getItems().removeIf(control -> HRStringUtils.equals((String)control.getKey(), (String)LIST_FIELD_SUPERIOR_QUESTION_NUM));
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        String currentView = this.getPageCache().get("currentView");
        if (HRStringUtils.equals((String)currentView, (String)"listview")) {
            String talentMapKey = (String)this.getView().getFormShowParameter().getCustomParam("talentMapKey");
            String calibrateStatus = (String)this.getView().getFormShowParameter().getCustomParam("calibrateStatus");
            OnlineCalibrationListDataProvider onlineCalibrationListDataProvider = new OnlineCalibrationListDataProvider(talentMapKey, calibrateStatus, (AbstractFormPlugin)this);
            args.setListDataProvider((IListDataProvider)onlineCalibrationListDataProvider);
            return;
        }
        super.beforeCreateListDataProvider(args);
    }

    public void packageData(PackageDataEvent evt) {
        DynamicObject rowData;
        super.packageData(evt);
        String currentView = this.getPageCache().get("currentView");
        if (!HRStringUtils.equals((String)currentView, (String)"listview")) {
            return;
        }
        AbstractColumnDesc abstractColumnDesc = (AbstractColumnDesc)evt.getSource();
        String key = abstractColumnDesc.getFieldKey();
        DataEntityPropertyCollection entityProperties = evt.getRowData().getDataEntityType().getProperties();
        if (key.contains(LIST_FIELD_REVIEWOBJECT_ERRORMSG)) {
            if (entityProperties.get((Object)"errormsg") == null) {
                return;
            }
            String errorMsg = evt.getRowData().getString("errormsg");
            if (HRStringUtils.isNotEmpty((String)errorMsg)) {
                evt.setFormatValue((Object)errorMsg);
            }
            return;
        }
        if ((key.contains(PREFIX_CALIBRATE_BEFORE) || key.contains(PREFIX_OUTER_TOOL_EVALUATION) || HRStringUtils.equals((String)key, (String)LIST_FIELD_EMPQUESTION_NUM) || HRStringUtils.equals((String)key, (String)LIST_FIELD_SUPERIOR_QUESTION_NUM) || key.contains("tooltype_")) && (rowData = evt.getRowData()).getDataEntityType().getProperties().containsKey((Object)key)) {
            evt.setFormatValue((Object)rowData.getString(key));
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        String fieldName = args.getFieldName();
        BillListHyperLinkClickEvent linkClickEvent = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
        ListSelectedRow currentRow = linkClickEvent.getCurrentRow();
        Object primaryKeyValue = currentRow.getPrimaryKeyValue();
        long pkId = Long.parseLong(String.valueOf(primaryKeyValue));
        if (HRStringUtils.equals((String)fieldName, (String)LIST_FIELD_EMPQUESTION_NUM)) {
            args.setCancel(true);
            this.clickEmpQuestionNum(fieldName, pkId);
            return;
        }
        if (HRStringUtils.equals((String)fieldName, (String)LIST_FIELD_SUPERIOR_QUESTION_NUM)) {
            args.setCancel(true);
            this.clickSuperiorQuestionNum(fieldName, pkId);
        }
        if (HRStringUtils.equals((String)fieldName, (String)LIST_FIELD_PERSON_NAME)) {
            args.setCancel(true);
            this.showPersonTalentPortrait();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)OP_SHOW_QUESTION)) {
            if (operationResult == null || !operationResult.isSuccess()) {
                return;
            }
            FormOperate source = (FormOperate)afterDoOperationEventArgs.getSource();
            this.showQuestionView(source);
        }
    }

    private void clickEmpQuestionNum(String fieldName, long pkId) {
        String empQuestionNumInfoStr = this.getPageCache().get(CACHE_EMP_QUESTION_NUM_INFO);
        this.clickQuestionNum(fieldName, pkId, empQuestionNumInfoStr);
    }

    private void clickSuperiorQuestionNum(String fieldName, long pkId) {
        String superiorQuestionNumInfoStr = this.getPageCache().get(CACHE_SUPERIOR_QUESTION_NUM_INFO);
        this.clickQuestionNum(fieldName, pkId, superiorQuestionNumInfoStr);
    }

    private void clickQuestionNum(String fieldName, long pkId, String cacheQuestionStr) {
        if (HRStringUtils.isEmpty((String)cacheQuestionStr)) {
            return;
        }
        Map questionNumInfo = (Map)SerializationUtils.fromJsonString((String)cacheQuestionStr, Map.class);
        String value = (String)questionNumInfo.get(String.valueOf(pkId));
        if (HRStringUtils.isEmpty((String)value) || HRStringUtils.equals((String)value, (String)"0")) {
            return;
        }
        Map<String, String> calibrationReviewObjIdMap = this.getCalibrationReviewObjIdMap(pkId);
        String reviewObjIdStr = calibrationReviewObjIdMap.get(String.valueOf(pkId));
        if (HRStringUtils.isEmpty((String)reviewObjIdStr)) {
            return;
        }
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue(PARAM_REVIEW_OBJ_ID_STR, reviewObjIdStr);
        operateOption.setVariableValue(PARAM_FIELD_NAME, fieldName);
        this.getView().invokeOperation(OP_SHOW_QUESTION, operateOption);
    }

    private void showPersonTalentPortrait() {
        HashMap customParamMap = Maps.newHashMap();
        Object focusRowPkId = this.getFocusRowPkId();
        DynamicObject onlineCalibration = this.onlineCalibrationQueryService.getOnlineCalibration(Long.valueOf(focusRowPkId.toString()));
        customParamMap.put("employee", onlineCalibration.getLong("employee.id"));
        customParamMap.put("person", onlineCalibration.getLong("person.id"));
        customParamMap.put("sceneNumber", "OATR_1010_S");
        logger.info("OnlineCalibrationList.talentportrait.customParamMap:{}", (Object)customParamMap);
        HRMServiceResult hrmServiceResult = (HRMServiceResult)HRMServiceHelper.invokeHRMPService((String)"hrti", (String)"IHRTIService", (String)"showTalentPortrait", (Object[])new Object[]{customParamMap});
        if (hrmServiceResult.isSuccess()) {
            this.getView().showForm((FormShowParameter)hrmServiceResult.getReturnData());
        } else {
            this.getView().showErrorNotification(hrmServiceResult.getMessage());
        }
    }

    private void showQuestionView(FormOperate source) {
        OperateOption option = source.getOption();
        String fieldName = option.getVariableValue(PARAM_FIELD_NAME);
        String reviewObjIdStr = option.getVariableValue(PARAM_REVIEW_OBJ_ID_STR);
        if (LIST_FIELD_EMPQUESTION_NUM.equals(fieldName)) {
            ListShowParameter showParameter = this.getQuestionListShowParameter(Long.parseLong(reviewObjIdStr));
            showParameter.setHasRight(true);
            showParameter.setBillFormId("oatr_employeeeval");
            this.getView().showForm((FormShowParameter)showParameter);
            return;
        }
        if (LIST_FIELD_SUPERIOR_QUESTION_NUM.equals(fieldName)) {
            ListShowParameter showParameter = this.getQuestionListShowParameter(Long.parseLong(reviewObjIdStr));
            showParameter.setHasRight(true);
            showParameter.setBillFormId("oatr_superioreval");
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    private ListShowParameter getQuestionListShowParameter(long reviewObjId) {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setCustomParam("reviewobject", (Object)reviewObjId);
        showParameter.setFormId("bos_list");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        return showParameter;
    }

    private void cacheCalibrationReviewObjIdMap(Map<String, String> calibrationReviewObjIdMap) {
        this.getPageCache().put(CACHE_CALIBRATION_REVIEW_OBJ_ID_MAP, SerializationUtils.toJsonString(calibrationReviewObjIdMap));
    }

    private Map<String, String> getCalibrationReviewObjIdMap(long pkId) {
        HashMap calibrationReviewObjIdMap = Maps.newHashMapWithExpectedSize((int)16);
        String onlineCalibrationIdMapStr = this.getPageCache().get(CACHE_CALIBRATION_REVIEW_OBJ_ID_MAP);
        if (HRStringUtils.isEmpty((String)onlineCalibrationIdMapStr)) {
            Object[] onlineCalibrations = this.onlineCalibrationQueryService.listOnlineCalibrationReviewObjId(Collections.singletonList(pkId));
            if (!HRArrayUtils.isEmpty((Object[])onlineCalibrations)) {
                Object calibration = onlineCalibrations[0];
                calibrationReviewObjIdMap.put(String.valueOf(pkId), String.valueOf(calibration.getLong("reviewobject.id")));
            }
            return calibrationReviewObjIdMap;
        }
        return (Map)SerializationUtils.fromJsonString((String)onlineCalibrationIdMapStr, Map.class);
    }

    private void setCurrentCalibrateSessionName(BeforeCreateListColumnsArgs args) {
        List listColumns = args.getListColumns();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        for (IListColumn listColumn : listColumns) {
            Object columName;
            if ("calibrateresult".equals(listColumn.getListFieldKey())) {
                Object calSessionIdObj = customParams.get("calSessionId");
                if (calSessionIdObj == null) {
                    return;
                }
                long calSessionId = Long.parseLong(calSessionIdObj.toString());
                DynamicObject calibrateSession = this.calSessionQueryService.getCalibrateSession(Long.valueOf(calSessionId));
                String name = MessageFormat.format(ResManager.loadKDString((String)"{0}\u843d\u4f4d", (String)"ReviewOnlineCalibrationList_2", (String)"tdc-oatr-formplugin", (Object[])new Object[0]), HRDyObjectPropUtil.getName((DynamicObject)calibrateSession));
                listColumn.setCaption(new LocaleString(name));
            }
            if (!LIST_COLUM_CALIBRATEBEFORE.equals(listColumn.getListFieldKey()) || (columName = customParams.get("calibrateBeforeColumName")) == null) continue;
            listColumn.setCaption(new LocaleString(columName.toString()));
        }
    }

    private void createCalibrateResultBeforeColumns(BeforeCreateListColumnsArgs args, DynamicObject activity) {
        if (activity == null) {
            return;
        }
        List listColumns = args.getListColumns();
        ListColumnGroup calibrateResultBeforeGroup = this.getCablibrateBeforeListColumnGroup(args);
        int indexBegin = this.getBeforeGroupIndex(calibrateResultBeforeGroup, listColumns) + 1;
        DynamicObjectCollection talentMapEntry = activity.getDynamicObjectCollection("talentmapentry");
        this.addMapEntryColumn(listColumns, indexBegin, calibrateResultBeforeGroup, talentMapEntry);
    }

    private void createReviewDimensionColumns(BeforeCreateListColumnsArgs args, DynamicObject activity) {
        if (activity == null) {
            return;
        }
        DynamicObjectCollection dimensionEntry = activity.getDynamicObjectCollection("dimesionentry");
        ArrayList<Map<String, String>> nameList = new ArrayList<Map<String, String>>(dimensionEntry.size());
        for (DynamicObject dimObj : dimensionEntry) {
            HashMap<String, String> dimNameMap = new HashMap<String, String>(3);
            dimNameMap.put("dimId", dimObj.getPkValue().toString());
            dimNameMap.put("transformColumnName", dimObj.getString("reviewdimension.name"));
            dimNameMap.put("originalColumnName", dimObj.getString("reviewdimension.name"));
            nameList.add(dimNameMap);
        }
        Map<String, Object> extendArgs = this.getExtendServiceData(nameList);
        boolean isShowOriginalColumn = (Boolean)extendArgs.get("isShowOriginalColumn");
        List dimNameList = (List)extendArgs.get("dimNameList");
        Map<String, Map> dimNameMap = dimNameList.stream().collect(Collectors.toMap(nameMap -> nameMap.get("dimId") != null ? (String)nameMap.get("dimId") : "dimId", nameMap -> nameMap, (v1, v2) -> v2));
        List listColumns = args.getListColumns();
        List listGroupColumns = args.getListGroupColumns();
        ListColumnGroup calibrateResultBeforeGroup = this.getCablibrateBeforeListColumnGroup(args);
        int dimBeginIndex = this.getBeforeGroupIndex(calibrateResultBeforeGroup, listColumns);
        for (DynamicObject entry : dimensionEntry) {
            Map nameMap2;
            long dimensionId = entry.getLong("reviewdimension.id");
            String dimensionName = entry.getString("reviewdimension.name");
            ListColumnGroup dimensionColumnGroup = new ListColumnGroup();
            dimensionColumnGroup.setKey("dimgroup" + dimensionId);
            dimensionColumnGroup.setName(new LocaleString(dimensionName));
            dimensionColumnGroup.setParentViewKey("gridview");
            dimensionColumnGroup.setVisible(((ListColumnGroup)listGroupColumns.get(0)).getVisible());
            args.getListGroupColumns().add(dimensionColumnGroup);
            String columnDimName = ResManager.loadKDString((String)"\u603b\u5206", (String)"OnlineCalibrationList_0", (String)"tdc-oatr-formplugin", (Object[])new Object[0]);
            if (isShowOriginalColumn && (nameMap2 = dimNameMap.get(entry.getPkValue().toString())) != null && nameMap2.get("transformColumnName") != null) {
                columnDimName = (String)nameMap2.get("transformColumnName");
            }
            this.addNewDynamicTextColumn(listColumns, ++dimBeginIndex, dimensionColumnGroup, OnlineCalibrationList.getDimensionColumnKey(dimensionId), columnDimName);
            if (isShowOriginalColumn) {
                String origDimTextColumKey = "orig" + OnlineCalibrationList.getDimensionColumnKey(dimensionId);
                String origDimName = "";
                Map nameMap3 = dimNameMap.get(entry.getPkValue().toString());
                origDimName = nameMap3 != null && nameMap3.get("originalColumnName") != null ? (String)nameMap3.get("originalColumnName") : entry.getString("reviewdimension.name");
                this.addNewDynamicTextColumn(listColumns, ++dimBeginIndex, dimensionColumnGroup, origDimTextColumKey, origDimName);
            }
            DynamicObjectCollection dimEvaluationObjs = entry.getDynamicObjectCollection("dimevaluation");
            for (DynamicObject dimEvaluationEntry : dimEvaluationObjs) {
                DynamicObject dimEvaluation = dimEvaluationEntry.getDynamicObject("fbasedataid");
                if (dimEvaluation == null) continue;
                long evalId = dimEvaluation.getLong("id");
                String evalName = dimEvaluation.getString("name");
                this.addNewDynamicTextColumn(listColumns, ++dimBeginIndex, dimensionColumnGroup, this.getEvaluationListKey(dimensionId, evalId), evalName);
            }
        }
    }

    private String getEvaluationListKey(Long dimId, Long evalItemId) {
        return PREFIX_OUTER_TOOL_EVALUATION + dimId + "#" + evalItemId;
    }

    private DynamicObject getActivity() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object activityIdObj = customParams.get("activityId");
        if (activityIdObj == null) {
            return null;
        }
        long activityId = Long.parseLong(activityIdObj.toString());
        DynamicObject activity = this.talentMapQueryService.getReviewDimensionAndTalentMapActivity(Long.valueOf(activityId));
        if (HRObjectUtils.isEmpty((Object)activity)) {
            return null;
        }
        return activity;
    }

    private static String getDimensionColumnKey(Long dimId) {
        return "be#dim" + dimId;
    }

    private void addMapEntryColumn(List<IListColumn> listColumns, int indexBegin, ListColumnGroup calibrateResultBeforeGroup, DynamicObjectCollection talentMapEntry) {
        if (CollectionUtils.isEmpty((Collection)talentMapEntry)) {
            return;
        }
        String currentOnlineMapName = "";
        String talentMapKey = (String)this.getView().getFormShowParameter().getCustomParam("talentMapKey");
        for (DynamicObject mapEntry : talentMapEntry) {
            DynamicObject xDimension = mapEntry.getDynamicObject("xaxisdim");
            DynamicObject yDimension = mapEntry.getDynamicObject("yaxisdim");
            if (HRObjectUtils.isEmpty((Object)xDimension) || HRObjectUtils.isEmpty((Object)yDimension)) continue;
            String entryMapKey = mapEntry.getString("id");
            String columnKey = "be#map" + entryMapKey;
            String loadKDString = ResManager.loadKDString((String)"{0}+{1}\u843d\u4f4d", (String)"ReviewOnlineCalibrationList_0", (String)"tdc-oatr-formplugin", (Object[])new Object[0]);
            String columnName = MessageFormat.format(loadKDString, HRDyObjectPropUtil.getName((DynamicObject)xDimension), HRDyObjectPropUtil.getName((DynamicObject)yDimension));
            if (HRStringUtils.equals((String)talentMapKey, (String)entryMapKey)) {
                currentOnlineMapName = columnName;
                continue;
            }
            this.addNewDynamicTextColumn(listColumns, indexBegin, calibrateResultBeforeGroup, columnKey, columnName);
            ++indexBegin;
        }
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object columName = customParams.get("calibrateBeforeColumName");
        if (columName == null || HRStringUtils.isEmpty((String)columName.toString())) {
            for (IListColumn listColumn : listColumns) {
                if (!LIST_COLUM_CALIBRATEBEFORE.equals(listColumn.getListFieldKey())) continue;
                listColumn.setCaption(new LocaleString(currentOnlineMapName));
                break;
            }
        }
    }

    private void addNewDynamicTextColumn(List<IListColumn> listColumns, int addIndex, ListColumnGroup listColumnGroup, String columnKey, String columnName) {
        DynamicTextListColumn textListColumn = new DynamicTextListColumn();
        textListColumn.setKey(columnKey);
        textListColumn.setCaption(new LocaleString(columnName));
        textListColumn.setParent((Container)listColumnGroup);
        textListColumn.setParentViewKey(listColumnGroup.getKey());
        if (listColumns.size() < addIndex) {
            addIndex = listColumns.size();
        }
        listColumns.add(addIndex, (IListColumn)textListColumn);
        listColumnGroup.getItems().add(textListColumn);
    }

    private ListColumnGroup getCablibrateBeforeListColumnGroup(BeforeCreateListColumnsArgs args) {
        List listGroupColumns = args.getListGroupColumns();
        Optional<ListColumnGroup> columnGroupOptional = listGroupColumns.stream().filter(listColumnGroup -> listColumnGroup.getKey().equals(LIST_COLUM_GROUP_CALIBRATERESULTBEFORE)).findFirst();
        return columnGroupOptional.orElseGet(ListColumnGroup::new);
    }

    private int getBeforeGroupIndex(ListColumnGroup calibrateResultBeforeGroup, List<IListColumn> listColumns) {
        IListColumn beforeGroupLastColumn = (IListColumn)calibrateResultBeforeGroup.getItems().get(calibrateResultBeforeGroup.getItems().size() - 1);
        return listColumns.indexOf(beforeGroupLastColumn);
    }

    private void setFixColumn(BeforeCreateListColumnsArgs args) {
        this.formCommonService.beforeCreateListColumns(args, "person.number");
    }

    private Map<String, Object> getExtendServiceData(List<Map<String, String>> nameList) {
        HashMap<String, Object> extendArgs = new HashMap<String, Object>(16);
        extendArgs.put("isShowOriginalColumn", false);
        extendArgs.put("isEnableDimValueValidator", true);
        extendArgs.put("dimNameList", nameList);
        HRPluginProxy pluginProxy = HRPlugInProxyFactory.create(null, IDimensionOriginalValueExtendService.class, (String)"kd.sdk.tdc.oatr.reviewobject.IDimensionOriginalValueExtendService", null);
        pluginProxy.callReplaceIfPresent(plugin -> {
            if (plugin != null) {
                boolean showOriginalColumn = plugin.isShowOriginalColumn();
                boolean enableValidator = plugin.isEnableDimValueValidator();
                plugin.setColumnName(nameList);
                extendArgs.put("isShowOriginalColumn", showOriginalColumn);
                extendArgs.put("isEnableDimValueValidator", enableValidator);
                extendArgs.put("dimNameList", nameList);
            }
            return null;
        });
        return extendArgs;
    }

    class OnlineCalibrationListDataProvider
    extends ListDataProvider {
        String talentMapKey;
        String calibrateStatus;
        AbstractFormPlugin plugin;

        public OnlineCalibrationListDataProvider(String talentMapKey, String calibrateStatus, AbstractFormPlugin plugin) {
            this.talentMapKey = talentMapKey;
            this.calibrateStatus = calibrateStatus;
            this.plugin = plugin;
        }

        public DynamicObjectCollection getData(int start, int limit) {
            DynamicObjectCollection pageData = super.getData(start, limit);
            if (CollectionUtils.isEmpty((Collection)pageData)) {
                return pageData;
            }
            List pkIds = pageData.stream().map(data -> data.getLong("id")).collect(Collectors.toList());
            DynamicObject[] onlineCalibrations = OnlineCalibrationList.this.onlineCalibrationQueryService.listOnlineCalibrationReviewObjId(pkIds);
            Map<Long, Long> reviewObjCalibrateIdMap = Arrays.stream(onlineCalibrations).collect(Collectors.toMap(calibration -> calibration.getLong("reviewobject.id"), calibration -> calibration.getLong("id"), (v1, v2) -> v1));
            ArrayList<Long> reviewObjIds = new ArrayList<Long>(reviewObjCalibrateIdMap.keySet());
            Map<String, String> calibrationReviewObjIdMap = Arrays.stream(onlineCalibrations).collect(Collectors.toMap(calibration -> String.valueOf(calibration.getLong("id")), calibration -> String.valueOf(calibration.getLong("reviewobject.id")), (v1, v2) -> v1));
            OnlineCalibrationList.this.cacheCalibrationReviewObjIdMap(calibrationReviewObjIdMap);
            DynamicObject[] reviewObjects = OnlineCalibrationList.this.reviewObjectQueryService.getReviewObjectEntity(reviewObjIds);
            this.setReviewObjectData(reviewObjects, reviewObjCalibrateIdMap, pageData);
            Map reviewObjectQuestionNum = OnlineCalibrationList.this.reviewEmpEvalQueryService.getReviewObjectQuestionNum(reviewObjIds);
            this.setEmpEvalData(reviewObjectQuestionNum, reviewObjCalibrateIdMap, pageData);
            Map reviewObjectSuperiorQuestionNum = OnlineCalibrationList.this.reviewSuperiorEvalQueryService.getReviewObjectQuestionNum(reviewObjIds);
            this.setSuperiorEvalData(reviewObjectSuperiorQuestionNum, reviewObjCalibrateIdMap, pageData);
            String groupToolNameMapString = this.plugin.getPageCache().get("groupToolNameMap");
            HashMap outerToolNameMap = HRStringUtils.isNotEmpty((String)groupToolNameMapString) ? (HashMap)SerializationUtils.fromJsonString((String)groupToolNameMapString, Map.class) : new HashMap(16);
            Map<Long, DynamicObject> rowDataMap = pageData.stream().collect(Collectors.toMap(data -> data.getLong("id"), data -> data, (v1, v2) -> v1));
            for (DynamicObject reviewObject : reviewObjects) {
                long groupId = reviewObject.getLong("reviewgroup.id");
                Map nameMap = (Map)outerToolNameMap.get(String.valueOf(groupId));
                Long calibrationId = reviewObjCalibrateIdMap.get(reviewObject.getLong("id"));
                DynamicObject rowData = rowDataMap.get(calibrationId);
                if (nameMap == null) continue;
                for (Map.Entry nameEntry : nameMap.entrySet()) {
                    String key = (String)nameEntry.getKey();
                    List toolNameList = (List)nameEntry.getValue();
                    String toolTypeKey = "tooltype_" + key;
                    if (!rowData.getDataEntityType().getProperties().containsKey((Object)toolTypeKey)) {
                        TextProp prop = new TextProp();
                        prop.setName(toolTypeKey);
                        prop.setDbIgnore(true);
                        rowData.getDynamicObjectType().registerSimpleProperty((DynamicSimpleProperty)prop);
                    }
                    rowData.set(toolTypeKey, (Object)String.join((CharSequence)",", toolNameList));
                }
            }
            return pageData;
        }

        private void setReviewObjectData(DynamicObject[] reviewObjects, Map<Long, Long> reviewObjCalibrateIdMap, DynamicObjectCollection pageData) {
            this.setErrorMsgEntry(reviewObjects, reviewObjCalibrateIdMap, pageData);
            this.setCalibrateBefore(reviewObjects, reviewObjCalibrateIdMap, pageData, this.talentMapKey);
            this.setReviewDimensionAndEvaluation(reviewObjects, reviewObjCalibrateIdMap, pageData);
        }

        private void setErrorMsgEntry(DynamicObject[] reviewObjects, Map<Long, Long> reviewObjCalibrateIdMap, DynamicObjectCollection pageData) {
            Map<Long, DynamicObject> rowDataMap = pageData.stream().collect(Collectors.toMap(data -> data.getLong("id"), data -> data, (v1, v2) -> v1));
            for (DynamicObject reviewObject : reviewObjects) {
                Long onlineCalibrationId;
                DynamicObject rowData;
                String exeMsg;
                DynamicObjectCollection exeInfos = reviewObject.getDynamicObjectCollection("errormsgentry");
                if (CollectionUtils.isEmpty((Collection)exeInfos) || !HRStringUtils.isNotEmpty((String)(exeMsg = exeInfos.stream().map(exeInfo -> exeInfo.getString("errormsgcontent")).collect(Collectors.joining(",")))) || (rowData = rowDataMap.get(onlineCalibrationId = reviewObjCalibrateIdMap.get(reviewObject.getLong("id")))) == null) continue;
                rowData.set(OnlineCalibrationList.LIST_FIELD_REVIEWOBJECT_ERRORMSG, (Object)exeMsg);
            }
        }

        private void setCalibrateBefore(DynamicObject[] reviewObjects, Map<Long, Long> reviewObjCalibrateIdMap, DynamicObjectCollection pageData, String talentMapKey) {
            Map<Long, DynamicObject> rowDataMap = pageData.stream().collect(Collectors.toMap(data -> data.getLong("id"), data -> data, (v1, v2) -> v1));
            DynamicObjectType dynamicObjectType = pageData.getDynamicObjectType();
            for (DynamicObject reviewObject : reviewObjects) {
                Long onlineCalibrationId = reviewObjCalibrateIdMap.get(reviewObject.getLong("id"));
                DynamicObject rowData = rowDataMap.get(onlineCalibrationId);
                DynamicObjectCollection talentMapEntry = reviewObject.getDynamicObjectCollection("entryentity_mapbefore");
                talentMapEntry.forEach(map -> {
                    String mapBeforeKey = map.getString("mapbeforekey");
                    if (HRStringUtils.equals((String)mapBeforeKey, (String)talentMapKey)) {
                        if (HRStringUtils.equals((String)this.calibrateStatus, (String)CalibrateSessionStatusEnum.WAIT_START.getCode())) {
                            rowData.set(OnlineCalibrationList.LIST_COLUM_CALIBRATEBEFORE, (Object)map.getString("mapbeforevalue"));
                        }
                    } else {
                        String columnKey = "be#map" + mapBeforeKey;
                        if (!dynamicObjectType.getProperties().containsKey((Object)columnKey)) {
                            this.registerProp(dynamicObjectType, columnKey);
                        }
                        rowData.set(columnKey, (Object)map.getString("mapbeforevalue"));
                    }
                });
            }
        }

        private void setReviewDimensionAndEvaluation(DynamicObject[] reviewObjects, Map<Long, Long> reviewObjCalibrateIdMap, DynamicObjectCollection pageData) {
            Map<Long, DynamicObject> rowDataMap = pageData.stream().collect(Collectors.toMap(data -> data.getLong("id"), data -> data, (v1, v2) -> v1));
            for (DynamicObject reviewObject : reviewObjects) {
                Long onlineCalibrationId = reviewObjCalibrateIdMap.get(reviewObject.getLong("id"));
                DynamicObject pageDataRow = rowDataMap.get(onlineCalibrationId);
                DynamicObjectCollection dimensions = reviewObject.getDynamicObjectCollection("entryentity_dimension");
                dimensions.forEach(dimension -> {
                    long dimId = dimension.getLong("dimension.id");
                    String dimensionValueKey = OnlineCalibrationList.getDimensionColumnKey(dimId);
                    if (!pageDataRow.getDataEntityType().getProperties().containsKey((Object)dimensionValueKey)) {
                        TextProp prop = new TextProp();
                        prop.setName(dimensionValueKey);
                        prop.setDbIgnore(true);
                        pageDataRow.getDynamicObjectType().registerSimpleProperty((DynamicSimpleProperty)prop);
                    }
                    pageDataRow.set(dimensionValueKey, (Object)dimension.getString("dimensionvalue"));
                    String dimensionValueScoreKey = "orig" + dimensionValueKey;
                    if (!pageDataRow.getDataEntityType().getProperties().containsKey((Object)dimensionValueScoreKey)) {
                        TextProp prop = new TextProp();
                        prop.setName(dimensionValueScoreKey);
                        prop.setDbIgnore(true);
                        pageDataRow.getDynamicObjectType().registerSimpleProperty((DynamicSimpleProperty)prop);
                    }
                    pageDataRow.set(dimensionValueScoreKey, (Object)dimension.getString("dimorigvalue"));
                });
                DynamicObjectCollection evals = reviewObject.getDynamicObjectCollection("entryentity_dimeval");
                evals.forEach(eval -> {
                    long dimId = eval.getLong("evaldim.id");
                    long dimEvalItemId = eval.getLong("dimevalitem.id");
                    String evaluationKey = OnlineCalibrationList.this.getEvaluationListKey(dimId, dimEvalItemId);
                    if (!pageDataRow.getDataEntityType().getProperties().containsKey((Object)evaluationKey)) {
                        TextProp prop = new TextProp();
                        prop.setName(evaluationKey);
                        prop.setDbIgnore(true);
                        pageDataRow.getDynamicObjectType().registerSimpleProperty((DynamicSimpleProperty)prop);
                    }
                    pageDataRow.set(evaluationKey, (Object)eval.getString("dimevalvalue"));
                });
            }
        }

        private void setEmpEvalData(Map<Long, Long> reviewObjectQuestionNum, Map<Long, Long> reviewObjCalibrateIdMap, DynamicObjectCollection pageData) {
            this.setEvalData(OnlineCalibrationList.LIST_FIELD_EMPQUESTION_NUM, reviewObjectQuestionNum, reviewObjCalibrateIdMap, pageData);
        }

        private void setSuperiorEvalData(Map<Long, Long> reviewObjectSuperiorQuestionNum, Map<Long, Long> reviewObjCalibrateIdMap, DynamicObjectCollection pageData) {
            this.setEvalData(OnlineCalibrationList.LIST_FIELD_SUPERIOR_QUESTION_NUM, reviewObjectSuperiorQuestionNum, reviewObjCalibrateIdMap, pageData);
        }

        private void setEvalData(String evalKey, Map<Long, Long> reviewObjectQuestionNum, Map<Long, Long> reviewObjCalibrateIdMap, DynamicObjectCollection pageData) {
            DynamicObjectType dynamicObjectType = pageData.getDynamicObjectType();
            if (!dynamicObjectType.getProperties().containsKey((Object)evalKey)) {
                this.registerProp(dynamicObjectType, evalKey);
            }
            Map<Long, DynamicObject> rowDataMap = pageData.stream().collect(Collectors.toMap(data -> data.getLong("id"), data -> data, (v1, v2) -> v1));
            HashMap questionNumInfo = Maps.newHashMapWithExpectedSize((int)reviewObjCalibrateIdMap.size());
            for (Map.Entry<Long, Long> entry : reviewObjectQuestionNum.entrySet()) {
                Long reviewObjId = entry.getKey();
                Long questionNum = entry.getValue() != null ? entry.getValue() : Long.valueOf(0L);
                Long onlineCalibrationId = reviewObjCalibrateIdMap.get(reviewObjId);
                DynamicObject rowData = rowDataMap.get(onlineCalibrationId);
                rowData.set(evalKey, (Object)String.valueOf(questionNum));
                questionNumInfo.put(String.valueOf(onlineCalibrationId), String.valueOf(questionNum));
            }
            if (HRStringUtils.equals((String)evalKey, (String)OnlineCalibrationList.LIST_FIELD_EMPQUESTION_NUM)) {
                this.plugin.getPageCache().put(OnlineCalibrationList.CACHE_EMP_QUESTION_NUM_INFO, SerializationUtils.toJsonString((Object)questionNumInfo));
            } else if (HRStringUtils.equals((String)evalKey, (String)OnlineCalibrationList.LIST_FIELD_SUPERIOR_QUESTION_NUM)) {
                this.plugin.getPageCache().put(OnlineCalibrationList.CACHE_SUPERIOR_QUESTION_NUM_INFO, SerializationUtils.toJsonString((Object)questionNumInfo));
            }
        }

        private void registerProp(DynamicObjectType dynamicObjectType, String propName) {
            TextProp textProp = new TextProp();
            textProp.setName(propName);
            textProp.setDisplayName(new LocaleString(propName));
            textProp.setDbIgnore(true);
            textProp.setAlias("");
            dynamicObjectType.registerSimpleProperty((DynamicSimpleProperty)textProp);
        }
    }
}

