/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.formplugin.web.activity;

import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.tdc.oatr.bussiness.ServiceFactory;
import kd.tdc.oatr.bussiness.application.CalibrateSessionApplicationService;
import kd.tdc.oatr.bussiness.application.OnlineCalibrationApplicationService;
import kd.tdc.oatr.bussiness.batchconfirm.activity.OnlineCalibrationFinishFormService;
import kd.tdc.oatr.bussiness.batchconfirm.activity.OnlineCalibrationFormService;
import kd.tdc.oatr.bussiness.queryservice.CalibrateSessionQueryService;
import kd.tdc.oatr.bussiness.queryservice.ReviewActivityQueryService;
import kd.tdc.oatr.common.constants.enums.ActivityStatusEnum;
import kd.tdc.oatr.common.constants.enums.CalibrateSessionStatusEnum;
import org.apache.commons.lang.StringUtils;

public class OnlineCalibrationOperateList
extends HRDataBaseList {
    private static final String OP_ACTUAL_FINISHCALIBRATE = "actualfinishcalibrate";
    private static final String OP_BEGINCALIBRATE = "begincalibrate";
    private static final String OP_ACTUAL_BEGINCALIBRATE = "actualbegincalibrate";
    private static final String OP_FINISHCALIBRATE = "finishcalibrate";
    private static final String CONFIRM_FINISH_CAL = "confirmfinishcalibrate";
    private static final String TBL_BEGIN_CAL = "tblbegincal";
    private static final String TBL_FINISH_CAL = "tblfinishcal";
    private static final String TBL_TEMP_SAVE = "tbltempsave";
    private static final String CACHE_TEMP_CALIBRATION_INFO = "tempCalibrationInfo";
    private final CalibrateSessionApplicationService sessionApplicationService = (CalibrateSessionApplicationService)ServiceFactory.getService(CalibrateSessionApplicationService.class);
    private final OnlineCalibrationFinishFormService finishFormService = (OnlineCalibrationFinishFormService)ServiceFactory.getService(OnlineCalibrationFinishFormService.class);
    private final OnlineCalibrationApplicationService calibrationApplicationService = (OnlineCalibrationApplicationService)ServiceFactory.getService(OnlineCalibrationApplicationService.class);
    private final ReviewActivityQueryService activityQueryService = (ReviewActivityQueryService)ServiceFactory.getService(ReviewActivityQueryService.class);
    private final OnlineCalibrationFormService onlineCalibrationFormService = (OnlineCalibrationFormService)ServiceFactory.getService(OnlineCalibrationFormService.class);
    private final CalibrateSessionQueryService calSessionQueryService = (CalibrateSessionQueryService)ServiceFactory.getService(CalibrateSessionQueryService.class);

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        this.showCalibrateBeginFinishButton();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        boolean isDelete = this.validateDataIsDelete();
        if (!isDelete) {
            args.setCancel(true);
            return;
        }
        if (HRStringUtils.equals((String)operateKey, (String)OP_FINISHCALIBRATE)) {
            String tempCalInfoStr = this.getPageCache().get(CACHE_TEMP_CALIBRATION_INFO);
            if (HRStringUtils.isEmpty((String)tempCalInfoStr)) {
                return;
            }
            Map tempCalInfoMap = (Map)SerializationUtils.deSerializeFromBase64((String)tempCalInfoStr);
            if (CollectionUtils.isEmpty((Map)tempCalInfoMap)) {
                return;
            }
            List wholeMsgList = this.onlineCalibrationFormService.validateCalibrate((AbstractFormPlugin)this);
            if (!CollectionUtils.isEmpty((Collection)wholeMsgList)) {
                this.onlineCalibrationFormService.showCalibrateErrorMsg(wholeMsgList, ResManager.loadKDString((String)"\u5b8c\u6210\u6821\u51c6", (String)"OnlineCalibrationOperateList_18", (String)"tdc-oatr-formplugin", (Object[])new Object[0]), (AbstractFormPlugin)this);
                this.getPageCache().put(CACHE_TEMP_CALIBRATION_INFO, null);
                this.getView().invokeOperation("refresh");
                args.setCancel(true);
                return;
            }
            Map msgOfPersonMap = this.onlineCalibrationFormService.validateCalibratePerson(tempCalInfoMap, (AbstractFormPlugin)this);
            this.onlineCalibrationFormService.updateCalibrationInfo(tempCalInfoMap, (AbstractFormPlugin)this);
            if (!CollectionUtils.isEmpty((Map)msgOfPersonMap)) {
                this.onlineCalibrationFormService.showValidateResult(msgOfPersonMap, (AbstractFormPlugin)this);
                args.setCancel(true);
                return;
            }
            this.getPageCache().put(CACHE_TEMP_CALIBRATION_INFO, null);
            BillList list = (BillList)this.getView().getControl("billlistap");
            list.refresh();
        }
        if (HRStringUtils.equals((String)operateKey, (String)OP_ACTUAL_FINISHCALIBRATE)) {
            Object activityIdObj = this.getView().getFormShowParameter().getCustomParam("activityId");
            Object sessionIdObj = this.getView().getFormShowParameter().getCustomParam("calSessionId");
            if (activityIdObj == null || sessionIdObj == null) {
                args.setCancel(true);
                return;
            }
            OperateOption option = source.getOption();
            option.setVariableValue("activityId", String.valueOf(activityIdObj));
            option.setVariableValue("calSessionId", String.valueOf(sessionIdObj));
            this.finishFormService.callValidatorBeforeDoOperation(args, operateKey, (AbstractFormPlugin)this);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)OP_BEGINCALIBRATE)) {
            if (operationResult == null || !operationResult.isSuccess()) {
                return;
            }
            this.doBeginCalibrate(afterDoOperationEventArgs);
        }
        if (HRStringUtils.equals((String)operateKey, (String)OP_ACTUAL_BEGINCALIBRATE)) {
            this.doActualBeginCalibrate(operationResult);
        }
        if (HRStringUtils.equals((String)operateKey, (String)OP_FINISHCALIBRATE)) {
            if (operationResult == null || !operationResult.isSuccess()) {
                return;
            }
            this.doFinishCalibrate(afterDoOperationEventArgs);
        }
        if (HRStringUtils.equals((String)operateKey, (String)OP_ACTUAL_FINISHCALIBRATE)) {
            this.doActualFinishCalibrate(operationResult);
        }
        this.onlineCalibrationFormService.setReviewActivityInfo((AbstractFormPlugin)this);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        this.finishFormService.callOperateCloseCallback(closedCallBackEvent, (AbstractFormPlugin)this);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (StringUtils.equals((String)callBackId, (String)CONFIRM_FINISH_CAL) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            OperateOption option = OperateOption.create();
            option.setVariableValue(CONFIRM_FINISH_CAL, "1");
            this.getView().invokeOperation(OP_FINISHCALIBRATE, option);
        }
    }

    private boolean validateDataIsDelete() {
        String msg = ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u88ab\u5176\u4ed6\u4eba\u5220\u9664\u4e86\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"OnlineCalibrationOperateList_7", (String)"tdc-oatr-formplugin", (Object[])new Object[0]);
        Object activityIdObj = this.getView().getFormShowParameter().getCustomParam("activityId");
        Object calSessionId = this.getView().getFormShowParameter().getCustomParam("calSessionId");
        if (activityIdObj == null || calSessionId == null) {
            this.getView().showErrorNotification(msg);
            return false;
        }
        DynamicObject reviewActivity = this.activityQueryService.getReviewActivity((Object)Long.valueOf(activityIdObj.toString()));
        if (reviewActivity == null) {
            this.getView().showErrorNotification(msg);
            return false;
        }
        DynamicObject calibrateSession = this.calSessionQueryService.getCalibrateSession(Long.valueOf(Long.parseLong(calSessionId.toString())));
        if (calibrateSession == null) {
            this.getView().showErrorNotification(msg);
            return false;
        }
        return true;
    }

    private void doActualFinishCalibrate(OperationResult operationResult) {
        if (operationResult != null && operationResult.isSuccess()) {
            this.getView().getFormShowParameter().setCustomParam("pageStatus", (Object)"view");
            this.getView().cacheFormShowParameter();
        }
        this.getView().getFormShowParameter().setCustomParam("calibrateStatus", (Object)CalibrateSessionStatusEnum.END.getCode());
        this.getView().cacheFormShowParameter();
        this.getView().invokeOperation("refresh");
    }

    private void doFinishCalibrate(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        afterDoOperationEventArgs.getOperationResult().setShowMessage(false);
        FormOperate operate = (FormOperate)afterDoOperationEventArgs.getSource();
        OperateOption option = operate.getOption();
        String isConfirmFinishCalibrate = option.getVariableValue(CONFIRM_FINISH_CAL, "");
        if (this.validateCalibrateFinish()) {
            BillList billList = (BillList)this.getView().getControl("billlistap");
            billList.selectAllRows();
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            if (selectedRows.isEmpty()) {
                if (!isConfirmFinishCalibrate.equals("1")) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u8be5\u64cd\u4f5c\u4e0d\u53ef\u64a4\u9500\uff0c\u786e\u8ba4\u8981\u7ee7\u7eed\u5417\uff1f\uff08\u6ce8\u610f\uff1a\u8be5\u6821\u51c6\u4f1a\u4e2d\u6ca1\u6709\u76d8\u70b9\u5bf9\u8c61\uff09", (String)"OnlineCalibrationOperateList_10", (String)"tdc-oatr-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CONFIRM_FINISH_CAL));
                    return;
                }
                Object sessionIdObj = this.getView().getFormShowParameter().getCustomParam("calSessionId");
                if (sessionIdObj == null || HRStringUtils.isEmpty((String)sessionIdObj.toString())) {
                    return;
                }
                this.sessionApplicationService.finishCalibrate(Long.valueOf(Long.parseLong(sessionIdObj.toString())));
                String msg = ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"OnlineCalibrationOperateList_1", (String)"tdc-oatr-formplugin", (Object[])new Object[0]);
                this.getView().showSuccessNotification(msg);
                this.getView().getFormShowParameter().setCustomParam("calibrateStatus", (Object)CalibrateSessionStatusEnum.END.getCode());
                this.getView().cacheFormShowParameter();
                this.getView().invokeOperation("refresh");
                return;
            }
            this.getView().invokeOperation(OP_ACTUAL_FINISHCALIBRATE);
        }
    }

    private void doActualBeginCalibrate(OperationResult operationResult) {
        if (operationResult != null && operationResult.isSuccess()) {
            this.getView().addClientCallBack("beginCalibrateAction");
        }
        this.getView().getFormShowParameter().setCustomParam("calibrateStatus", (Object)CalibrateSessionStatusEnum.GOING.getCode());
        this.getView().cacheFormShowParameter();
        this.getView().invokeOperation("refresh");
    }

    private void doBeginCalibrate(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        afterDoOperationEventArgs.getOperationResult().setShowMessage(false);
        if (this.validateCalibrateBegin()) {
            BillList billList = (BillList)this.getView().getControl("billlistap");
            billList.selectAllRows();
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            if (selectedRows.isEmpty()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6821\u51c6\u4f1a\u4e2d\u6709\u6821\u51c6\u5bf9\u8c61\u65f6\uff0c\u624d\u80fd\u5f00\u59cb\u6821\u51c6\u3002", (String)"OnlineCalibrationOperateList_11", (String)"tdc-oatr-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getView().invokeOperation(OP_ACTUAL_BEGINCALIBRATE);
        }
    }

    private void showCalibrateBeginFinishButton() {
        this.getView().setVisible(Boolean.TRUE, new String[]{TBL_BEGIN_CAL, TBL_FINISH_CAL, TBL_TEMP_SAVE});
        Object activityIdObj = this.getView().getFormShowParameter().getCustomParam("activityId");
        Object calSessionId = this.getView().getFormShowParameter().getCustomParam("calSessionId");
        String msg = ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u88ab\u5176\u4ed6\u4eba\u5220\u9664\u4e86\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"OnlineCalibrationOperateList_7", (String)"tdc-oatr-formplugin", (Object[])new Object[0]);
        if (activityIdObj == null || calSessionId == null) {
            this.getView().showErrorNotification(msg);
            return;
        }
        DynamicObject reviewActivity = this.activityQueryService.getReviewActivity((Object)Long.valueOf(activityIdObj.toString()));
        DynamicObject calibrateSession = this.calSessionQueryService.getCalibrateSession(Long.valueOf(Long.parseLong(calSessionId.toString())));
        if (reviewActivity == null || calibrateSession == null) {
            this.getView().showErrorNotification(msg);
            return;
        }
        String activityStatus = reviewActivity.getString("activitystatus");
        String calibrateStatus = calibrateSession.getString("calibratestatus");
        if (HRStringUtils.isEmpty((String)activityStatus) || HRStringUtils.isEmpty((String)calibrateStatus)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{TBL_BEGIN_CAL, TBL_FINISH_CAL, TBL_TEMP_SAVE});
            return;
        }
        String pageStatus = (String)this.getView().getFormShowParameter().getCustomParam("pageStatus");
        if (HRStringUtils.equals((String)pageStatus, (String)"view") || !HRStringUtils.equals((String)activityStatus, (String)ActivityStatusEnum.GOING.getCode())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{TBL_BEGIN_CAL, TBL_FINISH_CAL, TBL_TEMP_SAVE});
        } else {
            if (HRStringUtils.equals((String)calibrateStatus, (String)CalibrateSessionStatusEnum.WAIT_START.getCode())) {
                this.getView().setVisible(Boolean.FALSE, new String[]{TBL_FINISH_CAL, TBL_TEMP_SAVE});
            }
            if (HRStringUtils.equals((String)calibrateStatus, (String)CalibrateSessionStatusEnum.GOING.getCode())) {
                this.getView().setVisible(Boolean.FALSE, new String[]{TBL_BEGIN_CAL});
            }
            if (HRStringUtils.equals((String)calibrateStatus, (String)CalibrateSessionStatusEnum.END.getCode())) {
                this.getView().setVisible(Boolean.FALSE, new String[]{TBL_BEGIN_CAL, TBL_FINISH_CAL, TBL_TEMP_SAVE});
            }
        }
    }

    private boolean validateCalibrateBegin() {
        Object activityIdObj = this.getView().getFormShowParameter().getCustomParam("activityId");
        if (activityIdObj == null) {
            String msg = ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u88ab\u5176\u4ed6\u4eba\u5220\u9664\u4e86\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"OnlineCalibrationOperateList_7", (String)"tdc-oatr-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            return false;
        }
        Object sessionIdObj = this.getView().getFormShowParameter().getCustomParam("calSessionId");
        if (sessionIdObj == null) {
            String msg = ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u88ab\u5176\u4ed6\u4eba\u5220\u9664\u4e86\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"OnlineCalibrationOperateList_7", (String)"tdc-oatr-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            return false;
        }
        long sessionId = Long.parseLong(sessionIdObj.toString());
        long activityId = Long.parseLong(activityIdObj.toString());
        String collaborationFlag = (String)this.getView().getFormShowParameter().getCustomParam("collaboration_flag");
        List<String> requireCalibrateStatus = Collections.singletonList(CalibrateSessionStatusEnum.WAIT_START.getCode());
        List errorMsg = this.calibrationApplicationService.validateCalibrateCondition(activityId, sessionId, collaborationFlag, requireCalibrateStatus);
        this.showBeginCalibrateErrorMsg(errorMsg);
        return errorMsg.isEmpty();
    }

    private boolean validateCalibrateFinish() {
        Object activityIdObj = this.getView().getFormShowParameter().getCustomParam("activityId");
        if (activityIdObj == null) {
            return false;
        }
        Object sessionIdObj = this.getView().getFormShowParameter().getCustomParam("calSessionId");
        if (sessionIdObj == null) {
            return false;
        }
        long sessionId = Long.parseLong(sessionIdObj.toString());
        long activityId = Long.parseLong(activityIdObj.toString());
        String collaborationFlag = (String)this.getView().getFormShowParameter().getCustomParam("collaboration_flag");
        List<String> requireCalibrateStatus = Collections.singletonList(CalibrateSessionStatusEnum.GOING.getCode());
        List errorMsg = this.calibrationApplicationService.validateCalibrateCondition(activityId, sessionId, collaborationFlag, requireCalibrateStatus);
        this.showFinishCalibrateErrorMsg(errorMsg);
        return errorMsg.isEmpty();
    }

    private void showBeginCalibrateErrorMsg(List<String> errorMsg) {
        if (errorMsg.isEmpty()) {
            return;
        }
        if (errorMsg.contains("sessionEmptyError") || errorMsg.contains("activityEmptyError")) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u88ab\u5176\u4ed6\u4eba\u5220\u9664\u4e86\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"OnlineCalibrationOperateList_7", (String)"tdc-oatr-formplugin", (Object[])new Object[0]));
            return;
        }
        if (errorMsg.contains("organizerError")) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u6709\u6d3b\u52a8\u7ba1\u7406\u5458\u53ca\u6821\u51c6\u4f1a\u7ec4\u7ec7\u8005\u53ef\u64cd\u4f5c\u5f00\u59cb\u6821\u51c6\u3002", (String)"OnlineCalibrationOperateList_4", (String)"tdc-oatr-formplugin", (Object[])new Object[0]));
            return;
        }
        if (errorMsg.contains("activityStatusError")) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u76d8\u70b9\u6d3b\u52a8\u72b6\u6001\u4e3a\u201c\u8fdb\u884c\u4e2d\u201d\uff0c\u624d\u80fd\u5f00\u59cb\u6821\u51c6\u3002", (String)"OnlineCalibrationOperateList_5", (String)"tdc-oatr-formplugin", (Object[])new Object[0]));
            return;
        }
        if (errorMsg.contains("talentMapError")) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bab\u683c\u5730\u56fe\u5df2\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u88ab\u5176\u4ed6\u4eba\u5220\u9664\u4e86\uff0c\u8bf7\u5728\u6821\u51c6\u4f1a\u4e2d\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"OnlineCalibrationOperateList_8", (String)"tdc-oatr-formplugin", (Object[])new Object[0]));
            return;
        }
        if (errorMsg.contains("calibrateStatusError")) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6821\u51c6\u4f1a\u72b6\u6001\u662f\u201c\u5f85\u542f\u52a8\u201d\uff0c\u624d\u80fd\u5f00\u59cb\u6821\u51c6\u3002", (String)"OnlineCalibrationOperateList_2", (String)"tdc-oatr-formplugin", (Object[])new Object[0]));
        }
    }

    private void showFinishCalibrateErrorMsg(List<String> errorMsg) {
        if (errorMsg.isEmpty()) {
            return;
        }
        if (errorMsg.contains("sessionEmptyError") || errorMsg.contains("activityEmptyError")) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u88ab\u5176\u4ed6\u4eba\u5220\u9664\u4e86\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"OnlineCalibrationOperateList_7", (String)"tdc-oatr-formplugin", (Object[])new Object[0]));
            return;
        }
        if (errorMsg.contains("organizerError")) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u6709\u6d3b\u52a8\u7ba1\u7406\u5458\u53ca\u6821\u51c6\u4f1a\u7ec4\u7ec7\u8005\u53ef\u64cd\u4f5c\u5b8c\u6210\u6821\u51c6\u3002", (String)"OnlineCalibrationOperateList_14", (String)"tdc-oatr-formplugin", (Object[])new Object[0]));
            return;
        }
        if (errorMsg.contains("activityStatusError")) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u76d8\u70b9\u6d3b\u52a8\u72b6\u6001\u4e3a\u201c\u8fdb\u884c\u4e2d\u201d\uff0c\u624d\u80fd\u5b8c\u6210\u6821\u51c6\u3002", (String)"OnlineCalibrationOperateList_6", (String)"tdc-oatr-formplugin", (Object[])new Object[0]));
            return;
        }
        if (errorMsg.contains("calibrateStatusError")) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6821\u51c6\u4f1a\u72b6\u6001\u662f\u201c\u8fdb\u884c\u4e2d\u201d\uff0c\u624d\u80fd\u5b8c\u6210\u6821\u51c6\u3002", (String)"OnlineCalibrationOperateList_3", (String)"tdc-oatr-formplugin", (Object[])new Object[0]));
        }
    }
}

