/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.formplugin.web.activity;

import com.google.common.collect.Maps;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.ext.form.control.CustomControl;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.tdc.oatr.bussiness.ServiceFactory;
import kd.tdc.oatr.bussiness.queryservice.CalibrateSessionQueryService;
import kd.tdc.oatr.bussiness.queryservice.ReviewTalentMapQueryService;
import kd.tdc.oatr.common.bo.talentmap.TalentMapConfigInfo;
import kd.tdc.oatr.common.constants.enums.CalibrateSessionStatusEnum;
import kd.tdc.oatr.common.constants.enums.TalentMapPageSourceTypeEnum;

public class PreviewTalentMapPlugin
extends HRDynamicFormBasePlugin {
    private final ReviewTalentMapQueryService talentMapQueryService = (ReviewTalentMapQueryService)ServiceFactory.getService(ReviewTalentMapQueryService.class);
    private final CalibrateSessionQueryService calSessionQueryService = (CalibrateSessionQueryService)ServiceFactory.getService(CalibrateSessionQueryService.class);
    private static final String CONTROL_TALENTMAP = "talentmapcontrol";

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        TalentMapConfigInfo mapConfigInfo = this.getTalentMapConfigInfo();
        if (mapConfigInfo != null) {
            mapConfigInfo.setCloseSettings(true);
        }
        this.loadTalentMapView(mapConfigInfo);
    }

    private TalentMapConfigInfo getTalentMapConfigInfo() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object activityIdObj = customParams.get("activityId");
        Object sessionIdObj = customParams.get("calibrateSessionId");
        Object mapIdObj = customParams.get("mapEntryId");
        if (sessionIdObj != null && Long.parseLong(sessionIdObj.toString()) != 0L) {
            String mapConfigData;
            Long sessionId = Long.valueOf(sessionIdObj.toString());
            DynamicObject calibrateSession = this.calSessionQueryService.getCalibrateSession(sessionId);
            if (calibrateSession == null) {
                return null;
            }
            String talentMapId = calibrateSession.getString("talentmap");
            String calibrateStatus = calibrateSession.getString("calibratestatus");
            if ((HRStringUtils.equals((String)calibrateStatus, (String)CalibrateSessionStatusEnum.GOING.getCode()) || HRStringUtils.equals((String)calibrateStatus, (String)CalibrateSessionStatusEnum.END.getCode())) && HRStringUtils.isNotEmpty((String)(mapConfigData = calibrateSession.getString("talentmapconfig_tag")))) {
                String xAxisDimName = calibrateSession.getString("xaxisdim.name");
                String yAxisDimName = calibrateSession.getString("yaxisdim.name");
                TalentMapConfigInfo mapConfigInfo = (TalentMapConfigInfo)SerializationUtils.fromJsonString((String)mapConfigData, TalentMapConfigInfo.class);
                mapConfigInfo.getxAxisInfo().setName(xAxisDimName);
                mapConfigInfo.getyAxisInfo().setName(yAxisDimName);
                return mapConfigInfo;
            }
            if (mapIdObj != null && HRStringUtils.isNotEmpty((String)mapIdObj.toString())) {
                return this.getTalentMapConfigInfoByMapId(activityIdObj, mapIdObj);
            }
            return this.getTalentMapConfigInfoByMapId(activityIdObj, talentMapId);
        }
        return this.getTalentMapConfigInfoByMapId(activityIdObj, mapIdObj);
    }

    private TalentMapConfigInfo getTalentMapConfigInfoByMapId(Object activityIdObj, Object mapIdObj) {
        Long mapId;
        if (activityIdObj == null || mapIdObj == null || HRStringUtils.isEmpty((String)mapIdObj.toString())) {
            return null;
        }
        Long activityId = Long.valueOf(activityIdObj.toString());
        DynamicObject talentMapConfig = this.talentMapQueryService.getOneTalentMapConfig(activityId, mapId = Long.valueOf(mapIdObj.toString()));
        if (HRObjectUtils.isEmpty((Object)talentMapConfig)) {
            return null;
        }
        DynamicObjectCollection talentMapEntry = talentMapConfig.getDynamicObjectCollection("talentmapentry");
        if (talentMapEntry.isEmpty()) {
            return null;
        }
        DynamicObject talentMap = (DynamicObject)talentMapEntry.get(0);
        String mapConfigData = talentMap.getString("talentmapconfig_tag");
        if (HRStringUtils.isEmpty((String)mapConfigData)) {
            return null;
        }
        String xAxisDimName = talentMap.getString("xaxisdim.name");
        String yAxisDimName = talentMap.getString("yaxisdim.name");
        TalentMapConfigInfo mapConfigInfo = (TalentMapConfigInfo)SerializationUtils.fromJsonString((String)mapConfigData, TalentMapConfigInfo.class);
        mapConfigInfo.getxAxisInfo().setName(xAxisDimName);
        mapConfigInfo.getyAxisInfo().setName(yAxisDimName);
        return mapConfigInfo;
    }

    private void loadTalentMapView(TalentMapConfigInfo mapConfigInfo) {
        CustomControl gridControl = (CustomControl)this.getView().getControl(CONTROL_TALENTMAP);
        Map<String, Object> mapData = this.getCustomEventParams();
        mapData.put("data", mapConfigInfo);
        gridControl.setData(mapData);
    }

    private Map<String, Object> getCustomEventParams() {
        HashMap mapData = Maps.newHashMapWithExpectedSize((int)10);
        mapData.put("code", 200);
        mapData.put("success", true);
        mapData.put("eventName", "loadData");
        mapData.put("eventStatus", "init");
        mapData.put("times", System.currentTimeMillis());
        mapData.put("pageStatus", "view");
        mapData.put("pageSource", TalentMapPageSourceTypeEnum.ACTIVITY.getNumber());
        return mapData;
    }
}

