/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.formplugin.web.activity;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Consumer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.filter.CommonBaseDataFilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.column.ListOperationColumnDesc;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseList;
import kd.tdc.oatr.bussiness.ServiceFactory;
import kd.tdc.oatr.common.constants.enums.ManagerItemEnum;
import kd.tdc.oatr.formplugin.web.common.ManagerItemUtil;
import kd.tdc.oatr.formplugin.web.formservice.ReviewActivityFormService;

public class ReviewActivityColList
extends HRCoreBaseList {
    private static final Log logger = LogFactory.getLog(ReviewActivityColList.class);
    private static final HRBaseServiceHelper REVIEWGROUP_REPOSITORY = new HRBaseServiceHelper("oatr_reviewgroup");
    private static final HRBaseServiceHelper COL_REVIEW_ACTIVITY_REPOSITORY = new HRBaseServiceHelper("oatr_colreviewactivity");
    private final ReviewActivityFormService activityFormService = (ReviewActivityFormService)ServiceFactory.getService(ReviewActivityFormService.class);

    public void setFilter(SetFilterEvent setFilterEvent) {
        super.setFilter(setFilterEvent);
        setFilterEvent.setOrderBy("modifytime desc");
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        String fieldName;
        super.filterContainerBeforeF7Select(args);
        switch (fieldName = args.getFieldName()) {
            case "createorg.id": 
            case "createorg.name": {
                QFilter userQFilter = new QFilter("entryentity.collaborator", "=", (Object)RequestContext.get().getCurrUserId());
                QFilter statusQFilter = new QFilter("entryentity.colstatus", "=", (Object)"1");
                DynamicObject[] collaborators = REVIEWGROUP_REPOSITORY.query("entryentity,reviewactivity.id", new QFilter[]{userQFilter, statusQFilter});
                QFilter reviewActivityQFilter = new QFilter("id", "in", Arrays.stream(collaborators).map(d -> d.getLong("reviewactivity.id")).collect(Collectors.toSet()));
                DynamicObject[] activitys = COL_REVIEW_ACTIVITY_REPOSITORY.query("createorg", new QFilter[]{reviewActivityQFilter});
                args.addCustomQFilter(new QFilter("id", "in", Arrays.stream(activitys).map(activity -> activity.getLong("createorg.id")).collect(Collectors.toSet())));
                break;
            }
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        HashSet createOrgComboItems = Sets.newHashSetWithExpectedSize((int)16);
        QFilter userQFilter = new QFilter("entryentity.collaborator", "=", (Object)RequestContext.get().getCurrUserId());
        QFilter statusQFilter = new QFilter("entryentity.colstatus", "=", (Object)"1");
        DynamicObject[] collaborators = REVIEWGROUP_REPOSITORY.query("entryentity,reviewactivity.id", new QFilter[]{userQFilter, statusQFilter});
        QFilter reviewActivityQFilter = new QFilter("id", "in", Arrays.stream(collaborators).map(d -> d.getLong("reviewactivity.id")).collect(Collectors.toSet()));
        Object[] activitys = COL_REVIEW_ACTIVITY_REPOSITORY.query("createorg", new QFilter[]{reviewActivityQFilter});
        if (HRArrayUtils.isNotEmpty((Object[])activitys)) {
            List list = Arrays.stream(activitys).map(act -> act.getPkValue().toString()).collect(Collectors.toList());
            logger.info("ReviewActivityColList activitys: {}", list);
        }
        for (Object activity : activitys) {
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(activity.getString("createorg.name")));
            comboItem.setValue(activity.getString("createorg.id"));
            comboItem.setDisable(false);
            comboItem.setItemVisible(true);
            createOrgComboItems.add(comboItem);
        }
        List list = args.getCommonFilterColumns();
        ((CommonBaseDataFilterColumn)list.get(0)).setComboItems((List)Lists.newArrayList((Iterable)createOrgComboItems));
        logger.info("ReviewActivityColList init createOrgComboItems: {}", (Object)SerializationUtils.toJsonString((Object)createOrgComboItems));
    }

    public void beforeShowBill(BeforeShowBillFormEvent event) {
        super.beforeShowBill(event);
        BillShowParameter billShowParameter = event.getParameter();
        Object activityId = billShowParameter.getPkId();
        if (activityId != null) {
            ManagerItemUtil.checkPermByManagerItem(ManagerItemEnum.BASE_INFO, activityId, (Consumer<Boolean>)((Consumer)isCollaborator -> {
                if (!isCollaborator.booleanValue()) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u4f60\u7684\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u5237\u65b0\u6216\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"ReviewActivityColList_0", (String)"tdc-oatr-formplugin", (Object[])new Object[0]), MessageBoxOptions.None);
                    event.setCancel(true);
                } else {
                    billShowParameter.setStatus(OperationStatus.VIEW);
                }
            }));
            FormShowParameter listParameter = this.getView().getFormShowParameter();
            String groupPageKey = "openreviewgroup" + activityId;
            String processPageKey = "openreviewprocess" + activityId;
            String calibratePageKey = "opencalibratesession" + activityId;
            billShowParameter.setCustomParam(groupPageKey, listParameter.getCustomParam(groupPageKey));
            billShowParameter.setCustomParam(processPageKey, listParameter.getCustomParam(processPageKey));
            billShowParameter.setCustomParam(calibratePageKey, listParameter.getCustomParam(calibratePageKey));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (operateKey = afterDoOperationEventArgs.getOperateKey()) {
            case "openreviewgroup": 
            case "openreviewprocess": 
            case "opencalibratesession": {
                BillList list = (BillList)this.getView().getControl("billlistap");
                Object focusActivityId = list.getFocusRowPkId();
                String entityId = list.getEntityId();
                this.activityFormService.checkPermAndShowView(operateKey, focusActivityId, entityId, (AbstractFormPlugin)this);
                break;
            }
        }
    }

    public void packageData(PackageDataEvent e) {
        super.packageData(e);
        DynamicObject rowData = e.getRowData();
        if (e.getSource() instanceof ListOperationColumnDesc) {
            List operationColItems = (List)e.getFormatValue();
            this.activityFormService.setOpColVisible(rowData, operationColItems);
        }
    }
}

