/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.formplugin.web.activity;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.formop.DeleteEntry;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRDyObjectPropUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.tdc.oatr.bussiness.ServiceFactory;
import kd.tdc.oatr.bussiness.queryservice.EvaluationSchemeQueryService;
import kd.tdc.oatr.common.constants.enums.ActivityStatusEnum;
import kd.tdc.oatr.common.utils.PropUtils;
import kd.tdc.tdcs.bussiness.formservice.FormCommonService;
import org.apache.commons.lang3.tuple.Pair;

public class ReviewActivityDimensionEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener {
    private static final Map<String, String> DELETE_ENTRY = ImmutableMap.of((Object)"deleteentrydim", (Object)"dimesionentry");
    private static final HRBaseServiceHelper REVIEWGROUP_REPOSITORY = new HRBaseServiceHelper("oatr_reviewgroup");
    private final EvaluationSchemeQueryService evaluationSchemeQueryService = (EvaluationSchemeQueryService)ServiceFactory.getService(EvaluationSchemeQueryService.class);

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        ((BasedataEdit)this.getControl("evaluationscheme")).addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        boolean isDimSchemeDelete;
        Long activityId;
        QFilter activityQF;
        QFilter statusQFilter;
        QFilter userQFilter;
        super.beforeDoOperation(args);
        AbstractOperate source = (AbstractOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if ("oatr_colreviewactivity".equals(this.getView().getFormShowParameter().getFormId()) && (HRStringUtils.equals((String)operateKey, (String)"newentry_dim") || HRStringUtils.equals((String)operateKey, (String)"deleteentry_dim")) && !REVIEWGROUP_REPOSITORY.isExists(new QFilter[]{userQFilter = new QFilter("entryentity.collaborator", "=", (Object)RequestContext.get().getCurrUserId()), statusQFilter = new QFilter("entryentity.colstatus", "=", (Object)"1"), activityQF = new QFilter("reviewactivity.id", "=", (Object)(activityId = Long.valueOf(this.getModel().getDataEntity().getLong("id"))))})) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u4f60\u7684\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u5237\u65b0\u6216\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"ReviewActivityColList_0", (String)"tdc-oatr-formplugin", (Object[])new Object[0]), MessageBoxOptions.None);
            args.setCancel(true);
            return;
        }
        if (source instanceof DeleteEntry) {
            DeleteEntry deleteEntry = (DeleteEntry)source;
            OperateOption option = deleteEntry.getOption();
            String opKey = deleteEntry.getOperateKey();
            String entryKey = DELETE_ENTRY.get(opKey);
            if (HRStringUtils.isEmpty((String)entryKey)) {
                return;
            }
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(entryKey);
            int[] selectRows = entryGrid.getSelectRows();
            this.getPageCache().put("selectRows", SerializationUtils.toJsonString((Object)selectRows));
            int size = selectRows.length;
            Map variables = option.getVariables();
            if (variables.containsKey(opKey)) {
                return;
            }
            boolean isPass = this.checkTalentMapDimensionIsSelected(selectRows);
            if (isPass) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u4f60\u5df2\u9009\u4e2d%s\u6761\u8bb0\u5f55\uff0c\u786e\u5b9a\u8981\u7ee7\u7eed\u5417\uff1f", (String)"ReviewMaintainCollaboratorPlugin_2", (String)"tdc-oatr-formplugin", (Object[])new Object[]{size}), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(opKey, (IFormPlugin)this));
            }
            args.setCancel(true);
            return;
        }
        if (source instanceof Save && (isDimSchemeDelete = this.checkDimensionSchemeData())) {
            args.setCancel(true);
        }
    }

    private boolean checkDimensionSchemeData() {
        DynamicObjectCollection dimEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("dimesionentry");
        if (HRCollUtil.isEmpty((Collection)dimEntry)) {
            return false;
        }
        for (DynamicObject entryRow : dimEntry) {
            DynamicObject evaluationScheme = entryRow.getDynamicObject("evaluationscheme");
            String evaluationSchemeName = entryRow.getString("dimschemename");
            if (evaluationScheme != null || !HRStringUtils.isNotEmpty((String)evaluationSchemeName)) continue;
            String errorTips = ResManager.loadKDString((String)"{0}\u5df2\u88ab\u5176\u4ed6\u7528\u6237\u5220\u9664\u6216\u7981\u7528\uff0c\u8bf7\u91cd\u65b0\u786e\u8ba4\u76d8\u70b9\u7ef4\u5ea6\u8bc4\u4f30\u65b9\u6848\u3002", (String)"ReviewActivityTplToolPlugin_5", (String)"tdc-oatr-formplugin", (Object[])new Object[]{evaluationSchemeName});
            this.getView().showErrorNotification(errorTips);
            return true;
        }
        return false;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (HRStringUtils.equals((String)"deleteentrydim", (String)operateKey) && (this.getView().getFormShowParameter().getFormId().equals("oatr_reviewactivity") || this.getView().getFormShowParameter().getFormId().equals("oatr_colreviewactivity"))) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"ReviewActivityDimensionEdit_2", (String)"tdc-oatr-formplugin", (Object[])new Object[0]));
        }
        if (Objects.nonNull(args.getOperationResult()) && args.getOperationResult().isSuccess()) {
            switch (operateKey) {
                case "newentry_dim": {
                    this.newEntry();
                    break;
                }
                case "deleteentry_dim": {
                    this.deleteEntry();
                    break;
                }
            }
        }
    }

    private void deleteEntry() {
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("currbizappid", this.getView().getFormShowParameter().getAppId());
        this.getView().invokeOperation("deleteentrydim", operateOption);
    }

    private void newEntry() {
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"oatr_reviewdimension", (boolean)true);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectType dynamicObjectType = dataEntity.getDynamicObjectType();
        EntryProp dimTplEntry = (EntryProp)dynamicObjectType.getProperty("dimesionentry");
        DynamicObjectType dynamicCollectionItemPropertyType = dimTplEntry.getDynamicCollectionItemPropertyType();
        BasedataProp reviewDimension = (BasedataProp)dynamicCollectionItemPropertyType.getProperty("reviewdimension");
        List qFilters = reviewDimension.buildCoreFilterByString(this.getModel());
        DynamicObjectCollection dimTplColl = dataEntity.getDynamicObjectCollection("dimesionentry");
        Set dimIds = dimTplColl.stream().filter(dimTpl -> Objects.nonNull(dimTpl.get("reviewdimension"))).map(dimTpl -> {
            long dimId = dimTpl.getLong(PropUtils.getIdDot((String)"reviewdimension"));
            return dimId;
        }).collect(Collectors.toSet());
        if (kd.bos.util.CollectionUtils.isNotEmpty(dimIds)) {
            QFilter dimIdQFilter = new QFilter("id", "not in", dimIds);
            qFilters.add(dimIdQFilter);
        }
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        listFilterParameter.setQFilters(qFilters);
        listShowParameter.setListFilterParameter(listFilterParameter);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "newEntry_dim");
        listShowParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (Objects.isNull(closedCallBackEvent.getReturnData())) {
            return;
        }
        if ("newEntry_dim".equals(actionId)) {
            if (this.colReviewActivityPermitCheck()) {
                return;
            }
            ListSelectedRowCollection listSelectedRows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            if (CollectionUtils.isEmpty((Collection)listSelectedRows)) {
                return;
            }
            List dimIds = listSelectedRows.stream().map(row -> Long.parseLong(String.valueOf(row.getPrimaryKeyValue()))).collect(Collectors.toList());
            HRBaseServiceHelper dimServiceHelper = new HRBaseServiceHelper("oatr_reviewdimension");
            DynamicObject[] dimDOArr = dimServiceHelper.query("id,number,name", new QFilter[]{new QFilter("id", "in", dimIds)});
            TableValueSetter tableValueSetter = new TableValueSetter(new String[0]);
            for (DynamicObject dim : dimDOArr) {
                tableValueSetter.addField("reviewdimension", new Object[]{dim.getLong("id")});
            }
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.beginInit();
            model.batchCreateNewEntryRow("dimesionentry", tableValueSetter);
            model.endInit();
            DynamicObjectCollection entryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection("dimesionentry");
            Comparator<DynamicObject> numberCompare = Comparator.comparing(entry -> entry.getString("reviewdimension.number"), Comparator.naturalOrder());
            List collect = entryEntity.stream().sorted(numberCompare).collect(Collectors.toList());
            for (int i = 0; i < collect.size(); ++i) {
                entryEntity.set(i, collect.get(i));
            }
            this.getView().updateView("dimesionentry");
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6dfb\u52a0\u6210\u529f\u3002", (String)"ReviewActivityDimensionEdit_3", (String)"tdc-oatr-formplugin", (Object[])new Object[0]));
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String name = args.getProperty().getName();
        if (HRStringUtils.equals((String)name, (String)"evaluationscheme")) {
            int currentRowIndex = this.getModel().getEntryCurrentRowIndex("dimesionentry");
            DynamicObject evaluationScheme = (DynamicObject)this.getModel().getValue("evaluationscheme", currentRowIndex);
            String schemeName = evaluationScheme == null ? null : evaluationScheme.getString("name");
            this.getModel().setValue("dimschemename", (Object)schemeName, currentRowIndex);
            if (!this.isActivityForm()) {
                return;
            }
            String activityStatus = (String)this.getModel().getValue("activitystatus");
            if (ActivityStatusEnum.GOING.getCode().equals(activityStatus)) {
                if (evaluationScheme == null) {
                    this.getModel().setValue("dimevaluation", null, currentRowIndex);
                    this.getModel().setValue("dimschemename", null, currentRowIndex);
                    return;
                }
                long schemeId = evaluationScheme.getLong("id");
                DynamicObject[] evaluationSchemeObjs = this.evaluationSchemeQueryService.listEvaluationSchemes(Collections.singletonList(schemeId));
                List evaluationIds = Arrays.stream(evaluationSchemeObjs).map(scheme -> scheme.getLong("entryentity.evaluationitem.id")).collect(Collectors.toList());
                this.getModel().setValue("dimevaluation", (Object)evaluationIds.toArray(), currentRowIndex);
            }
        }
    }

    private boolean isActivityForm() {
        String currentFormId = this.getView().getFormShowParameter().getFormId();
        return "oatr_colreviewactivity".equals(currentFormId) || "oatr_reviewactivity".equals(currentFormId);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name = evt.getProperty().getName();
        if (HRStringUtils.equals((String)name, (String)"evaluationscheme")) {
            int currentRowIndex = this.getModel().getEntryCurrentRowIndex("dimesionentry");
            DynamicObject reviewDimension = (DynamicObject)this.getModel().getValue("reviewdimension", currentRowIndex);
            if (reviewDimension != null) {
                long dimId = reviewDimension.getLong("id");
                QFilter dimFilter = new QFilter("dimension", "=", (Object)dimId);
                evt.getCustomQFilters().add(dimFilter);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackOpKey = messageBoxClosedEvent.getCallBackId();
        String entryKey = DELETE_ENTRY.get(callBackOpKey);
        if (HRStringUtils.isNotEmpty((String)entryKey) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            if (this.colReviewActivityPermitCheck()) {
                return;
            }
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue(callBackOpKey, "1");
            this.getView().invokeOperation(callBackOpKey, operateOption);
        }
        if (HRStringUtils.equals((String)"deleteDimensionAction", (String)callBackOpKey) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            if (this.colReviewActivityPermitCheck()) {
                return;
            }
            this.handleDeleteDimensionAction(messageBoxClosedEvent);
            String selectRows = this.getPageCache().get("selectRows");
            List selectRowList = (List)SerializationUtils.fromJsonString((String)selectRows, List.class);
            int allNum = selectRowList.size();
            int failNum = 0;
            String delLockDimIds = this.getPageCache().get("delLockDimIds");
            if (HRStringUtils.isNotEmpty((String)delLockDimIds)) {
                Set delLockDimIdSet = (Set)SerializationUtils.fromJsonString((String)delLockDimIds, Set.class);
                Set delLockDimSets = delLockDimIdSet.stream().map(delContainAndLockDim -> Long.valueOf(delContainAndLockDim.toString())).collect(Collectors.toSet());
                DynamicObjectCollection entrys = this.getModel().getDataEntity(true).getDynamicObjectCollection("dimesionentry");
                for (int i = 0; i < entrys.size(); ++i) {
                    if (!delLockDimSets.contains(((DynamicObject)entrys.get(i)).getLong("reviewdimension.id"))) continue;
                    selectRowList.remove((Object)i);
                }
            }
            int[] del = new int[selectRowList.size()];
            for (int i = 0; i < selectRowList.size(); ++i) {
                del[i] = (Integer)selectRowList.get(i);
            }
            this.getModel().deleteEntryRows("dimesionentry", del);
            if (HRStringUtils.isEmpty((String)delLockDimIds)) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"ReviewActivityDimensionEdit_2", (String)"tdc-oatr-formplugin", (Object[])new Object[0]));
                return;
            }
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("bos_operationresult");
            showParameter.setShowTitle(false);
            String deleteDimIds = this.getPageCache().get("deleteDimIds");
            if (HRStringUtils.isEmpty((String)deleteDimIds)) {
                return;
            }
            ArrayList<String> errorMsg = new ArrayList<String>(16);
            if (HRStringUtils.isNotEmpty((String)delLockDimIds)) {
                Set fails = (Set)SerializationUtils.fromJsonString((String)delLockDimIds, Set.class);
                failNum = fails.size();
                String dimNumNameMap = this.getPageCache().get("dimNumNameMap");
                Map dimNumNameMaps = (Map)SerializationUtils.fromJsonString((String)dimNumNameMap, Map.class);
                for (Object failOne : fails) {
                    Long failOneLong = Long.valueOf(String.valueOf(failOne));
                    Map dim = (Map)dimNumNameMaps.get(String.valueOf(failOneLong));
                    String num = "";
                    String name = "";
                    for (Map.Entry entry : dim.entrySet()) {
                        num = (String)entry.getKey();
                        name = (String)entry.getValue();
                    }
                    errorMsg.add(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u201c%2$s\u201d\u5df2\u5728\u5bab\u683c\u5730\u56fe\u9501\u5b9a\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"ReviewActivityDimensionEdit_5", (String)"tdc-oatr-formplugin", (Object[])new Object[0]), num, name));
                }
            }
            String titleMsg = String.format(ResManager.loadKDString((String)"\u5171%1$s\u6761\u7ef4\u5ea6\uff0c\u5220\u9664\u6210\u529f%2$s\u4e2a\uff0c\u5931\u8d25%3$s\u4e2a\u3002", (String)"ReviewActivityDimensionEdit_4", (String)"tdc-oatr-formplugin", (Object[])new Object[0]), allNum, allNum - failNum, failNum);
            showParameter.setCustomParam("title", (Object)titleMsg);
            showParameter.setCustomParam("errorMsg", errorMsg);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(showParameter);
        }
    }

    private boolean colReviewActivityPermitCheck() {
        if ("oatr_colreviewactivity".equals(this.getView().getFormShowParameter().getFormId())) {
            QFilter userQFilter = new QFilter("entryentity.collaborator", "=", (Object)RequestContext.get().getCurrUserId());
            QFilter statusQFilter = new QFilter("entryentity.colstatus", "=", (Object)"1");
            Long activityId = this.getModel().getDataEntity().getLong("id");
            QFilter activityQF = new QFilter("reviewactivity.id", "=", (Object)activityId);
            if (!REVIEWGROUP_REPOSITORY.isExists(new QFilter[]{userQFilter, statusQFilter, activityQF})) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u4f60\u7684\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u5237\u65b0\u6216\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"ReviewActivityColList_0", (String)"tdc-oatr-formplugin", (Object[])new Object[0]), MessageBoxOptions.None);
                return true;
            }
        }
        return false;
    }

    private boolean checkTalentMapDimensionIsSelected(int[] dimRows) {
        if (dimRows.length == 0) {
            return true;
        }
        HashSet beDeleteDimensionIdList = Sets.newHashSetWithExpectedSize((int)dimRows.length);
        HashMap dimNameMap = Maps.newHashMapWithExpectedSize((int)dimRows.length);
        HashMap dimNumNameMap = Maps.newHashMapWithExpectedSize((int)dimRows.length);
        for (int dimRow : dimRows) {
            DynamicObject reviewDimension = (DynamicObject)this.getModel().getValue("reviewdimension", dimRow);
            long dimId = HRDyObjectPropUtil.getId((DynamicObject)reviewDimension);
            String name = HRDyObjectPropUtil.getName((DynamicObject)reviewDimension);
            beDeleteDimensionIdList.add(dimId);
            dimNameMap.put(dimId, name);
            if (null == reviewDimension) continue;
            dimNumNameMap.put(dimId, Pair.of((Object)reviewDimension.getString("number"), (Object)name));
        }
        DynamicObjectCollection talentMapEntry = this.getModel().getEntryEntity("talentmapentry");
        HashSet delContainDimIds = Sets.newHashSetWithExpectedSize((int)dimRows.length);
        HashSet delLockDimIds = Sets.newHashSetWithExpectedSize((int)dimRows.length);
        for (Object mapEntry : talentMapEntry) {
            boolean isLock;
            long xAxisDimId = HRDyObjectPropUtil.getId((DynamicObject)mapEntry.getDynamicObject("xaxisdim"));
            long yAxisDimId = HRDyObjectPropUtil.getId((DynamicObject)mapEntry.getDynamicObject("yaxisdim"));
            DynamicObjectCollection perCardDims = mapEntry.getDynamicObjectCollection("percarddim");
            List perCardDimIds = perCardDims.stream().map(dim -> dim.getLong("fbasedataid_id")).collect(Collectors.toList());
            if (beDeleteDimensionIdList.contains(xAxisDimId)) {
                delContainDimIds.add(xAxisDimId);
                isLock = mapEntry.getBoolean("isxaxisdimlock");
                if (isLock) {
                    delLockDimIds.add(xAxisDimId);
                }
            }
            if (beDeleteDimensionIdList.contains(yAxisDimId)) {
                delContainDimIds.add(yAxisDimId);
                isLock = mapEntry.getBoolean("isyaxisdimlock");
                if (isLock) {
                    delLockDimIds.add(yAxisDimId);
                }
            }
            for (Long perCardDimId : perCardDimIds) {
                if (!beDeleteDimensionIdList.contains(perCardDimId)) continue;
                delContainDimIds.add(perCardDimId);
                boolean isLock2 = mapEntry.getBoolean("ispercarddimlock");
                if (!isLock2) continue;
                delLockDimIds.add(perCardDimId);
            }
        }
        if (delContainDimIds.isEmpty()) {
            return true;
        }
        HashSet dimNames = Sets.newHashSetWithExpectedSize((int)delLockDimIds.size());
        this.getPageCache().remove("delLockDimIds");
        this.getPageCache().remove("dimNumNameMap");
        if (!delLockDimIds.isEmpty()) {
            this.getPageCache().put("delLockDimIds", SerializationUtils.toJsonString((Object)delLockDimIds));
            this.getPageCache().put("dimNumNameMap", SerializationUtils.toJsonString((Object)dimNumNameMap));
        }
        for (Long delContainDimId : delContainDimIds) {
            dimNames.add(dimNameMap.get(delContainDimId));
        }
        delContainDimIds.removeAll(delLockDimIds);
        this.getPageCache().put("deleteDimIds", SerializationUtils.toJsonString((Object)delContainDimIds));
        String dimNameTips = String.join((CharSequence)"\u3001", dimNames);
        String showTips = MessageFormat.format(ResManager.loadKDString((String)"\u201c{0}\u201d\u5df2\u88ab\u5bab\u683c\u5730\u56fe\u5f15\u7528\uff0c\u5220\u9664\u540e\u5c06\u6e05\u7a7a\u5bab\u683c\u7ef4\u5ea6\u76f8\u5173\u914d\u7f6e\uff0c\u786e\u5b9a\u8981\u7ee7\u7eed\u5417\uff1f", (String)"ReviewActivityDimensionEdit_1", (String)"tdc-oatr-formplugin", (Object[])new Object[0]), dimNameTips);
        this.getView().showConfirm(showTips, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("deleteDimensionAction", (IFormPlugin)this));
        return false;
    }

    private void handleDeleteDimensionAction(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            this.getView().addClientCallBack("refreshCurrentMapDim");
        }
    }

    public void beforeClosed(BeforeClosedEvent evt) {
        super.beforeClosed(evt);
        FormCommonService commonService = (FormCommonService)kd.tdc.tdcs.bussiness.ServiceFactory.getService(FormCommonService.class);
        commonService.setPropertyNotDataChanged(this.getModel(), new String[]{"dimevaluation"});
    }
}

