/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.formplugin.web.activity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.Consumer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.hr.hbp.common.model.AuthorizedOrgResult;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.tdc.oatr.bussiness.ServiceFactory;
import kd.tdc.oatr.bussiness.application.ReviewActivityApplicationService;
import kd.tdc.oatr.bussiness.application.ext.PermissionExternalService;
import kd.tdc.oatr.bussiness.domain.reviewgroup.ReviewGroupService;
import kd.tdc.oatr.bussiness.domain.reviewobjct.ReviewObjectService;
import kd.tdc.oatr.bussiness.queryservice.ReviewPlansQueryService;
import kd.tdc.oatr.common.constants.enums.ActivityStatusEnum;
import kd.tdc.oatr.common.constants.enums.ManagerItemEnum;
import kd.tdc.oatr.common.utils.PropUtils;
import kd.tdc.oatr.formplugin.web.activity.ReviewActivityFilterGridCommon;
import kd.tdc.oatr.formplugin.web.activity.detail.ReviewActivityDetailCommon;
import kd.tdc.oatr.formplugin.web.common.FormBizChangeUtils;
import kd.tdc.oatr.formplugin.web.common.ManagerItemUtil;
import kd.tdc.oatr.formplugin.web.formservice.ReviewActivityFormService;
import org.apache.commons.lang3.StringUtils;

public class ReviewActivityEdit
extends HRDataBaseEdit
implements ReviewActivityFilterGridCommon,
ReviewActivityDetailCommon,
BeforeF7SelectListener,
AfterF7SelectListener {
    public static final String GETOBJBYCONFIG_LABEL = "getobjbyconfig";
    public static final String DONOTHING_GETOBJBYCONFIG = "donothing_getobjbyconfig";
    private static final String FIELD_KEY_ADFFMINORGSELECT = "adminorgselect";
    private static final String ENTRY_ADMINORGENTRY = "adminorgentry";
    private static final String ENTRY_FIELD_ADMINORGVID = "adminorgvid";
    public static final String KEY_NEW_ORG_ENTRY = "neworgentry";
    private static final Log log = LogFactory.getLog(ReviewActivityApplicationService.class);
    private final ReviewActivityApplicationService activityAppService = (ReviewActivityApplicationService)ServiceFactory.getService(ReviewActivityApplicationService.class);
    private final ReviewObjectService reviewObjectService = (ReviewObjectService)ServiceFactory.getService(ReviewObjectService.class);
    private final ReviewActivityFormService activityFormService = (ReviewActivityFormService)ServiceFactory.getService(ReviewActivityFormService.class);
    private final PermissionExternalService permissionExternalService = (PermissionExternalService)ServiceFactory.getService(PermissionExternalService.class);
    private final ReviewPlansQueryService reviewPlansQueryService = (ReviewPlansQueryService)ServiceFactory.getService(ReviewPlansQueryService.class);
    private final ReviewGroupService reviewGroupService = (ReviewGroupService)ServiceFactory.getService(ReviewGroupService.class);

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        if (e.getFormShowParameter().getStatus().equals((Object)OperationStatus.ADDNEW)) {
            e.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u76d8\u70b9\u6d3b\u52a8", (String)"ReviewActivityEdit_5", (String)"tdc-oatr-formplugin", (Object[])new Object[0]));
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ((BasedataEdit)this.getControl("reviewplan")).addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit adminOrgHREdit = (MulBasedataEdit)this.getControl(FIELD_KEY_ADFFMINORGSELECT);
        adminOrgHREdit.addAfterF7SelectListener((AfterF7SelectListener)this);
        adminOrgHREdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setOpenBtnVisible();
        this.setPersonScopeCtlStgLabelValue(this.getView(), this.getModel().getDataEntity().getString("personscopectlstg"));
        this.showRefreshVectorIfTemplateChange();
        this.disablePersonScopeFilterGrid(this.getView());
        this.showGetObjByConfigLabel();
        this.showReviewTool(this.getView());
        this.setReviewPlanEditable();
        this.setAdminorgEnable();
    }

    private void setAdminorgEnable() {
        String activityStatus;
        Object activityStatusObj = this.getModel().getValue("activitystatus");
        String string = activityStatus = HRObjectUtils.isEmpty((Object)activityStatusObj) ? "" : activityStatusObj.toString();
        if (!HRStringUtils.equals((String)ActivityStatusEnum.WAIT_START.getCode(), (String)activityStatus)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"adminorg", ENTRY_ADMINORGENTRY});
            this.getView().setVisible(Boolean.FALSE, new String[]{"advconbaritemap", "advconbaritemap1"});
        }
    }

    public void propertyChanged(PropertyChangedArgs evt) {
        super.propertyChanged(evt);
        String name = evt.getProperty().getName();
        if (name.equals("adminorg")) {
            this.setReviewPlanEditable();
            DynamicObject adminorg = (DynamicObject)this.getModel().getValue(name);
            if (adminorg == null) {
                this.getModel().setValue("reviewplan", null);
            } else {
                DynamicObject reviewPlan = (DynamicObject)this.getModel().getValue("reviewplan");
                if (reviewPlan != null) {
                    long reviewPlanId = reviewPlan.getLong("id");
                    QFilter idFilter = new QFilter("id", "=", (Object)reviewPlanId);
                    long adminorgId = adminorg.getLong("id");
                    QFilter adminorgFilter = new QFilter("adminorgentry.adminorgvid", "=", (Object)adminorgId);
                    String structLongNumber = adminorg.getString("structlongnumber");
                    String[] structNumbers = structLongNumber.split("!");
                    QFilter parentOrgFilter = new QFilter("adminorgentry.adminorgincludesub", "=", (Object)true).and("adminorgentry.adminorgvid.structnumber", "in", Arrays.asList(structNumbers));
                    adminorgFilter.or(parentOrgFilter);
                    boolean exists = this.reviewPlansQueryService.isExists(new QFilter[]{idFilter, adminorgFilter});
                    if (!exists) {
                        this.getModel().setValue("reviewplan", null);
                    }
                }
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String propName = beforeF7SelectEvent.getProperty().getName();
        if ("reviewplan".equals(propName)) {
            QFilter buQF = new QFilter("createorg", "=", (Object)this.getModel().getDataEntity().getLong("createorg.id"));
            DynamicObject adminorg = (DynamicObject)this.getModel().getValue("adminorg");
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
            qFilters.add(buQF);
            if (!HRObjectUtils.isEmpty((Object)adminorg)) {
                long adminorgId = adminorg.getLong("id");
                QFilter adminorgFilter = new QFilter("adminorgentry.adminorgvid", "=", (Object)adminorgId);
                String structLongNumber = adminorg.getString("structlongnumber");
                String[] structNumbers = structLongNumber.split("!");
                QFilter parentOrgFilter = new QFilter("adminorgentry.adminorgincludesub", "=", (Object)true).and("adminorgentry.adminorgvid.structnumber", "in", Arrays.asList(structNumbers));
                adminorgFilter.or(parentOrgFilter);
                qFilters.add(adminorgFilter);
            }
            beforeF7SelectEvent.getCustomQFilters().addAll(qFilters);
        }
        if (FIELD_KEY_ADFFMINORGSELECT.equals(propName)) {
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ArrayList<QFilter> f7Filters = new ArrayList<QFilter>(10);
            AuthorizedOrgResult userAdminOrgs = this.permissionExternalService.getUserAdminOrgs("oatr_reviewobjcollistpop", "47150e89000000ac", ENTRY_FIELD_ADMINORGVID, (Map)Maps.newHashMapWithExpectedSize((int)0));
            if (!userAdminOrgs.isHasAllOrgPerm()) {
                List hasPermOrgIds = userAdminOrgs.getHasPermOrgs();
                f7Filters.add(new QFilter("id", "in", (Object)hasPermOrgIds));
            }
            beforeF7SelectEvent.getCustomQFilters().addAll(f7Filters);
            this.getView().getFormShowParameter().setCustomParam("customHREntityNumber", (Object)"oatr_reviewactivity");
            this.getView().getFormShowParameter().setCustomParam("custom_parent_f7_prop", (Object)ENTRY_FIELD_ADMINORGVID);
            this.getView().getFormShowParameter().setCustomParam("customHRPermItemId", (Object)"47150e89000000ac");
            this.getView().cacheFormShowParameter();
            DynamicObjectCollection adminOrgEntryDyCol = this.getModel().getDataEntity().getDynamicObjectCollection(ENTRY_ADMINORGENTRY);
            ArrayList orgIdList = Lists.newArrayListWithCapacity((int)adminOrgEntryDyCol.size());
            for (DynamicObject adminOrgEntryDy : adminOrgEntryDyCol) {
                DynamicObject dynamicObject = adminOrgEntryDy.getDynamicObject(ENTRY_FIELD_ADMINORGVID);
                orgIdList.add(dynamicObject.getLong("id"));
            }
            formShowParameter.setSelectedRows(orgIdList.toArray());
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (source instanceof Save) {
            DynamicObjectCollection adminorgEntry;
            boolean hasManagerItem;
            if ("oatr_colreviewactivity".equals(this.getView().getFormShowParameter().getFormId()) && !(hasManagerItem = ManagerItemUtil.checkPermByManagerItem(ManagerItemEnum.BASE_INFO, this.getModel().getDataEntity().getPkValue(), (Consumer<Boolean>)((Consumer)ignore -> {
                args.setCancel(true);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u4f60\u7684\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u5237\u65b0\u6216\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"ReviewActivityColList_0", (String)"tdc-oatr-formplugin", (Object[])new Object[0]), MessageBoxOptions.None);
            })))) {
                return;
            }
            String filterStr = this.getFilterConditionStr(this.getView());
            this.getModel().setValue("perscopefilter_tag", (Object)filterStr);
            boolean isToolSchemeDelete = this.checkReviewToolSchemeData();
            if (isToolSchemeDelete) {
                args.setCancel(true);
            }
            if (HRCollUtil.isEmpty((Collection)(adminorgEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_ADMINORGENTRY)))) {
                String tips = ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u9002\u7528\u7ec4\u7ec7\u8303\u56f4\u201d", (String)"ReviewActivityColList_4", (String)"tdc-oatr-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(tips);
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        Object source = afterDoOperationEventArgs.getSource();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        if (source instanceof Save && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            this.showGetObjByConfigLabel();
            String filterJson = dataEntity.getString("perscopefilter_tag");
            QFilter personScopeQFilter = this.activityAppService.getPersonScopeQFilter(filterJson);
            if (personScopeQFilter != null) {
                this.dispatch();
            } else {
                this.activityAppService.deleteNotJoinedObj(dataEntity.getLong("id"));
            }
            this.dealReviewToolRelation();
        }
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        long activityId = dataEntity.getLong("id");
        if (DONOTHING_GETOBJBYCONFIG.equals(operateKey)) {
            this.activityAppService.refreshReviewObjectByActivityConfig(activityId);
        }
        switch (operateKey) {
            case "openreviewgroup": 
            case "openreviewprocess": 
            case "opencalibratesession": {
                if (activityId == 0L) {
                    return;
                }
                String entityId = this.getView().getEntityId();
                this.activityFormService.checkPermAndShowView(operateKey, activityId, entityId, (AbstractFormPlugin)this);
                break;
            }
        }
        if (KEY_NEW_ORG_ENTRY.equals(operateKey)) {
            MulBasedataEdit adminOrgHREdit = (MulBasedataEdit)this.getControl(FIELD_KEY_ADFFMINORGSELECT);
            MulBasedataProp property = (MulBasedataProp)adminOrgHREdit.getProperty();
            property.setMustInput(true);
            adminOrgHREdit.click();
            property.setMustInput(false);
        }
    }

    private void dispatch() {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setAppId("oatr");
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setRunByLang(Lang.get());
        String number = this.getModel().getDataEntity().getString("number");
        jobInfo.setName(ResManager.loadKDString((String)"\u83b7\u53d6\u8303\u56f4\u4e0b\u76d8\u70b9\u4eba\u5458_{0}", (String)"ReviewActivityEdit_8", (String)"tdc-oatr-formplugin", (Object[])new Object[]{number}));
        jobInfo.setId(UUID.randomUUID().toString());
        jobInfo.setTaskClassname("kd.tdc.oatr.bussiness.task.GenReviewObjectTask");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("reviewActivity", SerializationUtils.serializeToBase64((Object)this.getModel().getDataEntity(true)));
        jobInfo.setParams(params);
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setCanBackground(true);
        jobFormInfo.setClickClassName("kd.tdc.oatr.bussiness.task.ScheduleTaskClick");
        JobForm.dispatch((JobFormInfo)jobFormInfo, (IFormView)this.getView());
    }

    private void showGetObjByConfigLabel() {
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (status == OperationStatus.VIEW) {
            this.getView().setVisible(Boolean.FALSE, new String[]{GETOBJBYCONFIG_LABEL});
            return;
        }
        String filterJson = this.getModel().getDataEntity().getString("perscopefilter_tag");
        if (StringUtils.isBlank((CharSequence)filterJson)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{GETOBJBYCONFIG_LABEL});
            return;
        }
        QFilter personScopeQFilter = this.activityAppService.getPersonScopeQFilter(filterJson);
        this.getView().setVisible(Boolean.valueOf(personScopeQFilter != null), new String[]{GETOBJBYCONFIG_LABEL});
    }

    private void setOpenBtnVisible() {
        String activityStatus;
        Object activityStatusObj = this.getModel().getValue("activitystatus");
        String string = activityStatus = HRObjectUtils.isEmpty((Object)activityStatusObj) ? "" : activityStatusObj.toString();
        if (HRStringUtils.equals((String)ActivityStatusEnum.WAIT_START.getCode(), (String)activityStatus)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"openreviewprocess", "opencalibratesession"});
        }
        ArrayList btnList = Lists.newArrayList((Object[])new String[]{"openreviewgroup", "openreviewprocess", "opencalibratesession"});
        int hideBtnNum = 0;
        for (String btn : btnList) {
            if (!this.activityFormService.isHideBtnByPagePerm(btn)) continue;
            this.getView().setVisible(Boolean.FALSE, new String[]{btn});
            ++hideBtnNum;
        }
        if (hideBtnNum == 3) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"openinfopage"});
        }
    }

    private void showRefreshVectorIfTemplateChange() {
        boolean activityEnd;
        DynamicObject dataEntity = this.getModel().getDataEntity();
        if (dataEntity.getDataEntityState().getFromDatabase() && (activityEnd = this.checkActivityStatus(this.getModel().getDataEntity().getPkValue(), () -> this.getView().setVisible(Boolean.FALSE, new String[]{"refreshtmp_vectorap"})))) {
            return;
        }
        boolean templateChange = this.isTemplateChange();
        this.getView().setVisible(Boolean.valueOf(templateChange), new String[]{"refreshtmp_vectorap"});
    }

    private boolean isTemplateChange() {
        boolean templateChange = false;
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject dynamicObject = dataEntity.getDynamicObject("activitytemplate");
        if (dynamicObject != null) {
            Date date = dynamicObject.getDate("contentchangetime");
            Date activityDate = dataEntity.getDate("contentchangetime");
            if (date == null || !date.equals(activityDate)) {
                templateChange = true;
            }
        }
        return templateChange;
    }

    @Override
    public String getFilterGridControlKey() {
        return "reviewperscopefilter";
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        FormBizChangeUtils.setBizChanged(this.getModel().getDataEntity(true), "perscopefilter", "perscopefilter_tag", "contentchangetime", "dimensionctlstg", "dimensionctlstg", "personscopectlstg", "toolsctlstg", "characteristic", "enablestatus", "lockstatus");
        if (!Objects.nonNull(this.getModel().getValue("activitytemplate"))) {
            FormBizChangeUtils.setBizChanged(this.getModel().getDataEntity(true), "selectstatus");
        }
    }

    private boolean checkReviewToolSchemeData() {
        IFormView view = this.getView();
        String reviewToolPageId = view.getPageCache().get("reviewToolPageId");
        if (StringUtils.isBlank((CharSequence)reviewToolPageId)) {
            return false;
        }
        IFormView toolView = view.getView(reviewToolPageId);
        if (toolView == null) {
            return false;
        }
        IDataModel toolViewModel = toolView.getModel();
        if (!toolViewModel.isDataLoaded()) {
            return false;
        }
        DynamicObject reviewTool = toolViewModel.getDataEntity(true);
        DynamicObjectCollection toolEntry = reviewTool.getDynamicObjectCollection("entryentity_outer");
        int row = 0;
        for (DynamicObject entry : toolEntry) {
            DynamicObject outerTool = entry.getDynamicObject("outer_tool");
            if (outerTool == null) {
                String toolName = entry.getString("toolname");
                String errorTips = ResManager.loadKDString((String)"{0}\u5df2\u88ab\u5176\u4ed6\u7528\u6237\u5220\u9664\u6216\u7981\u7528\uff0c\u8bf7\u91cd\u65b0\u786e\u8ba4\u76d8\u70b9\u5de5\u5177\u3002", (String)"ReviewActivityEdit_9", (String)"tdc-oatr-formplugin", (Object[])new Object[]{toolName});
                toolViewModel.deleteEntryRow("entryentity_outer", row);
                this.getView().sendFormAction(toolView);
                this.getView().showErrorNotification(errorTips);
                return true;
            }
            ++row;
        }
        return false;
    }

    private void dealReviewToolRelation() {
        DynamicObject[] reviewObjDOArr;
        IFormView view = this.getView();
        String reviewToolPageId = view.getPageCache().get("reviewToolPageId");
        if (StringUtils.isBlank((CharSequence)reviewToolPageId)) {
            return;
        }
        IFormView toolView = view.getView(reviewToolPageId);
        if (toolView == null) {
            return;
        }
        DynamicObject reviewTool = toolView.getModel().getDataEntity(true);
        long activityId = this.getModel().getDataEntity().getLong("id");
        if (reviewTool.get("id").equals(0L)) {
            reviewTool.set("reviewactivity", (Object)activityId);
            DynamicObject defaultReviewGroup = this.reviewGroupService.queryDefaultReviewGroup((Object)activityId);
            if (defaultReviewGroup != null) {
                DynamicObjectCollection entryEntityOuterTools;
                long defaultReviewGroupId = defaultReviewGroup.getLong("id");
                DynamicObjectCollection entryEntityInnerTools = reviewTool.getDynamicObjectCollection("entryentity_inner");
                if (HRCollUtil.isNotEmpty((Collection)entryEntityInnerTools)) {
                    for (Object entryEntityInnerTool : entryEntityInnerTools) {
                        DynamicObjectCollection innerReviewGroup = entryEntityInnerTool.getDynamicObjectCollection("inner_reviewgroup");
                        DynamicObject newReviewGroup = innerReviewGroup.addNew();
                        newReviewGroup.set("fbasedataid", (Object)defaultReviewGroupId);
                    }
                }
                if (HRCollUtil.isNotEmpty((Collection)(entryEntityOuterTools = reviewTool.getDynamicObjectCollection("entryentity_outer")))) {
                    for (DynamicObject entryEntityOuterTool : entryEntityOuterTools) {
                        DynamicObjectCollection outerReviewGroup = entryEntityOuterTool.getDynamicObjectCollection("outer_reviewgroup");
                        DynamicObject newReviewGroup = outerReviewGroup.addNew();
                        newReviewGroup.set("fbasedataid", (Object)defaultReviewGroupId);
                    }
                }
            }
            reviewToolApplicationService.saveReviewTool(reviewTool);
            return;
        }
        DynamicObjectCollection outerToolCollection = reviewTool.getDynamicObjectCollection("entryentity_outer");
        List outerToolIds = outerToolCollection.stream().map(outer -> outer.getLong(PropUtils.getIdDot((String)"outer_tool"))).collect(Collectors.toList());
        ArrayList deleteOuterToolIds = Lists.newArrayListWithExpectedSize((int)outerToolIds.size());
        DynamicObject reviewToolDataBase = reviewToolQueryService.getReviewToolByPkId(reviewTool.getPkValue());
        DynamicObjectCollection outerToolDataBase = reviewToolDataBase.getDynamicObjectCollection("entryentity_outer");
        outerToolDataBase.forEach(outerDataBase -> {
            long toolId = outerDataBase.getLong(PropUtils.getIdDot((String)"outer_tool"));
            if (!outerToolIds.contains(toolId)) {
                deleteOuterToolIds.add(toolId);
            }
        });
        for (DynamicObject reviewObj : reviewObjDOArr = this.reviewObjectService.getReviewObjByActivityId(activityId)) {
            DynamicObjectCollection entryEntityEval = reviewObj.getDynamicObjectCollection("entryentity_eval");
            entryEntityEval.removeIf(eval -> deleteOuterToolIds.contains(eval.getLong(PropUtils.getIdDot((String)"evaltool"))));
        }
        try (TXHandle txHandle = TX.required((String)"dealReviewToolRelation");){
            try {
                reviewToolApplicationService.saveReviewTool(reviewTool);
                this.reviewObjectService.save(reviewObjDOArr);
            }
            catch (Exception e) {
                log.error("dealReviewToolRelation error:", (Throwable)e);
                txHandle.markRollback();
            }
        }
    }

    private void setReviewPlanEditable() {
        DynamicObject adminOrg = (DynamicObject)this.getModel().getValue("adminorg");
        this.getView().setEnable(Boolean.valueOf(!HRObjectUtils.isEmpty((Object)adminOrg)), new String[]{"reviewplan"});
    }

    public void afterF7Select(AfterF7SelectEvent afterF7SelectEvent) {
        Control source = (Control)afterF7SelectEvent.getSource();
        String key = source.getKey();
        if (FIELD_KEY_ADFFMINORGSELECT.equals(key)) {
            this.updateEntry(ENTRY_ADMINORGENTRY, ENTRY_FIELD_ADMINORGVID, key);
        }
    }

    private void updateEntry(String entry, String field, String selectF7Name) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        DynamicObjectCollection entityEntity = model.getEntityEntity(entry);
        DynamicObjectCollection adminOrgEntryDyCol = this.getModel().getDataEntity().getDynamicObjectCollection(selectF7Name);
        ArrayList orgIdList = Lists.newArrayListWithCapacity((int)adminOrgEntryDyCol.size());
        for (DynamicObject adminOrgEntryDy : adminOrgEntryDyCol) {
            DynamicObject dynamicObject = adminOrgEntryDy.getDynamicObject("fbasedataid");
            orgIdList.add(dynamicObject.getLong("id"));
        }
        if (CollectionUtils.isEmpty((Collection)entityEntity)) {
            model.deleteEntryData(entry);
            int newEntryRowCount = adminOrgEntryDyCol.size();
            if (newEntryRowCount > 0) {
                int[] newEntryRow = model.batchCreateNewEntryRow(entry, newEntryRowCount);
                model.beginInit();
                for (int i = 0; i < adminOrgEntryDyCol.size(); ++i) {
                    DynamicObject adminOrg = ((DynamicObject)adminOrgEntryDyCol.get(i)).getDynamicObject("fbasedataid");
                    model.setValue(field, (Object)adminOrg, newEntryRow[i]);
                }
                model.endInit();
                this.getView().updateView(entry);
                model.setDataChanged(Boolean.TRUE.booleanValue());
            }
        } else {
            ArrayList<Integer> deleteIndex = new ArrayList<Integer>(10);
            for (int i = 0; i < entityEntity.size(); ++i) {
                DynamicObject entryDyn = (DynamicObject)entityEntity.get(i);
                DynamicObject entryOrg = entryDyn.getDynamicObject(field);
                if (null == entryOrg || orgIdList.contains(entryOrg.getLong("id"))) continue;
                deleteIndex.add(i);
            }
            int[] delIntArrays = deleteIndex.stream().mapToInt(idx -> idx).toArray();
            model.deleteEntryRows(entry, delIntArrays);
            List entryOrgIdList = entityEntity.stream().map(entryRow -> entryRow.getDynamicObject(field).getLong("id")).collect(Collectors.toList());
            ArrayList newOrgIdList = new ArrayList(orgIdList);
            newOrgIdList.removeAll(entryOrgIdList);
            if (HRCollUtil.isNotEmpty(newOrgIdList)) {
                int newEntryRowCount = newOrgIdList.size();
                int[] newEntryRow = model.batchCreateNewEntryRow(entry, newEntryRowCount);
                for (int i = 0; i < newEntryRowCount; ++i) {
                    Long adminOrgId = (Long)newOrgIdList.get(i);
                    model.setValue(field, (Object)adminOrgId, newEntryRow[i]);
                }
            }
            model.updateEntryCache(entityEntity);
            this.getView().updateView(entry);
        }
    }
}

