/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.formplugin.web.activity;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.column.ListOperationColumnDesc;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseList;
import kd.tdc.oatr.bussiness.ServiceFactory;
import kd.tdc.oatr.bussiness.batchconfirm.activity.ReviewActivityBatchEndFormService;
import kd.tdc.oatr.bussiness.batchconfirm.activity.ReviewActivityBatchStartFormService;
import kd.tdc.oatr.bussiness.batchconfirm.activity.ReviewActivityBatchStopFormService;
import kd.tdc.oatr.bussiness.domain.reviewobjct.ReviewObjectService;
import kd.tdc.oatr.bussiness.queryservice.ReviewActivityQueryService;
import kd.tdc.oatr.formplugin.web.activity.CollaboratorsPopup;
import kd.tdc.oatr.formplugin.web.formservice.ReviewActivityFormService;
import kd.tdc.tdcs.bussiness.license.TDCSCertCommonHelper;

public class ReviewActivityList
extends HRCoreBaseList
implements CollaboratorsPopup {
    private final ReviewActivityBatchStartFormService startFormService = (ReviewActivityBatchStartFormService)ServiceFactory.getService(ReviewActivityBatchStartFormService.class);
    private final ReviewActivityBatchEndFormService endFormService = (ReviewActivityBatchEndFormService)ServiceFactory.getService(ReviewActivityBatchEndFormService.class);
    private final ReviewActivityBatchStopFormService stopFormService = (ReviewActivityBatchStopFormService)ServiceFactory.getService(ReviewActivityBatchStopFormService.class);
    private final ReviewActivityQueryService activityQueryService = (ReviewActivityQueryService)ServiceFactory.getService(ReviewActivityQueryService.class);
    private final ReviewActivityFormService activityFormService = (ReviewActivityFormService)ServiceFactory.getService(ReviewActivityFormService.class);
    private Map<Long, Long> reviewObjectNum;
    ReviewObjectService reviewObjectService = (ReviewObjectService)ServiceFactory.getService(ReviewObjectService.class);

    public void setFilter(SetFilterEvent setFilterEvent) {
        super.setFilter(setFilterEvent);
        setFilterEvent.setOrderBy("modifytime desc");
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        BillShowParameter billShowParameter = e.getParameter();
        FormShowParameter listParameter = this.getView().getFormShowParameter();
        Object activityId = billShowParameter.getPkId();
        if (HRObjectUtils.isEmpty((Object)activityId)) {
            return;
        }
        String groupPageKey = "openreviewgroup" + activityId;
        String processPageKey = "openreviewprocess" + activityId;
        String calibratePageKey = "opencalibratesession" + activityId;
        billShowParameter.setCustomParam(groupPageKey, listParameter.getCustomParam(groupPageKey));
        billShowParameter.setCustomParam(processPageKey, listParameter.getCustomParam(processPageKey));
        billShowParameter.setCustomParam(calibratePageKey, listParameter.getCustomParam(calibratePageKey));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String errorMessage;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (operateKey.equals("new") && HRStringUtils.isNotEmpty((String)(errorMessage = ReviewActivityList.certValidate()))) {
            this.getView().showErrorNotification(errorMessage);
            args.setCancel(true);
            return;
        }
        this.startFormService.callValidatorBeforeDoOperation(args, "start", (AbstractFormPlugin)this);
        this.endFormService.callValidatorBeforeDoOperation(args, "end", (AbstractFormPlugin)this);
        this.stopFormService.callValidatorBeforeDoOperation(args, "stop", (AbstractFormPlugin)this);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (operateKey = afterDoOperationEventArgs.getOperateKey()) {
            case "start": 
            case "end": 
            case "stop": {
                OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
                if (operationResult == null || !operationResult.isSuccess()) break;
                this.getView().invokeOperation("refresh");
                break;
            }
            case "openreviewgroup": 
            case "openreviewprocess": 
            case "opencalibratesession": {
                BillList list = (BillList)this.getView().getControl("billlistap");
                Object focusActivityId = list.getFocusRowPkId();
                String entityId = list.getEntityId();
                this.activityFormService.checkPermAndShowView(operateKey, focusActivityId, entityId, (AbstractFormPlugin)this);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData != null) {
            String actionId = closedCallBackEvent.getActionId();
            if (actionId.equals("start")) {
                this.startFormService.doOperationClosedCallBack(returnData, "start", (AbstractFormPlugin)this);
            }
            if (actionId.equals("end")) {
                this.endFormService.doOperationClosedCallBack(returnData, "end", (AbstractFormPlugin)this);
            }
            if (actionId.equals("stop")) {
                this.stopFormService.doOperationClosedCallBack(returnData, "stop", (AbstractFormPlugin)this);
            }
        }
    }

    public void listRowClick(ListRowClickEvent evt) {
        BillList billList = (BillList)evt.getSource();
        String focusField = billList.getEntryState().getFocusField();
        ListSelectedRow currentListSelectedRow = evt.getCurrentListSelectedRow();
        if (currentListSelectedRow != null && HRStringUtils.equals((String)"collaboratornum", (String)focusField)) {
            long activityId = (Long)currentListSelectedRow.getPrimaryKeyValue();
            this.showCollaboratorPopForm(this.getView(), activityId);
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        BillListHyperLinkClickEvent hyperLinkClickEvent = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
        Object primaryKeyValue = hyperLinkClickEvent.getCurrentRow().getPrimaryKeyValue();
        String fieldName = args.getFieldName();
        HashSet adjustNums = Sets.newHashSet((Object[])new String[]{"collaboratornum"});
        if (adjustNums.contains(fieldName)) {
            args.setCancel(true);
        }
        if (fieldName.equals("number")) {
            if (!this.activityQueryService.isExists(primaryKeyValue)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"ReviewActivityList_1", (String)"tdc-oatr-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            ReviewActivityQueryService service = (ReviewActivityQueryService)ServiceFactory.getService(ReviewActivityQueryService.class);
            boolean activityEnd = service.getReviewActivityEnd(primaryKeyValue);
            if (activityEnd) {
                args.setCancel(true);
                this.getView().invokeOperation("view");
            }
        }
    }

    public void packageData(PackageDataEvent e) {
        super.packageData(e);
        DynamicObject rowData = e.getRowData();
        AbstractColumnDesc source = (AbstractColumnDesc)e.getSource();
        String fieldKey = source.getKey();
        if ("reviewpernum".equals(fieldKey)) {
            long id = rowData.getLong("id");
            Long num = this.getReviewObjectNum().get(id);
            if (num != null) {
                e.setFormatValue((Object)num);
            } else {
                e.setFormatValue((Object)"0");
            }
        }
        if (e.getSource() instanceof ListOperationColumnDesc) {
            List operationColItems = (List)e.getFormatValue();
            this.activityFormService.setOpColVisible(rowData, operationColItems);
        }
    }

    public void beforePackageData(BeforePackageDataEvent e) {
        super.beforePackageData(e);
        List activityIds = e.getPageData().stream().map(obj -> obj.getLong("id")).collect(Collectors.toList());
        Map reviewObjectNum = this.reviewObjectService.getReviewObjectNumByActivity(activityIds);
        this.setReviewObjectNum(reviewObjectNum);
    }

    public Map<Long, Long> getReviewObjectNum() {
        return this.reviewObjectNum;
    }

    public void setReviewObjectNum(Map<Long, Long> reviewObjectNum) {
        this.reviewObjectNum = reviewObjectNum;
    }

    private static String certValidate() {
        Map certResultMap = TDCSCertCommonHelper.verifyCert((String)"32J2T2KEXE6T", (String)"oatr_reviewactivity");
        if (CollectionUtils.isEmpty((Map)certResultMap)) {
            return "";
        }
        Object infoTypeObj = certResultMap.get("infoType");
        if ("FORBIDDEN".equals(infoTypeObj)) {
            return certResultMap.get("message") == null ? "" : certResultMap.get("message").toString();
        }
        return "";
    }
}

