/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.formplugin.web.activity;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.list.events.BeforePackageDataListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.tdc.oatr.bussiness.ServiceFactory;
import kd.tdc.oatr.bussiness.domain.reviewobjct.ReviewObjectService;
import kd.tdc.oatr.formplugin.web.activity.CollaboratorsPopup;

public class ReviewActivityListLayOutEdit
extends HRDataBaseEdit
implements CollaboratorsPopup,
BeforePackageDataListener {
    private Map<Long, Long> reviewObjectNum;
    ReviewObjectService reviewObjectService = (ReviewObjectService)ServiceFactory.getService(ReviewObjectService.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BillList billList = (BillList)this.getView().getControl("billlistap");
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        billList.addBeforeBindDataListener(beforeBindDataEvent -> this.filterBillList(formShowParameter));
        billList.addHyperClickListener(evt -> this.openCollaboratorsTpl((BillListHyperLinkClickEvent)evt));
    }

    private void openCollaboratorsTpl(BillListHyperLinkClickEvent evt) {
        ListSelectedRow currentRow = evt.getCurrentRow();
        long activityId = (Long)currentRow.getPrimaryKeyValue();
        this.showCollaboratorPopForm(this.getView(), activityId);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        BillList billList = this.filterBillList(formShowParameter);
        billList.addBeforePackageDataListener((BeforePackageDataListener)this);
        billList.addPackageDataListener(this::packageDataProcess);
        billList.refreshData();
    }

    private BillList filterBillList(FormShowParameter formShowParameter) {
        Map customParams = formShowParameter.getCustomParams();
        BillList billList = (BillList)this.getView().getControl("billlistap");
        Object activityListFilter = customParams.get("activity_bill_list_filter");
        if (activityListFilter != null) {
            QFilter qFilter = QFilter.fromSerializedString((String)String.valueOf(activityListFilter));
            billList.getFilterParameter().getQFilters().add(qFilter);
        } else {
            billList.getFilterParameter().getQFilters().add(new QFilter("id", "=", (Object)0));
        }
        return billList;
    }

    private void packageDataProcess(PackageDataEvent packageEvent) {
        DynamicObject rowData = packageEvent.getRowData();
        AbstractColumnDesc source = (AbstractColumnDesc)packageEvent.getSource();
        String fieldKey = source.getKey();
        if ("reviewpernum".equals(fieldKey)) {
            long id = rowData.getLong("id");
            Long num = this.getReviewObjectNum().get(id);
            if (num != null) {
                packageEvent.setFormatValue((Object)num);
            } else {
                packageEvent.setFormatValue((Object)"0");
            }
        }
    }

    public void beforePackageData(BeforePackageDataEvent e) {
        List activityIds = e.getPageData().stream().map(obj -> obj.getLong("id")).collect(Collectors.toList());
        Map reviewObjectNum = this.reviewObjectService.getReviewObjectNumByActivity(activityIds);
        this.setReviewObjectNum(reviewObjectNum);
    }

    public Map<Long, Long> getReviewObjectNum() {
        return this.reviewObjectNum;
    }

    public void setReviewObjectNum(Map<Long, Long> reviewObjectNum) {
        this.reviewObjectNum = reviewObjectNum;
    }
}

