/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.formplugin.web.activity;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.hr.hbp.common.util.HRDyObjectPropUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tdc.oatr.bussiness.ServiceFactory;
import kd.tdc.oatr.bussiness.queryservice.ReviewActivityTplQueryService;
import kd.tdc.oatr.common.constants.enums.TalentMapPageSourceTypeEnum;
import kd.tdc.oatr.formplugin.web.activity.ReviewTalentMapConfigCommonEdit;

public class ReviewActivityMapConfigEdit
extends ReviewTalentMapConfigCommonEdit
implements RowClickEventListener {
    public static final String CLIENT_ACTION_CLEAN_TALENT_MAP_DATA = "cleanTalentMapData";
    public static final String CLIENT_ACTION_UPDATE_TEMPLATE_TALENT_MAP_DATA = "updateTemplateTalentMapData";
    private static final String CACHE_IS_CLEAN_TALENT_MAP = "iscleantalentmap";
    private static final String CACHE_IS_UPDATE_TPL_TALENT_MAP = "isupdatetpltalentmap";
    private final ReviewActivityTplQueryService activityTplQueryService = (ReviewActivityTplQueryService)ServiceFactory.getService(ReviewActivityTplQueryService.class);

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        CardEntry mapEntry = (CardEntry)this.getControl("talentmapentry");
        mapEntry.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject evt) {
        super.afterCreateNewData(evt);
        int defaultTalentMapRow = this.createNewDefaultTalentMap();
        this.initNewTalentMapData(defaultTalentMapRow, true);
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        this.setTalentMapTabName();
        int defaultMapRow = this.getDefaultTalentMapRow();
        this.selectTalentMapTab(defaultMapRow);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setInitTalentMapDataChange();
    }

    public void clientCallBack(ClientCallBackEvent e) {
        super.clientCallBack(e);
        String actionName = e.getName();
        if (actionName.equals("refreshCurrentMapDim")) {
            this.deleteEntryDimension();
            int clickCurrentRow = this.getCurrentClickRow();
            this.selectTalentMapTab(clickCurrentRow);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (operateKey.equals("save") || operateKey.equals("submit")) {
            this.beforeSaveAndSubmit();
        }
        if (HRStringUtils.equals((String)operateKey, (String)"mapinteract")) {
            OperateOption option = operate.getOption();
            String actionName = option.getVariableValue("interactAction");
            this.interactAction(actionName);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ((operateKey.equals("save") || operateKey.equals("submit")) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
    }

    private void interactAction(String actionName) {
        if (HRStringUtils.equals((String)actionName, (String)"actionUpdateTalentMapData")) {
            this.updateTalentMapEntryData();
        }
        if (HRStringUtils.equals((String)actionName, (String)CLIENT_ACTION_CLEAN_TALENT_MAP_DATA)) {
            this.getPageCache().put(CACHE_IS_CLEAN_TALENT_MAP, "1");
            this.cleanTalentMapConfigData();
        }
        if (HRStringUtils.equals((String)actionName, (String)CLIENT_ACTION_UPDATE_TEMPLATE_TALENT_MAP_DATA)) {
            this.getPageCache().put(CACHE_IS_UPDATE_TPL_TALENT_MAP, "1");
            this.updateTalentMapConfigData();
        }
    }

    public void afterAddRow(AfterAddRowEventArgs evt) {
        super.afterAddRow(evt);
        EntryProp entryProp = evt.getEntryProp();
        String name = entryProp.getName();
        if (name.equals("talentmapentry")) {
            String isUpdateTplTalentMap = this.getPageCache().get(CACHE_IS_UPDATE_TPL_TALENT_MAP);
            if (HRStringUtils.equals((String)isUpdateTplTalentMap, (String)"1")) {
                this.getPageCache().remove(CACHE_IS_UPDATE_TPL_TALENT_MAP);
                return;
            }
            RowDataEntity[] rowDataEntities = evt.getRowDataEntities();
            int currentRowIndex = rowDataEntities[0].getRowIndex();
            boolean isDefault = currentRowIndex == 0;
            this.initNewTalentMapData(currentRowIndex, isDefault);
            this.recordCurrentClickRow(currentRowIndex);
            int clickCurrentRow = this.getCurrentClickRow();
            this.selectTalentMapTab(clickCurrentRow);
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        EntryProp entryProp = e.getEntryProp();
        String name = entryProp.getName();
        if (name.equals("talentmapentry")) {
            String isCleanTalentMap = this.getPageCache().get(CACHE_IS_CLEAN_TALENT_MAP);
            if (HRStringUtils.equals((String)isCleanTalentMap, (String)"1")) {
                this.getPageCache().remove(CACHE_IS_CLEAN_TALENT_MAP);
                return;
            }
            int row = this.getDefaultTalentMapRow();
            this.selectTalentMapTab(row);
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        EntryGrid source = (EntryGrid)evt.getSource();
        String key = source.getKey();
        if (key.equals("talentmapentry")) {
            int row = evt.getRow();
            if (row == -1) {
                row = this.getDefaultTalentMapRow();
            }
            this.recordCurrentClickRow(row);
            int clickCurrentRow = this.getCurrentClickRow();
            this.selectTalentMapTab(clickCurrentRow);
        }
    }

    @Override
    public String getTalentMapSourceType() {
        return TalentMapPageSourceTypeEnum.ACTIVITY.getNumber();
    }

    private void cleanTalentMapConfigData() {
        DynamicObjectCollection mapEntryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection("talentmapentry");
        ArrayList cleanMapEntryRows = Lists.newArrayList();
        for (int i = 0; i < mapEntryEntity.size(); ++i) {
            DynamicObject mapEntry = (DynamicObject)mapEntryEntity.get(i);
            long entrySourceId = mapEntry.getLong("entrysourceid");
            if (entrySourceId == 0L) continue;
            cleanMapEntryRows.add(i);
        }
        if (cleanMapEntryRows.isEmpty()) {
            return;
        }
        int[] deleteRows = cleanMapEntryRows.stream().mapToInt(Integer::intValue).toArray();
        this.getModel().deleteEntryRows("talentmapentry", deleteRows);
        mapEntryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection("talentmapentry");
        if (mapEntryEntity.isEmpty()) {
            this.getPageCache().put(CACHE_IS_UPDATE_TPL_TALENT_MAP, "1");
            this.resetTalentMapTabNumber();
            int newDefaultTalentMapRow = this.createNewDefaultTalentMap();
            this.initNewTalentMapData(newDefaultTalentMapRow, true);
            this.selectTalentMapTab(newDefaultTalentMapRow);
            return;
        }
        int defaultTalentMapRow = this.getDefaultTalentMapRow();
        if (defaultTalentMapRow == -1) {
            this.getModel().setValue("isdefaultmap", (Object)true, 0);
        }
        this.selectTalentMapTab(0);
    }

    private void updateTalentMapConfigData() {
        this.getModel().deleteEntryData("talentmapentry");
        DynamicObject activityTemplate = this.getModel().getDataEntity().getDynamicObject("activitytemplate");
        Long templateId = HRDyObjectPropUtil.getId((DynamicObject)activityTemplate);
        DynamicObject actTemplate = this.activityTplQueryService.getReviewActivityTplTalentMapConfig(templateId);
        DynamicObjectCollection tplTalentMapEntry = actTemplate.getDynamicObjectCollection("talentmapentry");
        if (tplTalentMapEntry.isEmpty()) {
            return;
        }
        int[] newEntryRows = this.getModel().batchCreateNewEntryRow("talentmapentry", tplTalentMapEntry.size());
        for (int i = 0; i < newEntryRows.length; ++i) {
            DynamicObject tplMapEntryRow = (DynamicObject)tplTalentMapEntry.get(i);
            int row = newEntryRows[i];
            String referStrategy = tplMapEntryRow.getString("referstrategy");
            this.getModel().setValue("referstrategy", (Object)referStrategy, row);
            boolean isDefaultMap = tplMapEntryRow.getBoolean("isdefaultmap");
            this.getModel().setValue("isdefaultmap", (Object)isDefaultMap, row);
            boolean isDefaultMapLock = tplMapEntryRow.getBoolean("isdefaultmaplock");
            this.getModel().setValue("isdefaultmaplock", (Object)isDefaultMapLock, row);
            long gridTemplateId = HRDyObjectPropUtil.getId((DynamicObject)tplMapEntryRow.getDynamicObject("gridtemplate"));
            this.getModel().setValue("gridtemplate", (Object)gridTemplateId, row);
            boolean isGridTemplateLock = tplMapEntryRow.getBoolean("isgridtemplatelock");
            this.getModel().setValue("isgridtemplatelock", (Object)isGridTemplateLock, row);
            long xAxisDimId = HRDyObjectPropUtil.getId((DynamicObject)tplMapEntryRow.getDynamicObject("xaxisdim"));
            this.getModel().setValue("xaxisdim", (Object)xAxisDimId, row);
            boolean isxAxisDimLock = tplMapEntryRow.getBoolean("isxaxisdimlock");
            this.getModel().setValue("isxaxisdimlock", (Object)isxAxisDimLock, row);
            long yAxisDimId = HRDyObjectPropUtil.getId((DynamicObject)tplMapEntryRow.getDynamicObject("yaxisdim"));
            this.getModel().setValue("yaxisdim", (Object)yAxisDimId, row);
            boolean isyAxisDimLock = tplMapEntryRow.getBoolean("isyaxisdimlock");
            this.getModel().setValue("isyaxisdimlock", (Object)isyAxisDimLock, row);
            DynamicObjectCollection perCardDims = tplMapEntryRow.getDynamicObjectCollection("percarddim");
            this.getModel().setValue("percarddim", (Object)perCardDims, row);
            boolean isPerCardDimLock = tplMapEntryRow.getBoolean("ispercarddimlock");
            this.getModel().setValue("ispercarddimlock", (Object)isPerCardDimLock, row);
            String talentMapConfig = tplMapEntryRow.getString("talentmapconfig_tag");
            this.getModel().setValue("talentmapconfig_tag", (Object)talentMapConfig, row);
            Date gridTplSelectTime = tplMapEntryRow.getDate("gridtplselecttime");
            this.getModel().setValue("gridtplselecttime", (Object)gridTplSelectTime, row);
            long sourceId = HRDyObjectPropUtil.getId((DynamicObject)tplMapEntryRow);
            this.getModel().setValue("entrysourceid", (Object)sourceId, row);
        }
        this.resetTalentMapTabNumber();
        this.setTalentMapTabName();
        int currentRowIndex = this.getModel().getEntryCurrentRowIndex("talentmapentry");
        if (currentRowIndex == -1) {
            currentRowIndex = this.getDefaultTalentMapRow();
        }
        this.selectTalentMapTab(currentRowIndex);
    }
}

