/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.formplugin.web.activity;

import com.google.common.collect.Maps;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDyObjectPropUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.tdc.oatr.bussiness.ServiceFactory;
import kd.tdc.oatr.bussiness.queryservice.GridTemplateQueryService;
import kd.tdc.oatr.common.constants.enums.TalentMapStrategyEnum;
import kd.tdc.tdcs.bussiness.formservice.FormCommonService;

public class ReviewTalentMapConfigCommonEdit
extends HRDataBaseEdit {
    private static final Log LOG = LogFactory.getLog(ReviewTalentMapConfigCommonEdit.class);
    private static final String CACHE_KEY_GRID_TPL_UPDATE_TIME_MAP = "gridTplUpdateTimeMap";
    private static final String CACHE_IS_DELETE_DIM = "isDeleteDim";
    protected static final String CACHE_KEY_CLICK_CURRENT_ROW = "clickCurrentRow";
    private static final String CACHE_KEY_MAP_NUMBER = "mapNumber";
    protected static final String CACHE_KEY_CURRENT_SHOW_MAP_ROW = "currentShowMapRow";
    private static final String CACHE_KEY_MAP_TAB_PAGEID = "mapTabPageId";
    private static final String FLEX_TALENT_MAP = "flextalentmap";
    private final GridTemplateQueryService gridTemplateQueryService = (GridTemplateQueryService)ServiceFactory.getService(GridTemplateQueryService.class);

    public void deleteEntryDimension() {
        String selectDimRow = this.getPageCache().get("deleteDimIds");
        if (HRStringUtils.isEmpty((String)selectDimRow)) {
            return;
        }
        Set deleteIdObjs = (Set)SerializationUtils.fromJsonString((String)selectDimRow, Set.class);
        Set deleteIds = deleteIdObjs.stream().map(deleteIdObj -> Long.valueOf(deleteIdObj.toString())).collect(Collectors.toSet());
        DynamicObjectCollection talentMapEntry = this.getModel().getEntryEntity("talentmapentry");
        for (int i = 0; i < talentMapEntry.size(); ++i) {
            long yAxisDimId;
            DynamicObject mapEntry = (DynamicObject)talentMapEntry.get(i);
            long xAxisDimId = HRDyObjectPropUtil.getId((DynamicObject)mapEntry.getDynamicObject("xaxisdim"));
            if (deleteIds.contains(xAxisDimId)) {
                this.getModel().setValue("xaxisdim", null, i);
            }
            if (deleteIds.contains(yAxisDimId = HRDyObjectPropUtil.getId((DynamicObject)mapEntry.getDynamicObject("yaxisdim")))) {
                this.getModel().setValue("yaxisdim", null, i);
            }
            DynamicObjectCollection perCardDims = mapEntry.getDynamicObjectCollection("percarddim");
            List perCardDimIds = perCardDims.stream().map(dim -> dim.getLong("fbasedataid_id")).collect(Collectors.toList());
            ArrayList newPerCardDimIds = new ArrayList(perCardDimIds);
            for (Long perCardDimId : perCardDimIds) {
                if (!deleteIds.contains(perCardDimId)) continue;
                newPerCardDimIds.remove(perCardDimId);
            }
            this.getModel().setValue("percarddim", (Object)newPerCardDimIds.toArray(), i);
        }
    }

    public void updateTalentMapEntryData() {
        int defaultTalentMapRow;
        int currentRowIndex = this.getCurrentShowMapRow();
        String mapTabPageId = this.getPageCache().get(CACHE_KEY_MAP_TAB_PAGEID);
        if (HRStringUtils.isEmpty((String)mapTabPageId)) {
            return;
        }
        IFormView mapPageView = this.getView().getViewNoPlugin(mapTabPageId);
        DynamicObject mapDy = mapPageView.getModel().getDataEntity(true);
        String referStrategy = mapDy.getString("referstrategy");
        boolean isDefaultMap = mapDy.getBoolean("isdefaultmap");
        boolean isDefaultMapLock = mapDy.getBoolean("isdefaultmaplock");
        long gridTemplateId = HRDyObjectPropUtil.getId((DynamicObject)mapDy.getDynamicObject("gridtemplate"));
        boolean isGridTemplateLock = mapDy.getBoolean("isgridtemplatelock");
        long xAxisDimId = HRDyObjectPropUtil.getId((DynamicObject)mapDy.getDynamicObject("xaxisdim"));
        boolean isXAxisDimLock = mapDy.getBoolean("isxaxisdimlock");
        long yAxisDimId = HRDyObjectPropUtil.getId((DynamicObject)mapDy.getDynamicObject("yaxisdim"));
        boolean isYAxisDimLock = mapDy.getBoolean("isyaxisdimlock");
        DynamicObjectCollection perCardDims = mapDy.getDynamicObjectCollection("percarddim");
        List perCardDimIds = perCardDims.stream().map(dim -> dim.getLong("fbasedataid_id")).collect(Collectors.toList());
        boolean isPerCardDimLock = mapDy.getBoolean("ispercarddimlock");
        String mapConfigInfo = mapDy.getString("talentmapconfig_tag");
        Date gridTplSelectDate = mapDy.getDate("gridtplselecttime");
        this.getModel().setValue("referstrategy", (Object)referStrategy, currentRowIndex);
        this.getModel().setValue("isdefaultmaplock", (Object)isDefaultMapLock, currentRowIndex);
        this.getModel().setValue("gridtemplate", (Object)(gridTemplateId == 0L ? null : Long.valueOf(gridTemplateId)), currentRowIndex);
        this.getModel().setValue("isgridtemplatelock", (Object)true, currentRowIndex);
        this.getModel().setValue("isgridtemplatelock", (Object)isGridTemplateLock, currentRowIndex);
        this.getModel().setValue("xaxisdim", (Object)(xAxisDimId == 0L ? null : Long.valueOf(xAxisDimId)), currentRowIndex);
        this.getModel().setValue("isxaxisdimlock", (Object)isXAxisDimLock, currentRowIndex);
        this.getModel().setValue("yaxisdim", (Object)(yAxisDimId == 0L ? null : Long.valueOf(yAxisDimId)), currentRowIndex);
        this.getModel().setValue("isyaxisdimlock", (Object)isYAxisDimLock, currentRowIndex);
        this.getModel().setValue("percarddim", (Object)(CollectionUtils.isEmpty(perCardDimIds) ? null : perCardDimIds.toArray()), currentRowIndex);
        this.getModel().setValue("ispercarddimlock", (Object)isPerCardDimLock, currentRowIndex);
        this.getModel().setValue("talentmapconfig_tag", (Object)mapConfigInfo, currentRowIndex);
        if (gridTplSelectDate != null) {
            this.getModel().setValue("gridtplselecttime", (Object)gridTplSelectDate, currentRowIndex);
        }
        if (isDefaultMap && (defaultTalentMapRow = this.getDefaultTalentMapRow()) != currentRowIndex) {
            this.getModel().setValue("isdefaultmap", (Object)false, defaultTalentMapRow);
            this.getModel().setValue("isdefaultmap", (Object)true, currentRowIndex);
        }
    }

    private String getTalentMapTabNumber() {
        String mapNumber = this.getPageCache().get(CACHE_KEY_MAP_NUMBER);
        if (HRStringUtils.isEmpty((String)mapNumber)) {
            this.getPageCache().put(CACHE_KEY_MAP_NUMBER, "1");
            return "1";
        }
        int newMapNumber = Integer.parseInt(mapNumber) + 1;
        this.getPageCache().put(CACHE_KEY_MAP_NUMBER, String.valueOf(newMapNumber));
        return String.valueOf(newMapNumber);
    }

    protected void resetTalentMapTabNumber() {
        this.getPageCache().remove(CACHE_KEY_MAP_NUMBER);
    }

    public int createNewDefaultTalentMap() {
        DynamicObjectCollection mapEntryEntity = this.getModel().getEntryEntity("talentmapentry");
        if (!CollectionUtils.isEmpty((Collection)mapEntryEntity)) {
            return this.getDefaultTalentMapRow();
        }
        return this.getModel().createNewEntryRow("talentmapentry");
    }

    public void initNewTalentMapData(int newEntryRow, boolean isDefaultMap) {
        String talMapName = this.getInitMapName();
        this.getModel().setValue("maptitle", (Object)talMapName, newEntryRow);
        this.getModel().setValue("isdefaultmap", (Object)isDefaultMap, newEntryRow);
        this.getModel().setValue("isdefaultmaplock", (Object)false, newEntryRow);
        this.getModel().setValue("isgridtemplatelock", (Object)false, newEntryRow);
        this.getModel().setValue("isxaxisdimlock", (Object)false, newEntryRow);
        this.getModel().setValue("isyaxisdimlock", (Object)false, newEntryRow);
        this.getModel().setValue("ispercarddimlock", (Object)false, newEntryRow);
    }

    private String getInitMapName() {
        String mapNumber = this.getTalentMapTabNumber();
        return ResManager.loadKDString((String)"\u5bab\u683c\u5730\u56fe{0}", (String)"ReviewActivityTplMapConfigEdit_0", (String)"tdc-oatr-formplugin", (Object[])new Object[]{mapNumber});
    }

    public void setTalentMapTabName() {
        DynamicObjectCollection mapEntryEntity = this.getModel().getEntryEntity("talentmapentry");
        if (CollectionUtils.isEmpty((Collection)mapEntryEntity)) {
            LOG.error("ReviewActivityTplMapConfigEdit.setTalentMapTabName: talent map is null.");
            return;
        }
        for (int i = 0; i < mapEntryEntity.size(); ++i) {
            DynamicObject mapEntity = (DynamicObject)mapEntryEntity.get(i);
            String mapTabName = mapEntity.getString("maptitle");
            if (!HRStringUtils.isEmpty((String)mapTabName)) continue;
            String xAxisDimName = HRDyObjectPropUtil.getName((DynamicObject)mapEntity.getDynamicObject("xaxisdim"));
            String yAxisDimName = HRDyObjectPropUtil.getName((DynamicObject)mapEntity.getDynamicObject("yaxisdim"));
            if (HRStringUtils.isNotEmpty((String)xAxisDimName) && HRStringUtils.isNotEmpty((String)yAxisDimName)) {
                mapTabName = xAxisDimName + "+" + yAxisDimName;
                this.getModel().setValue("maptitle", (Object)mapTabName, i);
                continue;
            }
            if (HRStringUtils.isEmpty((String)xAxisDimName) && HRStringUtils.isEmpty((String)yAxisDimName)) {
                mapTabName = this.getInitMapName();
                this.getModel().setValue("maptitle", (Object)mapTabName, i);
                continue;
            }
            if (HRStringUtils.isEmpty((String)xAxisDimName)) {
                mapTabName = yAxisDimName;
                this.getModel().setValue("maptitle", (Object)mapTabName, i);
                continue;
            }
            if (!HRStringUtils.isEmpty((String)yAxisDimName)) continue;
            mapTabName = xAxisDimName;
            this.getModel().setValue("maptitle", (Object)mapTabName, i);
        }
    }

    private Map<String, Object> getMapPageCustomParams(DynamicObject mapEntity) {
        HashMap mapInfoParams = Maps.newHashMapWithExpectedSize((int)25);
        String referStrategy = mapEntity.getString("referstrategy");
        boolean isDefaultMap = mapEntity.getBoolean("isdefaultmap");
        boolean isDefaultMapLock = mapEntity.getBoolean("isdefaultmaplock");
        Long gridTemplateId = HRDyObjectPropUtil.getId((DynamicObject)mapEntity.getDynamicObject("gridtemplate"));
        boolean isGridTemplateLock = mapEntity.getBoolean("isgridtemplatelock");
        Long xAxisDimId = HRDyObjectPropUtil.getId((DynamicObject)mapEntity.getDynamicObject("xaxisdim"));
        boolean isXAxisDimLock = mapEntity.getBoolean("isxaxisdimlock");
        Long yAxisDimId = HRDyObjectPropUtil.getId((DynamicObject)mapEntity.getDynamicObject("yaxisdim"));
        boolean isYAxisDimLock = mapEntity.getBoolean("isyaxisdimlock");
        DynamicObjectCollection perCardDims = mapEntity.getDynamicObjectCollection("percarddim");
        String[] perCardDimIdArray = (String[])perCardDims.stream().map(dim -> String.valueOf(dim.getLong("fbasedataid_id"))).toArray(String[]::new);
        boolean isPerCardDimLock = mapEntity.getBoolean("ispercarddimlock");
        String mapConfigInfo = mapEntity.getString("talentmapconfig_tag");
        Date gridTplSelectTime = mapEntity.getDate("gridtplselecttime");
        mapInfoParams.put("referstrategy", referStrategy);
        mapInfoParams.put("isdefaultmap", isDefaultMap);
        mapInfoParams.put("isdefaultmaplock", isDefaultMapLock);
        mapInfoParams.put("gridtemplate", String.valueOf(gridTemplateId));
        mapInfoParams.put("isgridtemplatelock", isGridTemplateLock);
        mapInfoParams.put("xaxisdim", String.valueOf(xAxisDimId));
        mapInfoParams.put("isxaxisdimlock", isXAxisDimLock);
        mapInfoParams.put("yaxisdim", String.valueOf(yAxisDimId));
        mapInfoParams.put("isyaxisdimlock", isYAxisDimLock);
        mapInfoParams.put("percarddim", SerializationUtils.toJsonString((Object)perCardDimIdArray));
        mapInfoParams.put("ispercarddimlock", isPerCardDimLock);
        mapInfoParams.put("talentmapconfig_tag", mapConfigInfo);
        mapInfoParams.put("gridtplselecttime", String.valueOf(gridTplSelectTime));
        int billStatusValue = this.getBillStatusValue();
        mapInfoParams.put("billStatusValue", String.valueOf(billStatusValue));
        boolean isCanUpdateGridTpl = this.checkIsCanUpdateGridTpl(gridTemplateId, gridTplSelectTime);
        mapInfoParams.put("isupdatetpl", isCanUpdateGridTpl);
        mapInfoParams.put("dimEntityName", "dimesionentry");
        mapInfoParams.put("dimFieldName", "reviewdimension");
        mapInfoParams.put("dimStatusName", "selectstatus");
        mapInfoParams.put("pageSource", this.getTalentMapSourceType());
        mapInfoParams.put("islockdefaultmap", this.isLockDefaultMap());
        return mapInfoParams;
    }

    public String getTalentMapSourceType() {
        return "";
    }

    private boolean isLockDefaultMap() {
        boolean isLockDefaultMap;
        int defaultTalentMapRow = this.getDefaultTalentMapRow();
        String referStrategy = (String)this.getModel().getValue("referstrategy", defaultTalentMapRow);
        if (HRStringUtils.equals((String)referStrategy, (String)TalentMapStrategyEnum.ADJUST_UNLOCK.getNumber()) && (isLockDefaultMap = ((Boolean)this.getModel().getValue("isdefaultmaplock", defaultTalentMapRow)).booleanValue())) {
            return true;
        }
        return HRStringUtils.equals((String)referStrategy, (String)TalentMapStrategyEnum.UN_ADJUST.getNumber());
    }

    private boolean checkIsCanUpdateGridTpl(Long gridTemplateId, Date gridTplSelectDate) {
        if (gridTemplateId == null || gridTemplateId == 0L || gridTplSelectDate == null) {
            return false;
        }
        String gridTplUpdateDateMapStr = this.getPageCache().get(CACHE_KEY_GRID_TPL_UPDATE_TIME_MAP);
        Map gridTplUpdateDateMap = HRStringUtils.isNotEmpty((String)gridTplUpdateDateMapStr) ? (Map)SerializationUtils.fromJsonString((String)gridTplUpdateDateMapStr, Map.class) : Maps.newHashMapWithExpectedSize((int)10);
        Date gridUpdateTime = null;
        String gridTemplateStr = String.valueOf(gridTemplateId);
        if (gridTplUpdateDateMap.containsKey(gridTemplateStr)) {
            String gridUpdateTimeStr = (String)gridTplUpdateDateMap.get(String.valueOf(gridTemplateId));
            try {
                gridUpdateTime = HRDateTimeUtils.parseDate((String)gridUpdateTimeStr);
            }
            catch (ParseException e) {
                LOG.error("ReviewActivityTplMapConfigEdit.checkIsCanUpdateGridTpl: the String value of {} parse to Date error!", (Object)gridUpdateTimeStr, (Object)e);
            }
        }
        if (gridUpdateTime == null) {
            gridUpdateTime = this.gridTemplateQueryService.getUpdateTime(gridTemplateId);
            gridTplUpdateDateMap.put(gridTemplateStr, gridUpdateTime.toString());
            this.getPageCache().put(CACHE_KEY_GRID_TPL_UPDATE_TIME_MAP, SerializationUtils.toJsonString(gridTplUpdateDateMap));
        }
        return HRDateTimeUtils.dayAfter(gridUpdateTime, (Date)gridTplSelectDate);
    }

    public int getDefaultTalentMapRow() {
        DynamicObjectCollection mapEntryEntity = this.getModel().getEntryEntity("talentmapentry");
        for (int i = 0; i < mapEntryEntity.size(); ++i) {
            DynamicObject mapEntity = (DynamicObject)mapEntryEntity.get(i);
            boolean isDefaultMap = mapEntity.getBoolean("isdefaultmap");
            if (!isDefaultMap) continue;
            return i;
        }
        if (mapEntryEntity.size() > 0) {
            this.getModel().setValue("isdefaultmap", (Object)true, 0);
            return 0;
        }
        return -1;
    }

    public void setInitTalentMapDataChange() {
        DynamicObjectCollection mapEntryEntity = this.getModel().getEntryEntity("talentmapentry");
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (status.equals((Object)OperationStatus.ADDNEW) && mapEntryEntity.size() == 1) {
            int defaultTalentMapRow = this.getDefaultTalentMapRow();
            if (defaultTalentMapRow == -1) {
                return;
            }
            this.getModel().setValue("isdefaultmap", (Object)false, defaultTalentMapRow);
            this.getModel().setValue("isdefaultmap", (Object)true, defaultTalentMapRow);
        }
    }

    public void beforeSaveAndSubmit() {
        int defaultTalentMapRow = this.getDefaultTalentMapRow();
        if (defaultTalentMapRow != -1 && defaultTalentMapRow != 0) {
            int[] topRows = new int[]{defaultTalentMapRow};
            this.getModel().setEntryRowTop("talentmapentry", topRows);
        }
        this.resetTalentMapTabNumber();
    }

    private void loadTalentMapData(int row) {
        if (row == -1) {
            return;
        }
        String mapTabPageId = this.getPageCache().get(CACHE_KEY_MAP_TAB_PAGEID);
        DynamicObjectCollection mapEntryEntity = this.getModel().getEntryEntity("talentmapentry");
        if (row >= mapEntryEntity.size()) {
            return;
        }
        DynamicObject mapEntity = (DynamicObject)mapEntryEntity.get(row);
        Map<String, Object> mapPageCustomParams = this.getMapPageCustomParams(mapEntity);
        if (HRStringUtils.isNotEmpty((String)mapTabPageId)) {
            IFormView mapPageView = this.getView().getView(mapTabPageId);
            mapPageView.getFormShowParameter().getCustomParams().putAll(mapPageCustomParams);
            mapPageView.cacheFormShowParameter();
            boolean dataLoaded = mapPageView.getModel().isDataLoaded();
            if (!dataLoaded) {
                return;
            }
            mapPageView.updateView();
            this.getView().sendFormAction(mapPageView);
        } else {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.getOpenStyle().setShowType(ShowType.InContainer);
            showParameter.getOpenStyle().setTargetKey(FLEX_TALENT_MAP);
            showParameter.setFormId("oatr_reviewtalentmap");
            String pageId = showParameter.getPageId();
            this.getPageCache().put(CACHE_KEY_MAP_TAB_PAGEID, pageId);
            showParameter.setCustomParams(mapPageCustomParams);
            showParameter.setStatus(this.getView().getFormShowParameter().getStatus());
            this.getView().showForm(showParameter);
        }
    }

    public void selectTalentMapTab(int selectedRow) {
        if (selectedRow == -1 && (selectedRow = this.getDefaultTalentMapRow()) == -1) {
            return;
        }
        this.setSelectTabValue(selectedRow);
        this.loadTalentMapData(selectedRow);
        this.recordCurrentShowMapRow(selectedRow);
        this.recordCurrentClickRow(selectedRow);
    }

    private void setSelectTabValue(int currentRow) {
        int talentMapEntryCount = this.getModel().getEntryRowCount("talentmapentry");
        for (int i = 0; i < talentMapEntryCount; ++i) {
            String isSelect = (String)this.getModel().getValue("isselect", i);
            if (i == currentRow) {
                if (HRStringUtils.equals((String)isSelect, (String)"1")) continue;
                this.getModel().setValue("isselect", (Object)"1", currentRow);
                continue;
            }
            if (HRStringUtils.equals((String)isSelect, (String)"0")) continue;
            this.getModel().setValue("isselect", (Object)"0", i);
        }
    }

    public void recordCurrentShowMapRow(int currentRow) {
        this.getPageCache().put(CACHE_KEY_CURRENT_SHOW_MAP_ROW, String.valueOf(currentRow));
    }

    private int getCurrentShowMapRow() {
        String currentSelectRow = this.getPageCache().get(CACHE_KEY_CURRENT_SHOW_MAP_ROW);
        if (HRStringUtils.isEmpty((String)currentSelectRow)) {
            return -1;
        }
        return Integer.parseInt(currentSelectRow);
    }

    public void recordCurrentClickRow(int clickRow) {
        this.getPageCache().put(CACHE_KEY_CLICK_CURRENT_ROW, String.valueOf(clickRow));
    }

    public int getCurrentClickRow() {
        String currentClickRow = this.getPageCache().get(CACHE_KEY_CLICK_CURRENT_ROW);
        if (HRStringUtils.isEmpty((String)currentClickRow)) {
            return -1;
        }
        return Integer.parseInt(currentClickRow);
    }

    public void beforeClosed(BeforeClosedEvent evt) {
        super.beforeClosed(evt);
        FormCommonService commonService = (FormCommonService)kd.tdc.tdcs.bussiness.ServiceFactory.getService(FormCommonService.class);
        commonService.setPropertyNotDataChanged(this.getModel(), new String[]{"talentmapentry"});
    }

    private int getBillStatusValue() {
        BaseShowParameter formShowParameter = (BaseShowParameter)this.getView().getFormShowParameter();
        return formShowParameter.getBillStatus().getValue();
    }
}

