/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.formplugin.web.activity.detail;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Consumer;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.container.TabPage;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.list.IListView;
import kd.bos.list.ITreeListView;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tdc.oatr.bussiness.ServiceFactory;
import kd.tdc.oatr.bussiness.application.ReviewToolApplicationService;
import kd.tdc.oatr.bussiness.domain.reviewgroup.ReviewGroupService;
import kd.tdc.oatr.bussiness.domain.reviewobjct.ReviewObjectService;
import kd.tdc.oatr.bussiness.queryservice.ReviewActivityQueryService;
import kd.tdc.oatr.bussiness.queryservice.ReviewToolQueryService;
import kd.tdc.oatr.common.constants.enums.ManagerItemEnum;
import kd.tdc.oatr.common.utils.PropUtils;
import kd.tdc.oatr.formplugin.web.common.ManagerItemUtil;
import kd.tdc.oatr.formplugin.web.common.ReviewActivityTreeUtil;
import kd.tdc.oatr.formplugin.web.common.ReviewToolMutexHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.tuple.Pair;

public interface ReviewActivityDetailCommon {
    public static final Map<String, String> ENTRY_TAB_MAP = ImmutableMap.of((Object)"entryentity_inner", (Object)"innertooltab", (Object)"entryentity_outer", (Object)"outertooltab");
    public static final ReviewToolQueryService reviewToolQueryService = (ReviewToolQueryService)ServiceFactory.getService(ReviewToolQueryService.class);
    public static final ReviewToolApplicationService reviewToolApplicationService = (ReviewToolApplicationService)ServiceFactory.getService(ReviewToolApplicationService.class);

    default public Object getActivityId(IFormView formView) {
        Object activityIdNoCheck = this.getActivityIdNoCheck(formView);
        if (activityIdNoCheck == null) {
            return 0L;
        }
        return activityIdNoCheck;
    }

    default public Object getActivityId(FormShowParameter showParameter) {
        Object activityIdNoCheck = this.getActivityIdNoCheck(showParameter);
        if (activityIdNoCheck == null) {
            return 0L;
        }
        return activityIdNoCheck;
    }

    default public Long getActivityLongId(IFormView formView) {
        Object activityId = this.getActivityId(formView);
        if (activityId != null) {
            String idStr = String.valueOf(activityId);
            return Long.parseLong(idStr);
        }
        return 0L;
    }

    default public boolean isCollaborate(IFormView formView) {
        String isCollaborate = (String)formView.getFormShowParameter().getCustomParam("collaboration_flag");
        return "1".equals(isCollaborate);
    }

    default public void collaborateGroupFilter(IFormView view, List<QFilter> qFilters) {
        if (this.isCollaborate(view)) {
            long currUserId = RequestContext.get().getCurrUserId();
            QFilter userQFilter = new QFilter("entryentity.collaborator", "=", (Object)currUserId);
            QFilter statusQFilter = new QFilter("entryentity.colstatus", "=", (Object)"1");
            qFilters.add(userQFilter);
            qFilters.add(statusQFilter);
        }
    }

    default public Object getActivityIdNoCheck(IFormView formView) {
        FormShowParameter showParameter = formView.getFormShowParameter();
        return this.getActivityIdNoCheck(showParameter);
    }

    default public Object getActivityIdNoCheck(FormShowParameter showParameter) {
        return showParameter.getCustomParam("activityId");
    }

    default public boolean checkPermByManagerItem(IFormView formView) {
        return this.checkPermByManagerItem(formView, null);
    }

    default public boolean checkPermByManagerItem(IFormView formView, Consumer<Boolean> fun) {
        if (!ManagerItemUtil.isCollaboratorPage(formView)) {
            return true;
        }
        return ManagerItemUtil.checkPermByManagerItem(ManagerItemEnum.COLLABORATOR_TOOL, this.getActivityId(formView), fun);
    }

    default public boolean checkActivity(IFormView formView) {
        return this.checkActivity(formView, null);
    }

    default public boolean checkActivity(IFormView formView, Consumer<Boolean> function) {
        ReviewActivityQueryService service = (ReviewActivityQueryService)ServiceFactory.getService(ReviewActivityQueryService.class);
        boolean flag = service.getReviewActivityEnd(this.getActivityId(formView));
        if (flag && Objects.nonNull(function)) {
            function.accept((Object)Boolean.TRUE);
        }
        return flag;
    }

    default public boolean checkActivityStatus(Object activityId, Runnable run) {
        ReviewActivityQueryService service = (ReviewActivityQueryService)ServiceFactory.getService(ReviewActivityQueryService.class);
        boolean activityEnd = service.getReviewActivityEnd(activityId);
        if (activityEnd && Objects.nonNull(run)) {
            run.run();
        }
        return activityEnd;
    }

    default public boolean checkData(IFormView formView) {
        boolean flag = this.checkActivity(formView);
        if (flag) {
            return false;
        }
        return this.checkPermByManagerItem(formView);
    }

    default public boolean checkData(IFormView formView, Consumer<Boolean> function) {
        boolean flag = this.checkActivity(formView, function);
        if (flag) {
            return false;
        }
        return this.checkPermByManagerItem(formView, function);
    }

    default public boolean checkPermConfirm(IFormView formView, BiConsumer<String, String> consumer) {
        boolean checkPermByManagerItem = this.checkPermByManagerItem(formView);
        if (!checkPermByManagerItem) {
            consumer.accept("failManagerItem", ResManager.loadKDString((String)"\u4f60\u7684\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u5237\u65b0\u6216\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"ReviewActivityDetailCommon_0", (String)"tdc-oatr-formplugin", (Object[])new Object[0]));
        }
        return checkPermByManagerItem;
    }

    default public void setOptionParam(IFormView formView, OperateOption option) {
        FormShowParameter formShowParameter = formView.getFormShowParameter();
        Long activityId = this.getActivityLongId(formView);
        option.setVariableValue("reviewactivity", String.valueOf(activityId));
        option.setVariableValue("collaboration_flag", (String)formShowParameter.getCustomParam("collaboration_flag"));
        List groupIdList = (List)formShowParameter.getCustomParam("groupId");
        if (CollectionUtils.isNotEmpty((Collection)groupIdList)) {
            Long groupId = (Long)groupIdList.get(0);
            option.setVariableValue("reviewgroup", String.valueOf(groupId));
        }
    }

    default public void refreshTreeView(IFormView formView) {
        ITreeListView treeListView = ((IListView)formView).getTreeListView();
        if (treeListView == null) {
            return;
        }
        treeListView.refreshTreeView();
    }

    default public List<Long> getGroupIdList(String curNodeId, Long activityId, String collaborate) {
        List<Object> groupIdList = Lists.newArrayListWithCapacity((int)0);
        if (HRStringUtils.equals((String)curNodeId, (String)"alreadyjoin")) {
            boolean isCollaborator = "1".equals(collaborate);
            DynamicObject[] groupInfos = ReviewActivityTreeUtil.getGroupInfo(activityId, RequestContext.get().getCurrUserId(), isCollaborator);
            if (groupInfos != null && groupInfos.length != 0) {
                groupIdList = Arrays.stream(groupInfos).map(dy -> dy.getLong("id")).collect(Collectors.toList());
            }
        } else if (!HRStringUtils.equals((String)String.valueOf(curNodeId), (String)"notjoin")) {
            DynamicObject groupInfo = ReviewActivityTreeUtil.getGroupInfo(String.valueOf(curNodeId), activityId);
            if (Objects.isNull(groupInfo)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u76d8\u70b9\u7ec4\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"ReviewObjectNavigationPlugin_2", (String)"tdc-oatr-formplugin", (Object[])new Object[0]));
            }
            groupIdList.add(groupInfo.getLong("id"));
        }
        return groupIdList;
    }

    default public void rebuildNavigation(IFormView formView) {
        IFormView parentView = formView.getParentView();
        if (parentView == null) {
            return;
        }
        parentView.invokeOperation("rebuildnavigation");
        formView.sendFormAction(formView.getParentView());
    }

    default public boolean checkAllDataDelete(IFormView view, BeforeDoOperationEventArgs args, ListSelectedRowCollection selectedRows) {
        if (CollectionUtils.isEmpty((Collection)selectedRows)) {
            return true;
        }
        List reviewObjIds = selectedRows.stream().map(obj -> (Long)obj.getPrimaryKeyValue()).collect(Collectors.toList());
        Map reviewObjExistMap = ((ReviewObjectService)ServiceFactory.getService(ReviewObjectService.class)).listReviewObjectIsDelete(reviewObjIds);
        if (MapUtils.isEmpty((Map)reviewObjExistMap)) {
            this.showTip(view, args);
            return true;
        }
        boolean allDataDelete = reviewObjExistMap.values().stream().allMatch(obj -> obj);
        if (allDataDelete) {
            this.showTip(view, args);
            return true;
        }
        return false;
    }

    default public boolean checkPhysicalDataDelete(IFormView view, BeforeDoOperationEventArgs args, ListSelectedRowCollection selectedRows) {
        if (CollectionUtils.isEmpty((Collection)selectedRows)) {
            return true;
        }
        List reviewObjIds = selectedRows.stream().map(obj -> (Long)obj.getPrimaryKeyValue()).collect(Collectors.toList());
        Map reviewObjExistMap = ((ReviewObjectService)ServiceFactory.getService(ReviewObjectService.class)).listReviewObjectIsDelete(reviewObjIds);
        if (MapUtils.isEmpty((Map)reviewObjExistMap)) {
            this.showTip(view, args);
            return true;
        }
        return false;
    }

    default public void showTip(IFormView view, BeforeDoOperationEventArgs args) {
        view.showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"ReviewGroupToolPlugin_3", (String)"tdc-oatr-formplugin", (Object[])new Object[0]));
        args.setCancel(true);
    }

    default public List<Long> collaborateGroupIdList(IFormView formView) {
        if (!ManagerItemUtil.isCollaboratorPage(formView)) {
            return Collections.emptyList();
        }
        Object activityId = this.getActivityId(formView);
        return ManagerItemUtil.getCollaborateGroup(activityId);
    }

    default public boolean reviewObjListOpCheckCollaboratorPerm(IFormView view, String itemKey) {
        String collaborationFlag = (String)view.getFormShowParameter().getCustomParam("collaboration_flag");
        ArrayList opItems = Lists.newArrayList((Object[])new String[]{"tblclose", "close"});
        if (HRStringUtils.equals((String)"1", (String)collaborationFlag) && !opItems.contains(itemKey)) {
            Long activityId = this.getActivityLongId(view);
            long currUserId = RequestContext.get().getCurrUserId();
            QFilter userQFilter = new QFilter("entryentity.collaborator", "=", (Object)currUserId);
            QFilter statusQFilter = new QFilter("entryentity.colstatus", "=", (Object)"1");
            QFilter activityQF = new QFilter("reviewactivity.id", "=", (Object)activityId);
            boolean exists = ((ReviewGroupService)ServiceFactory.getService(ReviewGroupService.class)).isExists(new QFilter[]{userQFilter, statusQFilter, activityQF});
            if (!exists) {
                view.showConfirm(ResManager.loadKDString((String)"\u4f60\u7684\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u5237\u65b0\u6216\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"ReviewActivityColList_0", (String)"tdc-oatr-formplugin", (Object[])new Object[0]), MessageBoxOptions.None);
                return false;
            }
        }
        return true;
    }

    default public void updateToolTabName(IFormView view, String entryKey) {
        String tabKey = ENTRY_TAB_MAP.get(entryKey);
        int size = view.getModel().getEntryRowCount(entryKey);
        String tabName = "";
        if (size == 0) {
            if (HRStringUtils.equals((String)tabKey, (String)"innertooltab")) {
                tabName = ResManager.loadKDString((String)"\u7cfb\u7edf\u5185\u90e8", (String)"ReviewActivityTplToolPlugin_2", (String)"tdc-oatr-formplugin", (Object[])new Object[0]);
            }
            if (HRStringUtils.equals((String)tabKey, (String)"outertooltab")) {
                tabName = ResManager.loadKDString((String)"\u7cfb\u7edf\u5916\u90e8", (String)"ReviewActivityTplToolPlugin_3", (String)"tdc-oatr-formplugin", (Object[])new Object[0]);
            }
        } else {
            if (HRStringUtils.equals((String)tabKey, (String)"innertooltab")) {
                tabName = ResManager.loadKDString((String)"\u7cfb\u7edf\u5185\u90e8(%s)", (String)"ReviewActivityTplToolPlugin_0", (String)"tdc-oatr-formplugin", (Object[])new Object[0]);
            }
            if (HRStringUtils.equals((String)tabKey, (String)"outertooltab")) {
                tabName = ResManager.loadKDString((String)"\u7cfb\u7edf\u5916\u90e8(%s)", (String)"ReviewActivityTplToolPlugin_1", (String)"tdc-oatr-formplugin", (Object[])new Object[0]);
            }
        }
        TabPage curTab = (TabPage)view.getControl(tabKey);
        curTab.setText(new LocaleString(String.format(tabName, size)));
    }

    default public void showReviewTool(IFormView view) {
        BillShowParameter showParameter = new BillShowParameter();
        DynamicObject dataEntity = view.getModel().getDataEntity();
        Object activityId = dataEntity.getPkValue();
        Long activityTplId = dataEntity.getLong("activitytemplate.id");
        Long reviewToolId = reviewToolQueryService.queryReviewToolId(((Long)activityId).longValue());
        if (Objects.isNull(reviewToolId)) {
            showParameter.setStatus(OperationStatus.ADDNEW);
        } else {
            showParameter.setPkId((Object)reviewToolId);
            boolean checkFlag = this.checkData(view);
            if (!checkFlag) {
                showParameter.setStatus(OperationStatus.VIEW);
            }
            if (!this.checkMutex(reviewToolId)) {
                showParameter.setStatus(OperationStatus.VIEW);
            }
            if (view.getFormShowParameter().getStatus().equals((Object)OperationStatus.VIEW)) {
                showParameter.setStatus(OperationStatus.VIEW);
            }
        }
        showParameter.setFormId("oatr_reviewtool");
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey("pdgzpz_flex");
        showParameter.setSendToClient(false);
        showParameter.setCustomParam("activityId", activityId);
        showParameter.setCustomParam("activityTplId", (Object)activityTplId);
        showParameter.setCustomParam("collaboration_flag", view.getFormShowParameter().getCustomParam("collaboration_flag"));
        view.showForm((FormShowParameter)showParameter);
        view.getPageCache().put("reviewToolPageId", showParameter.getPageId());
    }

    default public boolean checkMutex(long toolId) {
        DynamicObject[] dynamicObjects = ReviewToolMutexHelper.checkHasMutex("oatr_reviewtool", Collections.singletonList(toolId), "modify");
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return true;
        }
        DynamicObject userDO = dynamicObjects[0].getDynamicObject("user");
        return RequestContext.get().getCurrUserId() == userDO.getLong("id");
    }

    default public Pair<Boolean, String> haveModifyMutex(Object pkValue) {
        DynamicObject[] dynamicObjects = ReviewToolMutexHelper.checkHasMutex("oatr_reviewgroup", Collections.singletonList(pkValue), "modify");
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return Pair.of((Object)Boolean.FALSE, null);
        }
        DynamicObject dynamicObject = dynamicObjects[0];
        String userName = dynamicObject.getString(PropUtils.getNameDot((String)"user"));
        return Pair.of((Object)Boolean.TRUE, (Object)String.format(ResManager.loadKDString((String)"%s \u6b63\u5728PC\u7aef\u7f16\u8f91\u8be5\u8bb0\u5f55\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458", (String)"ReviewToolPlugin_10", (String)"tdc-oatr-formplugin", (Object[])new Object[0]), userName));
    }
}

