/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.formplugin.web.activity.detail;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRDyObjectPropUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.tdc.oatr.bussiness.ServiceFactory;
import kd.tdc.oatr.bussiness.application.ReviewActivityApplicationService;
import kd.tdc.oatr.bussiness.domain.collaborator.ReviewToolService;
import kd.tdc.oatr.bussiness.queryservice.ReviewToolSchemeQueryService;
import kd.tdc.oatr.common.constants.activity.detail.ReviewToolConstants;
import kd.tdc.oatr.common.utils.PropUtils;
import kd.tdc.oatr.common.utils.ReviewPermUtils;
import kd.tdc.oatr.formplugin.web.activity.ReviewEntryGridCommon;
import kd.tdc.oatr.formplugin.web.activity.detail.ReviewActivityDetailCommon;
import kd.tdc.oatr.formplugin.web.common.ReviewToolMutexHelper;

public class ReviewToolPlugin
extends HRCoreBaseBillEdit
implements ReviewActivityDetailCommon,
ReviewEntryGridCommon,
ReviewToolConstants,
HyperLinkClickListener,
BeforeF7SelectListener {
    private static final Log LOG = LogFactory.getLog(ReviewToolPlugin.class);
    private final ReviewToolSchemeQueryService toolSchemeQueryService = (ReviewToolSchemeQueryService)ServiceFactory.getService(ReviewToolSchemeQueryService.class);
    private static final String KEY_ACTION_QUESTIONNAIRE = "close_questionnaire";
    private static final String KEY_ACTION_OUTER_TOOL = "close_outertool";
    private static final String KEY_ACTION_SHOW_OUT_TOOL = "close_showOutTool";
    protected final Map<String, Consumer<ClosedCallBackEvent>> CLOSE_CALL_FUN = Maps.newHashMapWithExpectedSize((int)4);
    protected final Map<String, Consumer<AfterDoOperationEventArgs>> AFTER_DO_FUN = Maps.newHashMapWithExpectedSize((int)8);
    protected final Map<String, Consumer<HyperLinkClickEvent>> HYPER_LINK_CLICK_FUN = Maps.newHashMapWithExpectedSize((int)4);
    private final ReviewToolService reviewToolService;
    private final ReviewActivityApplicationService reviewActivityService;

    public ReviewToolPlugin() {
        this.CLOSE_CALL_FUN.put(KEY_ACTION_QUESTIONNAIRE, this.closeCallQuestionnaireConsumer());
        this.CLOSE_CALL_FUN.put(KEY_ACTION_OUTER_TOOL, this.closeCallAddOuterTool());
        this.CLOSE_CALL_FUN.put(KEY_ACTION_SHOW_OUT_TOOL, this.closeCallShowOutTool());
        this.AFTER_DO_FUN.put("add", this.innerAddConsumer());
        this.AFTER_DO_FUN.put("deleteentry", this.innerDeleteConsumer());
        this.AFTER_DO_FUN.put("preview", this.innerPreviewConsumer());
        this.AFTER_DO_FUN.put("outer_add", this.outerAddConsumer());
        this.AFTER_DO_FUN.put("outer_deleteentry", this.outerDeleteConsumer());
        this.HYPER_LINK_CLICK_FUN.put("evaluationitem_num", this.hyperClickEvaluationItemConsumer());
        this.HYPER_LINK_CLICK_FUN.put("outer_name", this.hyperClickOuterToolConsumer());
        this.reviewToolService = (ReviewToolService)ServiceFactory.getService(ReviewToolService.class);
        this.reviewActivityService = (ReviewActivityApplicationService)ServiceFactory.getService(ReviewActivityApplicationService.class);
    }

    private Consumer<HyperLinkClickEvent> hyperClickEvaluationItemConsumer() {
        return hyperLinkClickEvent -> {
            this.checkToolViewPerm();
            if (!this.checkPermConfirm(this.getView(), this.showConfirmConsumer())) {
                return;
            }
            int rowIndex = hyperLinkClickEvent.getRowIndex();
            EntryGrid entryGrid = this.getEntryGrid("entryentity_outer");
            DynamicObject rowData = entryGrid.getEntryData().getDataEntitys()[rowIndex];
            int num = rowData.getInt("evaluationitem_num");
            if (num != 0) {
                Object[] idArr = this.getCurrRowMultiBaseData(this.getView(), "entryentity_outer", "evaluationitem", rowIndex);
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("oatr_outtoolrelevaluation");
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.setShowTitle(true);
                String toolName = rowData.getString(PropUtils.getNameDot((String)"outer_tool"));
                String caption = new StringJoiner("_").add(toolName).add(ResManager.loadKDString((String)"\u8bc4\u4f30\u9879", (String)"ReviewToolPlugin_0", (String)"tdc-oatr-formplugin", (Object[])new Object[0])).toString();
                showParameter.setCaption(caption);
                showParameter.setCustomParam("id", (Object)SerializationUtils.toJsonString(Arrays.asList(idArr)));
                this.getView().showForm(showParameter);
            }
        };
    }

    private Consumer<HyperLinkClickEvent> hyperClickOuterToolConsumer() {
        return hyperLinkClickEvent -> {
            this.checkToolViewPerm();
            if (!this.checkPermConfirm(this.getView(), this.showConfirmConsumer())) {
                return;
            }
            BaseShowParameter showParameter = new BaseShowParameter();
            showParameter.setFormId("oatr_reviewtoolscheme");
            DynamicObject rowData = this.getRowData(this.getView(), "entryentity_outer", hyperLinkClickEvent.getRowIndex());
            showParameter.setPkId((Object)rowData.getLong(PropUtils.getIdDot((String)"outer_tool")));
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setStatus(OperationStatus.VIEW);
            showParameter.setBillStatus(BillOperationStatus.VIEW);
            showParameter.setCustomParam("isOnlyView", (Object)"1");
            this.getView().showForm((FormShowParameter)showParameter);
        };
    }

    private void checkToolViewPerm() {
        boolean hasPerm = ReviewPermUtils.getInstance().hasPerm("oatr_reviewtool", "47150e89000000ac");
        if (!hasPerm) {
            throw new KDBizException(ReviewPermUtils.getInstance().getNoPermTip(ResManager.loadKDString((String)"\u76d8\u70b9\u5de5\u5177", (String)"ReviewOutToolPlugin_2", (String)"tdc-oatr-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u67e5\u8be2", (String)"ReviewOutToolPlugin_3", (String)"tdc-oatr-formplugin", (Object[])new Object[0])));
        }
    }

    private Consumer<AfterDoOperationEventArgs> innerDeleteConsumer() {
        return afterDoOperationEventArgs -> this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"ReviewToolPlugin_4", (String)"tdc-oatr-formplugin", (Object[])new Object[0]));
    }

    private Consumer<AfterDoOperationEventArgs> outerDeleteConsumer() {
        return afterDoOperationEventArgs -> this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"ReviewToolPlugin_4", (String)"tdc-oatr-formplugin", (Object[])new Object[0]));
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.getEntryGrid("entryentity_outer").addHyperClickListener((HyperLinkClickListener)this);
        this.getEntryGrid("entryentity_inner").addHyperClickListener((HyperLinkClickListener)this);
        BasedataEdit schemeEdit = (BasedataEdit)this.getControl("selecttoolscheme");
        schemeEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    private EntryGrid getEntryGrid(String entryKey) {
        return (EntryGrid)this.getControl(entryKey);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        int length;
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        if (HRStringUtils.equals((String)operate.getOperateKey(), (String)"deleteentry")) {
            this.checkMutex();
            if (!this.checkPermConfirm(this.getView(), this.showConfirmConsumer())) {
                args.setCancel(true);
                return;
            }
            length = this.getSelectRows(this.getView(), "entryentity_inner").length;
            if (length > 1) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e00\u6b21\u53ea\u80fd\u64cd\u4f5c\u4e00\u6761\u6570\u636e\u3002", (String)"ReviewEntryGridCommon_0", (String)"tdc-oatr-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            this.checkQuestionRef();
        }
        if (HRStringUtils.equals((String)operate.getOperateKey(), (String)"outer_deleteentry")) {
            this.checkMutex();
            if (this.checkSelectAndGet(this.getView(), "entryentity_outer").length == 0) {
                args.setCancel(true);
                return;
            }
            if (!this.checkPermConfirm(this.getView(), this.showConfirmConsumer())) {
                args.setCancel(true);
                return;
            }
            length = this.getSelectRows(this.getView(), "entryentity_outer").length;
            if (length > 1) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e00\u6b21\u53ea\u80fd\u64cd\u4f5c\u4e00\u6761\u6570\u636e\u3002", (String)"ReviewEntryGridCommon_0", (String)"tdc-oatr-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject[] selectRowDO = this.getSelectRowDO(this.getView(), "entryentity_outer");
            DynamicObject dynamicObject = selectRowDO[0];
            long outToolId = dynamicObject.getLong(PropUtils.getIdDot((String)"outer_tool"));
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("oatr_reviewobject");
            DynamicObject[] reviewObjDOArr = serviceHelper.query("entryentity_eval,evaltool", new QFilter("reviewactivity", "=", this.getActivityId(this.getView())).toArray());
            boolean isRef = Arrays.stream(reviewObjDOArr).map(reviewObjDO -> reviewObjDO.getDynamicObjectCollection("entryentity_eval")).flatMap(Collection::stream).anyMatch(evalEntryRow -> evalEntryRow.getLong(PropUtils.getIdDot((String)"evaltool")) == outToolId);
            if (isRef) {
                String deleteOutToolConfirm = this.getPageCache().get("deleteOutToolConfirm");
                if (!Objects.equals(deleteOutToolConfirm, "1")) {
                    args.setCancel(true);
                    this.getPageCache().put("deleteOutToolConfirm", "1");
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u5c06\u4f1a\u6e05\u7a7a\u5bf9\u5e94\u8bc4\u4f30\u9879\u5df2\u6709\u6570\u636e\uff0c\u8be5\u64cd\u4f5c\u4e0d\u53ef\u64a4\u9500\uff0c\u786e\u5b9a\u8981\u7ee7\u7eed\u5417\uff1f", (String)"ReviewToolPlugin_17", (String)"tdc-oatr-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("deleteOutTool", (IFormPlugin)this));
                } else {
                    this.getModel().deleteEntryRow("entryentity_outer", this.getSelectRows(this.getView(), "entryentity_outer")[0]);
                }
            } else {
                this.getModel().deleteEntryRow("entryentity_outer", this.getSelectRows(this.getView(), "entryentity_outer")[0]);
            }
        }
    }

    private void checkQuestionRef() {
        HRBaseServiceHelper serviceHelper;
        DynamicObject[] selectRowDO = this.getSelectRowDO(this.getView(), "entryentity_inner");
        DynamicObject dynamicObject = selectRowDO[0];
        long outToolId = dynamicObject.getLong(PropUtils.getIdDot((String)"questionnaire"));
        boolean flag = false;
        if (outToolId == 1010L) {
            serviceHelper = new HRBaseServiceHelper("oatr_employeeeval");
            flag = serviceHelper.isExists(new QFilter("question", "=", (Object)outToolId).and(new QFilter("reviewactivity", "=", this.getActivityId(this.getView()))));
        }
        if (outToolId == 1020L) {
            serviceHelper = new HRBaseServiceHelper("oatr_superioreval");
            flag = serviceHelper.isExists(new QFilter("question", "=", (Object)outToolId).and(new QFilter("reviewactivity", "=", this.getActivityId(this.getView()))));
        }
        if (flag) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5de5\u5177\u5df2\u5b58\u5728\u95ee\u5377\u6570\u636e\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"", (String)"tdc-oatr-formplugin", (Object[])new Object[0]));
        }
    }

    private BiConsumer<String, String> showConfirmConsumer() {
        return (key, message) -> this.getView().showConfirm(message, MessageBoxOptions.OK, new ConfirmCallBackListener(key, (IFormPlugin)this));
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if (HRStringUtils.equals((String)messageBoxClosedEvent.getCallBackId(), (String)"deleteOutTool")) {
            if (result == MessageBoxResult.Yes) {
                this.getModel().deleteEntryRow("entryentity_outer", this.getSelectRows(this.getView(), "entryentity_outer")[0]);
            }
            this.getView().getPageCache().put("deleteOutToolConfirm", null);
        }
    }

    public void createNewData(BizDataEventArgs e) {
        super.createNewData(e);
        this.checkData(this.getView(), bool -> this.getView().setVisible(Boolean.FALSE, new String[]{"tabop_add", "tabop_delete", "tabop_group", "outer_add", "outer_delete", "outer_evaluationitem", "btn_outer_reviewgroup", "tabop_preview"}));
    }

    private Consumer<AfterDoOperationEventArgs> innerAddConsumer() {
        return afterDoOperationEventArgs -> {
            if (!this.checkPermConfirm(this.getView(), this.showConfirmConsumer())) {
                return;
            }
            ListShowParameter showListForm = ShowFormHelper.createShowListForm((String)"oatr_questionnaire", (boolean)true);
            CloseCallBack closeCallBack = new CloseCallBack(this.getPluginName(), KEY_ACTION_QUESTIONNAIRE);
            showListForm.setCloseCallBack(closeCallBack);
            DynamicObject[] dynamicObjects = this.getEntryRow(this.getView(), "entryentity_inner");
            showListForm.setSelectedRows(Arrays.stream(dynamicObjects).map(dynamicObject -> dynamicObject.getLong(PropUtils.getIdDot((String)"questionnaire"))).toArray());
            this.getView().showForm((FormShowParameter)showListForm);
        };
    }

    private Consumer<AfterDoOperationEventArgs> innerPreviewConsumer() {
        return afterDoOperationEventArgs -> {
            int[] selectRows = this.checkSelectSingleAndGet(this.getView(), "entryentity_inner");
            if (selectRows.length == 0) {
                return;
            }
            if (!this.checkPermConfirm(this.getView(), this.showConfirmConsumer())) {
                return;
            }
            DynamicObject[] dynamicObjects = this.getSelectRowDO(this.getView(), "entryentity_inner");
            DynamicObject rowData = dynamicObjects[0];
            long questionnaireId = rowData.getLong(PropUtils.getIdDot((String)"questionnaire"));
            String formId = "";
            if (questionnaireId == 1010L) {
                formId = "oatr_employeeeval_layout";
            }
            if (questionnaireId == 1020L) {
                formId = "oatr_superioreval_layout";
            }
            if (HRStringUtils.isEmpty((String)formId)) {
                return;
            }
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setFormId(formId);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)showParameter);
        };
    }

    private Consumer<AfterDoOperationEventArgs> outerAddConsumer() {
        return afterDoOperationEventArgs -> {
            if (!this.checkPermConfirm(this.getView(), this.showConfirmConsumer())) {
                return;
            }
            BasedataEdit schemeEdit = (BasedataEdit)this.getControl("selecttoolscheme");
            schemeEdit.setF7MultipleSelect(true);
            schemeEdit.click();
        };
    }

    private List<Long> getExistSchemeIds() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity_outer");
        if (HRCollUtil.isEmpty((Collection)entryEntity)) {
            return new ArrayList<Long>(0);
        }
        return entryEntity.stream().map(entity -> entity.getLong("outer_tool.id")).collect(Collectors.toList());
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.checkData(this.getView(), bool -> this.getView().setVisible(Boolean.FALSE, new String[]{"tabop_add", "tabop_delete", "tabop_group", "outer_add", "outer_delete", "outer_evaluationitem", "btn_outer_reviewgroup", "tabop_preview"}));
        this.setToolTypeForOldToolData();
    }

    public void beforeBindData(EventObject e) {
        DynamicObject createOrg;
        super.beforeBindData(e);
        Object activityId = this.getActivityId(this.getView());
        this.getModel().setValue("reviewactivity", activityId);
        IFormView parentView = this.getView().getParentView();
        if (parentView != null && parentView.getModel().getDataEntity().getDataEntityType().getProperties().containsKey((Object)"createorg") && (createOrg = (DynamicObject)parentView.getModel().getValue("createorg")) != null) {
            this.getModel().setValue("createorg", (Object)HRDyObjectPropUtil.getId((DynamicObject)createOrg));
        }
        this.setToolEntry();
    }

    private void setToolEntry() {
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return;
        }
        DynamicObject reviewActivity = parentView.getModel().getDataEntity();
        this.reviewActivityService.activityTemplateChangeRun(reviewActivity, this.getModel().getDataEntity(), (arg_0, arg_1) -> ((ReviewToolService)this.reviewToolService).initReviewTool(arg_0, arg_1), (arg_0, arg_1) -> ((ReviewToolService)this.reviewToolService).refreshReviewTool(arg_0, arg_1));
        this.getView().updateView("entryentity_inner");
        this.getView().updateView("entryentity_outer");
    }

    private void setToolTypeForOldToolData() {
        DynamicObjectCollection entryEntityOuter = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity_outer");
        for (DynamicObject entity : entryEntityOuter) {
            String toolType;
            DynamicObject outerTool = entity.getDynamicObject("outer_tool");
            if (HRObjectUtils.isEmpty((Object)outerTool) || !HRStringUtils.isEmpty((String)(toolType = outerTool.getString("tooltype")))) continue;
            entity.set("outer_tool.tooltype", (Object)"30");
        }
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        this.getView().setVisible(Boolean.valueOf(this.getModel().getDataEntity().getBoolean("isfromtpl")), new String[]{"lbl_toolsctlstg"});
        this.updateToolTabName(this.getView(), "entryentity_inner");
        this.updateToolTabName(this.getView(), "entryentity_outer");
        DynamicObject dataEntity = this.getModel().getDataEntity();
        boolean isFromTpl = dataEntity.getBoolean("isfromtpl");
        if (isFromTpl) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tabop_add", "tabop_delete", "outer_add", "outer_delete", "outer_evaluationitem"});
            DynamicObject[] innerRowDOArr = this.getEntryGrid("entryentity_inner").getEntryData().getDataEntitys();
            int row = 0;
            while (row < innerRowDOArr.length) {
                this.getEntryGrid("entryentity_inner").setRowLock(true, new int[]{row++});
            }
            row = 0;
            while (row < this.getEntryGrid("entryentity_outer").getEntryData().getDataEntitys().length) {
                this.getEntryGrid("entryentity_outer").setRowLock(true, new int[]{row++});
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (afterDoOperationEventArgs.getOperationResult() != null && !afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            return;
        }
        Consumer<AfterDoOperationEventArgs> consumer = this.AFTER_DO_FUN.get(operateKey);
        if (Objects.isNull(consumer)) {
            return;
        }
        if (!HRStringUtils.equals((String)operateKey, (String)"preview")) {
            this.checkMutex();
        }
        consumer.accept(afterDoOperationEventArgs);
    }

    public void beforeClosed(BeforeClosedEvent beforeClosedEvent) {
        super.beforeClosed(beforeClosedEvent);
        beforeClosedEvent.setCheckDataChange(true);
    }

    private Consumer<ClosedCallBackEvent> closeCallQuestionnaireConsumer() {
        return closedCallBackEvent -> {
            if (!this.checkPermConfirm(this.getView(), this.showConfirmConsumer())) {
                return;
            }
            ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            DynamicObject[] entryRows = this.getEntryRow(this.getView(), "entryentity_inner");
            List alreadySelectQuestionnaireIdList = Arrays.stream(entryRows).map(entryRow -> entryRow.get(PropUtils.getIdDot((String)"questionnaire"))).collect(Collectors.toList());
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            boolean isChanged = false;
            Date now = new Date();
            TableValueSetter tableValueSetter = new TableValueSetter(new String[0]);
            for (ListSelectedRow selectedRow : selectedRows) {
                if (alreadySelectQuestionnaireIdList.contains(selectedRow.getPrimaryKeyValue())) continue;
                tableValueSetter.addField("questionnaire", new Object[]{selectedRow.getPrimaryKeyValue()}).addField("innertoolselect", new Object[]{"1"}).addField("innertool_modifytime", new Object[]{now});
                isChanged = true;
            }
            if (tableValueSetter.getCount() > 0) {
                model.beginInit();
                model.batchCreateNewEntryRow("entryentity_inner", tableValueSetter);
                model.endInit();
            }
            List<Object> primaryKeyValues = Arrays.asList(selectedRows.getPrimaryKeyValues());
            for (int i = 0; i < entryRows.length; ++i) {
                if (primaryKeyValues.contains(entryRows[i].getLong(PropUtils.getIdDot((String)"questionnaire")))) continue;
                model.deleteEntryRow("entryentity_inner", i);
                isChanged = true;
            }
            this.getView().updateView("entryentity_inner");
            if (isChanged) {
                this.updateToolTabName(this.getView(), "entryentity_inner");
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6dfb\u52a0\u6210\u529f\u3002", (String)"ReviewToolPlugin_1", (String)"tdc-oatr-formplugin", (Object[])new Object[0]));
            }
        };
    }

    private void updateView(String keyEntryInner) {
        this.getView().updateView(keyEntryInner);
    }

    private Consumer<ClosedCallBackEvent> closeCallAddOuterTool() {
        return closedCallBackEvent -> {
            List evalutionIdList;
            Object returnData = closedCallBackEvent.getReturnData();
            if (returnData == null) {
                return;
            }
            ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)returnData;
            if (selectedRows.size() == 0) {
                return;
            }
            List returnSchemeIds = selectedRows.stream().map(selectedRow -> Long.valueOf(selectedRow.getPrimaryKeyValue().toString())).collect(Collectors.toList());
            DynamicObject[] entryRows = this.getEntryRow(this.getView(), "entryentity_outer");
            ArrayList<DynamicObject[]> alreadyExistsSchemeIds = new ArrayList<DynamicObject[]>(10);
            ArrayList<Integer> deleteRowIndex = new ArrayList<Integer>(10);
            for (int i = 0; i < entryRows.length; ++i) {
                DynamicObject entryRow = entryRows[i];
                DynamicObject[] schemeId = Long.valueOf(entryRow.getLong(PropUtils.getIdDot((String)"outer_tool")));
                if (returnSchemeIds.contains(schemeId)) {
                    alreadyExistsSchemeIds.add(schemeId);
                    continue;
                }
                deleteRowIndex.add(i);
            }
            returnSchemeIds.removeAll(alreadyExistsSchemeIds);
            DynamicObject[] reviewToolSchemes = this.toolSchemeQueryService.listReviewToolSchemes(returnSchemeIds);
            HashMap evaluationIdMap = new HashMap(reviewToolSchemes.length);
            for (DynamicObject reviewToolScheme : reviewToolSchemes) {
                long evaluationId;
                long schemeId = reviewToolScheme.getLong("id");
                evalutionIdList = (ArrayList<Long>)evaluationIdMap.get(schemeId);
                if (HRCollUtil.isEmpty((Collection)evalutionIdList)) {
                    evalutionIdList = new ArrayList<Long>(10);
                }
                if ((evaluationId = reviewToolScheme.getLong("entryentity.evaluationitem.id")) == 0L) continue;
                evalutionIdList.add(evaluationId);
                evaluationIdMap.put(schemeId, evalutionIdList);
            }
            this.getModel().beginInit();
            this.getModel().deleteEntryRows("entryentity_outer", deleteRowIndex.stream().mapToInt(row -> row).toArray());
            int[] newEntryRow = this.getModel().batchCreateNewEntryRow("entryentity_outer", returnSchemeIds.size());
            Date date = new Date();
            for (int i = 0; i < newEntryRow.length; ++i) {
                int row2 = newEntryRow[i];
                this.getModel().setValue("outtoolselect", (Object)"1", row2);
                this.getModel().setValue("outertool_modifytime", (Object)date, row2);
                Long schemeId = (Long)returnSchemeIds.get(i);
                this.getModel().setValue("outer_tool", (Object)schemeId, row2);
                DynamicObject outerTool = (DynamicObject)this.getModel().getValue("outer_tool", row2);
                this.getModel().setValue("toolname", (Object)HRDyObjectPropUtil.getName((DynamicObject)outerTool), row2);
                evalutionIdList = (List)evaluationIdMap.get(schemeId);
                if (!HRCollUtil.isNotEmpty(evalutionIdList)) continue;
                this.getModel().setValue("evaluationitem", (Object)evalutionIdList.toArray(), row2);
                this.getModel().setValue("evaluationitem_num", (Object)evalutionIdList.size(), row2);
            }
            this.getModel().endInit();
            this.setToolTypeForOldToolData();
            this.updateView("entryentity_outer");
            this.updateToolTabName(this.getView(), "entryentity_outer");
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"ReviewToolPlugin_1", (String)"tdc-oatr-formplugin", (Object[])new Object[0]));
        };
    }

    private Consumer<ClosedCallBackEvent> closeCallShowOutTool() {
        return closedCallBackEvent -> {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"ReviewToolPlugin_22", (String)"tdc-oatr-formplugin", (Object[])new Object[0]));
            this.updateView("entryentity_outer");
        };
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        Object returnData = closedCallBackEvent.getReturnData();
        String actionId = closedCallBackEvent.getActionId();
        Consumer<ClosedCallBackEvent> consumer = this.CLOSE_CALL_FUN.get(actionId);
        if (Objects.isNull(consumer)) {
            return;
        }
        if (Objects.isNull(returnData)) {
            return;
        }
        consumer.accept(closedCallBackEvent);
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName = evt.getFieldName();
        Consumer<HyperLinkClickEvent> consumer = this.HYPER_LINK_CLICK_FUN.get(fieldName);
        if (Objects.nonNull(consumer)) {
            consumer.accept(evt);
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs afterDeleteRowEventArgs) {
        super.afterDeleteRow(afterDeleteRowEventArgs);
        EntryProp entryProp = afterDeleteRowEventArgs.getEntryProp();
        String name = entryProp.getName();
        this.updateToolTabName(this.getView(), name);
    }

    private void checkMutex() {
        if (this.getModel().getDataEntity().getPkValue().equals(0L)) {
            return;
        }
        DynamicObject[] dynamicObjects = ReviewToolMutexHelper.checkHasMutex(this.getView().getEntityId(), Collections.singletonList(this.getId()), "modify");
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return;
        }
        if (!this.checkCurrUserHasMutex(dynamicObjects)) {
            DynamicObject user = dynamicObjects[0].getDynamicObject("user");
            if (RequestContext.get().getCurrUserId() == user.getLong("id")) {
                return;
            }
            String message = String.format(ResManager.loadKDString((String)"%s \u6b63\u5728PC\u7aef\u7f16\u8f91\u8be5\u8bb0\u5f55\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458", (String)"ReviewToolPlugin_10", (String)"tdc-oatr-formplugin", (Object[])new Object[0]), user.getString("name"));
            throw new KDBizException(message);
        }
    }

    private boolean checkCurrUserHasMutex(DynamicObject[] dynamicObjects) {
        DynamicObject user = dynamicObjects[0].getDynamicObject("user");
        return RequestContext.get().getCurrUserId() == user.getLong("id");
    }

    private long getId() {
        BillShowParameter showParameter = (BillShowParameter)this.getView().getFormShowParameter();
        return Long.parseLong(String.valueOf(showParameter.getPkId()));
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        if (HRStringUtils.equals((String)name, (String)"selecttoolscheme")) {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            List<Long> schemeIds = this.getExistSchemeIds();
            if (!CollectionUtils.isEmpty(schemeIds)) {
                showParameter.setSelectedRows(schemeIds.toArray());
            }
            showParameter.setMultiSelect(true);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_ACTION_OUTER_TOOL));
        }
    }
}

