/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.formplugin.web.activity.eval;

import java.util.Arrays;
import java.util.EventObject;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.tdc.oatr.bussiness.ServiceFactory;
import kd.tdc.oatr.bussiness.queryservice.ReviewSuperiorEvalQueryService;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class SuperiorQuestionNavPagePlugin
extends HRDynamicFormBasePlugin
implements RowClickEventListener {
    public static final String REFRESH_ENTRY_CALL_BACK = "refreshEntryCallBack";
    public static final String TARGET_QUESTION_ID = "targetQuestionId";
    public static final String CUR_SHOW_PAGE_ID = "curShowPageId";
    public static final String GO_EVAL = "go_eval";
    ReviewSuperiorEvalQueryService service = (ReviewSuperiorEvalQueryService)ServiceFactory.getService(ReviewSuperiorEvalQueryService.class);

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        e.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u7ecf\u7406\u4eba\u7efc\u5408\u8bc4\u4ef7", (String)"SuperiorQuestionNavPagePlugin_0", (String)"tdc-oatr-formplugin", (Object[])new Object[0]));
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object questionId = formShowParameter.getCustomParam("questionId");
        this.getPageCache().put(TARGET_QUESTION_ID, String.valueOf(questionId));
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.refreshNavEntry();
    }

    private void refreshNavEntry() {
        int[] selectRows;
        DynamicObject[] questionObjs = this.listQuestionObjs();
        boolean notRatedChk = this.getModel().getDataEntity().getBoolean("notratedchk");
        if (notRatedChk) {
            questionObjs = (DynamicObject[])Arrays.stream(questionObjs).filter(obj -> obj.getString("evalstatus").equals("A")).toArray(DynamicObject[]::new);
        }
        if (questionObjs.length == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u672a\u8bc4\u4ef7\u7684\u95ee\u5377\u3002", (String)"SuperiorQuestionNavPagePlugin_4", (String)"tdc-oatr-formplugin", (Object[])new Object[0]));
            return;
        }
        CardEntry entryGrid = (CardEntry)this.getView().getControl("entryentity");
        this.getModel().deleteEntryData("entryentity");
        this.getModel().batchCreateNewEntryRow("entryentity", questionObjs.length);
        for (int rowIndex = 0; rowIndex < questionObjs.length; ++rowIndex) {
            DynamicObject obj2 = questionObjs[rowIndex];
            String evalStatus = obj2.getString("evalstatus");
            entryGrid.setChildVisible(!"A".equals(evalStatus), rowIndex, new String[]{"vectorap"});
            this.getModel().setValue("questionid", (Object)obj2.getLong("id"), rowIndex);
            this.getModel().setValue("evalname", (Object)obj2.getString("reviewobject_name"), rowIndex);
        }
        int matchSelectRow = 0;
        boolean selectRowDetermine = false;
        String targetQuestionIdStr = this.getPageCache().get(TARGET_QUESTION_ID);
        if (StringUtils.isNotEmpty((CharSequence)targetQuestionIdStr)) {
            long targetQuestionId = Long.parseLong(targetQuestionIdStr);
            for (int rowIndex = 0; rowIndex < questionObjs.length; ++rowIndex) {
                DynamicObject obj3 = questionObjs[rowIndex];
                long curId = obj3.getLong("id");
                if (curId != targetQuestionId) continue;
                matchSelectRow = rowIndex;
                selectRowDetermine = true;
                this.getPageCache().put(TARGET_QUESTION_ID, String.valueOf(targetQuestionId));
                break;
            }
        }
        if (!selectRowDetermine) {
            for (int rowIndex = 0; rowIndex < questionObjs.length; ++rowIndex) {
                DynamicObject obj4 = questionObjs[rowIndex];
                String evalStatus = obj4.getString("evalstatus");
                if (!"A".equals(evalStatus)) continue;
                matchSelectRow = rowIndex;
                this.getPageCache().put(TARGET_QUESTION_ID, String.valueOf(obj4.getLong("id")));
                break;
            }
        }
        if (ArrayUtils.isEmpty((int[])(selectRows = entryGrid.getSelectRows())) || selectRows[0] != matchSelectRow) {
            entryGrid.selectRows(matchSelectRow);
        }
    }

    private DynamicObject[] listQuestionObjs() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object activityId = formShowParameter.getCustomParam("activityId");
        Object personId = formShowParameter.getCustomParam("personId");
        return this.service.listQuestionByActivity(activityId, personId);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.refreshNavEntry();
    }

    private void setFormStatus(long questionId, BillShowParameter showParameter) {
        DynamicObject questionObj = this.getQuestionObj(questionId);
        String evalStatus = questionObj.getString("evalstatus");
        if (!"A".equals(evalStatus)) {
            showParameter.setStatus(OperationStatus.VIEW);
        } else {
            showParameter.setStatus(OperationStatus.EDIT);
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        String initPage = this.getPageCache().get("initPage");
        if (StringUtils.isNotEmpty((CharSequence)initPage)) {
            this.getPageCache().remove("initPage");
            return;
        }
        String beforeSelectRowId = this.getPageCache().get(TARGET_QUESTION_ID);
        if (StringUtils.isNotEmpty((CharSequence)beforeSelectRowId)) {
            IFormView detailView;
            boolean dataLoaded;
            String evalStatus;
            long beforeSelectRow = Long.parseLong(beforeSelectRowId);
            DynamicObject dbQuestion = ((ReviewSuperiorEvalQueryService)ServiceFactory.getService(ReviewSuperiorEvalQueryService.class)).getQuestionById((Object)beforeSelectRow);
            if (dbQuestion == null || "C".equals(dbQuestion.getString("evalstatus"))) {
                long curRowClickQuestionId = this.getCurrentRowClickQuestionId(evt);
                this.getPageCache().put(TARGET_QUESTION_ID, String.valueOf(curRowClickQuestionId));
                this.getView().showConfirm(ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u88ab\u5220\u9664\u3002", (String)"SuperiorQuestionNavPagePlugin_6", (String)"tdc-oatr-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK, new ConfirmCallBackListener(REFRESH_ENTRY_CALL_BACK, (IFormPlugin)this));
                return;
            }
            DynamicObject curQuestionObj = this.getQuestionObj(beforeSelectRow);
            String curShowPageId = this.getPageCache().get(CUR_SHOW_PAGE_ID);
            String goEval = this.getPageCache().get(GO_EVAL);
            if (StringUtils.isNotEmpty((CharSequence)goEval)) {
                this.getPageCache().remove(GO_EVAL);
                IFormView detailView2 = this.getView().getView(curShowPageId);
                detailView2.close();
                this.getView().showLoading(new LocaleString(""));
            } else if (curQuestionObj != null && StringUtils.isNotEmpty((CharSequence)curShowPageId) && "A".equals(evalStatus = curQuestionObj.getString("evalstatus")) && (dataLoaded = (detailView = this.getView().getView(curShowPageId)).getModel().isDataLoaded())) {
                OperationResult operationResult = detailView.invokeOperation("save");
                if (operationResult.isSuccess()) {
                    detailView.close();
                    this.getView().showLoading(new LocaleString(""));
                } else {
                    this.getView().showOperationResult(operationResult);
                    return;
                }
            }
        }
        this.showClickRowPage(evt);
    }

    private void showClickRowPage(RowClickEvent evt) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        long curRowClickQuestionId = this.getCurrentRowClickQuestionId(evt);
        BillShowParameter showParameter = new BillShowParameter();
        this.setFormStatus(curRowClickQuestionId, showParameter);
        showParameter.setPkId((Object)curRowClickQuestionId);
        showParameter.setCustomParam("questionId", formShowParameter.getCustomParam("questionId"));
        showParameter.setCustomParam("activityId", formShowParameter.getCustomParam("activityId"));
        showParameter.setCustomParam("personId", formShowParameter.getCustomParam("personId"));
        showParameter.setFormId("oatr_superioreval");
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey("questiondetail_flex");
        this.getView().showForm((FormShowParameter)showParameter);
        this.getPageCache().put(CUR_SHOW_PAGE_ID, showParameter.getPageId());
        this.getPageCache().put(TARGET_QUESTION_ID, String.valueOf(curRowClickQuestionId));
    }

    private long getCurrentRowClickQuestionId(RowClickEvent evt) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection dynamicObjectCollection = dataEntity.getDynamicObjectCollection("entryentity");
        DynamicObject entryRowClickObj = (DynamicObject)dynamicObjectCollection.get(evt.getRow());
        return entryRowClickObj.getLong("questionid");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        if ("notratedchk".equals(propName)) {
            this.refreshNavEntry();
            this.getPageCache().remove(TARGET_QUESTION_ID);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (REFRESH_ENTRY_CALL_BACK.equals(callBackId)) {
            this.getPageCache().remove(CUR_SHOW_PAGE_ID);
            this.refreshNavEntry();
        } else if (MessageBoxResult.No.equals((Object)result)) {
            this.getView().close();
        } else {
            DynamicObject[] questionObjs = this.listQuestionObjs();
            DynamicObject question = Arrays.stream(questionObjs).filter(obj -> "A".equals(obj.getString("evalstatus"))).findFirst().orElse(null);
            if (question != null) {
                this.getPageCache().put(TARGET_QUESTION_ID, String.valueOf(question.get("id")));
                this.getPageCache().put(GO_EVAL, "1");
                this.refreshNavEntry();
            } else {
                this.getView().close();
            }
        }
    }

    private DynamicObject getQuestionObj(Object id) {
        return this.service.getQuestionById(id);
    }
}

