/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.formplugin.web.activity.group;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.tdc.oatr.bussiness.ServiceFactory;
import kd.tdc.oatr.bussiness.domain.activity.ReviewBusinessDataListService;
import kd.tdc.oatr.bussiness.domain.collaborator.ReviewCollaboratorService;
import kd.tdc.oatr.bussiness.queryservice.ReviewToolQueryService;
import kd.tdc.oatr.common.utils.PropUtils;
import kd.tdc.oatr.formplugin.web.activity.ReviewEntryGridCommon;
import kd.tdc.oatr.formplugin.web.activity.detail.ReviewActivityDetailCommon;
import kd.tdc.oatr.formplugin.web.common.FormBizChangeUtils;
import kd.tdc.tdcs.bussiness.formservice.FormCommonService;
import org.apache.commons.lang.StringUtils;

public class ReviewGroupEdit
extends HRDataBaseEdit
implements ReviewActivityDetailCommon,
ReviewEntryGridCommon {
    private final ReviewToolQueryService reviewToolQueryService = (ReviewToolQueryService)ServiceFactory.getService(ReviewToolQueryService.class);

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object activityId = formShowParameter.getCustomParam("activityId");
        this.getModel().setValue("reviewactivity", activityId);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.loadToolEntryData();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        for (int i = 0; i < entryEntity.size(); ++i) {
            String colStatus = (String)this.getModel().getValue("colstatus", i);
            this.getModel().setValue("colstatusedit", (Object)"1".equals(colStatus), i);
        }
        this.getModel().setDataChanged(false);
    }

    private void loadToolEntryData() {
        this.setToolEntry();
        this.setToolUse();
        this.getView().updateView("entryentity_inner");
        this.getView().updateView("entryentity_outer");
        this.updateToolTabName(this.getView(), "entryentity_inner");
        this.updateToolTabName(this.getView(), "entryentity_outer");
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        List collaborator = dataEntity.getDynamicObjectCollection("entryentity").stream().map(dy -> dy.getLong(PropUtils.getIdDot((String)"collaborator"))).collect(Collectors.toList());
        this.getModel().setValue("mul_collaborator", (Object)collaborator.toArray());
        for (DynamicObject dynamicObject : this.getModel().getDataEntity().getDynamicObjectCollection("mul_collaborator")) {
            dynamicObject.refreshDataEntityState();
        }
        this.getPageCache().put("originalMulColl", JSONObject.toJSONString(collaborator));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        OperateOption option = formOperate.getOption();
        if (StringUtils.equals((String)operateKey, (String)"save")) {
            this.checkPermByManagerItem(this.getView().getParentView(), ignore -> {
                args.setCancel(true);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u4f60\u7684\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u5237\u65b0\u6216\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"ReviewActivityDetailCommon_0", (String)"tdc-oatr-formplugin", (Object[])new Object[0]), MessageBoxOptions.None);
            });
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            List collaboratorIdList = dataEntity.getDynamicObjectCollection("entryentity").stream().map(dy -> dy.getLong(PropUtils.getIdDot((String)"collaborator"))).collect(Collectors.toList());
            option.setVariableValue("mul_collaborator", JSONObject.toJSONString(collaboratorIdList));
            option.setVariableValue("originalMulColl", this.getPageCache().get("originalMulColl"));
            option.setVariableValue("activityId", String.valueOf(this.getActivityId(this.getView().getParentView())));
            Map<String, List<Map<String, Object>>> toolEntryMap = this.getToolEntryMap(dataEntity);
            option.setVariableValue("toolEntryMap", SerializationUtils.serializeToBase64(toolEntryMap));
            OperationStatus status = this.getView().getFormShowParameter().getStatus();
            if (status.equals((Object)OperationStatus.ADDNEW)) {
                option.setVariableValue("formstatus", "addnew");
            } else {
                option.setVariableValue("formstatus", "modify");
            }
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.checkActivity(this.getView().getParentView(), ignore -> this.getView().getFormShowParameter().setStatus(OperationStatus.VIEW));
    }

    public void beforeClosed(BeforeClosedEvent beforeClosedEvent) {
        super.beforeClosed(beforeClosedEvent);
        FormBizChangeUtils.setBizChanged(this.getModel().getDataEntity(true), "mul_collaborator");
        FormCommonService commonService = new FormCommonService();
        commonService.setPropertyNotDataChanged(this.getModel(), new String[]{"entryentity_inner", "entryentity_outer", "colstatus"});
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("save".equals(operateKey) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            this.getView().returnDataToParent(this.getModel().getDataEntity().getPkValue());
        }
        if (HRStringUtils.equals((String)operateKey, (String)"newcollaborator")) {
            this.newCollaborator();
        }
        if (HRStringUtils.equals((String)operateKey, (String)"moveoutcollaborator")) {
            this.moveCollaborator();
        }
        this.loadToolEntryData();
    }

    public void propertyChanged(PropertyChangedArgs evt) {
        super.propertyChanged(evt);
        String name = evt.getProperty().getName();
        if ("colstatusedit".equals(name)) {
            boolean colStatusEnable = (Boolean)this.getModel().getValue(name);
            int currentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            this.getModel().setValue("colstatus", (Object)(colStatusEnable ? "1" : "0"), currentRowIndex);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        Object returnData = closedCallBackEvent.getReturnData();
        if (HRStringUtils.equals((String)closedCallBackEvent.getActionId(), (String)"newcollaborator") && Objects.nonNull(returnData)) {
            ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)returnData;
            List alrUserIdList = Arrays.stream(this.getEntryRow(this.getView(), "entryentity")).map(dy -> dy.getLong(PropUtils.getIdDot((String)"collaborator"))).collect(Collectors.toList());
            List newUserIds = selectedRows.stream().map(selectedRow -> (Long)selectedRow.getPrimaryKeyValue()).filter(userId -> !alrUserIdList.contains(userId)).collect(Collectors.toList());
            DynamicObjectType objectType = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity").getDynamicObjectType();
            DynamicObjectCollection newCollaborators = new DynamicObjectCollection();
            for (Long newUserId : newUserIds) {
                DynamicObject newObj = new DynamicObject(objectType);
                newObj.set("collaborator", (Object)newUserId);
                newCollaborators.add((Object)newObj);
            }
            ((ReviewCollaboratorService)ServiceFactory.getService(ReviewCollaboratorService.class)).fillWorkInfo(newCollaborators);
            IDataModel model = this.getModel();
            model.beginInit();
            for (DynamicObject newCollaborator : newCollaborators) {
                int index = model.createNewEntryRow("entryentity");
                model.setValue("collaborator", newCollaborator.get("collaborator"), index);
                model.setValue("adminorg", newCollaborator.get("adminorg"), index);
                model.setValue("position", newCollaborator.get("position"), index);
                model.setValue("job", newCollaborator.get("job"), index);
                model.setValue("std_position", newCollaborator.get("std_position"), index);
                model.setValue("colstatus", (Object)"0", index);
            }
            model.endInit();
            this.getView().updateView("entryentity");
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (HRStringUtils.equals((String)messageBoxClosedEvent.getCallBackId(), (String)"moveCollaborator") && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            int[] selectRows = this.getSelectRows(this.getView(), "entryentity");
            this.getModel().deleteEntryRows("entryentity", selectRows);
        }
    }

    private void moveCollaborator() {
        int[] selectAndGet = this.checkSelectAndGet(this.getView(), "entryentity");
        if (selectAndGet.length == 0) {
            return;
        }
        DynamicObject[] selectRowDOArr = this.getSelectRowDO(this.getView(), "entryentity");
        List userIdList = Arrays.stream(selectRowDOArr).map(dy -> dy.getLong(PropUtils.getIdDot((String)"collaborator"))).collect(Collectors.toList());
        long activityId = this.getModel().getDataEntity().getLong("reviewactivity.id");
        boolean haveBusinessData = ((ReviewBusinessDataListService)ServiceFactory.getService(ReviewBusinessDataListService.class)).haveBusinessData(userIdList, activityId);
        if (haveBusinessData) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u6cd5\u5220\u9664\uff0c\u534f\u4f5c\u4eba\u5df2\u4ea7\u751f\u4e1a\u52a1\u6570\u636e\u3002", (String)"ReviewMaintainCollaboratorPlugin_0", (String)"tdc-oatr-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u4f60\u5df2\u9009\u4e2d%s\u6761\u8bb0\u5f55\uff0c\u786e\u5b9a\u8981\u7ee7\u7eed\u5417\uff1f", (String)"ReviewMaintainCollaboratorPlugin_2", (String)"tdc-oatr-formplugin", (Object[])new Object[0]), selectRowDOArr.length), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("moveCollaborator", (IFormPlugin)this));
    }

    private void newCollaborator() {
        ListShowParameter showListForm = ShowFormHelper.createShowListForm((String)"bos_user", (boolean)true);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "newcollaborator");
        showListForm.setCloseCallBack(closeCallBack);
        showListForm.setSelectedRows(Arrays.stream(this.getEntryRow(this.getView(), "entryentity")).map(dy -> dy.getLong(PropUtils.getIdDot((String)"collaborator"))).toArray());
        this.getView().showForm((FormShowParameter)showListForm);
    }

    private void setToolEntry() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject reviewTool = this.reviewToolQueryService.getReviewToolByActivityId(dataEntity.getLong("reviewactivity.id"));
        if (reviewTool == null) {
            return;
        }
        this.getModel().deleteEntryData("entryentity_inner");
        this.getModel().deleteEntryData("entryentity_outer");
        DynamicObjectCollection entryEntityInner = reviewTool.getDynamicObjectCollection("entryentity_inner");
        Map innerToolEntityMap = this.reviewToolQueryService.getReviewInnerTool(entryEntityInner.stream().map(entity -> entity.getLong("id")).collect(Collectors.toList()));
        DynamicObjectCollection pageEntryInnerList = dataEntity.getDynamicObjectCollection("entryentity_inner");
        for (DynamicObject entityInner : entryEntityInner) {
            DynamicObject dynamicObject = pageEntryInnerList.addNew();
            dynamicObject.set("innertoolentity", innerToolEntityMap.get(entityInner.getLong("id")));
            dynamicObject.set("questionnaire", entityInner.get("questionnaire"));
        }
        DynamicObjectCollection entryEntityOuter = reviewTool.getDynamicObjectCollection("entryentity_outer");
        Map outerToolEntityMap = this.reviewToolQueryService.getReviewOuterTool(entryEntityOuter.stream().map(entity -> entity.getLong("id")).collect(Collectors.toList()));
        DynamicObjectCollection pageEntryOuterList = dataEntity.getDynamicObjectCollection("entryentity_outer");
        for (DynamicObject entityOuter : entryEntityOuter) {
            DynamicObject dynamicObject = pageEntryOuterList.addNew();
            DynamicObject outerToolEntity = (DynamicObject)outerToolEntityMap.get(entityOuter.getLong("id"));
            dynamicObject.set("outertoolentity", (Object)outerToolEntity);
            DynamicObject outerTool = outerToolEntity.getDynamicObject("outer_tool");
            if (outerTool == null) continue;
            this.setToolTypeForOldToolData(outerTool);
            dynamicObject.set("outer_tool", (Object)outerTool);
        }
        this.getModel().updateEntryCache(pageEntryInnerList);
        this.getModel().updateEntryCache(pageEntryOuterList);
    }

    private void setToolTypeForOldToolData(DynamicObject outerTool) {
        String toolType = outerTool.getString("tooltype");
        if (HRStringUtils.isEmpty((String)toolType)) {
            outerTool.set("tooltype", (Object)"30");
        }
    }

    private void setToolUse() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Object groupPkId = dataEntity.getPkValue();
        DynamicObjectCollection pageEntryInnerList = dataEntity.getDynamicObjectCollection("entryentity_inner");
        DynamicObjectCollection pageEntryOuterList = dataEntity.getDynamicObjectCollection("entryentity_outer");
        if (!groupPkId.equals(0L)) {
            Map reviewToolList = this.reviewToolQueryService.getReviewToolOfReviewGroup(dataEntity.getLong("reviewactivity.id"));
            List toolList = (List)reviewToolList.get((Long)groupPkId);
            if (CollectionUtils.isEmpty((Collection)toolList)) {
                for (DynamicObject entryInner : pageEntryInnerList) {
                    entryInner.set("innertooluse", (Object)false);
                }
                for (DynamicObject entryOuter : pageEntryOuterList) {
                    entryOuter.set("outertooluse", (Object)false);
                }
                return;
            }
            for (DynamicObject entryInner : pageEntryInnerList) {
                entryInner.set("innertooluse", (Object)toolList.contains(entryInner.getLong(PropUtils.getIdDot((String)"innertoolentity"))));
            }
            for (DynamicObject entryOuter : pageEntryOuterList) {
                entryOuter.set("outertooluse", (Object)toolList.contains(entryOuter.getLong(PropUtils.getIdDot((String)"outertoolentity"))));
            }
        }
    }

    private Map<String, List<Map<String, Object>>> getToolEntryMap(DynamicObject dataEntity) {
        HashMap valueMap;
        DynamicObjectCollection pageEntryInnerList = dataEntity.getDynamicObjectCollection("entryentity_inner");
        DynamicObjectCollection pageEntryOuterList = dataEntity.getDynamicObjectCollection("entryentity_outer");
        HashMap toolEntryMap = Maps.newHashMapWithExpectedSize((int)2);
        for (DynamicObject entryInner : pageEntryInnerList) {
            valueMap = Maps.newHashMapWithExpectedSize((int)2);
            valueMap.put("innertoolentity", entryInner.getLong(PropUtils.getIdDot((String)"innertoolentity")));
            valueMap.put("innertooluse", entryInner.getBoolean("innertooluse"));
            toolEntryMap.computeIfAbsent("entryentity_inner", k -> Lists.newArrayListWithExpectedSize((int)pageEntryInnerList.size())).add(valueMap);
        }
        for (DynamicObject entryOuter : pageEntryOuterList) {
            valueMap = Maps.newHashMapWithExpectedSize((int)2);
            valueMap.put("outertoolentity", entryOuter.getLong(PropUtils.getIdDot((String)"outertoolentity")));
            valueMap.put("outertooluse", entryOuter.getBoolean("outertooluse"));
            toolEntryMap.computeIfAbsent("entryentity_outer", k -> Lists.newArrayListWithExpectedSize((int)pageEntryOuterList.size())).add(valueMap);
        }
        return toolEntryMap;
    }
}

