/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.formplugin.web.activity.group;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.Consumer;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.list.events.BeforePackageDataListener;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.events.SetFilterListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.tdc.oatr.bussiness.ServiceFactory;
import kd.tdc.oatr.bussiness.application.ReviewActivityApplicationService;
import kd.tdc.oatr.bussiness.domain.activity.ReviewActivityService;
import kd.tdc.oatr.bussiness.domain.collaborator.ReviewCollaboratorService;
import kd.tdc.oatr.bussiness.domain.reviewgroup.ReviewGroupService;
import kd.tdc.oatr.bussiness.domain.reviewobjct.ReviewObjectService;
import kd.tdc.oatr.bussiness.queryservice.ReviewToolQueryService;
import kd.tdc.oatr.common.bo.CollaboratorObject;
import kd.tdc.oatr.common.constants.enums.ManagerItemEnum;
import kd.tdc.oatr.common.utils.JsonUtils;
import kd.tdc.oatr.common.utils.PermItemName;
import kd.tdc.oatr.common.utils.PropUtils;
import kd.tdc.oatr.common.utils.ReviewPermUtils;
import kd.tdc.oatr.formplugin.web.activity.detail.ReviewActivityDetailCommon;
import kd.tdc.oatr.formplugin.web.activity.group.ReviewGroupCollaboratorInfo;
import kd.tdc.oatr.formplugin.web.activity.group.ReviewGroupInfo;
import kd.tdc.oatr.formplugin.web.common.ManagerItemUtil;
import kd.tdc.oatr.formplugin.web.common.ReviewToolMutexHelper;
import kd.tdc.tdcs.bussiness.application.external.BosLogService;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.tuple.Pair;

public class ReviewGroupToolEdit
extends HRDataBaseEdit
implements ReviewActivityDetailCommon,
SetFilterListener,
HyperLinkClickListener,
BeforePackageDataListener {
    private static final Log logger = LogFactory.getLog(ReviewGroupToolEdit.class);
    public static final String REVIEW_GROUP_BILL_LIST = "reviewgroupbilllist";
    public static final String BTN_REVIEW_GROUP_NEW = "reviewgroupnew";
    public static final String BTN_REVIEW_GROUP_DELETE = "reviewgroupdelete";
    public static final String DEFAULT_REVIEW_GROUP = "default";
    public static final String ORDER_BY = "sortnum desc,number asc";
    public static final String DO_NOTHING_NEW = "donothing_new";
    public static final String DO_NOTHING_DELETE = "donothing_delete";
    public static final String KEY_GROUP_REVIEW_OBJ_NUM = "groupreviewobjnum";
    public static final String KEY_REVIEW_OBJ_NUM = "reviewobjnum";
    public static final String KEY_REVIEW_TOOL_NUM = "reviewtoolnum";
    private static final ReviewObjectService reviewObjectService = (ReviewObjectService)ServiceFactory.getService(ReviewObjectService.class);
    private static final ReviewActivityApplicationService reviewApplicationService = (ReviewActivityApplicationService)ServiceFactory.getService(ReviewActivityApplicationService.class);
    private static final ReviewGroupService reviewGroupService = (ReviewGroupService)ServiceFactory.getService(ReviewGroupService.class);
    private static final ReviewActivityService reviewActivityService = (ReviewActivityService)ServiceFactory.getService(ReviewActivityService.class);
    private final ReviewToolQueryService reviewToolQueryService = (ReviewToolQueryService)ServiceFactory.getService(ReviewToolQueryService.class);
    private static final HRBaseServiceHelper REPOSITORY = new HRBaseServiceHelper("oatr_reviewgroup");
    private Map<Long, List<Long>> groupReviewObjectList;
    private Map<Long, Map<Long, List<Long>>> colReviewObjectList;
    private Map<Long, List<Long>> reviewToolList;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BillList reviewGroupBillList = this.getReviewGroupBillList();
        reviewGroupBillList.addBeforeBindDataListener(beforeBindDataEvent -> this.filterActivity(reviewGroupBillList));
        reviewGroupBillList.addSetFilterListener((SetFilterListener)this);
        reviewGroupBillList.addHyperClickListener((HyperLinkClickListener)this);
        this.addClickListeners(new String[]{BTN_REVIEW_GROUP_NEW, BTN_REVIEW_GROUP_DELETE});
    }

    private BillList getReviewGroupBillList() {
        return (BillList)this.getView().getControl(REVIEW_GROUP_BILL_LIST);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        Object returnData = closedCallBackEvent.getReturnData();
        if (REVIEW_GROUP_BILL_LIST.equals(closedCallBackEvent.getActionId()) && !Objects.isNull(returnData)) {
            BillList reviewGroupBillList = this.getReviewGroupBillList();
            this.refreshGroupBillList(reviewGroupBillList);
            IFormView parentView = this.getView().getParentView();
            if (parentView != null) {
                parentView.invokeOperation("refresh");
                this.getView().sendFormAction(parentView);
            }
        }
        if (HRStringUtils.equals((String)closedCallBackEvent.getActionId(), (String)"maintainCollaborator")) {
            this.maintainCollaboratorCloseBack(returnData, closedCallBackEvent.getActionId());
        }
    }

    private void refreshGroupBillList(BillList reviewGroupBillList) {
        this.filterActivity(reviewGroupBillList);
        reviewGroupBillList.addBeforePackageDataListener((BeforePackageDataListener)this);
        reviewGroupBillList.addPackageDataListener(this::packageDataProcess);
        reviewGroupBillList.setOrderBy(ORDER_BY);
        reviewGroupBillList.refresh();
        reviewGroupBillList.clearSelection();
    }

    private void maintainCollaboratorCloseBack(Object returnData, String actionId) {
        ListSelectedRowCollection selectedRows = this.getReviewGroupBillList().getSelectedRows();
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("oatr_reviewgroup");
        DynamicObject[] groupDOArr = serviceHelper.query("entryentity,collaborator,colstatus,adminorg,position,job,std_position", new QFilter("id", "in", Arrays.asList(selectedRows.getPrimaryKeyValues())).toArray());
        boolean collaboratorPage = ManagerItemUtil.isCollaboratorPage(this.getView());
        String formId = collaboratorPage ? "oatr_colreviewgroup" : "oatr_reviewgroup";
        Arrays.stream(groupDOArr).map(dy -> dy.getLong("id")).forEach(groupId -> ReviewToolMutexHelper.releaseMutex(formId, groupId, "modify"));
        String str = (String)returnData;
        if (HRStringUtils.isEmpty((String)str)) {
            return;
        }
        List infoList = JSONObject.parseArray((String)str, ReviewGroupCollaboratorInfo.class);
        if (CollectionUtils.isEmpty((Collection)infoList)) {
            return;
        }
        boolean haveDBChange = false;
        for (DynamicObject groupDO : groupDOArr) {
            DynamicObjectCollection entryEntity = groupDO.getDynamicObjectCollection("entryentity");
            for (ReviewGroupCollaboratorInfo info2 : infoList) {
                if (info2.getGroupId() != groupDO.getLong("id")) continue;
                if (HRStringUtils.equals((String)info2.getOperate(), (String)"1")) {
                    DynamicObject dynamicObject;
                    Optional<DynamicObject> firstOp = entryEntity.stream().filter(dy -> dy.getLong(PropUtils.getIdDot((String)"collaborator")) == info2.getUserId()).findFirst();
                    if (firstOp.isPresent()) {
                        dynamicObject = firstOp.get();
                        dynamicObject.set("colstatus", (Object)info2.getUserStatus());
                        haveDBChange = true;
                    } else {
                        haveDBChange = true;
                        dynamicObject = entryEntity.addNew();
                        dynamicObject.set("collaborator", (Object)info2.getUserId());
                        dynamicObject.set("colstatus", (Object)info2.getUserStatus());
                    }
                }
                if (!HRStringUtils.equals((String)info2.getOperate(), (String)"0")) continue;
                entryEntity.removeIf(dy -> dy.getLong(PropUtils.getIdDot((String)"collaborator")) == info2.getUserId());
                haveDBChange = true;
            }
            ((ReviewCollaboratorService)ServiceFactory.getService(ReviewCollaboratorService.class)).fillWorkInfo(entryEntity);
        }
        serviceHelper.save(groupDOArr);
        List updateStatusInfoList = infoList.stream().filter(info -> HRStringUtils.equals((String)info.getUserStatus(), (String)"0") || HRStringUtils.equals((String)info.getUserStatus(), (String)"1")).collect(Collectors.toList());
        List disableIdList = updateStatusInfoList.stream().filter(info -> HRStringUtils.equals((String)info.getUserStatus(), (String)"0")).map(ReviewGroupCollaboratorInfo::getUserId).distinct().collect(Collectors.toList());
        List enableIdList = updateStatusInfoList.stream().filter(info -> HRStringUtils.equals((String)info.getUserStatus(), (String)"1")).map(ReviewGroupCollaboratorInfo::getUserId).distinct().collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(updateStatusInfoList)) {
            DynamicObject[] collaboratorDOArr;
            for (DynamicObject dynamicObject : collaboratorDOArr = serviceHelper.query("entryentity,collaborator,colstatus", new QFilter[]{new QFilter("entryentity.collaborator", "in", updateStatusInfoList.stream().map(ReviewGroupCollaboratorInfo::getUserId).collect(Collectors.toList())), new QFilter("reviewactivity", "=", this.getActivityId(this.getView()))})) {
                DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection("entryentity");
                for (DynamicObject object : entryEntity) {
                    if (disableIdList.contains(object.getLong(PropUtils.getIdDot((String)"collaborator")))) {
                        object.set("colstatus", (Object)"0");
                    }
                    if (!enableIdList.contains(object.getLong(PropUtils.getIdDot((String)"collaborator")))) continue;
                    object.set("colstatus", (Object)"1");
                }
            }
            serviceHelper.save(collaboratorDOArr);
        }
        ((ReviewCollaboratorService)ServiceFactory.getService(ReviewCollaboratorService.class)).updateActivityCollaboratorNum(((Long)this.getActivityId(this.getView())).longValue());
        if (haveDBChange) {
            BosLogService.recordLocalStringOpLogWithNoOp((IFormView)this.getView(), (String)formId, (String)actionId, (MultiLangEnumBridge)new MultiLangEnumBridge("\u7ef4\u62a4\u534f\u4f5c\u4eba\u5458", "ReviewGroupToolEdit_0", "tdc-oatr-formplugin"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u64cd\u4f5c\u6210\u529f\u3002", "ReviewGroupToolEdit_1", "tdc-oatr-formplugin"));
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"ReviewGroupToolEdit_1", (String)"tdc-oatr-formplugin", (Object[])new Object[0]));
        BillList reviewGroupBillList = this.getReviewGroupBillList();
        this.refreshGroupBillList(reviewGroupBillList);
    }

    private void packageDataProcess(PackageDataEvent packageEvent) {
        List<Long> objList;
        long id;
        DynamicObject rowData = packageEvent.getRowData();
        AbstractColumnDesc source = (AbstractColumnDesc)packageEvent.getSource();
        String fieldKey = source.getKey();
        if (KEY_GROUP_REVIEW_OBJ_NUM.equals(fieldKey)) {
            id = rowData.getLong("id");
            objList = this.getGroupReviewObjectList().get(id);
            if (org.apache.commons.collections4.CollectionUtils.isEmpty(objList) || objList.size() == 0) {
                packageEvent.setFormatValue((Object)"0");
            } else {
                packageEvent.setFormatValue((Object)objList.size());
            }
        }
        if (KEY_REVIEW_OBJ_NUM.equals(fieldKey)) {
            id = rowData.getLong("id");
            long collaboratorId = (Long)packageEvent.getRowData().get("collaborator_id");
            if (collaboratorId == 0L) {
                packageEvent.setFormatValue((Object)"");
                return;
            }
            Map<Long, List<Long>> colReviewObjList = this.getColReviewObjectList().get(id);
            if (MapUtils.isEmpty(colReviewObjList)) {
                packageEvent.setFormatValue((Object)"0");
                return;
            }
            List<Long> objList2 = colReviewObjList.get(collaboratorId);
            if (org.apache.commons.collections4.CollectionUtils.isEmpty(objList2) || objList2.size() == 0) {
                packageEvent.setFormatValue((Object)"0");
            } else {
                packageEvent.setFormatValue((Object)objList2.size());
            }
        }
        if (KEY_REVIEW_TOOL_NUM.equals(fieldKey)) {
            id = rowData.getLong("id");
            objList = this.getReviewToolList().get(id);
            if (org.apache.commons.collections4.CollectionUtils.isEmpty(objList)) {
                packageEvent.setFormatValue((Object)"0");
            } else {
                packageEvent.setFormatValue((Object)objList.size());
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        boolean collaboratorPage = ManagerItemUtil.isCollaboratorPage(this.getView());
        String formId = "oatr_reviewgroup";
        if (collaboratorPage) {
            formId = "oatr_colreviewgroup";
        }
        boolean hasGroupQueryPerm = ReviewPermUtils.getInstance().hasPerm(formId);
        boolean activityEnd = this.checkActivity(this.getView());
        if (!hasGroupQueryPerm || activityEnd) {
            this.hiddenBtn();
        }
        if (collaboratorPage) {
            ManagerItemUtil.checkPermByManagerItem(ManagerItemEnum.COLLABORATOR_TOOL, this.getActivityId(this.getView()), (Consumer<Boolean>)((Consumer)this::hiddenBtn));
        }
    }

    private void hiddenBtn() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"btnmaintain", "btnenablecolla", "btnstopcolla"});
    }

    private void hiddenBtn(boolean ignore) {
        this.hiddenBtn();
    }

    public void beforePackageData(BeforePackageDataEvent evt) {
        Long activityId = this.getActivityLongId(this.getView());
        DynamicObject[] reviewObjs = reviewObjectService.listJoinedReviewObjects(activityId.longValue());
        Map groupReviewObjMap = reviewApplicationService.getGroupReviewObjMap(reviewObjs);
        this.setGroupReviewObjectList(groupReviewObjMap);
        DynamicObject[] reviewGroups = reviewGroupService.listReviewGroupByActivity((Object)activityId);
        reviewObjs = ReviewGroupToolEdit.filterReviewObjTalentFileBuByActivityBu(activityId, reviewObjs);
        Map colReviewObjectList = reviewApplicationService.getColReviewObjectList(reviewObjs, reviewGroups, groupReviewObjMap);
        this.setColReviewObjectList(colReviewObjectList);
        Map reviewToolList = this.reviewToolQueryService.getReviewToolOfReviewGroup(activityId.longValue());
        this.setReviewToolList(reviewToolList);
    }

    public Map<Long, List<Long>> getGroupReviewObjectList() {
        return this.groupReviewObjectList;
    }

    public void setGroupReviewObjectList(Map<Long, List<Long>> groupReviewObjectList) {
        this.groupReviewObjectList = groupReviewObjectList;
    }

    public Map<Long, Map<Long, List<Long>>> getColReviewObjectList() {
        return this.colReviewObjectList;
    }

    public void setColReviewObjectList(Map<Long, Map<Long, List<Long>>> colReviewObjectList) {
        this.colReviewObjectList = colReviewObjectList;
    }

    public Map<Long, List<Long>> getReviewToolList() {
        return this.reviewToolList;
    }

    public void setReviewToolList(Map<Long, List<Long>> reviewToolList) {
        this.reviewToolList = reviewToolList;
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        BillList reviewGroupBillList = this.getReviewGroupBillList();
        this.filterActivity(reviewGroupBillList);
        reviewGroupBillList.setOrderBy(ORDER_BY);
        reviewGroupBillList.addBeforePackageDataListener((BeforePackageDataListener)this);
        reviewGroupBillList.addPackageDataListener(this::packageDataProcess);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object source = args.getSource();
        Long activityId = this.getActivityLongId(this.getView());
        if (source instanceof Donothing) {
            boolean managerItem;
            boolean collaboratorPage = ManagerItemUtil.isCollaboratorPage(this.getView());
            if (collaboratorPage && !(managerItem = this.checkPermByManagerItem(this.getView().getParentView().getParentView(), ignore -> {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u4f60\u7684\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u5237\u65b0\u6216\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"ReviewActivityColList_0", (String)"tdc-oatr-formplugin", (Object[])new Object[0]), MessageBoxOptions.None, new ConfirmCallBackListener("oatr_colreviewgroup", (IFormPlugin)this));
                args.setCancel(true);
            }))) {
                return;
            }
            Donothing donothing = (Donothing)source;
            String operateKey = donothing.getOperateKey();
            if (HRStringUtils.equals((String)operateKey, (String)"maintain_collaborator")) {
                BillList reviewGroupBillList = this.getReviewGroupBillList();
                ListSelectedRowCollection selectedRows = reviewGroupBillList.getSelectedRows();
                Object[] reviewGroupIds = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).toArray();
                if (reviewGroupIds.length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ReviewGroupToolPlugin_2", (String)"tdc-oatr-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
                if (!reviewGroupService.isExists(new QFilter("id", "in", Arrays.asList(primaryKeyValues)).toArray())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u76d8\u70b9\u7ec4\u5df2\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u88ab\u5176\u4ed6\u4eba\u5220\u9664\u4e86\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"ReviewGroupToolPlugin_4", (String)"tdc-oatr-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String tips;
        Object[] reviewGroupIds;
        ListSelectedRowCollection selectedRows;
        BillList reviewGroupBillList;
        super.afterDoOperation(afterDoOperationEventArgs);
        AbstractOperate operate = (AbstractOperate)afterDoOperationEventArgs.getSource();
        String localeOperateName = operate.getOperateName().getLocaleValue();
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (operationResult == null || !operationResult.isSuccess()) {
            return;
        }
        if (DO_NOTHING_NEW.equals(operateKey)) {
            if (this.checkActivity(this.getView())) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u76d8\u70b9\u6d3b\u52a8\u72b6\u6001\u4e3a\u201c\u8fdb\u884c\u4e2d\u201d\u3001\u201c\u5f85\u542f\u52a8\u201d\uff0c\u624d\u80fd%s\u3002", (String)"ReviewEntryGridCommon_3", (String)"tdc-oatr-formplugin", (Object[])new Object[0]), localeOperateName));
                return;
            }
            this.newReviewGroupFrom();
        }
        if (DO_NOTHING_DELETE.equals(operateKey)) {
            this.deleteReviewGroup();
        }
        if (HRStringUtils.equals((String)operateKey, (String)"maintain_collaborator")) {
            if (this.checkActivity(this.getView())) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u76d8\u70b9\u6d3b\u52a8\u72b6\u6001\u4e3a\u201c\u8fdb\u884c\u4e2d\u201d\u3001\u201c\u5f85\u542f\u52a8\u201d\uff0c\u624d\u80fd%s\u3002", (String)"ReviewEntryGridCommon_3", (String)"tdc-oatr-formplugin", (Object[])new Object[0]), localeOperateName));
                return;
            }
            this.showMaintainForm();
        }
        if ("view_collaboratelist".equals(operateKey)) {
            this.viewCollaborateList();
        }
        if (HRStringUtils.equals((String)operateKey, (String)"enablecolla")) {
            if (this.checkActivity(this.getView())) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u76d8\u70b9\u6d3b\u52a8\u72b6\u6001\u4e3a\u201c\u8fdb\u884c\u4e2d\u201d\u3001\u201c\u5f85\u542f\u52a8\u201d\uff0c\u624d\u80fd%s\u3002", (String)"ReviewEntryGridCommon_3", (String)"tdc-oatr-formplugin", (Object[])new Object[0]), localeOperateName));
                return;
            }
            reviewGroupBillList = this.getReviewGroupBillList();
            selectedRows = reviewGroupBillList.getSelectedRows();
            reviewGroupIds = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).toArray();
            if (reviewGroupIds.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ReviewGroupToolPlugin_2", (String)"tdc-oatr-formplugin", (Object[])new Object[0]));
                return;
            }
            try {
                this.enableCollaborate(reviewGroupIds);
            }
            catch (Exception exception) {
                logger.error("enableCollaborate fail", (Throwable)exception);
                String tips2 = ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002", (String)"ReviewGroupToolPlugin_10", (String)"tdc-oatr-formplugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(tips2);
                return;
            }
            tips = ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"ReviewGroupToolPlugin_9", (String)"tdc-oatr-formplugin", (Object[])new Object[0]);
            this.getView().showSuccessNotification(tips);
            this.refreshGroupBillList(reviewGroupBillList);
        }
        if (HRStringUtils.equals((String)operateKey, (String)"stopcolla")) {
            if (this.checkActivity(this.getView())) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u76d8\u70b9\u6d3b\u52a8\u72b6\u6001\u4e3a\u201c\u8fdb\u884c\u4e2d\u201d\u3001\u201c\u5f85\u542f\u52a8\u201d\uff0c\u624d\u80fd%s\u3002", (String)"ReviewEntryGridCommon_3", (String)"tdc-oatr-formplugin", (Object[])new Object[0]), localeOperateName));
                return;
            }
            reviewGroupBillList = this.getReviewGroupBillList();
            selectedRows = reviewGroupBillList.getSelectedRows();
            reviewGroupIds = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).toArray();
            if (reviewGroupIds.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ReviewGroupToolPlugin_2", (String)"tdc-oatr-formplugin", (Object[])new Object[0]));
                return;
            }
            try {
                this.stopCollaborate(reviewGroupIds);
            }
            catch (Exception exception) {
                logger.error("stopCollaborate fail", (Throwable)exception);
                String tips3 = ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002", (String)"ReviewGroupToolPlugin_10", (String)"tdc-oatr-formplugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(tips3);
                return;
            }
            tips = ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"ReviewGroupToolPlugin_9", (String)"tdc-oatr-formplugin", (Object[])new Object[0]);
            this.getView().showSuccessNotification(tips);
            this.refreshGroupBillList(reviewGroupBillList);
        }
    }

    private void stopCollaborate(Object[] reviewGroupIds) {
        this.setCollaborateStatus(reviewGroupIds, "0");
    }

    private void enableCollaborate(Object[] reviewGroupIds) {
        this.setCollaborateStatus(reviewGroupIds, "1");
    }

    private void setCollaborateStatus(Object[] reviewGroupIds, String status) {
        DynamicObject[] reviewGroup;
        if (HRArrayUtils.isEmpty((Object[])reviewGroupIds)) {
            return;
        }
        List groupIds = Arrays.stream(reviewGroupIds).map(id -> Long.valueOf(id.toString())).collect(Collectors.toList());
        for (DynamicObject group : reviewGroup = reviewGroupService.listReviewGroup(groupIds)) {
            DynamicObjectCollection entryEntity = group.getDynamicObjectCollection("entryentity");
            for (DynamicObject collator : entryEntity) {
                collator.set("colstatus", (Object)status);
            }
        }
        reviewApplicationService.sendMsgNotifyCollaborator(reviewGroup);
        reviewGroupService.saveReviewGroup(reviewGroup);
    }

    private void viewCollaborateList() {
        Long activityId = this.getActivityLongId(this.getView());
        DynamicObject[] reviewObjs = reviewObjectService.listJoinedReviewObjects(activityId.longValue());
        DynamicObject[] reviewGroups = reviewGroupService.listReviewGroupByActivity((Object)activityId);
        List collaboratorObjects = reviewApplicationService.getCollaboratorObjects(reviewObjs, reviewGroups);
        Set collaboratorObjIds = collaboratorObjects.stream().map(CollaboratorObject::getObjId).collect(Collectors.toSet());
        List noCollaboratorObjs = Arrays.stream(reviewObjs).filter(obj -> !collaboratorObjIds.contains(obj.getLong("id"))).sorted(Comparator.comparing(obj -> obj.getString("number"))).collect(Collectors.toList());
        for (DynamicObject noCollaboratorObj : noCollaboratorObjs) {
            long colId = noCollaboratorObj.getLong("id");
            String colNumber = noCollaboratorObj.getString("number");
            collaboratorObjects.add(0, new CollaboratorObject(Long.valueOf(0L), "", Long.valueOf(colId), colNumber));
        }
        List sortCollaboratorObj = collaboratorObjects.stream().sorted(Comparator.comparing(CollaboratorObject::getCollNumber).thenComparing(CollaboratorObject::getObjNumber)).collect(Collectors.toList());
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("oatr_reviewobjcollistpop");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setHasRight(true);
        showParameter.setCaption(ResManager.loadKDString((String)"\u76d8\u70b9\u5bf9\u8c61\u6e05\u5355", (String)"ReviewGroupToolPlugin_7", (String)"tdc-oatr-formplugin", (Object[])new Object[0]));
        showParameter.setCustomParam("list_select_review_objs", (Object)JsonUtils.toString(sortCollaboratorObj));
        this.getView().showForm(showParameter);
    }

    private void deleteReviewGroup() {
        BillList reviewGroupBillList = this.getReviewGroupBillList();
        ListSelectedRowCollection selectedRows = reviewGroupBillList.getSelectedRows();
        Object[] reviewGroupIds = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).toArray();
        Pair pair = this.haveModifyMutex(reviewGroupIds[0]);
        if (((Boolean)pair.getLeft()).booleanValue()) {
            this.getView().showTipNotification((String)pair.getRight());
            return;
        }
        boolean collaboratorPage = ManagerItemUtil.isCollaboratorPage(this.getView());
        String formId = collaboratorPage ? "oatr_colreviewgroup" : "oatr_reviewgroup";
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"delete", (String)formId, (Object[])reviewGroupIds, (OperateOption)OperateOption.create());
        if (operationResult.isSuccess()) {
            this.refreshGroupBillList(this.getReviewGroupBillList());
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"ReviewGroupToolPlugin_0", (String)"tdc-oatr-formplugin", (Object[])new Object[0]));
        } else {
            if (operationResult.getSuccessPkIds().size() != 0) {
                this.refreshGroupBillList(this.getReviewGroupBillList());
            }
            this.getView().showOperationResult(operationResult, ResManager.loadKDString((String)"\u5220\u9664", (String)"ReviewGroupToolPlugin_1", (String)"tdc-oatr-formplugin", (Object[])new Object[0]));
        }
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            parentView.invokeOperation("refresh");
            this.getView().sendFormAction(parentView);
        }
    }

    private void newReviewGroupFrom() {
        boolean collaboratorPage = ManagerItemUtil.isCollaboratorPage(this.getView());
        String formId = collaboratorPage ? "oatr_colreviewgroup" : "oatr_reviewgroup";
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId(formId);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("activityId", this.getActivityId(this.getView()));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, REVIEW_GROUP_BILL_LIST));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void showMaintainForm() {
        ListSelectedRowCollection selectedRows = this.getReviewGroupBillList().getSelectedRows();
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("oatr_maintaincollaborator");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("activityId", this.getActivityId(this.getView()));
        showParameter.setCustomParam("collaboration_flag", this.getView().getFormShowParameter().getCustomParam("collaboration_flag"));
        DynamicObject[] reviewGroupDOArr = REPOSITORY.query("id,entryentity,collaborator,colstatus,sortnum", new QFilter("id", "in", Arrays.asList(selectedRows.getPrimaryKeyValues())).toArray());
        showParameter.setCustomParam("groupInfo", (Object)JSONObject.toJSONString(Arrays.stream(reviewGroupDOArr).map(group -> new ReviewGroupInfo(group.getLong("id"), group.getString("sortnum"), group.getString("number"))).collect(Collectors.toList())));
        Map<Long, List<ReviewGroupCollaboratorInfo>> map = Arrays.stream(reviewGroupDOArr).map(group -> {
            DynamicObjectCollection entryEntity = group.getDynamicObjectCollection("entryentity");
            ArrayList<ReviewGroupCollaboratorInfo> reviewGroupCollaboratorInfoList = new ArrayList<ReviewGroupCollaboratorInfo>(entryEntity.size());
            for (DynamicObject dynamicObject : entryEntity) {
                ReviewGroupCollaboratorInfo info = new ReviewGroupCollaboratorInfo(group.getLong("id"), dynamicObject.getLong(PropUtils.getIdDot((String)"collaborator")), dynamicObject.getString("colstatus"));
                reviewGroupCollaboratorInfoList.add(info);
            }
            return reviewGroupCollaboratorInfoList;
        }).flatMap(Collection::stream).collect(Collectors.groupingBy(ReviewGroupCollaboratorInfo::getUserId));
        ArrayList collaboratorInfoList = new ArrayList(map.size());
        map.forEach((userId, info) -> {
            List<Long> collect = info.stream().map(ReviewGroupCollaboratorInfo::getGroupId).distinct().collect(Collectors.toList());
            if (this.listEquals(collect, Arrays.stream(selectedRows.getPrimaryKeyValues()).map(obj -> (Long)obj).distinct().collect(Collectors.toList()))) {
                for (ReviewGroupCollaboratorInfo reviewGroupCollaboratorInfo : info) {
                    if (!collaboratorInfoList.stream().noneMatch(l -> l.getUserId() == reviewGroupCollaboratorInfo.getUserId())) continue;
                    collaboratorInfoList.add(reviewGroupCollaboratorInfo);
                }
            }
        });
        showParameter.setCustomParam("collaborator", (Object)JSONObject.toJSONString(collaboratorInfoList));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "maintainCollaborator");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
        boolean collaboratorPage = ManagerItemUtil.isCollaboratorPage(this.getView());
        String formId = collaboratorPage ? "oatr_colreviewgroup" : "oatr_reviewgroup";
        Arrays.stream(reviewGroupDOArr).map(dy -> dy.getString("id")).forEach(groupId -> ReviewToolMutexHelper.requireMutex(formId, groupId, "modify", new StringBuilder()));
    }

    private boolean listEquals(List<Long> list1, List<Long> list2) {
        if (list1.size() != list2.size()) {
            return false;
        }
        Collections.sort(list1);
        Collections.sort(list2);
        for (int i = 0; i < list1.size(); ++i) {
            if (list1.get(i).equals(list2.get(i))) continue;
            return false;
        }
        return true;
    }

    private void filterActivity(BillList reviewGroupBillList) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object activityId = formShowParameter.getCustomParam("activityId");
        QFilter qFilter = new QFilter("reviewactivity.id", "=", activityId);
        if (ManagerItemUtil.isCollaboratorPage(this.getView())) {
            qFilter.and(new QFilter("id", "in", (Object)this.collaborateGroupIdList(this.getView())));
        }
        reviewGroupBillList.setFilter(qFilter);
    }

    public void setFilter(SetFilterEvent evt) {
        String key;
        Object source = evt.getSource();
        if (source instanceof BillList && REVIEW_GROUP_BILL_LIST.equals(key = ((BillList)evt.getSource()).getKey())) {
            evt.setOrderBy(ORDER_BY);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String key = ((BillList)evt.getSource()).getKey();
        if (REVIEW_GROUP_BILL_LIST.equals(key)) {
            String fieldName = evt.getFieldName();
            ListSelectedRow currentRow = ((BillListHyperLinkClickEvent)evt).getCurrentRow();
            Object primaryKeyValue = currentRow.getPrimaryKeyValue();
            ReviewActivityApplicationService reviewService = (ReviewActivityApplicationService)ServiceFactory.getService(ReviewActivityApplicationService.class);
            boolean existsReviewGroup = reviewService.isExistsReviewGroup(primaryKeyValue);
            if (!existsReviewGroup) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"ReviewGroupToolPlugin_3", (String)"tdc-oatr-formplugin", (Object[])new Object[0]));
                return;
            }
            ReviewPermUtils permUtils = ReviewPermUtils.getInstance();
            boolean collaboratorPage = ManagerItemUtil.isCollaboratorPage(this.getView());
            String formId = collaboratorPage ? "oatr_colreviewgroup" : "oatr_reviewgroup";
            boolean hasQueryPerm = permUtils.hasPerm(formId);
            if ("number".equals(fieldName)) {
                this.hyperLinkClickNumber(currentRow, primaryKeyValue);
            }
            if (!hasQueryPerm) {
                String noPermTip = permUtils.getNoPermTip(ResManager.loadKDString((String)"\u76d8\u70b9\u7ec4\u53ca\u534f\u4f5c\u4eba\u5458", (String)"ReviewGroupToolPlugin_5", (String)"tdc-oatr-formplugin", (Object[])new Object[0]), PermItemName.QUERY.getName());
                this.getView().showErrorNotification(noPermTip);
                return;
            }
            if (KEY_GROUP_REVIEW_OBJ_NUM.equals(fieldName)) {
                String name = ((BillListHyperLinkClickEvent)evt).getCurrentRow().getName();
                this.hyperLinkClickGroupObjNum((Long)primaryKeyValue, name);
            }
            if (KEY_REVIEW_OBJ_NUM.equals(fieldName)) {
                this.hyperLinkClickGroupCollaboratorObjNum(currentRow, (Long)primaryKeyValue);
            }
        }
    }

    private void hyperLinkClickGroupCollaboratorObjNum(ListSelectedRow currentRow, Long primaryKeyValue) {
        if (!this.checkPermConfirm(this.getView(), (key, value) -> this.getView().showConfirm(ResManager.loadKDString((String)"\u4f60\u7684\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u5237\u65b0\u6216\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"ReviewActivityDetailCommon_0", (String)"tdc-oatr-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK))) {
            return;
        }
        Object entryPrimaryKeyValue = currentRow.getEntryPrimaryKeyValue();
        DynamicObject reviewGroupById = reviewGroupService.getReviewGroupByColId((Object)this.getActivityLongId(this.getView()), entryPrimaryKeyValue);
        long collaboratorId = reviewGroupById.getLong("entryentity.collaborator");
        String collaboratorName = reviewGroupById.getString("entryentity.collaborator.name");
        Long activityId = this.getActivityLongId(this.getView());
        DynamicObject[] reviewObjs = reviewObjectService.listJoinedReviewObjects(this.getActivityLongId(this.getView()).longValue());
        reviewObjs = ReviewGroupToolEdit.filterReviewObjTalentFileBuByActivityBu(activityId, reviewObjs);
        Map groupReviewObjMap = reviewApplicationService.getGroupReviewObjMap(reviewObjs);
        DynamicObject[] reviewGroups = reviewGroupService.listReviewGroupByActivity((Object)activityId);
        Map colReviewObjectList = reviewApplicationService.getColReviewObjectList(reviewObjs, reviewGroups, groupReviewObjMap);
        Map groupColObjList = (Map)colReviewObjectList.get(primaryKeyValue);
        if (MapUtils.isEmpty((Map)groupColObjList)) {
            return;
        }
        List objList = (List)groupColObjList.get(collaboratorId);
        if (org.apache.commons.collections4.CollectionUtils.isEmpty((Collection)objList)) {
            return;
        }
        List<Long> objListSort = this.sortReviewObjById(objList);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("oatr_reviewobjlistpop");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setHasRight(true);
        showParameter.setCaption(String.format(ResManager.loadKDString((String)"%s\u76d8\u70b9\u5bf9\u8c61\u6e05\u5355", (String)"ReviewGroupToolPlugin_6", (String)"tdc-oatr-formplugin", (Object[])new Object[0]), collaboratorName));
        showParameter.setCustomParam("list_select_review_objs", objListSort);
        this.getView().showForm(showParameter);
    }

    private static DynamicObject[] filterReviewObjTalentFileBuByActivityBu(Long activityId, DynamicObject[] reviewObjs) {
        DynamicObject reviewActivity = reviewActivityService.getReviewActivity((Object)activityId);
        if (HRObjectUtils.isEmpty((Object)reviewActivity)) {
            return new DynamicObject[0];
        }
        long activityBu = reviewActivity.getLong("createorg.id");
        reviewObjs = (DynamicObject[])Arrays.stream(reviewObjs).filter(obj -> obj.getLong("talentfile.org.id") == activityBu).toArray(DynamicObject[]::new);
        return reviewObjs;
    }

    private void hyperLinkClickGroupObjNum(Long primaryKeyValue, String name) {
        if (!this.checkPermConfirm(this.getView(), (key, value) -> this.getView().showConfirm(ResManager.loadKDString((String)"\u4f60\u7684\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u5237\u65b0\u6216\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"ReviewActivityDetailCommon_0", (String)"tdc-oatr-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK))) {
            return;
        }
        Map groupReviewObjMap = reviewApplicationService.getGroupReviewObjMap(this.getActivityLongId(this.getView()).longValue());
        List objList = (List)groupReviewObjMap.get(primaryKeyValue);
        if (org.apache.commons.collections4.CollectionUtils.isEmpty((Collection)objList)) {
            return;
        }
        List<Long> objListSort = this.sortReviewObjById(objList);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("oatr_reviewobjlistpop");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setHasRight(true);
        showParameter.setCaption(String.format(ResManager.loadKDString((String)"%s\u76d8\u70b9\u5bf9\u8c61\u6e05\u5355", (String)"ReviewGroupToolPlugin_6", (String)"tdc-oatr-formplugin", (Object[])new Object[0]), name));
        showParameter.setCustomParam("list_select_review_objs", objListSort);
        this.getView().showForm(showParameter);
    }

    private List<Long> sortReviewObjById(List<Long> objList) {
        DynamicObject[] dynamicObjects = reviewObjectService.listReviewObject(objList);
        return Arrays.stream(dynamicObjects).sorted(Comparator.comparing(obj -> obj.getString("number"))).map(obj -> obj.getLong("id")).collect(Collectors.toList());
    }

    private void hyperLinkClickNumber(ListSelectedRow currentRow, Object primaryKeyValue) {
        String number = currentRow.getNumber();
        if (!this.checkPermConfirm(this.getView(), (key, value) -> this.getView().showConfirm(ResManager.loadKDString((String)"\u4f60\u7684\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u5237\u65b0\u6216\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"ReviewActivityDetailCommon_0", (String)"tdc-oatr-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK))) {
            return;
        }
        BaseShowParameter showParameter = new BaseShowParameter();
        boolean collaboratorPage = ManagerItemUtil.isCollaboratorPage(this.getView());
        String formId = collaboratorPage ? "oatr_colreviewgroup" : "oatr_reviewgroup";
        boolean hasEdit = ReviewPermUtils.getInstance().hasPerm(formId, "4715a0df000000ac");
        if (!hasEdit) {
            showParameter.setStatus(OperationStatus.VIEW);
        } else {
            showParameter.setStatus(OperationStatus.EDIT);
        }
        showParameter.setFormId(formId);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setPkId(primaryKeyValue);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, REVIEW_GROUP_BILL_LIST));
        boolean managerItem = this.checkPermByManagerItem(this.getView(), isCollaborator -> {
            if (!isCollaborator.booleanValue()) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u4f60\u7684\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u5237\u65b0\u6216\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"ReviewActivityColList_0", (String)"tdc-oatr-formplugin", (Object[])new Object[0]), MessageBoxOptions.None);
            } else {
                showParameter.setStatus(OperationStatus.VIEW);
                this.getView().showForm((FormShowParameter)showParameter);
            }
        });
        if (managerItem) {
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }
}

