/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.formplugin.web.activity.reviewobj;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.common.util.HRDyObjectPropUtil;
import kd.hr.hbp.common.util.HRImageUrlUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.tdc.oatr.bussiness.ServiceFactory;
import kd.tdc.oatr.bussiness.application.OnlineCalibrationApplicationService;
import kd.tdc.oatr.bussiness.queryservice.ReviewObjectQueryService;
import kd.tdc.oatr.bussiness.queryservice.ReviewTalentMapQueryService;
import kd.tdc.oatr.common.bo.gridtemplate.GridBlockInfo;
import kd.tdc.oatr.common.bo.onlinecalibration.CalibratePath;
import kd.tdc.oatr.common.bo.onlinecalibration.GridPersonInfo;
import kd.tdc.oatr.common.bo.onlinecalibration.PersonInfo;
import kd.tdc.oatr.common.bo.onlinecalibration.TalentMapInfo;
import kd.tdc.oatr.common.bo.talentmap.TalentMapConfigInfo;
import org.apache.commons.lang.StringUtils;

public class PreviewMapPlugin
extends HRDynamicFormBasePlugin {
    private final ReviewTalentMapQueryService talentMapQueryService = (ReviewTalentMapQueryService)ServiceFactory.getService(ReviewTalentMapQueryService.class);
    private final ReviewObjectQueryService reviewObjectQueryService = (ReviewObjectQueryService)ServiceFactory.getService(ReviewObjectQueryService.class);
    private final OnlineCalibrationApplicationService calibrationApplicationService = (OnlineCalibrationApplicationService)ServiceFactory.getService(OnlineCalibrationApplicationService.class);

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        long defaultMapId = this.setDefaultTalentMap();
        this.loadMapInfo(String.valueOf(defaultMapId));
        this.showDataRuleTip();
    }

    public void propertyChanged(PropertyChangedArgs args) {
        ChangeData[] changeSet;
        String newValue;
        super.propertyChanged(args);
        String name = args.getProperty().getName();
        if (HRStringUtils.equals((String)name, (String)"talentmap") && !StringUtils.isBlank((String)(newValue = (String)(changeSet = args.getChangeSet())[0].getNewValue())) && this.checkPermission()) {
            this.loadMapInfo(newValue);
        }
    }

    private boolean checkPermission() {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        List reviewObjIds = (List)showParameter.getCustomParam("selectReviewObjIds");
        if (CollectionUtils.isEmpty((Collection)reviewObjIds)) {
            return true;
        }
        String appId = "32J2T2KEXE6T";
        boolean hasPerm = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"oatr_reviewobject", (String)"3P+/T5BZ+DAZ");
        if (!hasPerm) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u4f60\u7684\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u5237\u65b0\u6216\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"PreviewMapPlugin_0", (String)"tdc-oatr-formplugin", (Object[])new Object[0]), MessageBoxOptions.None);
            return false;
        }
        QFilter selectObjIdFilter = new QFilter("id", "in", (Object)reviewObjIds);
        QFilter dataRuleFilter = PermissionServiceHelper.getDataRule((long)RequestContext.get().getCurrUserId(), (String)appId, (String)"oatr_reviewobject", (String)"3P+/T5BZ+DAZ");
        DynamicObject[] ruleReviewObjs = this.reviewObjectQueryService.listReviewObjectIdWithFilter(new QFilter[]{selectObjIdFilter, dataRuleFilter});
        if (ruleReviewObjs == null || ruleReviewObjs.length == 0) {
            showParameter.setCustomParam("successReviewObjIds", null);
        } else {
            reviewObjIds = Arrays.stream(ruleReviewObjs).map(obj -> obj.getLong("id")).collect(Collectors.toList());
            showParameter.setCustomParam("successReviewObjIds", reviewObjIds);
        }
        this.getView().cacheFormShowParameter();
        return true;
    }

    private void loadMapInfo(String mapId) {
        CustomControl gridControl = (CustomControl)this.getView().getControl("customcontrolap");
        if (gridControl == null) {
            return;
        }
        HashMap mapData = Maps.newHashMapWithExpectedSize((int)10);
        mapData.put("code", 200);
        mapData.put("success", true);
        mapData.put("eventName", "loadData");
        mapData.put("eventStatus", "init");
        mapData.put("times", System.currentTimeMillis());
        mapData.put("pageStatus", "view");
        TalentMapInfo talentMapInfo = this.getMapInfo(mapId);
        mapData.put("data", talentMapInfo);
        gridControl.setData((Object)mapData);
    }

    private TalentMapInfo getMapInfo(String mapId) {
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activityId");
        if (Objects.isNull(activityId) || activityId == 0L) {
            return null;
        }
        DynamicObject activity = this.talentMapQueryService.getOneTalentMapConfig(activityId, Long.valueOf(mapId));
        if (activity == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bab\u683c\u5730\u56fe\u5df2\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u88ab\u5176\u4ed6\u4eba\u5220\u9664\u4e86\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"CalibrateSessionEdit_4", (String)"tdc-oatr-formplugin", (Object[])new Object[0]));
            activity = this.talentMapQueryService.getDefaultTalentMapConfig(activityId);
            this.setDefaultTalentMap();
        }
        DynamicObjectCollection talentMapEntryCollection = activity.getDynamicObjectCollection("talentmapentry");
        DynamicObject talentMapEntry = (DynamicObject)talentMapEntryCollection.get(0);
        mapId = talentMapEntry.getString("id");
        String talentMapConfig = talentMapEntry.getString("talentmapconfig_tag");
        if (HRStringUtils.isEmpty((String)talentMapConfig)) {
            return null;
        }
        TalentMapConfigInfo talentMapConfigInfo = (TalentMapConfigInfo)SerializationUtils.fromJsonString((String)talentMapConfig, TalentMapConfigInfo.class);
        String xAxisDimName = talentMapEntry.getString("xaxisdim.name");
        String yAxisDimName = talentMapEntry.getString("yaxisdim.name");
        talentMapConfigInfo.getxAxisInfo().setName(xAxisDimName);
        talentMapConfigInfo.getyAxisInfo().setName(yAxisDimName);
        TalentMapInfo talentMapInfo = new TalentMapInfo();
        talentMapInfo.setxAxisInfo(talentMapConfigInfo.getxAxisInfo());
        talentMapInfo.setyAxisInfo(talentMapConfigInfo.getyAxisInfo());
        talentMapInfo.setGridData(talentMapConfigInfo.getGridData());
        List gridBlocks = talentMapConfigInfo.getGridData().getGridBlocks();
        int gridSize = gridBlocks.size();
        GridPersonInfo[] gridPersonInfos = new GridPersonInfo[gridSize];
        Map<String, String> gridNameMap = gridBlocks.stream().collect(Collectors.toMap(GridBlockInfo::getCustomNumber, gridBlock -> gridBlock.getName().getText(), (v1, v2) -> v1));
        List reviewObjIds = (List)this.getView().getFormShowParameter().getCustomParam("successReviewObjIds");
        if (CollectionUtils.isEmpty((Collection)reviewObjIds)) {
            return talentMapInfo;
        }
        DynamicObject[] reviewObjects = this.reviewObjectQueryService.getReviewObjectData(reviewObjIds);
        if (reviewObjects == null || reviewObjects.length == 0) {
            return talentMapInfo;
        }
        ArrayList<DynamicObject> reviewObjectList = new ArrayList<DynamicObject>(Arrays.asList(reviewObjects));
        Map<String, List<DynamicObject>> calibrateDataMap = this.getCalibrateDataMap(mapId, gridSize, reviewObjectList);
        List customNumberList = gridBlocks.stream().map(GridBlockInfo::getCustomNumber).collect(Collectors.toList());
        for (int i = 0; i < gridSize; ++i) {
            String gridNumber = (String)customNumberList.get(i);
            GridPersonInfo gridPersonInfo = new GridPersonInfo();
            gridPersonInfo.setGridNumber(gridNumber);
            gridPersonInfo.setGridName(gridNameMap.get(gridNumber));
            ArrayList calibrateDataList = calibrateDataMap.get(gridNumber);
            if (CollectionUtils.isEmpty(calibrateDataList)) {
                calibrateDataList = Lists.newArrayListWithCapacity((int)0);
            }
            ArrayList personInfoList = Lists.newArrayListWithExpectedSize((int)calibrateDataList.size());
            for (DynamicObject reviewObject : calibrateDataList) {
                Object mapResult2;
                PersonInfo personInfo = new PersonInfo();
                personInfo.setPersonId(reviewObject.getString("person.id"));
                personInfo.setPersonName(reviewObject.getString("person.name"));
                personInfo.setPersonNumber(reviewObject.getString("person.number"));
                personInfo.setHeadSculpture(HRImageUrlUtil.getImageFullUrl((String)reviewObject.getString("person.headsculpture")));
                personInfo.setDepartment(reviewObject.getLocaleString("adminorg.name").getLocaleValue());
                String jobName = this.getJobName(reviewObject);
                personInfo.setJob(jobName);
                DynamicObjectCollection superEvalCollection = reviewObject.getDynamicObjectCollection("supereval");
                String supervisor = superEvalCollection.stream().map(superEval -> HRDyObjectPropUtil.getName((DynamicObject)superEval.getDynamicObject("fbasedataid"))).collect(Collectors.joining(","));
                personInfo.setDirectSupervisor(supervisor);
                String calibrateResult = "";
                String calibrateBefore = "";
                DynamicObjectCollection mapResults = reviewObject.getDynamicObjectCollection("entryentity_map");
                for (Object mapResult2 : mapResults) {
                    if (!HRStringUtils.equals((String)mapId, (String)mapResult2.getString("mapkey"))) continue;
                    calibrateResult = mapResult2.getString("mapvalue");
                    break;
                }
                DynamicObjectCollection beforeMapResults = reviewObject.getDynamicObjectCollection("entryentity_mapbefore");
                mapResult2 = beforeMapResults.iterator();
                while (mapResult2.hasNext()) {
                    DynamicObject mapResult3 = (DynamicObject)mapResult2.next();
                    if (!HRStringUtils.equals((String)mapId, (String)mapResult3.getString("mapbeforekey"))) continue;
                    calibrateBefore = mapResult3.getString("mapbeforevalue");
                    break;
                }
                CalibratePath calibratePath = new CalibratePath();
                calibratePath.setBeforeCard(this.calibrationApplicationService.transCalibratePositionToPath(calibrateBefore));
                calibratePath.setAfterCard(this.calibrationApplicationService.transCalibratePositionToPath(HRStringUtils.isNotEmpty((String)calibrateResult) ? calibrateResult : calibrateBefore));
                personInfo.setCalibrated(HRStringUtils.isNotEmpty((String)calibrateResult) && !HRStringUtils.equals((String)calibrateBefore, (String)calibrateResult));
                personInfo.setCalibratePath(calibratePath);
                personInfoList.add(personInfo);
            }
            gridPersonInfo.setPersonInfo(personInfoList.toArray(new PersonInfo[0]));
            gridPersonInfos[i] = gridPersonInfo;
        }
        talentMapInfo.setGridPersonInfo(gridPersonInfos);
        return talentMapInfo;
    }

    private Map<String, List<DynamicObject>> getCalibrateDataMap(String mapId, int gridSize, List<DynamicObject> reviewObjectList) {
        HashMap calibrateDataMap = Maps.newHashMapWithExpectedSize((int)gridSize);
        for (DynamicObject reviewObject : reviewObjectList) {
            String gridNumber;
            Object mapResult2;
            String calibrateBefore = "";
            String calibrateResult = "";
            DynamicObjectCollection beforeMapResults = reviewObject.getDynamicObjectCollection("entryentity_mapbefore");
            for (Object mapResult2 : beforeMapResults) {
                if (!HRStringUtils.equals((String)mapId, (String)mapResult2.getString("mapbeforekey"))) continue;
                calibrateBefore = mapResult2.getString("mapbeforevalue");
                break;
            }
            DynamicObjectCollection mapResults = reviewObject.getDynamicObjectCollection("entryentity_map");
            mapResult2 = mapResults.iterator();
            while (mapResult2.hasNext()) {
                DynamicObject mapResult3 = (DynamicObject)mapResult2.next();
                if (!HRStringUtils.equals((String)mapId, (String)mapResult3.getString("mapkey"))) continue;
                calibrateResult = mapResult3.getString("mapvalue");
                break;
            }
            if (HRStringUtils.isEmpty((String)calibrateBefore) && HRStringUtils.isEmpty((String)calibrateResult) || HRStringUtils.isEmpty((String)(gridNumber = this.getCalibratePositionNumber(HRStringUtils.isNotEmpty((String)calibrateResult) ? calibrateResult : calibrateBefore)))) continue;
            List calibrateDataList = (List)calibrateDataMap.get(gridNumber);
            if (CollectionUtils.isEmpty((Collection)calibrateDataList)) {
                calibrateDataList = Lists.newArrayListWithExpectedSize((int)10);
                calibrateDataMap.put(gridNumber, calibrateDataList);
            }
            calibrateDataList.add(reviewObject);
        }
        return calibrateDataMap;
    }

    private String getJobName(DynamicObject reviewObject) {
        String posPattern = reviewObject.getString("pospattern");
        String jobName = "";
        switch (posPattern) {
            case "0": {
                ILocaleString stdPosition = reviewObject.getLocaleString("stdposition.name");
                if (Objects.isNull(stdPosition)) break;
                jobName = stdPosition.getLocaleValue();
                break;
            }
            case "1": {
                ILocaleString position = reviewObject.getLocaleString("position.name");
                if (Objects.isNull(position)) break;
                jobName = position.getLocaleValue();
                break;
            }
            case "2": {
                ILocaleString job = reviewObject.getLocaleString("job.name");
                if (Objects.isNull(job)) break;
                jobName = job.getLocaleValue();
                break;
            }
        }
        return jobName;
    }

    private long setDefaultTalentMap() {
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activityId");
        if (Objects.isNull(activityId) || activityId == 0L) {
            return 0L;
        }
        HashMap talentMapName = Maps.newHashMapWithExpectedSize((int)3);
        long defaultMapId = this.getTalentMapName(activityId, talentMapName);
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl("talentmap");
        ArrayList comboItems = Lists.newArrayListWithExpectedSize((int)talentMapName.size());
        talentMapName.forEach((mapId, mapName) -> comboItems.add(new ComboItem(new LocaleString(mapName), mapId)));
        comboEdit.setComboItems((List)comboItems);
        this.getModel().setValue("talentmap", (Object)defaultMapId);
        return defaultMapId;
    }

    private long getTalentMapName(Long activityId, Map<String, String> talentMapName) {
        long defaultMapId = 0L;
        DynamicObject activity = this.talentMapQueryService.getReviewTalentMapActivity(activityId);
        DynamicObjectCollection talentMapEntry = activity.getDynamicObjectCollection("talentmapentry");
        for (DynamicObject mapInfo : talentMapEntry) {
            long mapId = HRDyObjectPropUtil.getId((DynamicObject)mapInfo);
            String xAxisDimName = HRDyObjectPropUtil.getName((DynamicObject)mapInfo.getDynamicObject("xaxisdim"));
            String yAxisDimName = HRDyObjectPropUtil.getName((DynamicObject)mapInfo.getDynamicObject("yaxisdim"));
            if (HRStringUtils.isEmpty((String)xAxisDimName) || HRStringUtils.isEmpty((String)yAxisDimName)) continue;
            boolean isDefaultMap = mapInfo.getBoolean("isdefaultmap");
            if (isDefaultMap) {
                defaultMapId = mapId;
            }
            talentMapName.put(String.valueOf(mapId), xAxisDimName + "+" + yAxisDimName);
        }
        return defaultMapId;
    }

    private String getCalibratePositionNumber(String calibratePosition) {
        if (HRStringUtils.isEmpty((String)calibratePosition)) {
            return "";
        }
        String[] split = calibratePosition.trim().split("-");
        if (split.length != 2) {
            return "";
        }
        return split[0];
    }

    private void showDataRuleTip() {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        List selectReviewObjIds = (List)showParameter.getCustomParam("selectReviewObjIds");
        List successReviewObjIds = (List)showParameter.getCustomParam("successReviewObjIds");
        selectReviewObjIds.removeAll(successReviewObjIds);
        DynamicObject[] reviewObjs = this.reviewObjectQueryService.listReviewObjectDataWithFilter(selectReviewObjIds, (List)Lists.newArrayListWithCapacity((int)0));
        if (reviewObjs == null || reviewObjs.length == 0) {
            return;
        }
        String msg = ResManager.loadKDString((String)"{0}\uff0c\u5171{1}\u4eba\u4e0d\u80fd\u67e5\u770b\u5bab\u683c\u5206\u5e03\u3002\u60a8\u6ca1\u6709\u3010\u76d8\u70b9\u5bf9\u8c61\u3011\u3010\u67e5\u770b\u5bab\u683c\u5206\u5e03\u3011\u7684\u6570\u636e\u89c4\u5219\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PreviewMapPlugin_1", (String)"tdc-oatr-formplugin", (Object[])new Object[0]);
        String comma = ResManager.loadKDString((String)"\u3001", (String)"PreviewMapPlugin_2", (String)"tdc-oatr-formplugin", (Object[])new Object[0]);
        StringBuilder personTip = new StringBuilder();
        int maxIndex = Math.min(reviewObjs.length, 3);
        for (int i = 0; i < maxIndex; ++i) {
            personTip.append(reviewObjs[i].getString("person.name")).append(comma);
        }
        personTip = new StringBuilder(personTip.substring(0, personTip.length() - comma.length()));
        if (reviewObjs.length > 3) {
            personTip.append("...");
        }
        this.getView().showTipNotification(MessageFormat.format(msg, personTip.toString(), reviewObjs.length));
    }
}

