/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.formplugin.web.activity.reviewobj;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.tdc.oatr.common.constants.enums.ObjectStatusEnum;

public class RecommendTalentPlugin
extends HRDynamicFormBasePlugin {
    private static final String OPKEY_ADD = "add";
    private static final String OPKEY_DELETE = "delete";
    private static final String OPKEY_CONFIRM = "confirm";
    private static final String FIELD_TALENTPOOL = "talentpool";
    private static final String ENTRY_ENTRYENTITY = "entryentity";
    private static final String ACTION_ADD_REVIEW_OBJ = "addReviewObj";

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        this.setCreateOrg();
        this.setReviewObjectData();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        int cancelRight = this.getView().getParentView().getFormShowParameter().getCancelRight();
        if (cancelRight != 0) {
            String errContent = ResManager.loadKDString((String)"\u4f60\u7684\u6570\u636e\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u5237\u65b0\u6216\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"ReviewActivityColList_1", (String)"tdc-oatr-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(errContent, MessageBoxOptions.None);
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)OPKEY_ADD) && this.isOpSuccess(afterDoOperationEventArgs)) {
            this.addEntry();
        }
        if (HRStringUtils.equals((String)operateKey, (String)OPKEY_DELETE) && this.isOpSuccess(afterDoOperationEventArgs)) {
            this.deleteEntry();
        }
        if (HRStringUtils.equals((String)operateKey, (String)OPKEY_CONFIRM) && this.isOpSuccess(afterDoOperationEventArgs)) {
            this.confirm();
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String name = args.getProperty().getName();
        if (HRStringUtils.equals((String)name, (String)FIELD_TALENTPOOL)) {
            ChangeData[] changeSet = args.getChangeSet();
            DynamicObject newValue = (DynamicObject)changeSet[0].getNewValue();
            if (newValue == null) {
                return;
            }
            DynamicObjectCollection recommendTalentEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_ENTRYENTITY);
            if (recommendTalentEntry.isEmpty()) {
                return;
            }
            int row = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTRYENTITY);
            List<String> talentPoolKeys = this.getTalentPoolKeyList(recommendTalentEntry, row);
            if (talentPoolKeys.isEmpty()) {
                return;
            }
            DynamicObject reviewObject = (DynamicObject)this.getModel().getValue("reviewobject", row);
            if (reviewObject == null) {
                return;
            }
            Long reviewObjId = reviewObject.getLong("id");
            long newPoolId = newValue.getLong("id");
            String key = reviewObjId + String.valueOf(newPoolId);
            if (talentPoolKeys.contains(key)) {
                String errorInfo = ResManager.loadKDString((String)"\u5f53\u524d\u5217\u8868\u4e2d\u5df2\u5b58\u5728\u91cd\u590d\u6570\u636e\uff0c\u8bf7\u52ff\u91cd\u590d\u7ef4\u62a4\u3002", (String)"RecommendTalentPlugin_0", (String)"tdc-oatr-formplugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(errorInfo);
                this.getModel().setValue(name, null, row);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (ACTION_ADD_REVIEW_OBJ.equals(actionId) && (returnData = closedCallBackEvent.getReturnData()) != null) {
            ListSelectedRowCollection listSelectedRows = (ListSelectedRowCollection)returnData;
            List<Object> selReviewObjIds = listSelectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
            this.createEntry(selReviewObjIds);
        }
    }

    private void confirm() {
        DynamicObjectCollection recommendTalentEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_ENTRYENTITY);
        if (recommendTalentEntry.isEmpty()) {
            String errorInfo = ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"RecommendTalentPlugin_1", (String)"tdc-oatr-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(errorInfo);
            return;
        }
        List<Map<String, Object>> recommendTalentDataList = this.getRecommendTalentDataList(recommendTalentEntry);
        this.getView().returnDataToParent(recommendTalentDataList);
        this.getView().close();
    }

    private List<Map<String, Object>> getRecommendTalentDataList(DynamicObjectCollection recommendTalentEntry) {
        ArrayList recommendTalentData = Lists.newArrayListWithCapacity((int)recommendTalentEntry.size());
        if (recommendTalentEntry.isEmpty()) {
            return recommendTalentData;
        }
        for (DynamicObject talentRow : recommendTalentEntry) {
            HashMap talentInfoMap = Maps.newHashMapWithExpectedSize((int)5);
            talentInfoMap.put("reviewObjectId", talentRow.getLong("reviewobjectid"));
            talentInfoMap.put("talentFileId", talentRow.getLong("talentfileid"));
            talentInfoMap.put("reviewObjName", talentRow.getString("reviewobjname"));
            talentInfoMap.put("recommendPoolId", talentRow.getLong("talentpool.id"));
            talentInfoMap.put("recommendPoolName", talentRow.getString("talentpool.name"));
            talentInfoMap.put("recommendReason", talentRow.getString("reason"));
            recommendTalentData.add(talentInfoMap);
        }
        return recommendTalentData;
    }

    private void deleteEntry() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRY_ENTRYENTITY);
        int[] selectRows = entryGrid.getSelectRows();
        this.getModel().deleteEntryRows(ENTRY_ENTRYENTITY, selectRows);
    }

    private void addEntry() {
        Object collaborationFlag = this.getView().getFormShowParameter().getCustomParam("collaboration_flag");
        Object activityId = this.getView().getFormShowParameter().getCustomParam("activityId");
        ListShowParameter showListForm = ShowFormHelper.createShowListForm((String)"oatr_reviewobjectf7", (boolean)true);
        showListForm.setCustomParam("activityId", activityId);
        showListForm.setCustomParam("collaboration_flag", collaborationFlag);
        showListForm.getOpenStyle().setShowType(ShowType.Modal);
        showListForm.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ACTION_ADD_REVIEW_OBJ));
        ListFilterParameter filterParameter = new ListFilterParameter();
        filterParameter.getQFilters().add(new QFilter("reviewstatus", "!=", (Object)ObjectStatusEnum.UN_IN.getCode()));
        showListForm.setListFilterParameter(filterParameter);
        this.getView().showForm((FormShowParameter)showListForm);
    }

    private List<String> getTalentPoolKeyList(DynamicObjectCollection recommendTalentEntry, int row) {
        ArrayList talentPoolIdKeys = Lists.newArrayListWithExpectedSize((int)recommendTalentEntry.size());
        for (int i = 0; i < recommendTalentEntry.size(); ++i) {
            if (i == row) continue;
            DynamicObject entry = (DynamicObject)recommendTalentEntry.get(i);
            long reviewObjId = entry.getLong("reviewobject.id");
            long talentPoolId = entry.getLong("talentpool.id");
            if (reviewObjId == 0L || talentPoolId == 0L) continue;
            talentPoolIdKeys.add(reviewObjId + String.valueOf(talentPoolId));
        }
        return talentPoolIdKeys;
    }

    private boolean isOpSuccess(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        if (afterDoOperationEventArgs.getOperationResult() != null) {
            return afterDoOperationEventArgs.getOperationResult().isSuccess();
        }
        return false;
    }

    private void setCreateOrg() {
        Object createOrg = this.getView().getFormShowParameter().getCustomParam("createorg");
        if (createOrg != null) {
            this.getModel().setValue("createorg", (Object)Long.valueOf(createOrg.toString()));
        }
    }

    private void setReviewObjectData() {
        Object reviewObjectIdsJson = this.getView().getFormShowParameter().getCustomParam("reviewObjectIds");
        if (reviewObjectIdsJson != null) {
            List reviewObjIds = (List)SerializationUtils.fromJsonString((String)reviewObjectIdsJson.toString(), List.class);
            this.createEntry(reviewObjIds);
        }
    }

    private void createEntry(List<Object> reviewObjIds) {
        if (reviewObjIds.size() == 0) {
            return;
        }
        int[] entryRows = this.getModel().batchCreateNewEntryRow(ENTRY_ENTRYENTITY, reviewObjIds.size());
        for (int i = 0; i < entryRows.length; ++i) {
            this.getModel().setValue("reviewobject", (Object)Long.valueOf(reviewObjIds.get(i).toString()), entryRows[i]);
            DynamicObject reviewObject = (DynamicObject)this.getModel().getValue("reviewobject", entryRows[i]);
            this.getModel().setValue("reviewobjectid", (Object)reviewObject.getLong("id"), entryRows[i]);
            this.getModel().setValue("talentfileid", (Object)reviewObject.getLong("talentfile.id"), entryRows[i]);
            this.getModel().setValue("reviewobjname", (Object)reviewObject.getString("name"), entryRows[i]);
        }
    }
}

