/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.formplugin.web.activity.reviewobj;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.TextProp;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tdc.oatr.bussiness.ServiceFactory;
import kd.tdc.oatr.bussiness.queryservice.ReviewActivityQueryService;
import kd.tdc.oatr.common.bo.DimValidateResultInfo;
import kd.tdc.oatr.common.bo.ReviewImportFieldInfo;
import kd.tdc.oatr.common.bo.ValidateResult;
import kd.tdc.oatr.common.constants.enums.MapAxisValueTypeEnum;
import kd.tdc.oatr.common.constants.enums.MapValidateResultCode;
import kd.tdc.oatr.common.utils.PropUtils;
import org.apache.commons.lang3.StringUtils;

@FunctionalInterface
public interface ReviewImportFun {
    public static final Log LOG = LogFactory.getLog(ReviewImportFun.class);

    public ValidateResult execute(ReviewImportFunBO var1);

    public static ReviewImportFun personVerify() {
        return reviewImportFunBO -> {
            boolean result;
            JSONObject jsonObject = reviewImportFunBO.rowJson;
            String number = jsonObject.getString("number");
            String name = ReviewImportFun.getName(jsonObject);
            Optional<DynamicObject> filterOp = Arrays.stream(reviewImportFunBO.dynamicObjects).filter(dy -> HRStringUtils.equals((String)number, (String)dy.getString("number"))).findFirst();
            if (!filterOp.isPresent()) {
                result = false;
            } else {
                result = HRStringUtils.equals((String)name, (String)filterOp.get().getString("name"));
                if (result) {
                    result = !HRStringUtils.equals((String)filterOp.get().getString("reviewstatus"), (String)"E");
                }
            }
            return ReviewImportFun.genResult(result, ResManager.loadKDString((String)"\u4eba\u624d\u6863\u6848\u4e0d\u5b58\u5728\uff1b", (String)"ReviewImportFun_0", (String)"tdc-oatr-formplugin", (Object[])new Object[0]));
        };
    }

    public static String getName(JSONObject jsonObject) {
        JSONObject nameJsonObj = jsonObject.getJSONObject("name");
        String name = null;
        if (!CollectionUtils.isEmpty((Map)nameJsonObj)) {
            name = nameJsonObj.getString(Lang.get().getLocale().toString());
        }
        return name;
    }

    public static ReviewImportFun personRangeVerify() {
        return reviewImportFunBO -> {
            Object permVerifyObj = reviewImportFunBO.othParam.get("permVerify");
            if (Objects.isNull(permVerifyObj)) {
                return ReviewImportFun.genResult(false, ResManager.loadKDString((String)"\u5f53\u524d\u6d3b\u52a8\u4e0b\u65e0\u4eba\u624d\u6863\u6848\u6570\u636e\u6743\u9650\uff1b", (String)"ReviewImportFun_1", (String)"tdc-oatr-formplugin", (Object[])new Object[0]));
            }
            DynamicObject[] dynamicObjects = (DynamicObject[])permVerifyObj;
            if (((Boolean)reviewImportFunBO.othParam.get("isCollaborator")).booleanValue()) {
                String collaborator_group = (String)reviewImportFunBO.othParam.get("collaborator_group");
                List collaboratorGroupIdList = JSONObject.parseArray((String)collaborator_group, Long.class);
                dynamicObjects = (DynamicObject[])Arrays.stream(dynamicObjects).filter(dy -> collaboratorGroupIdList.contains(dy.getLong(PropUtils.getIdDot((String)"reviewgroup")))).toArray(DynamicObject[]::new);
            }
            String number = reviewImportFunBO.rowJson.getString("number");
            String name = ReviewImportFun.getName(reviewImportFunBO.rowJson);
            boolean result = Arrays.stream(dynamicObjects).anyMatch(tFile -> HRStringUtils.equals((String)number, (String)tFile.getString("number")) && HRStringUtils.equals((String)name, (String)tFile.getString("name")));
            LOG.info("importDyCol.personRangeVerify, personNumber:{},personName:{},result:{}", new Object[]{number, name, result});
            return ReviewImportFun.genResult(result, ResManager.loadKDString((String)"\u5f53\u524d\u6d3b\u52a8\u4e0b\u65e0\u4eba\u624d\u6863\u6848\u6570\u636e\u6743\u9650\uff1b", (String)"ReviewImportFun_1", (String)"tdc-oatr-formplugin", (Object[])new Object[0]));
        };
    }

    public static ReviewImportFun evalValueExistVerify() {
        return reviewImportFunBO -> {
            String rowImportType = reviewImportFunBO.rowImportType;
            JSONObject rowJson = reviewImportFunBO.rowJson;
            ArrayList<String> errorMsg = new ArrayList<String>(10);
            List fieldInfoList = (List)reviewImportFunBO.othParam.get("dyFieldInfo");
            ArrayList<String> overLenEvalNameList = new ArrayList<String>(10);
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"oatr_reviewobject");
            TextProp entityProperty = (TextProp)dataEntityType.getAllFields().get("dimensionvalue");
            int MAX_LEN = entityProperty.getMaxLenth();
            for (ReviewImportFieldInfo fieldInfo : fieldInfoList) {
                String dimId = (String)fieldInfo.getKeyMap().get("dimId");
                String evaluationItemNum = (String)fieldInfo.getKeyMap().get("evaluationItemNum");
                for (DynamicObject dynamicObject : reviewImportFunBO.dynamicObjects) {
                    String evalValue;
                    JSONObject dimJson;
                    String number = dynamicObject.getString("number");
                    if (!HRStringUtils.equals((String)number, (String)rowJson.getString("number")) || !HRStringUtils.equals((String)dynamicObject.getString("name"), (String)ReviewImportFun.getName(rowJson)) || CollectionUtils.isEmpty((Map)(dimJson = rowJson.getJSONObject(dimId))) || HRStringUtils.isEmpty((String)(evalValue = dimJson.getString(evaluationItemNum)))) continue;
                    if (evalValue.length() > MAX_LEN) {
                        overLenEvalNameList.add(fieldInfo.getName());
                    }
                    DynamicObjectCollection evalEntryEntity = dynamicObject.getDynamicObjectCollection("entryentity_dimeval");
                    Optional<DynamicObject> entryRowOp = evalEntryEntity.stream().filter(evalInfo -> HRStringUtils.equals((String)dimId, (String)evalInfo.getString(PropUtils.getIdDot((String)"evaldim"))) && HRStringUtils.equals((String)evaluationItemNum, (String)evalInfo.getString(PropUtils.getNumberDot((String)"dimevalitem")))).findFirst();
                    if (HRStringUtils.equals((String)rowImportType, (String)"new") && entryRowOp.isPresent()) {
                        errorMsg.add(String.format(ResManager.loadKDString((String)"%s\u6570\u636e\u5df2\u5b58\u5728\uff1b", (String)"ReviewImportFun_2", (String)"tdc-oatr-formplugin", (Object[])new Object[0]), fieldInfo.getName()));
                    }
                    if (!HRStringUtils.equals((String)rowImportType, (String)"update") || entryRowOp.isPresent()) continue;
                    errorMsg.add(String.format(ResManager.loadKDString((String)"%s\u4e0d\u5b58\u5728\u9700\u66f4\u65b0\u7684\u7ed3\u679c\u6570\u636e\uff1b", (String)"ReviewImportFun_3", (String)"tdc-oatr-formplugin", (Object[])new Object[0]), fieldInfo.getName()));
                }
            }
            if (!overLenEvalNameList.isEmpty()) {
                errorMsg.add(String.format(ResManager.loadKDString((String)"%1$s\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7%2$s\u4e2a\u5b57\u7b26\uff1b", (String)"ReviewImportFun_10", (String)"tdc-oatr-formplugin", (Object[])new Object[0]), StringUtils.join(overLenEvalNameList, (String)"\uff0c"), MAX_LEN));
            }
            return ReviewImportFun.genResult(CollectionUtils.isEmpty(errorMsg), Joiner.on((char)' ').skipNulls().join(errorMsg));
        };
    }

    public static ReviewImportFun evaluationItemExistVerify() {
        return reviewImportFunBO -> {
            JSONObject rowJson = reviewImportFunBO.rowJson;
            DynamicObject[] dynamicObjects = reviewImportFunBO.dynamicObjects;
            List fieldInfoList = (List)reviewImportFunBO.othParam.get("dyFieldInfo");
            DynamicObject reviewDimension = (DynamicObject)reviewImportFunBO.othParam.get("reviewDimension");
            ArrayList errorMsgList = new ArrayList(10);
            Arrays.stream(dynamicObjects).filter(reviewObj -> HRStringUtils.equals((String)reviewObj.getString("number"), (String)rowJson.getString("number")) && HRStringUtils.equals((String)reviewObj.getString("name"), (String)ReviewImportFun.getName(rowJson))).findFirst().ifPresent(reviewObj -> {
                if (CollectionUtils.isEmpty((Collection)fieldInfoList)) {
                    errorMsgList.add(ResManager.loadKDString((String)"\u6d3b\u52a8\u8bc4\u4f30\u9879\u53d8\u66f4\uff0c\u8bf7\u91cd\u65b0\u4e0b\u8f7d\u6a21\u677f\uff1b", (String)"ReviewImportFun_7", (String)"tdc-oatr-formplugin", (Object[])new Object[0]));
                    return;
                }
                for (ReviewImportFieldInfo reviewImportFieldInfo : fieldInfoList) {
                    String evalItemJson;
                    String dimId = (String)reviewImportFieldInfo.getKeyMap().get("dimId");
                    String evaluationItemNum = (String)reviewImportFieldInfo.getKeyMap().get("evaluationItemNum");
                    JSONObject excelDataRowJson = rowJson.getJSONObject(dimId);
                    if (CollectionUtils.isEmpty((Map)excelDataRowJson) || !HRStringUtils.isNotEmpty((String)(evalItemJson = excelDataRowJson.getString(evaluationItemNum)))) continue;
                    DynamicObjectCollection dimEntry = reviewDimension.getDynamicObjectCollection("dimesionentry");
                    Optional<DynamicObject> dimensionOp = dimEntry.stream().filter(dimEntryRow -> HRStringUtils.equals((String)dimId, (String)dimEntryRow.getString(PropUtils.getIdDot((String)"reviewdimension")))).findFirst();
                    if (!dimensionOp.isPresent()) {
                        errorMsgList.add(String.format(ResManager.loadKDString((String)"\u4eba\u624d\u672a\u5173\u8054\u8bc4\u4f30\u9879\uff1a%s\uff1b", (String)"ReviewImportFun_6", (String)"tdc-oatr-formplugin", (Object[])new Object[0]), reviewImportFieldInfo.getName()));
                        continue;
                    }
                    dimensionOp.ifPresent(dimEntryRow -> {
                        Optional<DynamicObject> evaluationItemOp = dimEntryRow.getDynamicObjectCollection("dimevaluation").stream().filter(evalItemMul -> HRStringUtils.equals((String)evalItemMul.getString(PropUtils.getNumberDot((String)"fbasedataid")), (String)evaluationItemNum)).findFirst();
                        if (!evaluationItemOp.isPresent()) {
                            errorMsgList.add(String.format(ResManager.loadKDString((String)"\u4eba\u624d\u672a\u5173\u8054\u8bc4\u4f30\u9879\uff1a%s\uff1b", (String)"ReviewImportFun_6", (String)"tdc-oatr-formplugin", (Object[])new Object[0]), reviewImportFieldInfo.getName()));
                        }
                    });
                }
            });
            return ReviewImportFun.genResult(CollectionUtils.isEmpty(errorMsgList), Joiner.on((char)' ').skipNulls().join(errorMsgList));
        };
    }

    public static ReviewImportFun activityStatusVerify() {
        return reviewImportFunBO -> {
            boolean activityIsEnd;
            Object activityEndObj = reviewImportFunBO.othParam.get("activityEnd");
            if (Objects.nonNull(activityEndObj)) {
                activityIsEnd = (Boolean)activityEndObj;
            } else {
                long reviewActivityId = reviewImportFunBO.dynamicObjects[0].getLong(PropUtils.getIdDot((String)"reviewactivity"));
                ReviewActivityQueryService service = (ReviewActivityQueryService)ServiceFactory.getService(ReviewActivityQueryService.class);
                activityIsEnd = service.getReviewActivityEnd((Object)reviewActivityId);
            }
            return ReviewImportFun.genResult(!activityIsEnd, ResManager.loadKDString((String)"\u76d8\u70b9\u6d3b\u52a8\u72b6\u6001\u4e3a\u201c\u8fdb\u884c\u4e2d\u201d\u3001\u201c\u5f85\u542f\u52a8\u201d\uff0c\u624d\u80fd\u7ef4\u62a4\u6570\u636e\uff1b", (String)"ReviewImportFun_4", (String)"tdc-oatr-formplugin", (Object[])new Object[0]));
        };
    }

    public static ReviewImportFun dimValueVerify() {
        return reviewImportFunBO -> {
            JSONObject rowJson = reviewImportFunBO.rowJson;
            String number = rowJson.getString("number");
            String name = ReviewImportFun.getName(rowJson);
            DynamicObject activityDO = (DynamicObject)reviewImportFunBO.othParam.get("activity");
            Map<String, DynamicObject> dimensionMap = activityDO.getDynamicObjectCollection("dimesionentry").stream().collect(Collectors.toMap(dim -> dim.getString(PropUtils.getNumberDot((String)"reviewdimension")), dim -> dim.getDynamicObject("reviewdimension"), (V1, V2) -> V1));
            DynamicObject[] reviewObjectDOArr = reviewImportFunBO.dynamicObjects;
            String rowImportType = reviewImportFunBO.rowImportType;
            ArrayList<String> errorMsgList = new ArrayList<String>(10);
            Map dimValidateInfo = (Map)reviewImportFunBO.othParam.get("dimValidateInfo");
            ArrayList overLenEvalNameList = new ArrayList(10);
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"oatr_reviewobject");
            TextProp entityProperty = (TextProp)dataEntityType.getAllFields().get("dimensionvalue");
            int MAX_LEN = entityProperty.getMaxLenth();
            Arrays.stream(reviewObjectDOArr).filter(dy -> HRStringUtils.equals((String)dy.getString("number"), (String)number) && HRStringUtils.equals((String)dy.getString("name"), (String)name)).forEach(reviewObject -> dimensionMap.forEach((dimNum, dim) -> {
                String dimValue = rowJson.getString(dimNum);
                if (HRStringUtils.isEmpty((String)dimValue)) {
                    return;
                }
                if (dimValue.length() > MAX_LEN) {
                    overLenEvalNameList.add(dim.getString("name"));
                }
                if (HRStringUtils.equals((String)rowImportType, (String)"new") && reviewObject.getDynamicObjectCollection("entryentity_dimension").stream().anyMatch(dy -> dy.getLong(PropUtils.getIdDot((String)"dimension")) == dim.getLong("id"))) {
                    errorMsgList.add(String.format(ResManager.loadKDString((String)"%s\u6570\u636e\u5df2\u5b58\u5728\uff1b", (String)"ReviewImportFun_5", (String)"tdc-oatr-formplugin", (Object[])new Object[0]), dim.getString("name")));
                }
                if (HRStringUtils.equals((String)rowImportType, (String)"update") && reviewObject.getDynamicObjectCollection("entryentity_dimension").stream().noneMatch(dy -> Objects.equals(dy.getString(PropUtils.getNumberDot((String)"dimension")), dim.getString("number")))) {
                    errorMsgList.add(String.format(ResManager.loadKDString((String)"%s\u4e0d\u5b58\u5728\u9700\u66f4\u65b0\u7684\u7ed3\u679c\u6570\u636e\uff1b", (String)"ReviewImportFun_3", (String)"tdc-oatr-formplugin", (Object[])new Object[0]), dim.getString("name")));
                }
                if (!CollectionUtils.isEmpty((Map)dimValidateInfo)) {
                    String mapKey = String.join((CharSequence)"_", number, name);
                    Map rowData = (Map)dimValidateInfo.get(mapKey);
                    if (CollectionUtils.isEmpty((Map)rowData)) {
                        return;
                    }
                    List dimValidateResultInfoList = DimValidateResultInfo.convertByValidateResult((Map)rowData);
                    List curDimInfoList = dimValidateResultInfoList.stream().filter(dimInfo -> HRStringUtils.equals((String)dimInfo.getDimId(), (String)dim.getString("id"))).collect(Collectors.toList());
                    if (CollectionUtils.isEmpty(curDimInfoList)) {
                        if (!ReviewImportFun.verifyPrecision(dimValue)) {
                            errorMsgList.add(String.format(ResManager.loadKDString((String)"\u6570\u503c\u8d85\u51fa\u5c0f\u6570\u70b9\u540e\u56db\u4f4d\uff1b", (String)"ReviewImportFun_9", (String)"tdc-oatr-formplugin", (Object[])new Object[0]), dim.getString("name")));
                        }
                        return;
                    }
                    if (curDimInfoList.stream().allMatch(dimInfo -> dimInfo.getValueType() == MapAxisValueTypeEnum.SCORE && !dimInfo.isSuccess() && dimInfo.getValidateResultCode() == MapValidateResultCode.OVER_SCALE) || curDimInfoList.stream().allMatch(dimInfo -> dimInfo.getValueType() == MapAxisValueTypeEnum.PERCENT && !dimInfo.isSuccess() && dimInfo.getValidateResultCode() == MapValidateResultCode.OVER_SCALE)) {
                        errorMsgList.add(String.format(ResManager.loadKDString((String)"\u6570\u503c\u8d85\u51fa\u5c0f\u6570\u70b9\u540e\u56db\u4f4d\uff1b", (String)"ReviewImportFun_9", (String)"tdc-oatr-formplugin", (Object[])new Object[0]), dim.getString("name")));
                        return;
                    }
                    if (dimValidateResultInfoList.stream().noneMatch(dimInfo -> HRStringUtils.equals((String)dimInfo.getDimId(), (String)dim.getString("id")) && dimInfo.isSuccess())) {
                        errorMsgList.add(String.format(ResManager.loadKDString((String)"%s\u503c\u4e0d\u5728\u5bab\u683c\u5730\u56fe\u5b9a\u4e49\u8303\u56f4\u5185\uff1b", (String)"ReviewImportFun_8", (String)"tdc-oatr-formplugin", (Object[])new Object[0]), dim.getString("name")));
                    }
                }
            }));
            if (!overLenEvalNameList.isEmpty()) {
                errorMsgList.add(String.format(ResManager.loadKDString((String)"%1$s\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7%2$s\u4e2a\u5b57\u7b26\uff1b", (String)"ReviewImportFun_10", (String)"tdc-oatr-formplugin", (Object[])new Object[0]), StringUtils.join(overLenEvalNameList, (String)"\uff0c"), MAX_LEN));
            }
            return ReviewImportFun.genResult(CollectionUtils.isEmpty(errorMsgList), Joiner.on((char)' ').skipNulls().join(errorMsgList));
        };
    }

    public static boolean verifyPrecision(String value) {
        boolean isPercent = false;
        if (value.endsWith("%")) {
            isPercent = true;
            value = value.substring(0, value.lastIndexOf("%"));
        }
        int maxScale = isPercent ? 2 : 4;
        try {
            BigDecimal bigDecimal = new BigDecimal(value);
            return bigDecimal.scale() <= maxScale;
        }
        catch (NumberFormatException numberFormatException) {
            return true;
        }
    }

    public static ValidateResult genResult(boolean result, String errorMsg) {
        if (result) {
            errorMsg = null;
        }
        return new ValidateResult(result, errorMsg);
    }

    public static ValidateResult genSuccResult() {
        return ReviewImportFun.genResult(true, null);
    }

    public static class ReviewImportFunBO {
        JSONObject rowJson;
        DynamicObject[] dynamicObjects;
        String rowImportType;
        Map<String, Object> othParam = new HashMap<String, Object>(8);

        public ReviewImportFunBO(JSONObject rowJson, DynamicObject[] dynamicObjects, String rowImportType) {
            this.rowJson = rowJson;
            this.dynamicObjects = dynamicObjects;
            this.rowImportType = rowImportType;
        }

        public ReviewImportFunBO() {
        }

        public void addOthParam(String key, Object value) {
            this.othParam.put(key, value);
        }

        public void setRowJson(JSONObject rowJson) {
            this.rowJson = rowJson;
        }

        public void setDynamicObjects(DynamicObject[] dynamicObjects) {
            this.dynamicObjects = dynamicObjects;
        }

        public void setRowImportType(String rowImportType) {
            this.rowImportType = rowImportType;
        }
    }
}

