/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.formplugin.web.activity.reviewobj;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hies.business.export.ExportHeaderWriterFormat;
import kd.hr.impt.common.dto.ImportBillData;
import kd.hr.impt.common.dto.ImportLog;
import kd.hr.impt.common.dto.ImportRowErrorLog;
import kd.hr.impt.common.enu.ValidatorEnum;
import kd.hr.impt.common.enu.ValidatorOrderEnum;
import kd.hr.impt.common.plugin.AfterTemplateValidateEventArgs;
import kd.hr.impt.common.plugin.BeforeCallOperationEventArgs;
import kd.hr.impt.common.plugin.BeforeCreateHeaderColumnEventArgs;
import kd.hr.impt.common.plugin.BeforeInitValidatorEventArgs;
import kd.hr.impt.common.plugin.BeforeLoadEntityEventArgs;
import kd.hr.impt.common.plugin.BeforeShowTemplateSelectListEventArgs;
import kd.hr.impt.common.plugin.BeforeTemplateValidateEventArgs;
import kd.hr.impt.common.plugin.BeforeValidateEventArgs;
import kd.hr.impt.common.plugin.HRImportPlugin;
import kd.hr.impt.core.validate.AbstractValidateHandler;
import kd.sdk.tdc.oatr.reviewobject.IDimResultImportExtendService;
import kd.sdk.tdc.oatr.reviewobject.IDimensionOriginalValueExtendService;
import kd.tdc.oatr.bussiness.ServiceFactory;
import kd.tdc.oatr.bussiness.application.ReviewTalentMapConfigApplicationService;
import kd.tdc.oatr.bussiness.queryservice.ReviewActivityQueryService;
import kd.tdc.oatr.common.bo.ReviewImportFieldInfo;
import kd.tdc.oatr.common.bo.ValidateResult;
import kd.tdc.oatr.common.utils.PropUtils;
import kd.tdc.oatr.formplugin.web.activity.reviewobj.ReviewImportFun;
import kd.tdc.oatr.formplugin.web.common.ImportIgnoreValidateHandler;

public class ReviewObjImportDimResultPlugin
implements HRImportPlugin,
Serializable {
    private static final HRBaseServiceHelper REVIEW_OBJ_REPOSITORY = new HRBaseServiceHelper("oatr_reviewobject");
    private static final HRBaseServiceHelper ACTIVITY_REPOSITORY = new HRBaseServiceHelper("oatr_reviewactivity");
    private static final String SELECT_PROP = String.join((CharSequence)",", "reviewactivity", "entryentity_dimension", "dimension", "dimensionvalue", "entryentity_mapbefore", "mapbeforekey", "mapbeforename", "mapbeforevalue", "reviewstatus", "reviewgroup", "talentfile");
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog(ReviewObjImportDimResultPlugin.class);

    public void beforeCreateHeaderColumn(BeforeCreateHeaderColumnEventArgs args) {
        super.beforeCreateHeaderColumn(args);
        Optional<ExportHeaderWriterFormat> formatOptional = args.getHeaderWriterFormats().stream().filter(format -> HRStringUtils.equals((String)format.getEnityName(), (String)REVIEW_OBJ_REPOSITORY.getEntityName())).findFirst();
        if (!formatOptional.isPresent()) {
            return;
        }
        ExportHeaderWriterFormat exportHeaderWriterFormat = formatOptional.get();
        DynamicObject activityDO = this.getActivityDO(args.getExtParams());
        activityDO.getDynamicObjectCollection("dimesionentry").forEach(entryRow -> {
            DynamicObject reviewDimension = entryRow.getDynamicObject("reviewdimension");
            exportHeaderWriterFormat.getFields().add(reviewDimension.getString("number"));
            HashMap<String, String> dimResultProp = new HashMap<String, String>(8);
            dimResultProp.put("DisplayName", reviewDimension.getString("name"));
            dimResultProp.put("InputType", "varchar");
            dimResultProp.put("PropType", null);
            dimResultProp.put("InputDesc", ResManager.loadKDString((String)"\u6587\u672c", (String)"ReviewObjImportDimResultPlugin_1", (String)"tdc-oatr-formplugin", (Object[])new Object[0]));
            exportHeaderWriterFormat.getProperties().put(reviewDimension.getString("number"), dimResultProp);
        });
    }

    public void beforeTemplateValidate(BeforeTemplateValidateEventArgs args) {
        super.beforeTemplateValidate(args);
        args.setIgnoreValidateMap((Map)ImmutableMap.of((Object)REVIEW_OBJ_REPOSITORY.getEntityName(), this.getFieldKeyList(args.getExtParams()).stream().map(ReviewImportFieldInfo::getKey).collect(Collectors.toList())));
    }

    private List<ReviewImportFieldInfo> getFieldKeyList(String extParams) {
        DynamicObject reviewActivityDO = this.getActivityDO(extParams);
        DynamicObjectCollection evalEntryEntity = reviewActivityDO.getDynamicObjectCollection("dimesionentry");
        return evalEntryEntity.stream().map(dy -> new ReviewImportFieldInfo(dy.getString(PropUtils.getNumberDot((String)"reviewdimension")), dy.getString(PropUtils.getNameDot((String)"reviewdimension")))).collect(Collectors.toList());
    }

    public void afterTemplateValidate(AfterTemplateValidateEventArgs args) {
        super.afterTemplateValidate(args);
        Collection fieldList = (Collection)args.getEntityFields().get("oatr_reviewobject");
        fieldList.removeAll(this.ignoreField());
        fieldList.removeIf(field -> HRStringUtils.isNotEmpty((String)field) && field.startsWith("name.") || HRStringUtils.equals((String)field, (String)"number"));
        fieldList.removeAll(this.getFieldKeyList(args.getExtParams()).stream().map(ReviewImportFieldInfo::getKey).collect(Collectors.toList()));
        if (!fieldList.isEmpty()) {
            args.setErrorMsg(ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u6a21\u677f\u6709\u8bef\uff0c\u8bf7\u9009\u62e9\u6b63\u786e\u7684\u6a21\u677f\u3002", (String)"ReviewObjImportDimResultPlugin_0", (String)"tdc-oatr-formplugin", (Object[])new Object[0]));
        }
    }

    public void beforeLoadEntity(BeforeLoadEntityEventArgs args) {
        super.beforeLoadEntity(args);
        QFilter qFilterAdd = this.getCommonQFilter(args.getExtParams());
        for (QFilter qFilter : args.getqFilters()) {
            qFilter.and(qFilterAdd);
        }
    }

    public void beforeShowTemplateSelectList(BeforeShowTemplateSelectListEventArgs args) {
        super.beforeShowTemplateSelectList(args);
        ArrayList<String> templateNumbers = new ArrayList<String>(5);
        templateNumbers.add("reviewobject_new_preset");
        templateNumbers.add("evalinfo_new_preset");
        templateNumbers.add("evalinfo_update_preset");
        templateNumbers.add("evalinfo_updateandnew_preset");
        QFilter filter = new QFilter("number", "not in", templateNumbers);
        args.setqFilterList(new ArrayList<QFilter>(Collections.singletonList(filter)));
    }

    private QFilter getCommonQFilter(String extParam) {
        return new QFilter("reviewactivity", "=", (Object)this.getActivityId(extParam)).and(new QFilter("reviewstatus", "!=", (Object)"E"));
    }

    private QFilter getCommonQFilterNoStatus(String extParam) {
        return new QFilter("reviewactivity", "=", (Object)this.getActivityId(extParam));
    }

    protected List<String> ignoreField() {
        return Collections.emptyList();
    }

    public void beforeValidate(BeforeValidateEventArgs args) {
        super.beforeValidate(args);
        if (args.getBillDatas().isEmpty()) {
            return;
        }
        String extParamsStr = args.getExtParams();
        JSONObject extParams = JSONObject.parseObject((String)extParamsStr);
        List dimData = args.getBillDatas().stream().map(importBillData -> importBillData.getData().getJSONObject("oatr_reviewobject")).collect(Collectors.toList());
        HRPluginProxy pluginProxy = HRPlugInProxyFactory.create(null, IDimResultImportExtendService.class, (String)"kd.sdk.tdc.oatr.reviewobject.IDimResultImportExtendService", null);
        pluginProxy.callReplaceIfPresent(plugin -> {
            if (plugin != null && plugin.isUseDimResultImportConvertor(extParams)) {
                plugin.dimResultImportConvertor(extParams, dimData);
            }
            return null;
        });
    }

    public void beforeInitValidator(final BeforeInitValidatorEventArgs args) {
        super.beforeInitValidator(args);
        args.setValidator(ValidatorEnum.CUSTOM_VALIDATOR, new AbstractValidateHandler(){

            public ValidatorOrderEnum setValidatorRole() {
                return ValidatorOrderEnum.DEFAULT;
            }

            public void validate(List<ImportBillData> billDataList, ImportLog importLog) {
                List numberList = billDataList.stream().map(data -> data.getData().getJSONObject(REVIEW_OBJ_REPOSITORY.getEntityName()).getString("number")).collect(Collectors.toList());
                DynamicObject[] reviewObjectDOArr = ReviewObjImportDimResultPlugin.this.getReviewObjectByNumber(args.getExtParams(), numberList);
                LOG.info("importDyCol_dim_getReviewObjectByNumber:{}", Arrays.stream(reviewObjectDOArr).map(dy -> dy.getLong("id")).collect(Collectors.toList()));
                ReviewImportFun.ReviewImportFunBO reviewImportFunBO = new ReviewImportFun.ReviewImportFunBO();
                boolean isCollaborator = HRStringUtils.equals((String)"1", (String)ReviewObjImportDimResultPlugin.this.getCollaboratorParam(args.getExtParams()));
                DynamicObject[] reviewObjectWithPerm = ((ReviewActivityQueryService)ServiceFactory.getService(ReviewActivityQueryService.class)).getReviewObjectWithPerm((Object)ReviewObjImportDimResultPlugin.this.getActivityId(args.getExtParams()));
                reviewImportFunBO.addOthParam("permVerify", reviewObjectWithPerm);
                LOG.info("importDyCol_dim_getReviewObjectWithPerm:{}", Arrays.stream(reviewObjectWithPerm).map(dy -> dy.getLong("id")).collect(Collectors.toList()));
                reviewImportFunBO.addOthParam("activityEnd", ((ReviewActivityQueryService)ServiceFactory.getService(ReviewActivityQueryService.class)).getReviewActivityEnd((Object)ReviewObjImportDimResultPlugin.this.getActivityId(args.getExtParams())));
                reviewImportFunBO.addOthParam("activity", ReviewObjImportDimResultPlugin.this.getActivityDO(args.getExtParams()));
                reviewImportFunBO.addOthParam("isCollaborator", isCollaborator);
                if (isCollaborator) {
                    reviewImportFunBO.addOthParam("collaborator_group", JSONObject.toJSONString((Object)ReviewObjImportDimResultPlugin.this.getCollaboratorGroup(args.getExtParams())));
                }
                Map<String, Map<Long, Map<String, Object>>> dimValidateInfo = this.getDimValidateInfo(billDataList, args.getExtParams());
                reviewImportFunBO.addOthParam("dimValidateInfo", dimValidateInfo);
                for (ImportBillData importBillData : billDataList) {
                    JSONObject fieldJson = importBillData.getData().getJSONObject(REVIEW_OBJ_REPOSITORY.getEntityName());
                    for (ReviewImportFun reviewImportFun : ReviewObjImportDimResultPlugin.this.getValidatorList()) {
                        String importType = args.getContext().getImporttype();
                        reviewImportFunBO.setRowImportType(importType);
                        reviewImportFunBO.setDynamicObjects(reviewObjectDOArr);
                        reviewImportFunBO.setRowJson(fieldJson);
                        ValidateResult result = reviewImportFun.execute(reviewImportFunBO);
                        if (result.getResult()) continue;
                        ImportRowErrorLog importRowErrorLog = new ImportRowErrorLog(importBillData.getSheetName(), importBillData.getStartIndex(), importBillData.getEndIndex(), result.getErrorMsg(), importLog);
                        importLog.writeRowLog(importRowErrorLog);
                    }
                }
            }

            private Map<String, Map<Long, Map<String, Object>>> getDimValidateInfo(List<ImportBillData> billDataList, String extParams) {
                List fieldKeyList = ReviewObjImportDimResultPlugin.this.getFieldKeyList(extParams).stream().map(ReviewImportFieldInfo::getKey).collect(Collectors.toList());
                HRBaseServiceHelper dimServiceHelper = new HRBaseServiceHelper("oatr_reviewdimension");
                DynamicObject[] dimDOArr = dimServiceHelper.query("id", new QFilter[0]);
                Map<String, Map> validateParam = billDataList.stream().map(billData -> billData.getData().getJSONObject("oatr_reviewobject")).filter(data -> !CollectionUtils.isEmpty((Map)data)).collect(Collectors.toMap(data -> String.join((CharSequence)"_", data.getString("number"), ReviewImportFun.getName(data)), data -> {
                    HashMap<Long, String> map = new HashMap<Long, String>(fieldKeyList.size());
                    for (String dyKey : fieldKeyList) {
                        Optional<Long> dimIdOp = Arrays.stream(dimDOArr).filter(dim -> HRStringUtils.equals((String)dyKey, (String)dim.getString("number"))).map(dim -> dim.getLong("id")).findFirst();
                        if (!dimIdOp.isPresent()) continue;
                        map.put(dimIdOp.get(), data.getString(dyKey));
                    }
                    return map;
                }, (V1, V2) -> V1));
                Map result = ((ReviewTalentMapConfigApplicationService)ServiceFactory.getService(ReviewTalentMapConfigApplicationService.class)).validateDimensionData(validateParam, Long.valueOf(ReviewObjImportDimResultPlugin.this.getActivityId(extParams)));
                LOG.info("getDimValidateInfo: activityId:{}, validateDimensionData:{}, result:{}", new Object[]{ReviewObjImportDimResultPlugin.this.getActivityId(extParams), validateParam, result});
                return result;
            }
        });
        args.setValidator(ValidatorEnum.DATA_RULE_PERM_VALIDATOR, (AbstractValidateHandler)new ImportIgnoreValidateHandler());
    }

    public void beforeCallOperation(BeforeCallOperationEventArgs args) {
        super.beforeCallOperation(args);
        OperateOption option = OperateOption.create();
        option.setVariableValue("billData", JSONObject.toJSONString((Object)args.getImportBillDatas()));
        option.setVariableValue("activityId", String.valueOf(this.getActivityId(args.getExtParams())));
        option.setVariableValue("groupId", JSONObject.toJSONString(this.getGroupId(args.getExtParams())));
        option.setVariableValue("isCollaborator", this.getCollaboratorParam(args.getExtParams()));
        option.setVariableValue("importtype", args.getContext().getImporttype());
        args.setOperateOptions((Map)ImmutableMap.of((Object)REVIEW_OBJ_REPOSITORY.getEntityName(), (Object)option));
        args.setSubmitOPs((Map)ImmutableMap.of((Object)REVIEW_OBJ_REPOSITORY.getEntityName(), (Object)"importdimsave"));
    }

    private String getCollaboratorParam(String extParam) {
        if (HRStringUtils.isEmpty((String)extParam)) {
            return "";
        }
        JSONObject jsonObject = JSONObject.parseObject((String)extParam);
        return jsonObject.getString("isCollaborator");
    }

    private List<Long> getCollaboratorGroup(String extParam) {
        long activityId = this.getActivityId(extParam);
        long currUserId = RequestContext.get().getCurrUserId();
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("oatr_reviewgroup");
        QFilter qFilter = new QFilter("reviewactivity", "=", (Object)activityId);
        DynamicObject[] dynamicObjects = serviceHelper.query("entryentity,colstatus,collaborator", new QFilter[]{qFilter});
        List<Long> havePermGroup = Arrays.stream(dynamicObjects).filter(dynamicObject -> dynamicObject.getDynamicObjectCollection("entryentity").stream().anyMatch(dy -> HRStringUtils.equals((String)dy.getString("colstatus"), (String)"1") && dy.getLong(PropUtils.getIdDot((String)"collaborator")) == currUserId)).map(dy -> dy.getLong("id")).collect(Collectors.toList());
        LOG.info("importDyCol_dim_getCollaboratorGroup_havePermGroup:{}", havePermGroup);
        return havePermGroup;
    }

    protected List<ReviewImportFun> getValidatorList() {
        LinkedList<ReviewImportFun> validatorList = new LinkedList<ReviewImportFun>();
        validatorList.add(ReviewImportFun.personVerify());
        validatorList.add(ReviewImportFun.personRangeVerify());
        Map<String, Object> extendArgs = this.getExtendServiceData();
        boolean isEnableDimValueValidator = (Boolean)extendArgs.get("isEnableDimValueValidator");
        if (isEnableDimValueValidator) {
            validatorList.add(ReviewImportFun.dimValueVerify());
        }
        validatorList.add(ReviewImportFun.activityStatusVerify());
        return validatorList;
    }

    private DynamicObject getActivityDO(String extParam) {
        return this.getActivityDO(this.getActivityId(extParam));
    }

    private DynamicObject getActivityDO(long activityId) {
        return ACTIVITY_REPOSITORY.queryOne("dimesionentry,reviewdimension,selectstatus", (Object)activityId);
    }

    private long getActivityId(String extParam) {
        if (HRStringUtils.isEmpty((String)extParam)) {
            return 0L;
        }
        JSONObject jsonObject = JSONObject.parseObject((String)extParam);
        return jsonObject.getLongValue("activityId");
    }

    private DynamicObject[] getReviewObjectByNumber(String extParam, List<String> numberList) {
        QFilter groupQF = new QFilter("reviewgroup", "in", this.getGroupId(extParam));
        QFilter numberQF = new QFilter("number", "in", numberList);
        return REVIEW_OBJ_REPOSITORY.query(SELECT_PROP, new QFilter[]{groupQF, numberQF, this.getCommonQFilterNoStatus(extParam)});
    }

    private List<Long> getGroupId(String extParam) {
        if (HRStringUtils.isEmpty((String)extParam)) {
            return Collections.emptyList();
        }
        JSONObject jsonObject = JSONObject.parseObject((String)extParam);
        return jsonObject.getJSONArray("groupId").toJavaList(Long.class);
    }

    private Map<String, Object> getExtendServiceData() {
        HashMap<String, Object> extendArgs = new HashMap<String, Object>(16);
        extendArgs.put("isEnableDimValueValidator", true);
        HRPluginProxy pluginProxy = HRPlugInProxyFactory.create(null, IDimensionOriginalValueExtendService.class, (String)"kd.sdk.tdc.oatr.reviewobject.IDimensionOriginalValueExtendService", null);
        pluginProxy.callReplaceIfPresent(plugin -> {
            if (plugin != null) {
                boolean enableValidator = plugin.isEnableDimValueValidator();
                extendArgs.put("isEnableDimValueValidator", enableValidator);
            }
            return null;
        });
        return extendArgs;
    }
}

