/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.formplugin.web.activity.reviewobj;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hies.business.export.ExportHeaderWriterFormat;
import kd.hr.impt.common.dto.ImportBillData;
import kd.hr.impt.common.dto.ImportLog;
import kd.hr.impt.common.dto.ImportRowErrorLog;
import kd.hr.impt.common.enu.ValidatorEnum;
import kd.hr.impt.common.enu.ValidatorOrderEnum;
import kd.hr.impt.common.plugin.AfterTemplateValidateEventArgs;
import kd.hr.impt.common.plugin.BeforeCallOperationEventArgs;
import kd.hr.impt.common.plugin.BeforeCreateHeaderColumnEventArgs;
import kd.hr.impt.common.plugin.BeforeInitValidatorEventArgs;
import kd.hr.impt.common.plugin.BeforeLoadEntityEventArgs;
import kd.hr.impt.common.plugin.BeforeShowTemplateSelectListEventArgs;
import kd.hr.impt.common.plugin.BeforeTemplateValidateEventArgs;
import kd.hr.impt.common.plugin.BeforeValidateEventArgs;
import kd.hr.impt.common.plugin.HRImportPlugin;
import kd.hr.impt.core.validate.AbstractValidateHandler;
import kd.sdk.tdc.oatr.reviewobject.IEvalImportExtendService;
import kd.tdc.oatr.bussiness.ServiceFactory;
import kd.tdc.oatr.bussiness.queryservice.ReviewActivityQueryService;
import kd.tdc.oatr.common.bo.ReviewImportFieldInfo;
import kd.tdc.oatr.common.bo.ValidateResult;
import kd.tdc.oatr.common.utils.PropUtils;
import kd.tdc.oatr.formplugin.web.activity.detail.ReviewActivityDetailCommon;
import kd.tdc.oatr.formplugin.web.activity.reviewobj.ReviewImportFun;
import kd.tdc.oatr.formplugin.web.common.ImportIgnoreValidateHandler;

public class ReviewObjImportEvaluationPlugin
implements HRImportPlugin,
ReviewActivityDetailCommon,
Serializable {
    private static final HRBaseServiceHelper REVIEW_OBJ_REPOSITORY = new HRBaseServiceHelper("oatr_reviewobject");
    private static final String SELECT_PROP = String.join((CharSequence)",", "evaltool", "evaluationitem", "evalvalue", "reviewactivity", "reviewgroup", "reviewstatus", "evaldim", "dimevalitem", "dimevalvalue");
    private static final Log LOG = LogFactory.getLog(ReviewObjImportEvaluationPlugin.class);
    private static final long serialVersionUID = 1L;

    public void beforeCreateHeaderColumn(BeforeCreateHeaderColumnEventArgs args) {
        super.beforeCreateHeaderColumn(args);
        LOG.info("Eval_Item -> beforeCreateHeaderColumn start");
        Optional<ExportHeaderWriterFormat> formatOptional = args.getHeaderWriterFormats().stream().filter(format -> HRStringUtils.equals((String)format.getEnityName(), (String)REVIEW_OBJ_REPOSITORY.getEntityName())).findFirst();
        if (!formatOptional.isPresent()) {
            return;
        }
        LOG.info("Eval_Item -> beforeCreateHeaderColumn have entity");
        ExportHeaderWriterFormat exportHeaderWriterFormat = formatOptional.get();
        List<ReviewImportFieldInfo> dimEvalfieldKeyList = this.getDimEvalFieldInfoList(args.getExtParams());
        for (ReviewImportFieldInfo fieldInfo : dimEvalfieldKeyList) {
            exportHeaderWriterFormat.getFields().add(fieldInfo.getKey());
            HashMap<String, String> dimProp = new HashMap<String, String>(8);
            dimProp.put("DisplayName", fieldInfo.getName());
            dimProp.put("InputType", "varchar");
            dimProp.put("PropType", null);
            dimProp.put("InputDesc", ResManager.loadKDString((String)"\u6587\u672c", (String)"ReviewObjImportDimResultPlugin_1", (String)"tdc-oatr-formplugin", (Object[])new Object[0]));
            exportHeaderWriterFormat.getProperties().put(fieldInfo.getKey(), dimProp);
        }
    }

    private DynamicObject getReviewDimensionActivity(String extParams) {
        long activityId = this.getActivityId(extParams);
        QFilter qFilter = new QFilter("id", "=", (Object)activityId);
        HRBaseServiceHelper activityHelper = new HRBaseServiceHelper("oatr_reviewactivity");
        return activityHelper.queryOne("dimesionentry,dimesionentry.reviewdimension,dimesionentry.evaluationscheme,dimesionentry.dimevaluation", qFilter.toArray());
    }

    protected List<String> ignoreField() {
        return Collections.emptyList();
    }

    public void beforeTemplateValidate(BeforeTemplateValidateEventArgs args) {
        super.beforeTemplateValidate(args);
        args.setIgnoreValidateMap((Map)ImmutableMap.of((Object)REVIEW_OBJ_REPOSITORY.getEntityName(), this.getDimEvalFieldInfoList(args.getExtParams()).stream().map(ReviewImportFieldInfo::getKey).collect(Collectors.toList())));
    }

    private List<ReviewImportFieldInfo> getDimEvalFieldInfoList(String extParams) {
        DynamicObject reviewDimDO = this.getReviewDimensionActivity(extParams);
        DynamicObjectCollection dimEntry = reviewDimDO.getDynamicObjectCollection("dimesionentry");
        ArrayList<ReviewImportFieldInfo> fieldInfoList = new ArrayList<ReviewImportFieldInfo>(10);
        for (DynamicObject dimEntryRow : dimEntry) {
            String dimId = String.valueOf(dimEntryRow.getLong("reviewdimension.id"));
            String dimName = dimEntryRow.getString("reviewdimension.name");
            DynamicObjectCollection dimEvaluation = dimEntryRow.getDynamicObjectCollection("dimevaluation");
            for (DynamicObject mulEvaluationItem : dimEvaluation) {
                DynamicObject evaluationItem = mulEvaluationItem.getDynamicObject("fbasedataid");
                if (evaluationItem == null) continue;
                ReviewImportFieldInfo fieldInfo = new ReviewImportFieldInfo();
                fieldInfo.setKey(String.join((CharSequence)".", dimId, evaluationItem.getString("number")));
                fieldInfo.setKeyMap((Map)ImmutableMap.of((Object)"dimId", (Object)dimId, (Object)"evaluationItemNum", (Object)evaluationItem.getString("number")));
                fieldInfo.setName(String.join((CharSequence)"-", dimName, evaluationItem.getString("name")));
                fieldInfo.setNameMap((Map)ImmutableMap.of((Object)"dimName", (Object)dimName, (Object)"evaluationItemName", (Object)evaluationItem.getString("name")));
                fieldInfoList.add(fieldInfo);
            }
        }
        return fieldInfoList;
    }

    public void afterTemplateValidate(AfterTemplateValidateEventArgs args) {
        super.afterTemplateValidate(args);
        Collection fieldList = (Collection)args.getEntityFields().get("oatr_reviewobject");
        fieldList.removeAll(this.ignoreField());
        fieldList.removeIf(field -> HRStringUtils.isNotEmpty((String)field) && field.startsWith("name.") || HRStringUtils.equals((String)field, (String)"number"));
        fieldList.removeAll(this.getDimEvalFieldInfoList(args.getExtParams()).stream().map(ReviewImportFieldInfo::getKey).collect(Collectors.toList()));
        if (!fieldList.isEmpty()) {
            args.setErrorMsg(ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u6a21\u677f\u6709\u8bef\uff0c\u8bf7\u9009\u62e9\u6b63\u786e\u7684\u6a21\u677f\u3002", (String)"ReviewObjImportDimResultPlugin_0", (String)"tdc-oatr-formplugin", (Object[])new Object[0]));
        }
    }

    public void beforeInitValidator(final BeforeInitValidatorEventArgs args) {
        super.beforeInitValidator(args);
        class EvaluationAbstractValidateHandler
        extends AbstractValidateHandler {
            EvaluationAbstractValidateHandler() {
            }

            public ValidatorOrderEnum setValidatorRole() {
                return ValidatorOrderEnum.DEFAULT;
            }

            public void validate(List<ImportBillData> billDataList, ImportLog importLog) {
                List numberList = billDataList.stream().map(data -> data.getData().getJSONObject(REVIEW_OBJ_REPOSITORY.getEntityName()).getString("number")).collect(Collectors.toList());
                DynamicObject[] reviewObjectDOArr = ReviewObjImportEvaluationPlugin.this.getReviewObjectByNumber(args.getExtParams(), numberList);
                ReviewImportFun.ReviewImportFunBO reviewImportFunBO = new ReviewImportFun.ReviewImportFunBO();
                boolean isCollaborator = HRStringUtils.equals((String)"1", (String)ReviewObjImportEvaluationPlugin.this.getCollaboratorParam(args.getExtParams()));
                reviewImportFunBO.addOthParam("permVerify", ((ReviewActivityQueryService)ServiceFactory.getService(ReviewActivityQueryService.class)).getReviewObjectWithPerm((Object)ReviewObjImportEvaluationPlugin.this.getActivityId(args.getExtParams())));
                reviewImportFunBO.addOthParam("activityEnd", ((ReviewActivityQueryService)ServiceFactory.getService(ReviewActivityQueryService.class)).getReviewActivityEnd((Object)ReviewObjImportEvaluationPlugin.this.getActivityId(args.getExtParams())));
                reviewImportFunBO.addOthParam("dyFieldInfo", ReviewObjImportEvaluationPlugin.this.getDimEvalFieldInfoList(args.getExtParams()));
                reviewImportFunBO.addOthParam("reviewDimension", ReviewObjImportEvaluationPlugin.this.getReviewDimensionActivity(args.getExtParams()));
                reviewImportFunBO.addOthParam("isCollaborator", isCollaborator);
                if (isCollaborator) {
                    reviewImportFunBO.addOthParam("collaborator_group", JSONObject.toJSONString((Object)ReviewObjImportEvaluationPlugin.this.getCollaboratorGroup(args.getExtParams())));
                }
                for (ImportBillData importBillData : billDataList) {
                    JSONObject fieldJson = importBillData.getData().getJSONObject(REVIEW_OBJ_REPOSITORY.getEntityName());
                    for (ReviewImportFun reviewImportFun : ReviewObjImportEvaluationPlugin.this.getValidatorList()) {
                        reviewImportFunBO.setRowImportType(args.getContext().getImporttype());
                        reviewImportFunBO.setDynamicObjects(reviewObjectDOArr);
                        reviewImportFunBO.setRowJson(fieldJson);
                        ValidateResult result = reviewImportFun.execute(reviewImportFunBO);
                        if (result.getResult()) continue;
                        ImportRowErrorLog importRowErrorLog = new ImportRowErrorLog(importBillData.getSheetName(), importBillData.getStartIndex(), importBillData.getEndIndex(), result.getErrorMsg(), importLog);
                        importLog.writeRowLog(importRowErrorLog);
                    }
                }
            }
        }
        args.setValidator(ValidatorEnum.CUSTOM_VALIDATOR, (AbstractValidateHandler)new EvaluationAbstractValidateHandler());
        args.setValidator(ValidatorEnum.DATA_RULE_PERM_VALIDATOR, (AbstractValidateHandler)new ImportIgnoreValidateHandler());
    }

    public void beforeValidate(BeforeValidateEventArgs args) {
        super.beforeValidate(args);
        if (args.getBillDatas().isEmpty()) {
            return;
        }
        String extParamsStr = args.getExtParams();
        JSONObject extParams = JSONObject.parseObject((String)extParamsStr);
        List evalData = args.getBillDatas().stream().map(importBillData -> importBillData.getData().getJSONObject("oatr_reviewobject")).collect(Collectors.toList());
        HRPluginProxy pluginProxy = HRPlugInProxyFactory.create(null, IEvalImportExtendService.class, (String)"kd.sdk.tdc.oatr.reviewobject.IEvalImportExtendService", null);
        pluginProxy.callReplaceIfPresent(plugin -> {
            if (plugin != null && plugin.isUseEvalImportConvertor(extParams)) {
                plugin.evalImportConvertor(extParams, evalData);
            }
            return null;
        });
    }

    public void beforeLoadEntity(BeforeLoadEntityEventArgs args) {
        super.beforeLoadEntity(args);
        QFilter commonQFilter = this.getCommonQFilter(args.getExtParams());
        for (QFilter qFilter : args.getqFilters()) {
            qFilter.and(commonQFilter);
        }
    }

    public void beforeShowTemplateSelectList(BeforeShowTemplateSelectListEventArgs args) {
        super.beforeShowTemplateSelectList(args);
        ArrayList<String> templateNumbers = new ArrayList<String>(5);
        templateNumbers.add("reviewobject_new_preset");
        templateNumbers.add("dimresult_new_preset");
        templateNumbers.add("dimresult_update_preset");
        templateNumbers.add("dimresult_updateandnew_preset");
        QFilter filter = new QFilter("number", "not in", templateNumbers);
        args.setqFilterList(new ArrayList<QFilter>(Collections.singletonList(filter)));
    }

    public void beforeCallOperation(BeforeCallOperationEventArgs args) {
        super.beforeCallOperation(args);
        OperateOption option = OperateOption.create();
        option.setVariableValue("billData", JSONObject.toJSONString((Object)args.getImportBillDatas()));
        option.setVariableValue("activityId", String.valueOf(this.getActivityId(args.getExtParams())));
        option.setVariableValue("groupId", JSONObject.toJSONString(this.getGroupId(args.getExtParams())));
        option.setVariableValue("fieldInfo", JSONObject.toJSONString(this.getDimEvalFieldInfoList(args.getExtParams())));
        option.setVariableValue("reviewDimension", this.getReviewDimensionActivity(args.getExtParams()).getString("id"));
        option.setVariableValue("isCollaborator", this.getCollaboratorParam(args.getExtParams()));
        option.setVariableValue("importtype", args.getContext().getImporttype());
        args.setOperateOptions((Map)ImmutableMap.of((Object)REVIEW_OBJ_REPOSITORY.getEntityName(), (Object)option));
        args.setSubmitOPs((Map)ImmutableMap.of((Object)REVIEW_OBJ_REPOSITORY.getEntityName(), (Object)"importevalsave"));
    }

    private String getCollaboratorParam(String extParam) {
        if (HRStringUtils.isEmpty((String)extParam)) {
            return "";
        }
        JSONObject jsonObject = JSONObject.parseObject((String)extParam);
        return jsonObject.getString("isCollaborator");
    }

    private List<Long> getCollaboratorGroup(String extParam) {
        long activityId = this.getActivityId(extParam);
        long currUserId = RequestContext.get().getCurrUserId();
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("oatr_reviewgroup");
        QFilter qFilter = new QFilter("reviewactivity", "=", (Object)activityId);
        DynamicObject[] dynamicObjects = serviceHelper.query("entryentity,colstatus,collaborator", new QFilter[]{qFilter});
        return Arrays.stream(dynamicObjects).filter(dynamicObject -> dynamicObject.getDynamicObjectCollection("entryentity").stream().anyMatch(dy -> HRStringUtils.equals((String)dy.getString("colstatus"), (String)"1") && dy.getLong(PropUtils.getIdDot((String)"collaborator")) == currUserId)).map(dy -> dy.getLong("id")).collect(Collectors.toList());
    }

    private DynamicObject[] getReviewObjectByNumber(String extParam, List<String> numberList) {
        QFilter numberQF = new QFilter("number", "in", numberList);
        return REVIEW_OBJ_REPOSITORY.query(SELECT_PROP, new QFilter[]{numberQF, this.getCommonQFilterNoStatus(extParam)});
    }

    private long getActivityId(String extParam) {
        if (HRStringUtils.isEmpty((String)extParam)) {
            return 0L;
        }
        JSONObject jsonObject = JSONObject.parseObject((String)extParam);
        return jsonObject.getLongValue("activityId");
    }

    private List<Long> getGroupId(String extParam) {
        if (HRStringUtils.isEmpty((String)extParam)) {
            return Collections.emptyList();
        }
        JSONObject jsonObject = JSONObject.parseObject((String)extParam);
        JSONArray groupIdArr = jsonObject.getJSONArray("groupId");
        return groupIdArr.toJavaList(Long.class);
    }

    protected List<ReviewImportFun> getValidatorList() {
        LinkedList<ReviewImportFun> validatorList = new LinkedList<ReviewImportFun>();
        validatorList.add(ReviewImportFun.personVerify());
        validatorList.add(ReviewImportFun.personRangeVerify());
        validatorList.add(ReviewImportFun.evalValueExistVerify());
        validatorList.add(ReviewImportFun.evaluationItemExistVerify());
        validatorList.add(ReviewImportFun.activityStatusVerify());
        return validatorList;
    }

    private QFilter getCommonQFilter(String extParam) {
        return new QFilter("reviewactivity", "=", (Object)this.getActivityId(extParam)).and(new QFilter("reviewstatus", "!=", (Object)"E")).and(new QFilter("reviewgroup", "in", this.getGroupId(extParam)));
    }

    private QFilter getCommonQFilterNoStatus(String extParam) {
        return new QFilter("reviewactivity", "=", (Object)this.getActivityId(extParam)).and(new QFilter("reviewgroup", "in", this.getGroupId(extParam)));
    }
}

