/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.formplugin.web.activity.reviewobj;

import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.lang.Lang;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tdc.oatr.formplugin.web.activity.reviewobj.ReviewImportFun;
import org.apache.commons.lang3.tuple.Pair;

public interface ReviewObjImportFun
extends ReviewImportFun {
    public static ReviewImportFun personPermitRangeVerify() {
        return reviewImportFunBO -> {
            JSONObject jsonObject;
            JSONObject nameJsonObj;
            Object talentFileRangeObj = reviewImportFunBO.othParam.get("talentFileRange");
            if (Objects.isNull(talentFileRangeObj)) {
                return ReviewImportFun.genSuccResult();
            }
            Pair talentFileRange = (Pair)talentFileRangeObj;
            String number = reviewImportFunBO.rowJson.getString("number");
            String name = reviewImportFunBO.rowJson.getString("name");
            if (HRStringUtils.isEmpty((String)number) || HRStringUtils.isEmpty((String)name)) {
                String msg = ResManager.loadKDString((String)"\u5de5\u53f7\u6216\u59d3\u540d\u6570\u636e\u4e3a\u7a7a\uff1b", (String)"ReviewObjImportFun_6", (String)"tdc-oatr-formplugin", (Object[])new Object[0]);
                return ReviewImportFun.genResult(false, msg);
            }
            JSONObject nameObj = reviewImportFunBO.rowJson.getJSONObject("name");
            String nameStr = nameObj.getString(Lang.get().getLocale().toString());
            Object searchTalentFileByNumbers = reviewImportFunBO.othParam.get("searchTalentFileByNumbers");
            DynamicObject[] searchTalentFileDOsByNumbers = (DynamicObject[])searchTalentFileByNumbers;
            if (!ReviewObjImportFun.checkPerson(searchTalentFileDOsByNumbers, number, nameStr)) {
                String msg = ResManager.loadKDString((String)"\u4eba\u624d\u6863\u6848\u4e0d\u5b58\u5728\uff1b", (String)"ReviewObjImportFun_4", (String)"tdc-oatr-formplugin", (Object[])new Object[0]);
                return ReviewImportFun.genResult(false, msg);
            }
            if (!((Boolean)talentFileRange.getKey()).booleanValue()) {
                LOG.info("ReviewObjImportFun.personPermitRangeVerify: no talent file range");
                String msg = ResManager.loadKDString((String)"\u5f53\u524d\u6d3b\u52a8\u4e0b\u65e0\u4eba\u624d\u6863\u6848\u6570\u636e\u6743\u9650\uff1b", (String)"ReviewImportFun_1", (String)"tdc-oatr-formplugin", (Object[])new Object[0]);
                Object talentFile = reviewImportFunBO.othParam.get("talentFile");
                if (Objects.isNull(talentFile)) {
                    LOG.info("ReviewObjImportFun.personPermitRangeVerify: talent file is empty");
                    return ReviewImportFun.genResult(false, msg);
                }
                DynamicObject[] talentFiles = (DynamicObject[])talentFile;
                boolean result = Arrays.stream(talentFiles).anyMatch(tFile -> HRStringUtils.equals((String)number, (String)tFile.getString("number")));
                return ReviewImportFun.genResult(result, msg);
            }
            DynamicObject[] talentFileDOArr = (DynamicObject[])talentFileRange.getValue();
            boolean result = Arrays.stream(talentFileDOArr).anyMatch(tFile -> HRStringUtils.equals((String)number, (String)tFile.getString("number")));
            if (result) {
                String adminorgScopeStr = (String)reviewImportFunBO.othParam.get("adminorgscope");
                String orgScopeStr = (String)reviewImportFunBO.othParam.get("orgscope");
                List adminorgIds = (List)SerializationUtils.fromJsonString((String)adminorgScopeStr, List.class);
                List orgIds = (List)SerializationUtils.fromJsonString((String)orgScopeStr, List.class);
                if (HRCollUtil.isNotEmpty((Collection)adminorgIds)) {
                    List adminorgIdStrList = adminorgIds.stream().map(String::valueOf).collect(Collectors.toList());
                    List orgIdStrList = orgIds.stream().map(String::valueOf).collect(Collectors.toList());
                    for (DynamicObject tFile2 : talentFileDOArr) {
                        if (!HRStringUtils.equals((String)number, (String)tFile2.getString("number"))) continue;
                        String adminorgId = tFile2.getString("affiliateadminorg.id");
                        String orgId = tFile2.getString("org.id");
                        if (adminorgIdStrList.contains(adminorgId) && orgIdStrList.contains(orgId)) continue;
                        LOG.info("ReviewObjImportFun.personPermitRangeVerify: adminorg/org is not contain, adminorg={}, org={}", (Object)adminorgId, (Object)orgId);
                        return ReviewImportFun.genResult(false, ResManager.loadKDString((String)"\u5f53\u524d\u6d3b\u52a8\u4e0b\u65e0\u4eba\u624d\u6863\u6848\u6570\u636e\u6743\u9650\uff1b", (String)"ReviewImportFun_1", (String)"tdc-oatr-formplugin", (Object[])new Object[0]));
                    }
                }
            }
            if (!CollectionUtils.isEmpty((Map)(nameJsonObj = (jsonObject = reviewImportFunBO.rowJson).getJSONObject("name")))) {
                name = nameJsonObj.getString(Lang.get().getLocale().toString());
            }
            String msg = String.format(ResManager.loadKDString((String)"%s\u4e0d\u7b26\u5408\u8be5\u76d8\u70b9\u6d3b\u52a8\u7684\u4eba\u5458\u8303\u56f4\u89c4\u5219\u3002", (String)"ReviewObjImportFun_0", (String)"tdc-oatr-formplugin", (Object[])new Object[0]), name);
            return ReviewImportFun.genResult(result, msg);
        };
    }

    public static boolean checkPerson(DynamicObject[] searchTalentFileDOsByNumbers, String number, String name) {
        boolean res = false;
        for (DynamicObject talentFile : searchTalentFileDOsByNumbers) {
            String talentFilePersonName = talentFile.getString("person.name");
            String talentFilePersonNumber = talentFile.getString("person.number");
            if (talentFilePersonName == null || talentFilePersonNumber == null || !talentFilePersonName.equals(name) || !talentFilePersonNumber.equals(number)) continue;
            res = true;
        }
        return res;
    }

    public static ReviewImportFun existVerify() {
        return reviewImportFunBO -> {
            Object reviewObjs = reviewImportFunBO.othParam.get("reviewObjs");
            if (Objects.isNull(reviewObjs)) {
                return ReviewImportFun.genSuccResult();
            }
            DynamicObject[] reviewObjArr = (DynamicObject[])reviewObjs;
            String number = reviewImportFunBO.rowJson.getString("number");
            boolean result = Arrays.stream(reviewObjArr).anyMatch(reviewObj -> HRStringUtils.equals((String)number, (String)reviewObj.getString("number")));
            String msg = ResManager.loadKDString((String)"\u76d8\u70b9\u5bf9\u8c61\u5df2\u5b58\u5728\uff1b", (String)"ReviewObjImportFun_1", (String)"tdc-oatr-formplugin", (Object[])new Object[0]);
            return ReviewImportFun.genResult(!result, msg);
        };
    }

    public static ReviewImportFun reviewGroupVerify() {
        return reviewImportFunBO -> {
            String msg = ResManager.loadKDString((String)"\u76d8\u70b9\u7ec4\u6570\u636e\u4e3a\u7a7a\uff1b", (String)"ReviewObjImportFun_5", (String)"tdc-oatr-formplugin", (Object[])new Object[0]);
            if (null == reviewImportFunBO.rowJson.getJSONObject("reviewgroup")) {
                return ReviewImportFun.genResult(false, msg);
            }
            msg = ResManager.loadKDString((String)"\u76d8\u70b9\u7ec4\u4e0d\u5b58\u5728\uff1b", (String)"ReviewObjImportFun_2", (String)"tdc-oatr-formplugin", (Object[])new Object[0]);
            Object reviewGroups = reviewImportFunBO.othParam.get("reviewGroup");
            if (Objects.isNull(reviewGroups)) {
                return ReviewImportFun.genResult(false, msg);
            }
            DynamicObject[] reviewGroupArr = (DynamicObject[])reviewGroups;
            String name = reviewImportFunBO.rowJson.getJSONObject("reviewgroup").getString("name");
            boolean result = Arrays.stream(reviewGroupArr).anyMatch(group -> HRStringUtils.equals((String)name, (String)group.getString("name")));
            return ReviewImportFun.genResult(result, msg);
        };
    }

    public static ReviewImportFun actStatusVerify() {
        return reviewImportFunBO -> {
            Object activityEndObj = reviewImportFunBO.othParam.get("activityEnd");
            boolean activityIsEnd = (Boolean)activityEndObj;
            return ReviewImportFun.genResult(!activityIsEnd, ResManager.loadKDString((String)"\u76d8\u70b9\u6d3b\u52a8\u72b6\u6001\u4e3a\u201c\u8fdb\u884c\u4e2d\u201d\u3001\u201c\u5f85\u542f\u52a8\u201d\uff0c\u624d\u80fd\u6dfb\u52a0\u76d8\u70b9\u5bf9\u8c61\u3002", (String)"ReviewObjImportFun_3", (String)"tdc-oatr-formplugin", (Object[])new Object[0]));
        };
    }
}

