/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.formplugin.web.activity.reviewobj;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.impt.common.dto.ImportBillData;
import kd.hr.impt.common.dto.ImportLog;
import kd.hr.impt.common.dto.ImportRowErrorLog;
import kd.hr.impt.common.enu.ValidatorEnum;
import kd.hr.impt.common.enu.ValidatorOrderEnum;
import kd.hr.impt.common.plugin.BeforeCallOperationEventArgs;
import kd.hr.impt.common.plugin.BeforeInitValidatorEventArgs;
import kd.hr.impt.common.plugin.BeforeQueryRefBdEventArgs;
import kd.hr.impt.common.plugin.BeforeShowTemplateSelectListEventArgs;
import kd.hr.impt.common.plugin.HRImportPlugin;
import kd.hr.impt.core.validate.AbstractValidateHandler;
import kd.tdc.oatr.bussiness.ServiceFactory;
import kd.tdc.oatr.bussiness.application.ReviewActivityApplicationService;
import kd.tdc.oatr.bussiness.application.ext.OatrPluginExternalService;
import kd.tdc.oatr.bussiness.application.ext.PermissionExternalService;
import kd.tdc.oatr.bussiness.domain.reviewgroup.ReviewGroupService;
import kd.tdc.oatr.bussiness.queryservice.ReviewActivityQueryService;
import kd.tdc.oatr.bussiness.queryservice.TalentFileQueryService;
import kd.tdc.oatr.common.bo.ValidateResult;
import kd.tdc.oatr.formplugin.web.activity.detail.ReviewActivityDetailCommon;
import kd.tdc.oatr.formplugin.web.activity.reviewobj.ReviewImportFun;
import kd.tdc.oatr.formplugin.web.activity.reviewobj.ReviewObjImportFun;
import kd.tdc.oatr.formplugin.web.common.ImportIgnoreValidateHandler;
import kd.tdc.tdcs.bussiness.license.TDCSCertCommonHelper;
import org.apache.commons.lang3.tuple.Pair;

public class ReviewObjImportPlugin
implements HRImportPlugin,
ReviewActivityDetailCommon,
Serializable {
    private static final HRBaseServiceHelper REVIEW_OBJ_REPOSITORY = new HRBaseServiceHelper("oatr_reviewobject");
    private static final String SELECT_PROP = String.join((CharSequence)",", "reviewactivity", "reviewgroup", "reviewstatus", "person");
    private static final HRBaseServiceHelper TDCS_TALENTFILE_HELPER = new HRBaseServiceHelper("tdcs_talentfile");
    private static final HRBaseServiceHelper REVIEWTOOLHELPER = new HRBaseServiceHelper("oatr_reviewgroup");
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ReviewObjImportPlugin.class);
    private final TalentFileQueryService talentFileQueryService = (TalentFileQueryService)ServiceFactory.getService(TalentFileQueryService.class);
    private static final ReviewActivityApplicationService reviewActivityAppService = (ReviewActivityApplicationService)ServiceFactory.getService(ReviewActivityApplicationService.class);
    private static final HRBaseServiceHelper REVIEWACTIVITY_HELPER = new HRBaseServiceHelper("oatr_reviewactivity");
    private static final PermissionExternalService permissionExternalService = (PermissionExternalService)ServiceFactory.getService(PermissionExternalService.class);
    private static final OatrPluginExternalService pluginExternalService = (OatrPluginExternalService)ServiceFactory.getService(OatrPluginExternalService.class);

    public void beforeQueryRefBd(BeforeQueryRefBdEventArgs args) {
        QFilter[] filters;
        super.beforeQueryRefBd(args);
        long activityId = this.getActivityId(args.getExtParams());
        boolean isCollaborator = this.getIsCollaborator(args.getExtParams());
        List<Object> userReviewGroupIds = new ArrayList(0);
        if (isCollaborator) {
            long currUserId = RequestContext.get().getCurrUserId();
            DynamicObject[] userReviewGroups = ((ReviewGroupService)ServiceFactory.getService(ReviewGroupService.class)).getReviewGroupByBosUser((Object)activityId, currUserId);
            userReviewGroupIds = this.getUserReviewGroupIds(userReviewGroups);
        }
        if (HRStringUtils.equals((String)"reviewgroup", (String)args.getFieldId()) && (filters = args.getFilters()).length > 0) {
            QFilter filter = filters[0];
            if (null != filter) {
                filter.and(new QFilter("reviewactivity.id", "=", (Object)activityId));
            } else {
                filter = new QFilter("reviewactivity.id", "=", (Object)activityId);
            }
            if (isCollaborator) {
                filter.and(new QFilter("id", "in", userReviewGroupIds));
            }
        }
    }

    private List<Long> getUserReviewGroupIds(DynamicObject[] userReviewGroups) {
        ArrayList<Long> userReviewGroupIds = new ArrayList<Long>(0);
        for (DynamicObject userReviewGroup : userReviewGroups) {
            userReviewGroupIds.add(userReviewGroup.getLong("id"));
        }
        return userReviewGroupIds;
    }

    public void beforeShowTemplateSelectList(BeforeShowTemplateSelectListEventArgs args) {
        super.beforeShowTemplateSelectList(args);
        ArrayList<String> templateNumbers = new ArrayList<String>(5);
        templateNumbers.add("evalinfo_new_preset");
        templateNumbers.add("dimresult_new_preset");
        templateNumbers.add("evalinfo_update_preset");
        templateNumbers.add("dimresult_update_preset");
        templateNumbers.add("evalinfo_updateandnew_preset");
        templateNumbers.add("dimresult_updateandnew_preset");
        QFilter filter = new QFilter("number", "not in", templateNumbers);
        args.setqFilterList(new ArrayList<QFilter>(Collections.singletonList(filter)));
    }

    public void beforeInitValidator(final BeforeInitValidatorEventArgs args) {
        super.beforeInitValidator(args);
        args.setValidator(ValidatorEnum.CUSTOM_VALIDATOR, new AbstractValidateHandler(){

            public ValidatorOrderEnum setValidatorRole() {
                return ValidatorOrderEnum.DEFAULT;
            }

            public void validate(List<ImportBillData> billDataList, ImportLog importLog) {
                ReviewImportFun.ReviewImportFunBO reviewImportFunBO = new ReviewImportFun.ReviewImportFunBO();
                long activityId = ReviewObjImportPlugin.this.getActivityId(args.getExtParams());
                Pair persons = ((ReviewActivityApplicationService)ServiceFactory.getService(ReviewActivityApplicationService.class)).listActivityTalentFilesByPersonScope(activityId);
                List<Object> talentFileIds = Lists.newArrayListWithExpectedSize((int)10);
                if (persons.getValue() != null) {
                    talentFileIds = Arrays.stream((Object[])persons.getValue()).map(person -> person.getPkValue().toString()).collect(Collectors.toList());
                }
                log.info("ReviewObjImportPlugin validate person talentFileIds:{}", (Object)talentFileIds);
                reviewImportFunBO.addOthParam("talentFileRange", persons);
                reviewImportFunBO.addOthParam("reviewGroup", ReviewObjImportPlugin.this.getReviewGroup(args.getExtParams()));
                reviewImportFunBO.addOthParam("activityEnd", ((ReviewActivityQueryService)ServiceFactory.getService(ReviewActivityQueryService.class)).getReviewActivityEnd((Object)activityId));
                QFilter activityIdQF = new QFilter("reviewactivity.id", "=", (Object)activityId);
                QFilter groupQF = new QFilter("reviewgroup.id", "!=", (Object)0L);
                DynamicObject[] reviewObjs = REVIEW_OBJ_REPOSITORY.query("number,person", new QFilter[]{activityIdQF, groupQF});
                reviewImportFunBO.addOthParam("reviewObjs", reviewObjs);
                QFilter dataStatusQFilter = new QFilter("datastatus", "=", (Object)"1");
                QFilter isCurFilter = new QFilter("iscurrentversion", "=", (Object)"1");
                QFilter isPrimary = new QFilter("isprimary", "=", (Object)"1");
                QFilter idQF = new QFilter("id", "=", (Object)activityId);
                DynamicObject act = REVIEWACTIVITY_HELPER.queryOne("adminorgentry.adminorgvid,adminorgentry.includesub", new QFilter[]{idQF});
                List adminorgIds = reviewActivityAppService.getActivityAdminorgIds(act);
                QFilter adminOrgFilter = null;
                if (HRCollUtil.isNotEmpty((Collection)adminorgIds)) {
                    adminOrgFilter = new QFilter("affiliateadminorg", "in", (Object)adminorgIds);
                }
                HasPermOrgResult permOrgResult = permissionExternalService.getAllPermOrgs("oatr_reviewobject", "47150e89000000ac");
                QFilter orgFilter = null;
                List hasPermOrgs = new ArrayList(10);
                if (!permOrgResult.hasAllOrgPerm()) {
                    hasPermOrgs = permOrgResult.getHasPermOrgs();
                    orgFilter = new QFilter("org", "in", hasPermOrgs);
                }
                reviewImportFunBO.addOthParam("adminorgscope", SerializationUtils.toJsonString((Object)adminorgIds));
                reviewImportFunBO.addOthParam("orgscope", SerializationUtils.toJsonString(hasPermOrgs));
                ArrayList<String> personNumber = new ArrayList<String>(16);
                for (ImportBillData impData : billDataList) {
                    JSONObject impRowData = impData.getData().getJSONObject(REVIEW_OBJ_REPOSITORY.getEntityName());
                    String number = impRowData.getString("number");
                    if (HRStringUtils.isEmpty((String)number)) continue;
                    personNumber.add(number);
                }
                QFilter personNumberQF = new QFilter("person.number", "in", personNumber);
                ArrayList<QFilter> talentFilterQFilters = new ArrayList<QFilter>(10);
                talentFilterQFilters.add(dataStatusQFilter);
                talentFilterQFilters.add(isCurFilter);
                talentFilterQFilters.add(isPrimary);
                talentFilterQFilters.add(personNumberQF);
                if (adminOrgFilter != null) {
                    talentFilterQFilters.add(adminOrgFilter);
                }
                if (orgFilter != null) {
                    talentFilterQFilters.add(orgFilter);
                }
                pluginExternalService.setQueryTalentFileFilter("importValidate", activityId, talentFilterQFilters);
                DynamicObject[] talentFileArr = TDCS_TALENTFILE_HELPER.query("id,number,person.number,person.name,affiliateadminorg", talentFilterQFilters.toArray(new QFilter[0]));
                reviewImportFunBO.addOthParam("talentFile", talentFileArr);
                DynamicObject[] talentDynamics = ReviewObjImportPlugin.this.searchTalentFileByNumbers(billDataList);
                reviewImportFunBO.addOthParam("searchTalentFileByNumbers", talentDynamics);
                Map certResultMap = ReviewObjImportPlugin.this.certValidate(talentDynamics);
                for (ImportBillData importBillData : billDataList) {
                    String forbid;
                    JSONObject fieldJson = importBillData.getData().getJSONObject(REVIEW_OBJ_REPOSITORY.getEntityName());
                    if (certResultMap != null && HRStringUtils.isNotEmpty((String)(forbid = (String)certResultMap.get("FORBID")))) {
                        ImportRowErrorLog importRowErrorLog = new ImportRowErrorLog(importBillData.getSheetName(), importBillData.getStartIndex(), importBillData.getEndIndex(), forbid, importLog);
                        importLog.writeRowLog(importRowErrorLog);
                        continue;
                    }
                    boolean flag = true;
                    for (ReviewImportFun reviewImportFun : ReviewObjImportPlugin.this.getValidatorList()) {
                        reviewImportFunBO.setRowImportType(importBillData.getOpType());
                        reviewImportFunBO.setRowJson(fieldJson);
                        ValidateResult validateResult = reviewImportFun.execute(reviewImportFunBO);
                        if (validateResult.getResult()) continue;
                        ImportRowErrorLog importRowErrorLog = new ImportRowErrorLog(importBillData.getSheetName(), importBillData.getStartIndex(), importBillData.getEndIndex(), validateResult.getErrorMsg(), importLog);
                        importLog.writeRowLog(importRowErrorLog);
                        flag = false;
                    }
                    if (certResultMap == null || !flag) continue;
                    String number = fieldJson.getString("number");
                    String errorMessage = (String)certResultMap.get(number);
                    ImportRowErrorLog importRowErrorLog = new ImportRowErrorLog(importBillData.getSheetName(), importBillData.getStartIndex(), importBillData.getEndIndex(), errorMessage, importLog);
                    importLog.writeRowLog(importRowErrorLog);
                }
            }
        });
        args.setValidator(ValidatorEnum.DATA_RULE_PERM_VALIDATOR, (AbstractValidateHandler)new ImportIgnoreValidateHandler());
    }

    private Map<String, String> certValidate(DynamicObject[] talentDynamics) {
        if (talentDynamics == null || talentDynamics.length == 0) {
            return null;
        }
        HashMap result = Maps.newHashMap();
        ArrayList personIdList = Lists.newArrayList();
        HashMap personIdNumberMap = Maps.newHashMap();
        Arrays.stream(talentDynamics).forEach(dynamicObject -> {
            long personId = dynamicObject.getLong("person");
            if (0L == personId) {
                return;
            }
            String number = dynamicObject.getString("number");
            String name = dynamicObject.getString("name");
            personIdList.add(personId);
            personIdNumberMap.put(personId, number + ',' + name);
        });
        Map certResultMap = TDCSCertCommonHelper.verifyCertByPersonId((String)"32J2T2KEXE6T", (String)"oatr_reviewobject", (List)personIdList);
        Object state = certResultMap.get("STATE");
        if ("NORMAL".equals(state)) {
            return null;
        }
        if ("FORBID".equals(state)) {
            Map data = (Map)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString(certResultMap.get("DATA")), Map.class);
            String message = data.get("message") == null ? "" : data.get("message").toString();
            result.put("FORBID", message);
            return result;
        }
        if ("FAIL".equals(state)) {
            ArrayList failPersonIdList = Lists.newArrayList();
            if (null != certResultMap.get("NEXISTID")) {
                List nExistPersonIdList = (List)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString(certResultMap.get("NEXISTID")), ArrayList.class);
                failPersonIdList.addAll(nExistPersonIdList);
            }
            if (null != certResultMap.get("EXCEPTID")) {
                List exceptPersonIdList = (List)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString(certResultMap.get("EXCEPTID")), ArrayList.class);
                failPersonIdList.addAll(exceptPersonIdList);
            }
            failPersonIdList.forEach(failPersonId -> {
                String numberAndName = (String)personIdNumberMap.get(failPersonId);
                if (HRStringUtils.isBlank((CharSequence)numberAndName)) {
                    return;
                }
                String[] split = numberAndName.split(",");
                String number = split[0];
                String name = split[1];
                String errorInfo = ResManager.loadKDString((String)"{0}\u8bb8\u53ef\u6821\u9a8c\u5f02\u5e38\uff0c\u65e0\u6cd5\u6267\u884c\u8be5\u64cd\u4f5c\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u786e\u8ba4\u8bb8\u53ef\u4fe1\u606f\u3002", (String)"ReviewObjectJoinList_7", (String)"tdc-oatr-formplugin", (Object[])new Object[]{name});
                result.put(number, errorInfo);
            });
        }
        return result;
    }

    private DynamicObject[] searchTalentFileByNumbers(List<ImportBillData> impDatas) {
        ArrayList<String> personNumber = new ArrayList<String>(16);
        for (ImportBillData impData : impDatas) {
            JSONObject impRowData = impData.getData().getJSONObject(REVIEW_OBJ_REPOSITORY.getEntityName());
            String number = impRowData.getString("number");
            if (HRStringUtils.isEmpty((String)number)) continue;
            personNumber.add(number);
        }
        DynamicObject[] talentFileByNumbers = this.talentFileQueryService.listTalentFileByNumbers(personNumber);
        return talentFileByNumbers;
    }

    private long getActivityId(String extParam) {
        if (HRStringUtils.isEmpty((String)extParam)) {
            return 0L;
        }
        JSONObject jsonObject = JSONObject.parseObject((String)extParam);
        return jsonObject.getLongValue("activityId");
    }

    private boolean getIsCollaborator(String extParam) {
        boolean isCollaborator = false;
        if (HRStringUtils.isEmpty((String)extParam)) {
            return false;
        }
        JSONObject jsonObject = JSONObject.parseObject((String)extParam);
        long isCollaboratorValue = jsonObject.getLongValue("isCollaborator");
        if (isCollaboratorValue == 1L) {
            isCollaborator = true;
        }
        return isCollaborator;
    }

    protected List<ReviewImportFun> getValidatorList() {
        LinkedList<ReviewImportFun> validatorList = new LinkedList<ReviewImportFun>();
        validatorList.add(ReviewObjImportFun.personPermitRangeVerify());
        validatorList.add(ReviewObjImportFun.existVerify());
        validatorList.add(ReviewObjImportFun.reviewGroupVerify());
        validatorList.add(ReviewObjImportFun.actStatusVerify());
        return validatorList;
    }

    private DynamicObject[] getReviewGroup(String extParams) {
        long activityId = this.getActivityId(extParams);
        QFilter qFilter = new QFilter("reviewactivity", "=", (Object)activityId);
        return REVIEWTOOLHELPER.query("number,name", qFilter.toArray());
    }

    public void beforeCallOperation(BeforeCallOperationEventArgs args) {
        super.beforeCallOperation(args);
        OperateOption option = OperateOption.create();
        long activityId = this.getActivityId(args.getExtParams());
        option.setVariableValue("activityId", String.valueOf(activityId));
        option.setVariableValue("successData", SerializationUtils.toJsonString((Object)args.getDynamicObjects()));
        DynamicObject[] succDynamicObjects = (DynamicObject[])args.getDynamicObjects();
        List nums = Arrays.stream(succDynamicObjects).map(dyn -> dyn.getString("number")).collect(Collectors.toList());
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        QFilter dataStatusQFilter = new QFilter("datastatus", "=", (Object)"1");
        QFilter numQFilter = new QFilter("person.number", "in", nums);
        QFilter isCurFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter isPrimary = new QFilter("isprimary", "=", (Object)"1");
        qFilters.add(dataStatusQFilter);
        qFilters.add(numQFilter);
        qFilters.add(isCurFilter);
        qFilters.add(isPrimary);
        pluginExternalService.setQueryTalentFileFilter("importBeforeOp", activityId, qFilters);
        DynamicObject[] talentFileArr = TDCS_TALENTFILE_HELPER.query("id,person.id,person.name,org.id,affiliateadminorg.id,job.id,adminorg.id,company.id,position.id,stdposition.id", qFilters.toArray(new QFilter[0]));
        List talentFileIds = Arrays.stream(talentFileArr).map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
        option.setVariableValue("talentFiles", SerializationUtils.toJsonString(talentFileIds));
        args.setOperateOptions((Map)ImmutableMap.of((Object)REVIEW_OBJ_REPOSITORY.getEntityName(), (Object)option));
        args.setSubmitOPs((Map)ImmutableMap.of((Object)REVIEW_OBJ_REPOSITORY.getEntityName(), (Object)"importobjsave"));
    }
}

