/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.formplugin.web.activity.reviewobj;

import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.TreeView;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.tdc.oatr.formplugin.web.activity.detail.ReviewActivityDetailCommon;
import kd.tdc.oatr.formplugin.web.common.ReviewActivityTreeUtil;
import org.apache.commons.lang3.StringUtils;

public class ReviewObjectF7TreeListPlugin
extends StandardTreeListPlugin
implements ReviewActivityDetailCommon {
    public void initializeTree(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String collaboration = (String)formShowParameter.getCustomParam("collaboration_flag");
        Long activityId = this.getActivityLongId(this.getView());
        TreeNode treeNode = ReviewActivityTreeUtil.buildReviewObjF7Tree(activityId, collaboration);
        this.getTreeModel().setRoot(treeNode);
        this.getTreeModel().setCurrentNodeId((Object)"alreadyjoin");
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        Long activityId = this.getActivityLongId(this.getView());
        QFilter groupFilter = this.getGroupQFilter();
        e.getQFilters().add(new QFilter("reviewactivity.id", "=", (Object)activityId));
        if (groupFilter != null) {
            e.getQFilters().add(groupFilter);
        }
    }

    protected QFilter nodeClickFilter() {
        TreeView userGroupTree = (TreeView)this.getControl("treeview");
        String focusNodeId = userGroupTree.getTreeState().getFocusNodeId();
        if ("alreadyjoin".equals(focusNodeId)) {
            return this.getGroupQFilter();
        }
        if (StringUtils.isNotEmpty((CharSequence)focusNodeId)) {
            return new QFilter("reviewgroup.id", "=", (Object)Long.parseLong(focusNodeId));
        }
        return null;
    }

    private QFilter getGroupQFilter() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String collaboration = (String)formShowParameter.getCustomParam("collaboration_flag");
        Long activityId = this.getActivityLongId(this.getView());
        boolean isCollaborator = "1".equals(collaboration);
        Object[] groupInfos = ReviewActivityTreeUtil.getGroupInfo(activityId, RequestContext.get().getCurrUserId(), isCollaborator);
        if (HRArrayUtils.isEmpty((Object[])groupInfos)) {
            return null;
        }
        List groupIdList = Arrays.stream(groupInfos).map(dy -> dy.getLong("id")).collect(Collectors.toList());
        return new QFilter("reviewgroup.id", "in", groupIdList);
    }
}

