/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.formplugin.web.activity.reviewobj;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.mvc.form.FormDataModel;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.tdc.oatr.bussiness.ServiceFactory;
import kd.tdc.oatr.bussiness.domain.reviewobjct.ReviewObjectService;
import kd.tdc.oatr.bussiness.queryservice.ReviewSuperiorEvalQueryService;
import kd.tdc.oatr.common.utils.JsonUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class ReviewObjectInviteSuperiorFillEvalPopPlugin
extends HRDynamicFormBasePlugin {
    public static final String DONOTHING_CHANGEEVAL = "donothing_changeeval";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        List reviewObjIds = (List)formShowParameter.getCustomParam("list_select_review_objs");
        Map reviewObjectLastQuestion = ((ReviewSuperiorEvalQueryService)ServiceFactory.getService(ReviewSuperiorEvalQueryService.class)).getReviewObjectEvalLastQuestion(reviewObjIds);
        DynamicObject[] reviewObjects = ((ReviewObjectService)ServiceFactory.getService(ReviewObjectService.class)).listReviewObject(reviewObjIds);
        LinkedList questionEntryDataList = Lists.newLinkedList();
        for (DynamicObject reviewObject : reviewObjects) {
            long reviewObjId = reviewObject.getLong("id");
            DynamicObjectCollection superiorEvalCol = reviewObject.getDynamicObjectCollection("supereval");
            if (CollectionUtils.isEmpty((Collection)superiorEvalCol)) {
                questionEntryDataList.add(new QuestionEntryData(reviewObject.getPkValue()));
                continue;
            }
            for (DynamicObject superiorObj : superiorEvalCol) {
                Set questionObjs;
                long superiorId = superiorObj.getLong("fbasedataid_id");
                if (superiorId == 0L) continue;
                QuestionEntryData questionEntryData = new QuestionEntryData(reviewObject.getPkValue(), superiorId);
                questionEntryDataList.add(questionEntryData);
                Map evaluatorQuestions = (Map)reviewObjectLastQuestion.get(reviewObjId);
                if (!MapUtils.isNotEmpty((Map)evaluatorQuestions) || !CollectionUtils.isNotEmpty((Collection)(questionObjs = (Set)evaluatorQuestions.get(superiorId)))) continue;
                questionObjs.stream().filter(obj -> obj.getLong("evaluator.id") == superiorId).findFirst().ifPresent(obj -> {
                    String evalStatus = obj.getString("evalstatus");
                    questionEntryData.setDataStatus(evalStatus);
                    if ("A".equals(evalStatus)) {
                        questionEntryDataList.removeLast();
                    }
                });
            }
        }
        this.paddingEntryData(questionEntryDataList);
    }

    private void paddingEntryData(LinkedList<QuestionEntryData> questionEntryDataList) {
        if (CollectionUtils.isNotEmpty(questionEntryDataList)) {
            TableValueSetter tableValueSetter = new TableValueSetter(new String[0]);
            for (QuestionEntryData questionEntryData : questionEntryDataList) {
                tableValueSetter.addField("reviewobject", new Object[]{questionEntryData.getPk()});
                tableValueSetter.addField("personfield", new Object[]{questionEntryData.getSuperiorId()});
                tableValueSetter.addField("superiorevalstatus", new Object[]{questionEntryData.getDataStatus()});
            }
            FormDataModel model = (FormDataModel)this.getModel();
            model.batchCreateNewEntryRow("entryentity", tableValueSetter);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        boolean cancelDataRight = this.getView().getParentView().getFormShowParameter().isCancelDataRight();
        if (cancelDataRight) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u4f60\u7684\u6570\u636e\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u5237\u65b0\u6216\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"ReviewActivityColList_1", (String)"tdc-oatr-formplugin", (Object[])new Object[0]), MessageBoxOptions.None);
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (DONOTHING_CHANGEEVAL.equals(operateKey)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
            int[] selectRows = entryGrid.getSelectRows();
            if (selectRows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ReviewObjectInviteSuperiorFillEvalPopPlugin_0", (String)"tdc-oatr-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject[] dataEntities = entryGrid.getEntryData().getDataEntitys();
            HashMap objSuperior = Maps.newHashMapWithExpectedSize((int)selectRows.length);
            for (int selectRow : selectRows) {
                DynamicObject selectDataEntity = dataEntities[selectRow];
                long reviewObjId = selectDataEntity.getLong("reviewobject.id");
                Set superiors = (Set)objSuperior.get(reviewObjId);
                if (CollectionUtils.isEmpty((Collection)superiors)) {
                    objSuperior.put(reviewObjId, Sets.newHashSet((Object[])new Long[]{selectDataEntity.getLong("personfield.id")}));
                    continue;
                }
                superiors.add(selectDataEntity.getLong("personfield.id"));
            }
            String selReviewObjIds = JsonUtils.toString((Object)objSuperior);
            this.getView().returnDataToParent((Object)selReviewObjIds);
            this.getView().close();
        }
    }

    static class QuestionEntryData {
        private Object pk;
        private long superiorId;
        private String dataStatus;

        public QuestionEntryData() {
        }

        public QuestionEntryData(Object pk, long superiorId) {
            this.pk = pk;
            this.superiorId = superiorId;
        }

        public QuestionEntryData(Object pk) {
            this.pk = pk;
        }

        public QuestionEntryData(Object pk, long superiorId, String dataStatus) {
            this.pk = pk;
            this.superiorId = superiorId;
            this.dataStatus = dataStatus;
        }

        public Object getPk() {
            return this.pk;
        }

        public void setPk(Object pk) {
            this.pk = pk;
        }

        public long getSuperiorId() {
            return this.superiorId;
        }

        public void setSuperiorId(long superiorId) {
            this.superiorId = superiorId;
        }

        public String getDataStatus() {
            return StringUtils.isEmpty((CharSequence)this.dataStatus) ? "D" : this.dataStatus;
        }

        public void setDataStatus(String dataStatus) {
            this.dataStatus = dataStatus;
        }
    }
}

