/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.formplugin.web.activity.reviewobj;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.CommonBaseDataFilterColumn;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.SchemeFilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.mservice.HRMServiceResult;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseList;
import kd.tdc.oatr.bussiness.ServiceFactory;
import kd.tdc.oatr.bussiness.application.ReviewActivityApplicationService;
import kd.tdc.oatr.bussiness.application.ext.PermissionExternalService;
import kd.tdc.oatr.bussiness.domain.reviewgroup.ReviewGroupService;
import kd.tdc.oatr.bussiness.domain.reviewobjct.ReviewObjectService;
import kd.tdc.oatr.bussiness.queryservice.ReviewActivityQueryService;
import kd.tdc.oatr.bussiness.queryservice.ReviewObjectQueryService;
import kd.tdc.oatr.bussiness.queryservice.TalentFileQueryService;
import kd.tdc.oatr.common.constants.enums.ActivityStatusEnum;
import kd.tdc.oatr.common.constants.enums.ObjectStatusEnum;
import kd.tdc.oatr.formplugin.web.activity.detail.ReviewActivityDetailCommon;

public class ReviewObjectList
extends HRCoreBaseList
implements ReviewActivityDetailCommon {
    private final ReviewActivityApplicationService reviewApplicationService = (ReviewActivityApplicationService)ServiceFactory.getService(ReviewActivityApplicationService.class);
    private static final HRBaseServiceHelper REVIEWGROUP_REPOSITORY = new HRBaseServiceHelper("oatr_reviewgroup");
    private static final HRBaseServiceHelper REVIEWOBJECT_REPOSITORY = new HRBaseServiceHelper("oatr_reviewobject");
    private static final HRBaseServiceHelper ACTIVITYHELPER = new HRBaseServiceHelper("oatr_reviewactivity");
    private static final ReviewObjectService reviewObjectService = (ReviewObjectService)ServiceFactory.getService(ReviewObjectService.class);
    private final ReviewObjectQueryService reviewObjectQueryService = (ReviewObjectQueryService)ServiceFactory.getService(ReviewObjectQueryService.class);
    private static final ReviewActivityQueryService reviewActivityQueryService = (ReviewActivityQueryService)ServiceFactory.getService(ReviewActivityQueryService.class);
    private static final ReviewGroupService reviewGroupService = (ReviewGroupService)ServiceFactory.getService(ReviewGroupService.class);
    private static final PermissionExternalService permissionExternalService = (PermissionExternalService)ServiceFactory.getService(PermissionExternalService.class);
    private static final TalentFileQueryService talentFileQueryService = (TalentFileQueryService)ServiceFactory.getService(TalentFileQueryService.class);
    private static final Log logger = LogFactory.getLog(ReviewObjectList.class);
    private static final String[] tblArray = new String[]{"addreviewobj", "importobjdata", "deleteobj", "tblterminate", "changegroup", "changeevaluator", "inviteempfilleval", "invitesuperiorfilleval", "tblimportdim", "tblexport", "joinreviewobj", "bartalentpool"};
    private static final String[] tblJoinArray = new String[]{"addreviewobj", "importobjdata", "deleteobj", "tblterminate", "changegroup", "changeevaluator", "inviteempfilleval", "bartalentpool", "invitesuperiorfilleval", "tblimportdim", "tblexport"};
    private static final String[] tblGroupArray = new String[]{"addreviewobj", "importobjdata", "deleteobj"};
    private static final String[] tblProcessArray = new String[]{"tblterminate", "changeevaluator", "inviteempfilleval", "bartalentpool", "invitesuperiorfilleval", "tblimportdim"};

    public void setFilter(SetFilterEvent setFilterEvent) {
        super.setFilter(setFilterEvent);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        List groupIdList = (List)parameter.getCustomParam("groupId");
        String nodeId = (String)parameter.getCustomParam("nodeId");
        String isFinishInit = (String)parameter.getCustomParam("isFromTreeNodeClick");
        if (HRStringUtils.equals((String)isFinishInit, (String)"1")) {
            QFilter reviewStatusFilter = new QFilter("reviewstatus", "in", (Object)Lists.newArrayList((Object[])new String[]{ObjectStatusEnum.WAIT_START.getCode(), ObjectStatusEnum.GOING_UNCHECK.getCode(), ObjectStatusEnum.GOING_CHECK.getCode(), ObjectStatusEnum.END.getCode()}));
            setFilterEvent.getQFilters().add(reviewStatusFilter);
            parameter.setCustomParam("isFromTreeNodeClick", (Object)"0");
            this.getView().cacheFormShowParameter();
        }
        if (HRStringUtils.equals((String)nodeId, (String)"notjoin")) {
            setFilterEvent.getQFilters().removeIf(filter -> HRStringUtils.equals((String)filter.getProperty(), (String)"reviewstatus"));
            groupIdList = Lists.newArrayList((Object[])new Long[]{0L});
        }
        QFilter groupIdListQF = new QFilter("reviewgroup.id", "in", (Object)groupIdList);
        setFilterEvent.getQFilters().add(groupIdListQF);
        Long activityId = (Long)parameter.getCustomParam("activityId");
        logger.info("ReviewObjectList setFilter activityId:{}", (Object)activityId);
        if (activityId == null || activityId == 0L) {
            return;
        }
        QFilter activityIdQF = new QFilter("reviewactivity.id", "=", (Object)activityId);
        setFilterEvent.getQFilters().add(activityIdQF);
        HasPermOrgResult permOrgResult = permissionExternalService.getAllPermOrgs("oatr_reviewobject", "47150e89000000ac");
        if (!permOrgResult.hasAllOrgPerm()) {
            List hasPermOrgs = permOrgResult.getHasPermOrgs();
            setFilterEvent.getQFilters().add(new QFilter("talentfile.org", "in", (Object)hasPermOrgs));
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        List groupIdList = (List)parameter.getCustomParam("groupId");
        List commonFilterColumns = args.getCommonFilterColumns();
        List schemeFilterColumns = args.getSchemeFilterColumns();
        if (CollectionUtils.isEmpty((Collection)groupIdList)) {
            commonFilterColumns.remove(0);
            schemeFilterColumns.remove(2);
            SchemeFilterColumn reviewStatusFilterColumn = (SchemeFilterColumn)schemeFilterColumns.get(2);
            List comboItems = reviewStatusFilterColumn.getComboItems();
            reviewStatusFilterColumn.setComboItems((List)Lists.newArrayList((Object[])new ComboItem[]{(ComboItem)comboItems.get(0)}));
        } else {
            ((FilterColumn)commonFilterColumns.get(0)).setDefaultValues(new Object[]{ObjectStatusEnum.WAIT_START.getCode(), ObjectStatusEnum.GOING_UNCHECK.getCode(), ObjectStatusEnum.GOING_CHECK.getCode(), ObjectStatusEnum.END.getCode()});
            List comboItems = ((CommonFilterColumn)commonFilterColumns.get(0)).getComboItems();
            comboItems.remove(0);
            SchemeFilterColumn reviewStatusFilterColumn = (SchemeFilterColumn)schemeFilterColumns.get(3);
            reviewStatusFilterColumn.getComboItems().remove(0);
        }
        HashSet comOrgComboItems = Sets.newHashSetWithExpectedSize((int)16);
        HashSet adminOrgComboItems = Sets.newHashSetWithExpectedSize((int)16);
        String nodeId = (String)parameter.getCustomParam("nodeId");
        if (HRStringUtils.equals((String)nodeId, (String)"notjoin")) {
            groupIdList = Lists.newArrayList((Object[])new Long[]{0L});
        }
        QFilter groupIdListQF = new QFilter("reviewgroup.id", "in", (Object)groupIdList);
        Long activityId = (Long)parameter.getCustomParam("activityId");
        logger.info("ReviewObjectList filterContainerInit activityId:{}", (Object)activityId);
        if (activityId == null || activityId == 0L) {
            return;
        }
        QFilter activityIdQF = new QFilter("reviewactivity.id", "=", (Object)activityId);
        DynamicObject[] reviewObjects = REVIEWOBJECT_REPOSITORY.query("company,adminorg", new QFilter[]{groupIdListQF, activityIdQF});
        for (DynamicObject reviewObject : reviewObjects) {
            ComboItem comOrgComboItem = new ComboItem();
            DynamicObject company = reviewObject.getDynamicObject("company");
            if (!HRObjectUtils.isEmpty((Object)company)) {
                comOrgComboItem.setCaption(new LocaleString(reviewObject.getString("company.name")));
                comOrgComboItem.setValue(reviewObject.getString("company.id"));
                comOrgComboItem.setDisable(false);
                comOrgComboItem.setItemVisible(true);
                comOrgComboItems.add(comOrgComboItem);
            }
            ComboItem adminOrgComboItem = new ComboItem();
            DynamicObject adminorg = reviewObject.getDynamicObject("adminorg");
            if (HRObjectUtils.isEmpty((Object)adminorg)) continue;
            adminOrgComboItem.setCaption(new LocaleString(reviewObject.getString("adminorg.name")));
            adminOrgComboItem.setValue(reviewObject.getString("adminorg.id"));
            adminOrgComboItem.setDisable(false);
            adminOrgComboItem.setItemVisible(true);
            adminOrgComboItems.add(adminOrgComboItem);
        }
        for (FilterColumn filterColumn2 : commonFilterColumns) {
            if (HRStringUtils.equals((String)"company.name", (String)filterColumn2.getFieldName())) {
                ((CommonBaseDataFilterColumn)filterColumn2).setComboItems((List)Lists.newArrayList((Iterable)comOrgComboItems));
                continue;
            }
            if (!HRStringUtils.equals((String)"adminorg.name", (String)filterColumn2.getFieldName())) continue;
            ((CommonBaseDataFilterColumn)filterColumn2).setComboItems((List)Lists.newArrayList((Iterable)adminOrgComboItems));
        }
        String openKey = (String)parameter.getCustomParam("openKey");
        if (HRStringUtils.equals((String)openKey, (String)"oatr_reviewgroup") || HRStringUtils.equals((String)openKey, (String)"oatr_colreviewgroup")) {
            ArrayList<String> removeKeys = new ArrayList<String>(10);
            removeKeys.add("termreviewreson");
            removeKeys.add("termreviewrsndesc");
            removeKeys.add("supereval");
            List filterColumns = args.getSchemeFilterColumns();
            filterColumns.removeIf(filterColumn -> {
                String fieldName = filterColumn.getFieldName();
                for (String removeKey : removeKeys) {
                    if (!fieldName.contains(removeKey)) continue;
                    return true;
                }
                return false;
            });
        }
        logger.info("ReviewObjectList init comOrgComboItems: {}", (Object)SerializationUtils.toJsonString((Object)comOrgComboItems));
        logger.info("ReviewObjectList init adminOrgComboItems: {}", (Object)SerializationUtils.toJsonString((Object)adminOrgComboItems));
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        List listColumns = args.getListColumns();
        for (IListColumn listColumn : listColumns) {
            if (!"number".equals(listColumn.getListFieldKey()) && !"name".equals(listColumn.getListFieldKey()) && !HRStringUtils.equals((String)"person.headsculpture", (String)listColumn.getListFieldKey())) continue;
            listColumn.setFixed(true);
        }
        FormShowParameter parameter = this.getView().getFormShowParameter();
        List groupIdList = (List)parameter.getCustomParam("groupId");
        String openPage = (String)parameter.getCustomParam("openKey");
        if (CollectionUtils.isEmpty((Collection)groupIdList) || HRStringUtils.equals((String)openPage, (String)"oatr_reviewgroup") || HRStringUtils.equals((String)openPage, (String)"oatr_colreviewgroup")) {
            IListColumn errorMsgContent = args.getListColumn("errormsg");
            IListColumn reviewGroup = args.getListColumn("reviewgroup.name");
            IListColumn termReviewReson = args.getListColumn("termreviewreson.name");
            IListColumn termReviewRsnDesc = args.getListColumn("termreviewrsndesc");
            IListColumn superEval = args.getListColumn("supereval.name");
            List columns = args.getListColumns();
            columns.remove(errorMsgContent);
            columns.remove(reviewGroup);
            columns.remove(termReviewReson);
            columns.remove(termReviewRsnDesc);
            columns.remove(superEval);
            List dynamicTextListColumns = args.getDynamicTextListColumns();
            dynamicTextListColumns.forEach(dynamicTextListColumn -> {
                if ("employeeeval".equals(dynamicTextListColumn.getKey()) || "superioreval".equals(dynamicTextListColumn.getKey())) {
                    dynamicTextListColumn.setVisible(0);
                }
            });
            List listGroupColumns = args.getListGroupColumns();
            ArrayList<String> removeGroupKey = new ArrayList<String>(10);
            removeGroupKey.add("calibratefinal");
            removeGroupKey.add("calibrateresult");
            removeGroupKey.add("calibrateresultbefore");
            removeGroupKey.add("associateeval");
            listGroupColumns.removeIf(groupColumn -> removeGroupKey.contains(groupColumn.getKey()));
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setButtonVisible();
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String itemKey = evt.getItemKey();
        if (!this.reviewObjListOpCheckCollaboratorPerm(this.getView(), itemKey)) {
            evt.setCancel(true);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        OperateOption option = operate.getOption();
        String operateKey = operate.getOperateKey();
        IListView listView = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = listView.getSelectedRows();
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Long activityId = (Long)parameter.getCustomParam("activityId");
        DynamicObject actDynamicObject = ACTIVITYHELPER.queryOriginalOne("activitystatus", (Object)activityId);
        if (actDynamicObject == null) {
            args.setCancel(true);
            String msg = ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"ReviewObjectList_4", (String)"tdc-oatr-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            return;
        }
        String activityStatus = actDynamicObject.getString("activitystatus");
        String collaborationFlag = (String)this.getView().getFormShowParameter().getCustomParam("collaboration_flag");
        if (HRStringUtils.equals((String)"1", (String)collaborationFlag) && (HRStringUtils.equals((String)"delete", (String)operateKey) || HRStringUtils.equals((String)"terminate", (String)operateKey))) {
            Long actId = this.getActivityLongId(this.getView());
            long currUserId = RequestContext.get().getCurrUserId();
            QFilter userQFilter = new QFilter("entryentity.collaborator", "=", (Object)currUserId);
            QFilter statusQFilter = new QFilter("entryentity.colstatus", "=", (Object)"1");
            DynamicObject[] activityQF = new QFilter("reviewactivity.id", "=", (Object)actId);
            DynamicObject[] reviewObjects = REVIEWOBJECT_REPOSITORY.query("reviewgroup", new QFilter[]{new QFilter("id", "in", (Object)selectedRows.getPrimaryKeyValues())});
            Set reviewGroupIdSet = Arrays.stream(reviewObjects).map(reviewObject -> reviewObject.getLong("reviewgroup.id")).collect(Collectors.toSet());
            QFilter idQF = new QFilter("id", "in", reviewGroupIdSet);
            DynamicObject[] reviewGroups = REVIEWGROUP_REPOSITORY.query("id", new QFilter[]{userQFilter, statusQFilter, activityQF, idQF});
            if (reviewGroupIdSet.size() != reviewGroups.length) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u4f60\u7684\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u5237\u65b0\u6216\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"ReviewActivityColList_0", (String)"tdc-oatr-formplugin", (Object[])new Object[0]), MessageBoxOptions.None);
                args.setCancel(true);
                return;
            }
        }
        if (HRStringUtils.equals((String)"delete", (String)operateKey)) {
            this.setOptionParam(this.getView(), option);
            String entityNum = "oatr_reviewactivity";
            if (HRStringUtils.equals((String)((String)this.getView().getFormShowParameter().getCustomParam("collaboration_flag")), (String)"1")) {
                entityNum = "oatr_colreviewactivity";
            }
            String permit = "47150e89000000ac";
            HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((Long)RequestContext.get().getCurrUserId(), (String)"32J2T2KEXE6T", (String)entityNum, (String)permit);
            if (!result.hasAllOrgPerm()) {
                List hasPermOrgs = result.getHasPermOrgs();
                DynamicObject activity = ACTIVITYHELPER.queryOne("createorg.id", new QFilter[]{new QFilter("id", "=", (Object)activityId)});
                if (activity != null && !hasPermOrgs.contains(activity.getLong("createorg.id"))) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u4f60\u7684\u6570\u636e\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u5237\u65b0\u6216\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"ReviewActivityColList_1", (String)"tdc-oatr-formplugin", (Object[])new Object[0]), MessageBoxOptions.None);
                    args.setCancel(true);
                    return;
                }
            }
        }
        HashSet operateKeys = Sets.newHashSet((Object[])new String[]{"delete", "terminate", "donothing_changegroup", "donothing_changeevaluator", "donothing_inviteempfilleval", "donothing_invitesuperiorfilleval"});
        String nodeId = (String)parameter.getCustomParam("nodeId");
        DynamicObject[] reviewObjects = REVIEWOBJECT_REPOSITORY.query("reviewgroup", new QFilter[]{new QFilter("id", "in", (Object)selectedRows.getPrimaryKeyValues())});
        int i = 0;
        HashMap reviewObjectOfIds = Maps.newHashMapWithExpectedSize((int)reviewObjects.length);
        for (DynamicObject reviewObject2 : reviewObjects) {
            if (reviewObject2 == null) continue;
            reviewObjectOfIds.put(reviewObject2.getLong("id"), reviewObject2);
            if (!operateKeys.contains(operateKey) || HRStringUtils.equals((String)nodeId, (String)"notjoin") || !HRStringUtils.equals((String)(reviewObject2.getLong("reviewgroup.id") + ""), (String)"0")) continue;
            ++i;
        }
        if (operateKeys.contains(operateKey) && selectedRows.size() == i && i > 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"ReviewActivityColList_3", (String)"tdc-oatr-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (HRStringUtils.equals((String)"recommendtalent", (String)operateKey)) {
            String syncRecommendTalent = option.getVariableValue("syncRecommendTalent", "");
            if (!HRStringUtils.isEmpty((String)syncRecommendTalent)) {
                return;
            }
            this.isExistReviewObj(selectedRows, reviewObjectOfIds);
        }
        switch (operateKey) {
            case "importobjdata": {
                if (HRStringUtils.equals((String)activityStatus, (String)ActivityStatusEnum.WAIT_START.getCode()) || HRStringUtils.equals((String)activityStatus, (String)ActivityStatusEnum.GOING.getCode())) break;
                String errorMsg = ResManager.loadKDString((String)"\u76d8\u70b9\u6d3b\u52a8\u72b6\u6001\u4e3a\u201c\u8fdb\u884c\u4e2d\u201d\u3001\u201c\u5f85\u542f\u52a8\u201d\uff0c\u624d\u80fd\u6dfb\u52a0\u76d8\u70b9\u5bf9\u8c61\u3002", (String)"ReviewActivityList_2", (String)"tdc-oatr-formplugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(errorMsg);
                this.getView().invokeOperation("refresh");
                args.setCancel(true);
                break;
            }
            case "terminate": {
                args.setCancel(true);
                ListSelectedRowCollection listSelectedData = this.getSelectedRows();
                Object[] primaryKeyValues = listSelectedData.getPrimaryKeyValues();
                DynamicObject[] reviewObjs = REVIEWOBJECT_REPOSITORY.query("reviewactivity.activitystatus,reviewstatus", new QFilter[]{new QFilter("id", "in", (Object)primaryKeyValues)});
                if (reviewObjs.length == 0) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"ReviewActivityList_1", (String)"tdc-oatr-formplugin", (Object[])new Object[0]));
                    break;
                }
                if (!HRStringUtils.equals((String)activityStatus, (String)ActivityStatusEnum.WAIT_START.getCode()) && !HRStringUtils.equals((String)activityStatus, (String)ActivityStatusEnum.GOING.getCode())) {
                    String errorMsg = ResManager.loadKDString((String)"\u76d8\u70b9\u6d3b\u52a8\u72b6\u6001\u4e3a\u201c\u8fdb\u884c\u4e2d\u201d\uff0c\u624d\u80fd\u7ec8\u6b62\u76d8\u70b9\u3002", (String)"ReviewObjectStopValidator_0", (String)"tdc-oatr-opplugin", (Object[])new Object[0]);
                    this.getView().showErrorNotification(errorMsg);
                    this.getView().invokeOperation("refresh");
                    break;
                }
                int j = 0;
                for (DynamicObject reviewObj : reviewObjs) {
                    String reviewStatus = reviewObj.getString("reviewstatus");
                    if (HRStringUtils.equals((String)reviewStatus, (String)ObjectStatusEnum.WAIT_START.getCode()) || HRStringUtils.equals((String)reviewStatus, (String)ObjectStatusEnum.GOING_UNCHECK.getCode()) || HRStringUtils.equals((String)reviewStatus, (String)ObjectStatusEnum.GOING_CHECK.getCode())) continue;
                    ++j;
                }
                if (j == reviewObjs.length) {
                    String errorMsg = ResManager.loadKDString((String)"\u76d8\u70b9\u72b6\u6001\u5fc5\u987b\u662f\u201c\u5f85\u542f\u52a8\u3001\u8fdb\u884c\u4e2d-\u672a\u6821\u51c6\u3001\u8fdb\u884c\u4e2d-\u5df2\u6821\u51c6\u201d\u624d\u80fd\u7ec8\u6b62\u76d8\u70b9\u3002", (String)"ReviewObjectStopValidator_1", (String)"tdc-oatr-opplugin", (Object[])new Object[0]);
                    this.getView().showErrorNotification(errorMsg);
                    this.getView().invokeOperation("refresh");
                    break;
                }
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.setFormId("oatr_terminateobject");
                formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                formShowParameter.setCustomParam("id", (Object)primaryKeyValues);
                formShowParameter.setCustomParam("activityId", (Object)activityId);
                Set reviewGroupIdSet = Arrays.stream(reviewObjects).map(reviewObject -> reviewObject.getLong("reviewgroup.id")).collect(Collectors.toSet());
                formShowParameter.setCustomParam("reviewGroupIdSet", reviewGroupIdSet);
                formShowParameter.setCustomParam("collaboration_flag", this.getView().getFormShowParameter().getCustomParam("collaboration_flag"));
                this.getView().showForm(formShowParameter);
                break;
            }
            case "import_dim_result": {
                if (HRStringUtils.equals((String)activityStatus, (String)ActivityStatusEnum.GOING.getCode())) break;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u76d8\u70b9\u6d3b\u52a8\u72b6\u6001\u4e3a\u201c\u8fdb\u884c\u4e2d\u201d\uff0c\u624d\u80fd\u5bfc\u5165\u3002", (String)"ReviewObjectList_6", (String)"tdc-oatr-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
            case "import_evaluation_result": {
                if (HRStringUtils.equals((String)activityStatus, (String)ActivityStatusEnum.WAIT_START.getCode()) || HRStringUtils.equals((String)activityStatus, (String)ActivityStatusEnum.GOING.getCode())) break;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u76d8\u70b9\u6d3b\u52a8\u72b6\u6001\u4e3a\u201c\u8fdb\u884c\u4e2d\u201d\uff0c\u624d\u80fd\u5bfc\u5165\u3002", (String)"ReviewObjectList_6", (String)"tdc-oatr-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
        }
        if (HRStringUtils.equals((String)operateKey, (String)"previewmap") && HRStringUtils.equals((String)activityStatus, (String)ActivityStatusEnum.WAIT_START.getCode())) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u542f\u52a8\u6d3b\u52a8\uff0c\u624d\u80fd\u67e5\u770b\u5bab\u683c\u5206\u5e03\u3002", (String)"ReviewObjectList_8", (String)"tdc-oatr-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        List successPkIds;
        super.afterDoOperation(afterDoOperationEventArgs);
        String opKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        List list = successPkIds = operationResult == null ? Lists.newArrayListWithCapacity((int)0) : operationResult.getSuccessPkIds();
        if (HRStringUtils.equals((String)opKey, (String)"recommendtalent")) {
            FormOperate operate = (FormOperate)afterDoOperationEventArgs.getSource();
            OperateOption option = operate.getOption();
            String syncRecommendTalent = option.getVariableValue("syncRecommendTalent", "");
            if (HRStringUtils.equals((String)syncRecommendTalent, (String)"1")) {
                String recommendTalentData = option.getVariableValue("recommendTalentData", "");
                if (HRStringUtils.isEmpty((String)recommendTalentData)) {
                    return;
                }
                List recommendTalentInfo = (List)SerializationUtils.fromJsonString((String)recommendTalentData, List.class);
                int allSize = recommendTalentInfo.size();
                List<String> validateErrorInfo = this.validateRecommendTalentData(recommendTalentInfo);
                Map<String, Object> recommendResult = this.doSyncRecommendTalent(recommendTalentInfo);
                this.showSyncRecommendTalentResult(allSize, recommendTalentInfo, recommendResult, validateErrorInfo);
                return;
            }
            this.showFormRecommendTalent();
        }
        if (HRStringUtils.equals((String)opKey, (String)"previewmap") && !CollectionUtils.isEmpty((Collection)successPkIds)) {
            afterDoOperationEventArgs.getOperationResult().setShowMessage(false);
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("oatr_previewmap");
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCustomParam("activityId", this.getView().getFormShowParameter().getCustomParam("activityId"));
            Object[] primaryKeyValues = ((BillList)this.getView().getControl("billlistap")).getSelectedRows().getPrimaryKeyValues();
            List reviewObjIds = Arrays.stream(primaryKeyValues).map(key -> Long.parseLong(String.valueOf(key))).collect(Collectors.toList());
            List successReviewObjIds = successPkIds.stream().map(id -> Long.parseLong(id.toString())).collect(Collectors.toList());
            formShowParameter.setCustomParam("selectReviewObjIds", reviewObjIds);
            formShowParameter.setCustomParam("successReviewObjIds", successReviewObjIds);
            this.getView().showForm(formShowParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (HRStringUtils.equals((String)actionId, (String)"recommendTalent") && (returnData = closedCallBackEvent.getReturnData()) != null) {
            List recommendTalentInfo = (List)returnData;
            if (CollectionUtils.isEmpty((Collection)recommendTalentInfo)) {
                return;
            }
            OperateOption option = OperateOption.create();
            String recommendTalentInfoString = SerializationUtils.toJsonString((Object)recommendTalentInfo);
            option.setVariableValue("recommendTalentData", recommendTalentInfoString);
            option.setVariableValue("syncRecommendTalent", "1");
            this.getView().invokeOperation("recommendtalent", option);
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        BillListHyperLinkClickEvent event = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
        ListSelectedRow currentRow = event.getCurrentRow();
        Object pk = currentRow.getPrimaryKeyValue();
        if (HRStringUtils.equals((String)((String)this.getView().getFormShowParameter().getCustomParam("collaboration_flag")), (String)"1")) {
            QFilter idQF;
            QFilter userQFilter = new QFilter("entryentity.collaborator", "=", (Object)RequestContext.get().getCurrUserId());
            QFilter statusQFilter = new QFilter("entryentity.colstatus", "=", (Object)"1");
            FormShowParameter parameter = this.getView().getFormShowParameter();
            Long activityId = (Long)parameter.getCustomParam("activityId");
            if (activityId == null || activityId == 0L) {
                return;
            }
            QFilter activityQF = new QFilter("reviewactivity.id", "=", (Object)activityId);
            DynamicObject reviewObject = reviewObjectService.getReviewObject(((Long)pk).longValue());
            Long groupId = reviewObject.getLong("reviewgroup.id");
            if (null != groupId && !REVIEWGROUP_REPOSITORY.isExists(new QFilter[]{userQFilter, statusQFilter, activityQF, idQF = new QFilter("id", "=", (Object)groupId)})) {
                String errContent = ResManager.loadKDString((String)"\u4f60\u7684\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u5237\u65b0\u6216\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"ReviewObjectReviewGroupPermValidator_0", (String)"tdc-oatr-opplugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(errContent);
                args.setCancel(true);
                return;
            }
        }
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String nodeId = (String)parameter.getCustomParam("nodeId");
        DynamicObject reviewObject = REVIEWOBJECT_REPOSITORY.queryOne("reviewgroup", pk);
        if (!HRStringUtils.equals((String)nodeId, (String)"notjoin") && reviewObject != null && HRStringUtils.equals((String)(reviewObject.getLong("reviewgroup.id") + ""), (String)"0")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"ReviewActivityColList_3", (String)"tdc-oatr-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (HRStringUtils.equals((String)args.getFieldName(), (String)"name")) {
            super.billListHyperLinkClick(args);
            args.setCancel(true);
            HashMap customParamMap = Maps.newHashMap();
            Object focusRowPkId = this.getFocusRowPkId();
            DynamicObject fileDy = REVIEWOBJECT_REPOSITORY.queryOne("talentfile.person,talentfile.employee,", (Object)Long.parseLong(String.valueOf(focusRowPkId)));
            customParamMap.put("employee", fileDy.getLong("talentfile.employee_id"));
            customParamMap.put("person", fileDy.getLong("talentfile.person.id"));
            customParamMap.put("sceneNumber", "OATR_1010_S");
            logger.info("ReviewObjectList billListHyperLinkClick customParamMap:{}", (Object)customParamMap);
            HRMServiceResult hrmServiceResult = (HRMServiceResult)HRMServiceHelper.invokeHRMPService((String)"hrti", (String)"IHRTIService", (String)"showTalentPortrait", (Object[])new Object[]{customParamMap});
            if (hrmServiceResult.isSuccess()) {
                this.getView().showForm((FormShowParameter)hrmServiceResult.getReturnData());
            } else {
                this.getView().showErrorNotification(hrmServiceResult.getMessage());
            }
        }
    }

    private void setButtonVisible() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Long activityId = (Long)parameter.getCustomParam("activityId");
        if (activityId == null || activityId == 0L) {
            return;
        }
        String nodeId = (String)parameter.getCustomParam("nodeId");
        String openPage = (String)parameter.getCustomParam("openKey");
        if (reviewActivityQueryService.getReviewActivityEnd((Object)activityId)) {
            this.getView().setVisible(Boolean.FALSE, tblArray);
        } else {
            if (HRStringUtils.equals((String)nodeId, (String)"notjoin")) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"joinreviewobj"});
                this.getView().setVisible(Boolean.FALSE, tblJoinArray);
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"joinreviewobj"});
                this.getView().setVisible(Boolean.TRUE, tblJoinArray);
            }
            if (HRStringUtils.equals((String)openPage, (String)"oatr_reviewgroup") || HRStringUtils.equals((String)openPage, (String)"oatr_colreviewgroup")) {
                this.getView().setVisible(Boolean.FALSE, tblProcessArray);
            } else if (HRStringUtils.equals((String)openPage, (String)"oatr_reviewobject")) {
                this.getView().setVisible(Boolean.FALSE, tblGroupArray);
                this.getView().setVisible(Boolean.TRUE, new String[]{"changegroup"});
            }
        }
        if (HRStringUtils.equals((String)nodeId, (String)"notjoin") || HRStringUtils.equals((String)openPage, (String)"oatr_reviewgroup") || HRStringUtils.equals((String)openPage, (String)"oatr_colreviewgroup")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tblpreviewmap"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"tblpreviewmap"});
        }
        if (HRStringUtils.equals((String)nodeId, (String)"notjoin")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tblexport_from_list_hr"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"tblexport_from_list_hr"});
        }
    }

    private void isExistReviewObj(ListSelectedRowCollection selectedRows, Map<Long, DynamicObject> reviewObjectOfIds) {
        ArrayList correctSelectIds = Lists.newArrayListWithExpectedSize((int)selectedRows.size());
        StringBuilder notExistObjName = new StringBuilder();
        String comma = ResManager.loadKDString((String)"\u3001", (String)"ReviewObjectList_1", (String)"tdc-oatr-formplugin", (Object[])new Object[0]);
        selectedRows.forEach(row -> {
            Object pkId = row.getPrimaryKeyValue();
            DynamicObject existReviewObj = (DynamicObject)reviewObjectOfIds.get(Long.valueOf(pkId.toString()));
            if (existReviewObj == null || existReviewObj.getLong("reviewgroup.id") == 0L) {
                notExistObjName.append(row.getName()).append(comma);
            } else {
                correctSelectIds.add(Long.valueOf(pkId.toString()));
            }
        });
        this.getView().getFormShowParameter().setCustomParam("correctSelectIds", (Object)SerializationUtils.toJsonString((Object)correctSelectIds));
        if (!HRStringUtils.isEmpty((String)notExistObjName.toString())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c{0}\u201d\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u88ab\u5176\u4ed6\u4eba\u5220\u9664\u4e86\u3002", (String)"ReviewObjectList_0", (String)"tdc-oatr-formplugin", (Object[])new Object[]{notExistObjName.substring(0, notExistObjName.length() - comma.length())}));
        }
    }

    private void showFormRecommendTalent() {
        FormShowParameter reviewObjShowParameter = this.getView().getFormShowParameter();
        Object activityId = reviewObjShowParameter.getCustomParam("activityId");
        Object collaborationFlag = reviewObjShowParameter.getCustomParam("collaboration_flag");
        Object createOrg = reviewObjShowParameter.getCustomParam("createorg");
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("oatr_recommendtalent");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("reviewObjectIds", reviewObjShowParameter.getCustomParam("correctSelectIds"));
        formShowParameter.setCustomParam("createorg", createOrg);
        formShowParameter.setCustomParam("activityId", activityId);
        formShowParameter.setCustomParam("collaboration_flag", collaborationFlag);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "recommendTalent"));
        this.getView().showForm(formShowParameter);
    }

    private List<String> validateRecommendTalentData(List<Map<String, Object>> recommendTalentInfo) {
        ArrayList<Map<String, Object>> validateData = new ArrayList<Map<String, Object>>(recommendTalentInfo);
        List<String> deleteErrorRecommendInfo = this.validateReviewObjIsDelete(recommendTalentInfo, validateData);
        List<String> dataRuleErrorRecommendInfo = this.validateRecommendOpDataRule(recommendTalentInfo, validateData);
        ArrayList<String> errorRecommendInfo = new ArrayList<String>(deleteErrorRecommendInfo.size() + dataRuleErrorRecommendInfo.size());
        errorRecommendInfo.addAll(deleteErrorRecommendInfo);
        errorRecommendInfo.addAll(dataRuleErrorRecommendInfo);
        return errorRecommendInfo;
    }

    private List<String> validateRecommendOpDataRule(List<Map<String, Object>> recommendData, List<Map<String, Object>> validateData) {
        ArrayList errorInfo = Lists.newArrayListWithExpectedSize((int)recommendData.size());
        List reviewObjectIdList = recommendData.stream().map(data -> Long.valueOf(data.get("reviewObjectId").toString())).distinct().collect(Collectors.toList());
        String appId = BizAppServiceHelp.getAppIdByFormNum((String)"oatr_reviewobject");
        QFilter dataRuleFilter = PermissionServiceHelper.getDataRule((long)RequestContext.get().getCurrUserId(), (String)appId, (String)"oatr_reviewobject", (String)"3G8MBW3LXPID");
        Object[] reviewObjs = this.reviewObjectQueryService.listReviewObjectDataWithFilter(reviewObjectIdList, Collections.singletonList(dataRuleFilter));
        if (HRArrayUtils.isEmpty((Object[])reviewObjs)) {
            reviewObjs = new DynamicObject[]{};
        }
        List hasPermReviewObjIds = Arrays.stream(reviewObjs).map(reviewObj -> reviewObj.getLong("id")).collect(Collectors.toList());
        ArrayList removeKeys = Lists.newArrayListWithExpectedSize((int)validateData.size());
        String dataRuleErrorMsg = ResManager.loadKDString((String)"\u4f60\u6ca1\u6709\u201c\u52a0\u5165\u4eba\u624d\u6c60\u201d\u3001\u201c\u76d8\u70b9\u5bf9\u8c61\u201d\u7684\u6570\u636e\u89c4\u5219\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ReviewObjectList_5", (String)"tdc-oatr-formplugin", (Object[])new Object[0]);
        for (Map<String, Object> recommendDataMap : recommendData) {
            Long reviewObjectId = Long.valueOf(recommendDataMap.get("reviewObjectId").toString());
            if (hasPermReviewObjIds.contains(reviewObjectId)) continue;
            String validateErrorMsg = this.getRecommendErrorMsg(recommendDataMap, dataRuleErrorMsg);
            errorInfo.add(validateErrorMsg);
            Object recommendPoolId = recommendDataMap.get("recommendPoolId");
            String key = String.valueOf(reviewObjectId) + recommendPoolId;
            removeKeys.add(key);
        }
        recommendData.removeIf(data -> {
            Object reviewObjectId = data.get("reviewObjectId");
            Object recommendPoolId = data.get("recommendPoolId");
            String dataKey = String.valueOf(reviewObjectId) + recommendPoolId;
            return removeKeys.contains(dataKey);
        });
        return errorInfo;
    }

    private List<String> validateReviewObjIsDelete(List<Map<String, Object>> recommendData, List<Map<String, Object>> validateData) {
        ArrayList errorMsgInfo = Lists.newArrayListWithExpectedSize((int)validateData.size());
        List reviewObjectIdList = validateData.stream().map(data -> Long.valueOf(data.get("reviewObjectId").toString())).distinct().collect(Collectors.toList());
        HashMap reviewObjectIsDelete = reviewObjectService.listReviewObjectIsDelete(reviewObjectIdList);
        if (reviewObjectIsDelete == null || reviewObjectIsDelete.isEmpty()) {
            reviewObjectIsDelete = new HashMap(0);
        }
        ArrayList removeKeys = Lists.newArrayListWithExpectedSize((int)validateData.size());
        String deleteErrorMsg = ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"ReviewObjectList_4", (String)"tdc-oatr-formplugin", (Object[])new Object[0]);
        Set reviewObjIds = reviewObjectIsDelete.keySet();
        for (Map<String, Object> recommendDataMap : validateData) {
            Long reviewObjectId = Long.valueOf(recommendDataMap.get("reviewObjectId").toString());
            if (reviewObjIds.contains(reviewObjectId) && !((Boolean)reviewObjectIsDelete.get(reviewObjectId)).booleanValue()) continue;
            String recommendErrorMsg = this.getRecommendErrorMsg(recommendDataMap, deleteErrorMsg);
            errorMsgInfo.add(recommendErrorMsg);
            Object recommendPoolId = recommendDataMap.get("recommendPoolId");
            String key = String.valueOf(reviewObjectId) + recommendPoolId;
            removeKeys.add(key);
        }
        recommendData.removeIf(data -> {
            Object reviewObjectId = data.get("reviewObjectId");
            Object recommendPoolId = data.get("recommendPoolId");
            String dataKey = String.valueOf(reviewObjectId) + recommendPoolId;
            return removeKeys.contains(dataKey);
        });
        return errorMsgInfo;
    }

    private String getRecommendErrorMsg(Map<String, Object> recommendDataMap, String errorMsgTips) {
        Object reviewObjectName = recommendDataMap.get("reviewObjName");
        Object recommendPoolName = recommendDataMap.get("recommendPoolName");
        String msgInfo = ResManager.loadKDString((String)"\u201c{0}\u201d\u63a8\u8350\u81f3\u50a8\u5907\u6c60\u201c{1}\u201d\u5931\u8d25\u3002\u539f\u56e0\uff1a{2}\u3002", (String)"ReviewObjectList_3", (String)"tdc-oatr-formplugin", (Object[])new Object[0]);
        return MessageFormat.format(msgInfo, reviewObjectName, recommendPoolName, errorMsgTips);
    }

    private Map<String, Object> doSyncRecommendTalent(List<Map<String, Object>> recommendTalentInfo) {
        if (CollectionUtils.isEmpty(recommendTalentInfo)) {
            return new HashMap<String, Object>(0);
        }
        Map<String, String> reviewObjEmployeeIdMap = this.getReviewObjEmployeeIdMap(recommendTalentInfo);
        Map<String, Object> recommendData = this.constructRecommendData(recommendTalentInfo, reviewObjEmployeeIdMap);
        Map recommendResult = this.reviewApplicationService.syncRecommendTalent(recommendData);
        logger.info("ReviewObjectList.doSyncRecommendTalent: recommendResult is {}", (Object)recommendResult);
        return recommendResult;
    }

    private Map<String, String> getReviewObjEmployeeIdMap(List<Map<String, Object>> recommendTalentInfo) {
        List talentFileIds = recommendTalentInfo.stream().map(entry -> Long.valueOf(entry.get("talentFileId").toString())).distinct().collect(Collectors.toList());
        Object[] talentFileObjs = talentFileQueryService.listTalentFile(talentFileIds);
        if (HRArrayUtils.isEmpty((Object[])talentFileObjs)) {
            return new HashMap<String, String>(0);
        }
        Map<Long, Long> employeeIdMap = Arrays.stream(talentFileObjs).collect(Collectors.toMap(talentFileObj -> talentFileObj.getLong("id"), talentFileObj -> talentFileObj.getLong("employee.id"), (v1, v2) -> v1));
        return recommendTalentInfo.stream().collect(Collectors.toMap(entry -> entry.get("reviewObjectId").toString(), entry -> {
            long talentFileId = Long.parseLong(entry.get("talentFileId").toString());
            return String.valueOf(employeeIdMap.get(talentFileId));
        }, (v1, v2) -> v1));
    }

    private Map<String, Object> constructRecommendData(List<Map<String, Object>> recommendTalentInfo, Map<String, String> reviewObjEmployeeIdMap) {
        Object createOrg = this.getView().getFormShowParameter().getCustomParam("createorg");
        HashMap recommendTalentInfoMap = Maps.newHashMapWithExpectedSize((int)5);
        if (createOrg != null) {
            recommendTalentInfoMap.put("org", Long.valueOf(createOrg.toString()));
        }
        recommendTalentInfoMap.put("recommendsource", 1737001619649838080L);
        ArrayList recommendTalentData = Lists.newArrayListWithCapacity((int)recommendTalentInfo.size());
        for (Map<String, Object> recommendInfo : recommendTalentInfo) {
            HashMap talentInfoMap = Maps.newHashMapWithExpectedSize((int)5);
            talentInfoMap.put("employee", reviewObjEmployeeIdMap.get(recommendInfo.get("reviewObjectId").toString()));
            talentInfoMap.put("recommendintopool", recommendInfo.get("recommendPoolId"));
            talentInfoMap.put("recommendemp", RequestContext.get().getCurrUserId());
            talentInfoMap.put("recommendreason", recommendInfo.get("recommendReason"));
            recommendTalentData.add(talentInfoMap);
        }
        recommendTalentInfoMap.put("data", recommendTalentData);
        return recommendTalentInfoMap;
    }

    private void showSyncRecommendTalentResult(int allSize, List<Map<String, Object>> recommendTalentInfo, Map<String, Object> recommendResult, List<String> validateErrorInfo) {
        int validateSize = validateErrorInfo.size();
        if (recommendResult.isEmpty() && validateSize == 0) {
            String errorTips = ResManager.loadKDString((String)"\u63a8\u8350\u81f3\u50a8\u5907\u6c60\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"ReviewActivityColList_6", (String)"tdc-oatr-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(errorTips);
            return;
        }
        String status = (String)recommendResult.get("status");
        if (HRStringUtils.equals((String)status, (String)"1") && validateSize == 0) {
            String tips = ResManager.loadKDString((String)"\u63a8\u8350\u81f3\u50a8\u5907\u6c60\u6210\u529f\u3002", (String)"ReviewActivityColList_7", (String)"tdc-oatr-formplugin", (Object[])new Object[0]);
            this.getView().showSuccessNotification(tips);
        } else if (HRStringUtils.equals((String)status, (String)"0") && validateSize == 0) {
            String errorMsg = (String)recommendResult.get("errorMsg");
            this.getView().showErrorNotification(errorMsg);
        } else {
            ArrayList errorInfoList = (ArrayList)recommendResult.get("data");
            if (errorInfoList == null) {
                errorInfoList = new ArrayList(0);
            }
            if (errorInfoList.isEmpty() && validateSize == 0) {
                return;
            }
            int failSize = errorInfoList.size() + validateSize;
            int successSize = allSize - failSize;
            String titleMsgStr = ResManager.loadKDString((String)"\u5171\u53d1\u9001{0}\u6761\u6570\u636e\u81f3\u50a8\u5907\u6c60\uff0c\u6210\u529f{1}\u4e2a\uff0c\u5931\u8d25{2}\u4e2a\u3002", (String)"ReviewObjectList_2", (String)"tdc-oatr-formplugin", (Object[])new Object[0]);
            String titleMsg = MessageFormat.format(titleMsgStr, allSize, successSize, failSize);
            Map<String, Map> errorResultMap = errorInfoList.stream().collect(Collectors.toMap(errorInfoMap -> {
                Object employee = errorInfoMap.get("employee");
                Object recommendIntoPool = errorInfoMap.get("recommendintopool");
                return String.valueOf(employee) + recommendIntoPool;
            }, errorInfoMap -> errorInfoMap, (v1, v2) -> v1));
            Map<String, String> reviewObjEmployeeIdMap = this.getReviewObjEmployeeIdMap(recommendTalentInfo);
            StringBuilder msgContentBuilder = new StringBuilder();
            for (String string : validateErrorInfo) {
                msgContentBuilder.append(string);
                msgContentBuilder.append(System.lineSeparator());
            }
            for (Map map : recommendTalentInfo) {
                Object reviewObjectId = map.get("reviewObjectId");
                Object recommendPoolId = map.get("recommendPoolId");
                String employeeId = reviewObjEmployeeIdMap.get(reviewObjectId.toString());
                String key = employeeId + recommendPoolId;
                Map errorInfoMap2 = errorResultMap.get(key);
                if (errorInfoMap2 == null || errorInfoMap2.isEmpty()) continue;
                Object reviewObjectName = map.get("reviewObjName");
                Object recommendPoolName = map.get("recommendPoolName");
                String msgInfo = ResManager.loadKDString((String)"\u201c{0}\u201d\u63a8\u8350\u81f3\u50a8\u5907\u6c60\u201c{1}\u201d\u5931\u8d25\u3002\u539f\u56e0\uff1a{2}\u3002", (String)"ReviewObjectList_3", (String)"tdc-oatr-formplugin", (Object[])new Object[0]);
                String errorMsgContent = (String)errorInfoMap2.get("errorMsg");
                String errorMsg = MessageFormat.format(msgInfo, reviewObjectName, recommendPoolName, errorMsgContent);
                msgContentBuilder.append(errorMsg);
                msgContentBuilder.append(System.lineSeparator());
            }
            String contentMsg = msgContentBuilder.toString();
            this.getView().showMessage(titleMsg, contentMsg, MessageTypes.Default);
        }
    }
}

