/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.formplugin.web.activity.reviewobj;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.list.ITreeListView;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.TreeListModel;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tdc.oatr.bussiness.ServiceFactory;
import kd.tdc.oatr.bussiness.queryservice.ReviewActivityQueryService;
import kd.tdc.oatr.common.constants.enums.ActivityStatusEnum;
import kd.tdc.oatr.formplugin.web.activity.detail.ReviewActivityDetailCommon;
import kd.tdc.oatr.formplugin.web.common.ReviewActivityTreeUtil;

public class ReviewObjectTreeList
extends StandardTreeListPlugin
implements ReviewActivityDetailCommon {
    private final ReviewActivityQueryService activityQueryService = (ReviewActivityQueryService)ServiceFactory.getService(ReviewActivityQueryService.class);
    private static final Log LOGGER = LogFactory.getLog(ReviewObjectTreeList.class);
    private static final String BTN_NEW = "btnnew";
    private static final String BTN_EDIT = "btnedit";
    private static final String BTN_DEL = "btndel";
    private static final String CLOSE_GROUP_ADD = "closeGroupAdd";
    private static final String CLOSE_GROUP_EDIT = "closeGroupEdit";

    public void initializeTree(EventObject e) {
        this.initTreeNode("alreadyjoin");
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        LocaleString localeString = ResManager.getLocaleString((String)"\u8bf7\u8f93\u5165\u540d\u79f0\u540e\u6309\u56de\u8f66\u952e", (String)"ReviewObjectTreeList_0", (String)"tdc-oatr-formplugin");
        HashMap searchApCtrl = Maps.newHashMapWithExpectedSize((int)1);
        searchApCtrl.put("emptytip", localeString);
        this.getView().updateControlMetadata("searchap", (Map)searchApCtrl);
    }

    public void refreshNode(RefreshNodeEvent evt) {
        super.refreshNode(evt);
        String curNodeId = evt.getNodeId().toString();
        if (HRStringUtils.equals((String)curNodeId, (String)"root")) {
            curNodeId = "alreadyjoin";
            evt.setNodeId((Object)curNodeId);
        }
        TreeView treeView = (TreeView)this.getView().getControl("treeview");
        treeView.deleteAllNodes();
        this.initTreeNode(curNodeId);
        ITreeModel treeModel = this.getTreeModel();
        TreeNode root = treeModel.getRoot();
        TreeNode currNode = root.getTreeNode(curNodeId);
        if (currNode != null && currNode.getChildren() != null && !currNode.getChildren().isEmpty()) {
            evt.setChildNodes(currNode.getChildren());
        }
        treeView.setRootVisible(false);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        List successPkIds;
        super.afterDoOperation(args);
        OperationResult operationResult = args.getOperationResult();
        List list = successPkIds = operationResult == null ? Lists.newArrayListWithCapacity((int)0) : operationResult.getSuccessPkIds();
        if (HRStringUtils.equals((String)args.getOperateKey(), (String)"refresh") || !CollectionUtils.isEmpty((Collection)successPkIds)) {
            this.rebuildTreeNode();
        }
    }

    public void initTreeToolbar(EventObject e) {
        Object activityId;
        DynamicObject activity;
        super.initTreeToolbar(e);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String openPage = (String)showParameter.getCustomParam("openKey");
        if (HRStringUtils.equals((String)openPage, (String)"oatr_reviewobject")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_NEW, BTN_EDIT, BTN_DEL});
        }
        if ((activity = this.activityQueryService.getReviewActivity(activityId = this.getActivityId(this.getView()))) != null) {
            String activityStatus = activity.getString("activitystatus");
            if (HRStringUtils.equals((String)ActivityStatusEnum.END.getCode(), (String)activityStatus) || HRStringUtils.equals((String)ActivityStatusEnum.STOP.getCode(), (String)activityStatus)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{BTN_NEW, BTN_DEL});
            }
        }
    }

    public void search(SearchEnterEvent evt) {
        String searchText = evt.getText();
        if (HRStringUtils.isEmpty((String)searchText)) {
            this.focusCurOrDefNode();
        } else {
            super.search(evt);
        }
    }

    public void filterContainerAfterSearchClick(FilterContainerSearchClickArgs args) {
        Map filterValues;
        List fastFilters;
        super.filterContainerAfterSearchClick(args);
        ITreeListView treeListView = this.getTreeListView();
        if (treeListView != null) {
            ((TreeListModel)treeListView.getTreeModel()).setGobackToRoot(false);
        }
        if (CollectionUtils.isEmpty((Collection)(fastFilters = (List)(filterValues = args.getSearchClickEvent().getFilterValues()).get("fastfilter")))) {
            this.focusCurOrDefNode();
        }
    }

    public void treeNodeClick(TreeNodeEvent e) {
        super.treeNodeClick(e);
        ITreeModel treeModel = this.getTreeModel();
        String curNodeId = treeModel.getCurrentNodeId().toString();
        if (HRStringUtils.equals((String)curNodeId, (String)"root")) {
            return;
        }
        this.updateCustomParams(curNodeId);
    }

    private void initTreeNode(String curNodeId) {
        TreeNode notJoinNode;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String openKey = (String)formShowParameter.getCustomParam("openKey");
        String collaboration = (String)formShowParameter.getCustomParam("collaboration_flag");
        Long activityId = this.getActivityLongId(this.getView());
        TreeNode rootNode = ReviewActivityTreeUtil.buildReviewObjTree(activityId, collaboration);
        ITreeModel treeModel = this.getTreeModel();
        treeModel.setRoot(rootNode);
        treeModel.setRootVisable(false);
        treeModel.setCurrentNodeId((Object)curNodeId);
        TreeView treeView = (TreeView)this.getView().getControl("treeview");
        treeView.addNode(rootNode);
        treeView.focusNode(rootNode.getTreeNode(curNodeId));
        this.updateCustomParams(curNodeId);
        if (HRStringUtils.equals((String)openKey, (String)"oatr_reviewobject") && (notJoinNode = rootNode.getTreeNode("notjoin")) != null) {
            treeModel.deleteNode(notJoinNode, true);
        }
    }

    private void focusCurOrDefNode() {
        TreeView treeView = (TreeView)this.getView().getControl("treeview");
        if (Objects.nonNull(treeView)) {
            Object currentNodeId;
            ITreeModel treeModel = this.getTreeModel();
            TreeNode rootNode = treeModel.getRoot();
            Object focusNodeId = currentNodeId = treeModel.getCurrentNodeId();
            if (HRObjectUtils.isEmpty((Object)currentNodeId) || HRObjectUtils.equals((Object)"root", (Object)currentNodeId)) {
                String nodeId = (String)this.getView().getFormShowParameter().getCustomParam("nodeId");
                focusNodeId = HRStringUtils.isEmpty((String)nodeId) ? "alreadyjoin" : nodeId;
            }
            treeModel.setCurrentNodeId(focusNodeId);
            treeView.focusNode(rootNode.getTreeNode(focusNodeId.toString()));
            treeView.treeNodeClick(rootNode.getId(), focusNodeId.toString());
        }
    }

    private void rebuildTreeNode() {
        TreeView treeView = (TreeView)this.getView().getControl("treeview");
        String focusNodeId = treeView.getTreeState().getFocusNodeId();
        if (HRStringUtils.equals((String)focusNodeId, (String)"root")) {
            focusNodeId = "alreadyjoin";
        }
        treeView.deleteAllNodes();
        this.initTreeNode(focusNodeId);
        ITreeModel treeModel = this.getTreeModel();
        TreeNode root = treeModel.getRoot();
        String currNodeId = treeModel.getCurrentNodeId().toString();
        TreeNode currNode = root.getTreeNode(currNodeId);
        treeView.setRootVisible(false);
        if (Objects.nonNull(currNode)) {
            treeView.treeNodeClick(currNode.getParentid(), currNodeId);
        }
    }

    private void updateCustomParams(String curNodeId) {
        if (HRStringUtils.equals((String)curNodeId, (String)"root")) {
            return;
        }
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String collaborate = (String)showParameter.getCustomParam("collaboration_flag");
        Long activityId = this.getActivityLongId(this.getView());
        if (activityId == null || activityId == 0L) {
            return;
        }
        String preNodeId = (String)showParameter.getCustomParam("nodeId");
        List groupIdList = this.getGroupIdList(curNodeId, activityId, collaborate);
        showParameter.setCustomParam("groupId", (Object)groupIdList);
        showParameter.setCustomParam("nodeId", (Object)curNodeId);
        this.getView().cacheFormShowParameter();
        if (HRStringUtils.isNotEmpty((String)preNodeId) && !HRStringUtils.equals((String)preNodeId, (String)curNodeId)) {
            showParameter.setCustomParam("isFromTreeNodeClick", (Object)"1");
            this.getView().cacheFormShowParameter();
            this.getView().updateView("filtercontainerap");
        }
    }
}

