/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.formplugin.web.activity.template;

import java.util.EventObject;
import kd.bos.dataentity.OperateOption;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tdc.oatr.common.constants.enums.TalentMapPageSourceTypeEnum;
import kd.tdc.oatr.formplugin.web.activity.ReviewTalentMapConfigCommonEdit;

public class ReviewActivityTplMapConfigEdit
extends ReviewTalentMapConfigCommonEdit
implements RowClickEventListener {
    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        CardEntry mapEntry = (CardEntry)this.getControl("talentmapentry");
        mapEntry.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject evt) {
        super.afterCreateNewData(evt);
        int defaultTalentMapRow = this.createNewDefaultTalentMap();
        this.initNewTalentMapData(defaultTalentMapRow, true);
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        this.setTalentMapTabName();
        int defaultMapRow = this.getDefaultTalentMapRow();
        this.selectTalentMapTab(defaultMapRow);
    }

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        this.setInitTalentMapDataChange();
    }

    public void clientCallBack(ClientCallBackEvent e) {
        super.clientCallBack(e);
        String actionName = e.getName();
        if (actionName.equals("refreshCurrentMapDim")) {
            this.deleteEntryDimension();
            int clickCurrentRow = this.getCurrentClickRow();
            this.selectTalentMapTab(clickCurrentRow);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (operateKey.equals("save") || operateKey.equals("submit")) {
            this.beforeSaveAndSubmit();
        }
        if (HRStringUtils.equals((String)operateKey, (String)"mapinteract")) {
            OperateOption option = operate.getOption();
            String actionName = option.getVariableValue("interactAction");
            this.interactAction(actionName);
        }
    }

    private void interactAction(String actionName) {
        if (HRStringUtils.equals((String)actionName, (String)"actionUpdateTalentMapData")) {
            this.updateTalentMapEntryData();
        }
    }

    public void afterAddRow(AfterAddRowEventArgs evt) {
        super.afterAddRow(evt);
        EntryProp entryProp = evt.getEntryProp();
        String name = entryProp.getName();
        if (name.equals("talentmapentry")) {
            RowDataEntity[] rowDataEntities = evt.getRowDataEntities();
            int currentRowIndex = rowDataEntities[0].getRowIndex();
            boolean isDefault = currentRowIndex == 0;
            this.initNewTalentMapData(currentRowIndex, isDefault);
            this.recordCurrentClickRow(currentRowIndex);
            int clickCurrentRow = this.getCurrentClickRow();
            this.selectTalentMapTab(clickCurrentRow);
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs evt) {
        super.afterDeleteRow(evt);
        EntryProp entryProp = evt.getEntryProp();
        String name = entryProp.getName();
        if (name.equals("talentmapentry")) {
            int row = this.getDefaultTalentMapRow();
            this.selectTalentMapTab(row);
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        EntryGrid source = (EntryGrid)evt.getSource();
        String key = source.getKey();
        if (key.equals("talentmapentry")) {
            int currentClickRow;
            int row = evt.getRow();
            if (row == (currentClickRow = this.getCurrentClickRow())) {
                return;
            }
            if (row == -1) {
                row = this.getDefaultTalentMapRow();
            }
            this.recordCurrentClickRow(row);
            int clickCurrentRow = this.getCurrentClickRow();
            this.selectTalentMapTab(clickCurrentRow);
        }
    }

    @Override
    public String getTalentMapSourceType() {
        return TalentMapPageSourceTypeEnum.TEMPLATE.getNumber();
    }
}

