/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.formplugin.web.activity.template;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.Submit;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.formop.DeleteEntry;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRDyObjectPropUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.tdc.oatr.bussiness.ServiceFactory;
import kd.tdc.oatr.bussiness.queryservice.ReviewToolSchemeQueryService;
import kd.tdc.oatr.common.constants.activity.detail.ReviewToolConstants;
import kd.tdc.oatr.common.utils.PropUtils;
import kd.tdc.oatr.formplugin.web.activity.ReviewEntryGridCommon;
import kd.tdc.oatr.formplugin.web.activity.detail.ReviewActivityDetailCommon;
import kd.tdc.tdcs.bussiness.formservice.FormCommonService;

public class ReviewActivityTplToolPlugin
extends HRDynamicFormBasePlugin
implements ReviewActivityDetailCommon,
ReviewEntryGridCommon,
ReviewToolConstants,
HyperLinkClickListener,
BeforeF7SelectListener {
    private final ReviewToolSchemeQueryService toolSchemeQueryService = (ReviewToolSchemeQueryService)ServiceFactory.getService(ReviewToolSchemeQueryService.class);
    private static final String KEY_ACTION_QUESTIONNAIRE = "close_questionnaire";
    private static final String KEY_ACTION_OUTER_TOOL = "close_outertool";
    private static final String KEY_ACTION_SHOW_OUT_TOOL = "close_showOutTool";
    protected final Map<String, Consumer<ClosedCallBackEvent>> CLOSE_CALL_FUN = Maps.newHashMapWithExpectedSize((int)4);
    protected final Map<String, Consumer<AfterDoOperationEventArgs>> AFTER_DO_FUN = Maps.newHashMapWithExpectedSize((int)8);
    protected final Map<String, Consumer<HyperLinkClickEvent>> HYPER_LINK_CLICK_FUN = Maps.newHashMapWithExpectedSize((int)4);

    public ReviewActivityTplToolPlugin() {
        this.CLOSE_CALL_FUN.put(KEY_ACTION_QUESTIONNAIRE, this.closeCallQuestionnaireConsumer());
        this.CLOSE_CALL_FUN.put(KEY_ACTION_OUTER_TOOL, this.closeCallAddOuterTool());
        this.CLOSE_CALL_FUN.put(KEY_ACTION_SHOW_OUT_TOOL, this.closeCallShowOutTool());
        this.AFTER_DO_FUN.put("add", this.innerAddConsumer());
        this.AFTER_DO_FUN.put("deleteentry", null);
        this.AFTER_DO_FUN.put("preview", this.innerPreviewConsumer());
        this.AFTER_DO_FUN.put("outer_add", this.outerAddConsumer());
        this.AFTER_DO_FUN.put("outer_deleteentry", null);
        this.HYPER_LINK_CLICK_FUN.put("evaluationitem_num", this.hyperClickEvaluationItemConsumer());
        this.HYPER_LINK_CLICK_FUN.put("outer_name", this.hyperClickOuterToolConsumer());
    }

    private Consumer<HyperLinkClickEvent> hyperClickEvaluationItemConsumer() {
        return hyperLinkClickEvent -> {
            int rowIndex = hyperLinkClickEvent.getRowIndex();
            EntryGrid entryGrid = this.getEntryGrid("entryentity_outer");
            DynamicObject rowData = entryGrid.getEntryData().getDataEntitys()[rowIndex];
            int num = rowData.getInt("evaluationitem_num");
            if (num != 0) {
                Object[] idArr = this.getCurrRowMultiBaseData(this.getView(), "entryentity_outer", "evaluationitem", rowIndex);
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("oatr_outtoolrelevaluation");
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.setShowTitle(true);
                String toolName = rowData.getString(PropUtils.getNameDot((String)"outer_tool"));
                String caption = new StringJoiner("_").add(toolName).add(ResManager.loadKDString((String)"\u8bc4\u4f30\u9879", (String)"ReviewToolPlugin_0", (String)"tdc-oatr-formplugin", (Object[])new Object[0])).toString();
                showParameter.setCaption(caption);
                showParameter.setCustomParam("id", (Object)SerializationUtils.toJsonString(Arrays.asList(idArr)));
                this.getView().showForm(showParameter);
            }
        };
    }

    private Consumer<HyperLinkClickEvent> hyperClickOuterToolConsumer() {
        return hyperLinkClickEvent -> {
            BaseShowParameter showParameter = new BaseShowParameter();
            showParameter.setFormId("oatr_reviewtoolscheme");
            DynamicObject rowData = this.getRowData(this.getView(), "entryentity_outer", hyperLinkClickEvent.getRowIndex());
            showParameter.setPkId((Object)rowData.getLong(PropUtils.getIdDot((String)"outer_tool")));
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setStatus(OperationStatus.VIEW);
            showParameter.setBillStatus(BillOperationStatus.VIEW);
            showParameter.setCustomParam("isOnlyView", (Object)"1");
            this.getView().showForm((FormShowParameter)showParameter);
        };
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        EntryGrid outerEntry = this.getEntryGrid("entryentity_outer");
        outerEntry.addHyperClickListener((HyperLinkClickListener)this);
        this.getEntryGrid("entryentity_inner").addHyperClickListener((HyperLinkClickListener)this);
        BasedataEdit schemeEdit = (BasedataEdit)this.getControl("selecttoolscheme");
        schemeEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    private EntryGrid getEntryGrid(String entryKey) {
        return (EntryGrid)this.getControl(entryKey);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setToolTypeForOldToolData();
    }

    private void setToolTypeForOldToolData() {
        DynamicObjectCollection entryEntityOuter = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity_outer");
        for (DynamicObject entity : entryEntityOuter) {
            String toolType = entity.getString("outer_tool.tooltype");
            if (!HRStringUtils.isEmpty((String)toolType)) continue;
            entity.set("outer_tool.tooltype", (Object)"30");
        }
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        OperationStatus status = showParameter.getStatus();
        if (status == OperationStatus.VIEW) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tabop_add", "tabop_delete", "tabop_preview", "outer_add", "outer_delete", "outer_evaluationitem"});
        }
        this.updateToolTabName(this.getView(), "entryentity_outer");
        this.updateToolTabName(this.getView(), "entryentity_inner");
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs afterDeleteRowEventArgs) {
        super.afterDeleteRow(afterDeleteRowEventArgs);
        EntryProp entryProp = afterDeleteRowEventArgs.getEntryProp();
        String name = entryProp.getName();
        if (!name.equals("talentmapentry") && !name.equals("dimesionentry")) {
            this.updateToolTabName(this.getView(), name);
        }
    }

    private Consumer<AfterDoOperationEventArgs> innerAddConsumer() {
        return afterDoOperationEventArgs -> {
            ListShowParameter showListForm = ShowFormHelper.createShowListForm((String)"oatr_questionnaire", (boolean)true);
            CloseCallBack closeCallBack = new CloseCallBack(this.getPluginName(), KEY_ACTION_QUESTIONNAIRE);
            showListForm.setCloseCallBack(closeCallBack);
            DynamicObject[] dynamicObjects = this.getEntryRow(this.getView(), "entryentity_inner");
            showListForm.setSelectedRows(Arrays.stream(dynamicObjects).map(dynamicObject -> dynamicObject.getLong(PropUtils.getIdDot((String)"questionnaire"))).toArray());
            this.getView().showForm((FormShowParameter)showListForm);
        };
    }

    private Consumer<AfterDoOperationEventArgs> innerPreviewConsumer() {
        return afterDoOperationEventArgs -> {
            int[] selectRows = this.checkSelectSingleAndGet(this.getView(), "entryentity_inner");
            if (selectRows.length == 0) {
                return;
            }
            DynamicObject[] dynamicObjects = this.getSelectRowDO(this.getView(), "entryentity_inner");
            DynamicObject rowData = dynamicObjects[0];
            long questionnaireId = rowData.getLong(PropUtils.getIdDot((String)"questionnaire"));
            String formId = "";
            if (questionnaireId == 1010L) {
                formId = "oatr_employeeeval_layout";
            }
            if (questionnaireId == 1020L) {
                formId = "oatr_superioreval_layout";
            }
            if (HRStringUtils.isEmpty((String)formId)) {
                return;
            }
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setFormId(formId);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)showParameter);
        };
    }

    private Consumer<AfterDoOperationEventArgs> outerAddConsumer() {
        return afterDoOperationEventArgs -> {
            BasedataEdit schemeEdit = (BasedataEdit)this.getControl("selecttoolscheme");
            schemeEdit.setF7MultipleSelect(true);
            schemeEdit.click();
        };
    }

    private List<Long> getExistSchemeIds() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity_outer");
        if (HRCollUtil.isEmpty((Collection)entryEntity)) {
            return new ArrayList<Long>(0);
        }
        return entryEntity.stream().map(entity -> entity.getLong("outer_tool.id")).collect(Collectors.toList());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        boolean isToolSchemeDelete;
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if ((source instanceof Save || source instanceof Submit) && (isToolSchemeDelete = this.checkReviewToolSchemeData())) {
            args.setCancel(true);
        }
    }

    private boolean checkReviewToolSchemeData() {
        DynamicObject reviewTool = this.getModel().getDataEntity(true);
        DynamicObjectCollection toolEntry = reviewTool.getDynamicObjectCollection("entryentity_outer");
        int row = 0;
        for (DynamicObject entry : toolEntry) {
            DynamicObject outerTool = entry.getDynamicObject("outer_tool");
            if (outerTool == null) {
                String toolName = entry.getString("toolname");
                String errorTips = ResManager.loadKDString((String)"{0}\u5df2\u88ab\u5176\u4ed6\u7528\u6237\u5220\u9664\u6216\u7981\u7528\uff0c\u8bf7\u91cd\u65b0\u786e\u8ba4\u76d8\u70b9\u5de5\u5177\u3002", (String)"ReviewActivityEdit_9", (String)"tdc-oatr-formplugin", (Object[])new Object[]{toolName});
                this.getModel().deleteEntryRow("entryentity_outer", row);
                this.getView().showErrorNotification(errorTips);
                return true;
            }
            ++row;
        }
        return false;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        AbstractOperate operate = (AbstractOperate)afterDoOperationEventArgs.getSource();
        if (operate instanceof DeleteEntry) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"ReviewToolPlugin_4", (String)"tdc-oatr-formplugin", (Object[])new Object[0]));
            return;
        }
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        Consumer<AfterDoOperationEventArgs> consumer = this.AFTER_DO_FUN.get(operateKey);
        if (Objects.isNull(consumer)) {
            return;
        }
        consumer.accept(afterDoOperationEventArgs);
    }

    private Consumer<ClosedCallBackEvent> closeCallQuestionnaireConsumer() {
        return closedCallBackEvent -> {
            ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            DynamicObject[] entryRows = this.getEntryRow(this.getView(), "entryentity_inner");
            List alreadySelectQuestionnaireIdList = Arrays.stream(entryRows).map(entryRow -> entryRow.get(PropUtils.getIdDot((String)"questionnaire"))).collect(Collectors.toList());
            boolean isChanged = false;
            for (ListSelectedRow selectedRow : selectedRows) {
                if (alreadySelectQuestionnaireIdList.contains(selectedRow.getPrimaryKeyValue())) continue;
                int newEntryRow = this.getModel().createNewEntryRow("entryentity_inner");
                this.getModel().setValue("questionnaire", selectedRow.getPrimaryKeyValue(), newEntryRow);
                this.getModel().setValue("innertoolselect", (Object)"1", newEntryRow);
                isChanged = true;
            }
            List<Object> primaryKeyValues = Arrays.asList(selectedRows.getPrimaryKeyValues());
            for (int i = 0; i < entryRows.length; ++i) {
                if (primaryKeyValues.contains(entryRows[i].getLong(PropUtils.getIdDot((String)"questionnaire")))) continue;
                this.getModel().deleteEntryRow("entryentity_inner", i);
                isChanged = true;
            }
            if (isChanged) {
                this.updateToolTabName(this.getView(), "entryentity_inner");
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6dfb\u52a0\u6210\u529f\u3002", (String)"ReviewToolPlugin_1", (String)"tdc-oatr-formplugin", (Object[])new Object[0]));
            }
        };
    }

    private Consumer<ClosedCallBackEvent> closeCallAddOuterTool() {
        return closedCallBackEvent -> {
            Object returnData = closedCallBackEvent.getReturnData();
            if (returnData == null) {
                return;
            }
            ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)returnData;
            if (selectedRows.size() == 0) {
                return;
            }
            List returnSchemeIds = selectedRows.stream().map(selectedRow -> Long.valueOf(selectedRow.getPrimaryKeyValue().toString())).collect(Collectors.toList());
            DynamicObject[] reviewToolSchemes = this.toolSchemeQueryService.listReviewToolSchemes(returnSchemeIds);
            HashMap evaluationIdMap = new HashMap(reviewToolSchemes.length);
            for (DynamicObject reviewToolScheme : reviewToolSchemes) {
                long evaluationId;
                long schemeId = reviewToolScheme.getLong("id");
                ArrayList<Long> evalutionIdList = (ArrayList<Long>)evaluationIdMap.get(schemeId);
                if (HRCollUtil.isEmpty((Collection)evalutionIdList)) {
                    evalutionIdList = new ArrayList<Long>(10);
                }
                if ((evaluationId = reviewToolScheme.getLong("entryentity.evaluationitem.id")) == 0L) continue;
                evalutionIdList.add(evaluationId);
                evaluationIdMap.put(schemeId, evalutionIdList);
            }
            this.getModel().beginInit();
            this.getModel().deleteEntryData("entryentity_outer");
            int[] newEntryRow = this.getModel().batchCreateNewEntryRow("entryentity_outer", returnSchemeIds.size());
            for (int i = 0; i < newEntryRow.length; ++i) {
                int row = newEntryRow[i];
                this.getModel().setValue("outtoolselect", (Object)"1", row);
                Long schemeId = (Long)returnSchemeIds.get(i);
                this.getModel().setValue("outer_tool", (Object)schemeId, row);
                DynamicObject outerTool = (DynamicObject)this.getModel().getValue("outer_tool", row);
                this.getModel().setValue("toolname", (Object)HRDyObjectPropUtil.getName((DynamicObject)outerTool), row);
                List evalutionIdList = (List)evaluationIdMap.get(schemeId);
                if (!HRCollUtil.isNotEmpty((Collection)evalutionIdList)) continue;
                this.getModel().setValue("evaluationitem", (Object)evalutionIdList.toArray(), row);
                this.getModel().setValue("evaluationitem_num", (Object)evalutionIdList.size(), row);
            }
            this.getModel().endInit();
            this.setToolTypeForOldToolData();
            this.updateToolTabName(this.getView(), "entryentity_outer");
            this.getView().updateView("entryentity_outer");
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"ReviewToolPlugin_1", (String)"tdc-oatr-formplugin", (Object[])new Object[0]));
        };
    }

    private Consumer<ClosedCallBackEvent> closeCallShowOutTool() {
        return closedCallBackEvent -> {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"ReviewToolPlugin_22", (String)"tdc-oatr-formplugin", (Object[])new Object[0]));
            this.getView().updateView("entryentity_outer");
        };
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        Object returnData = closedCallBackEvent.getReturnData();
        if (Objects.isNull(returnData)) {
            return;
        }
        String actionId = closedCallBackEvent.getActionId();
        Consumer<ClosedCallBackEvent> consumer = this.CLOSE_CALL_FUN.get(actionId);
        if (Objects.isNull(consumer)) {
            return;
        }
        consumer.accept(closedCallBackEvent);
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName = evt.getFieldName();
        Consumer<HyperLinkClickEvent> consumer = this.HYPER_LINK_CLICK_FUN.get(fieldName);
        if (Objects.nonNull(consumer)) {
            consumer.accept(evt);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        if (HRStringUtils.equals((String)name, (String)"selecttoolscheme")) {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            List<Long> schemeIds = this.getExistSchemeIds();
            if (!CollectionUtils.isEmpty(schemeIds)) {
                showParameter.setSelectedRows(schemeIds.toArray());
            }
            showParameter.setMultiSelect(true);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_ACTION_OUTER_TOOL));
        }
    }

    public void beforeClosed(BeforeClosedEvent evt) {
        super.beforeClosed(evt);
        FormCommonService formCommonService = (FormCommonService)kd.tdc.tdcs.bussiness.ServiceFactory.getService(FormCommonService.class);
        formCommonService.setPropertyNotDataChanged(this.getModel(), new String[]{"entryentity_outer", "entryentity_inner"});
    }
}

