/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.formplugin.web.activity.template;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDyObjectPropUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.sdk.tdc.oatr.activity.IReviewTalentMapExtendService;
import kd.tdc.oatr.bussiness.ServiceFactory;
import kd.tdc.oatr.bussiness.queryservice.GridTemplateQueryService;
import kd.tdc.oatr.bussiness.queryservice.ReviewDimensionQueryService;
import kd.tdc.oatr.common.bo.gridtemplate.GridBlockInfo;
import kd.tdc.oatr.common.bo.gridtemplate.GridConfigInfo;
import kd.tdc.oatr.common.bo.talentmap.AxisDivideScaleInfo;
import kd.tdc.oatr.common.bo.talentmap.AxisInfo;
import kd.tdc.oatr.common.bo.talentmap.AxisValueTypeInfo;
import kd.tdc.oatr.common.bo.talentmap.CommonComboInfo;
import kd.tdc.oatr.common.bo.talentmap.DefaultMapInfo;
import kd.tdc.oatr.common.bo.talentmap.GridTemplateInfo;
import kd.tdc.oatr.common.bo.talentmap.MapBlockRatioInfo;
import kd.tdc.oatr.common.bo.talentmap.MapDistributionRatioInfo;
import kd.tdc.oatr.common.bo.talentmap.PersonCardDimInfo;
import kd.tdc.oatr.common.bo.talentmap.ReferStrategyInfo;
import kd.tdc.oatr.common.bo.talentmap.TalentMapConfigInfo;
import kd.tdc.oatr.common.constants.enums.MapAxisValueTypeEnum;
import kd.tdc.oatr.common.constants.enums.MapRangeEnum;
import kd.tdc.oatr.common.constants.enums.TalentMapPageSourceTypeEnum;
import kd.tdc.oatr.common.constants.enums.TalentMapStrategyEnum;

public class ReviewTalentMapPlugin
extends HRDynamicFormBasePlugin
implements BeforeF7SelectListener {
    private static final Log LOG = LogFactory.getLog(ReviewTalentMapPlugin.class);
    private static final String CONTROL_CUSTOM_CONTROL_AP = "customcontrolap";
    private static final String CALLBACK_F7_UPDATE_GRID_TPL_DATA = "updateGridTplData";
    private static final String CALLBACK_F7_COVER_GRID_TPL_DATA = "coverGridTplData";
    private static final String CALLBACK_CHANGE_DEFAULT_MAP = "changeDefaultMap";
    private static final String CALLBACK_RESET_OLD_GRID_TPL_DATA = "resetOldGridTplData";
    private static final String CACHE_OLD_GRIDTPL_ID = "oldGridTplId";
    private static final String CACHE_NEW_GRID_TPL_CONFIG_DATA = "gridTplConfigData";
    private final GridTemplateQueryService gridTemplateQueryService = (GridTemplateQueryService)ServiceFactory.getService(GridTemplateQueryService.class);
    private final ReviewDimensionQueryService reviewDimensionQueryService = (ReviewDimensionQueryService)ServiceFactory.getService(ReviewDimensionQueryService.class);

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        MulBasedataEdit perCardDim = (MulBasedataEdit)this.getControl("percarddim");
        perCardDim.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        Map<String, Object> defaultValues = this.getExtendMapValues();
        this.getPageCache().put("mapdefaultvalue", SerializationUtils.toJsonString(defaultValues));
        this.initTalentMap();
    }

    private Map<String, Object> getExtendMapValues() {
        HashMap defaultValues = Maps.newHashMapWithExpectedSize((int)16);
        HRPluginProxy pluginProxy = HRPlugInProxyFactory.create(null, IReviewTalentMapExtendService.class, (String)"kd.sdk.tdc.oatr.activity.IReviewTalentMapExtendService", null);
        pluginProxy.callReplaceIfPresent(plugin -> {
            Map mapDefaultValue;
            if (plugin != null && (mapDefaultValue = plugin.setTalentMapDefaultValue()) != null && !mapDefaultValue.isEmpty()) {
                defaultValues.putAll(mapDefaultValue);
            }
            return null;
        });
        return defaultValues;
    }

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        this.setVisibleFromActivity();
        this.setEnableFromActivity();
    }

    public void propertyChanged(PropertyChangedArgs evt) {
        super.propertyChanged(evt);
        String propertyName = evt.getProperty().getName();
        String talentMapConfigString = (String)this.getModel().getValue("talentmapconfig_tag");
        if (propertyName.equals("isdefaultmap")) {
            boolean isSelect = (Boolean)evt.getChangeSet()[0].getNewValue();
            this.changeDefaultMap(isSelect);
        }
        if (propertyName.equals("referstrategy")) {
            this.handleReferStrategyChangeEvent(talentMapConfigString);
        }
        if (propertyName.equals("gridtemplate")) {
            Object oldValue = evt.getChangeSet()[0].getOldValue();
            Object newValue = evt.getChangeSet()[0].getNewValue();
            this.cacheGridTemplateData(oldValue, newValue);
            if (this.isFromActivity()) {
                this.gridTemplateChangeFromActivity(oldValue, newValue);
            }
            if (this.isFromTemplate()) {
                this.gridTemplateChangeFromTemplate();
            }
        }
        if (propertyName.equals("percarddim")) {
            this.handlePerCardDimChangeEvent(talentMapConfigString);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        String talentMapConfigString = (String)this.getModel().getValue("talentmapconfig_tag");
        if (callBackId.equals(CALLBACK_CHANGE_DEFAULT_MAP) && !MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            this.confirmChangeDefaultMap();
            this.pushDefaultMapChangeAction(false);
            this.updateMapDataToParent();
        }
        if (callBackId.equals(CALLBACK_F7_UPDATE_GRID_TPL_DATA)) {
            if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                this.handleGridTemplateUpdateEvent(talentMapConfigString);
            } else {
                this.pushResetOldGridTplEvent();
            }
        }
        if (callBackId.equals(CALLBACK_F7_COVER_GRID_TPL_DATA)) {
            if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                this.loadNewTalentMapData();
            } else {
                this.pushResetOldGridTplEvent();
            }
        }
    }

    public void customEvent(CustomEventArgs eventArgs) {
        super.customEvent(eventArgs);
        String eventName = eventArgs.getEventName();
        String eventDataString = eventArgs.getEventArgs();
        if (HRStringUtils.equals((String)eventDataString, (String)"null") || HRStringUtils.isEmpty((String)eventDataString)) {
            return;
        }
        if (eventName.equals("propertyChange")) {
            String field;
            String mapConfigData = (String)this.getModel().getValue("talentmapconfig_tag");
            TalentMapConfigInfo talentMapConfigInfo = (TalentMapConfigInfo)SerializationUtils.fromJsonString((String)mapConfigData, TalentMapConfigInfo.class);
            JSONObject eventDataJson = (JSONObject)SerializationUtils.fromJsonString((String)eventDataString, JSONObject.class);
            switch (field = (String)eventDataJson.getObject("field", String.class)) {
                case "defaultMap": {
                    DefaultMapInfo defaultMapInfo = (DefaultMapInfo)eventDataJson.getObject("data", DefaultMapInfo.class);
                    talentMapConfigInfo.setDefaultMap(defaultMapInfo);
                    this.getModel().setValue("talentmapconfig_tag", (Object)SerializationUtils.toJsonString((Object)talentMapConfigInfo));
                    this.getModel().setValue("isdefaultmap", (Object)defaultMapInfo.isValue());
                    this.getModel().setValue("isdefaultmaplock", (Object)defaultMapInfo.isLock());
                    break;
                }
                case "referStrategy": {
                    ReferStrategyInfo referStrategyInfo = (ReferStrategyInfo)eventDataJson.getObject("data", ReferStrategyInfo.class);
                    talentMapConfigInfo.setReferStrategy(referStrategyInfo);
                    this.getModel().setValue("talentmapconfig_tag", (Object)SerializationUtils.toJsonString((Object)talentMapConfigInfo));
                    this.getModel().setValue("referstrategy", (Object)referStrategyInfo.getNumber());
                    break;
                }
                case "gridTemplate": {
                    GridTemplateInfo gridTemplateInfo = (GridTemplateInfo)eventDataJson.getObject("data", GridTemplateInfo.class);
                    talentMapConfigInfo.setGridTemplate(gridTemplateInfo);
                    this.getModel().setValue("talentmapconfig_tag", (Object)SerializationUtils.toJsonString((Object)talentMapConfigInfo));
                    if (HRStringUtils.isNotEmpty((String)gridTemplateInfo.getId())) {
                        DynamicObject gridTemplate = this.gridTemplateQueryService.getGridTemplate(Long.valueOf(gridTemplateInfo.getId()));
                        this.getModel().setValue("gridtemplate", (Object)gridTemplate);
                    }
                    this.getModel().setValue("isgridtemplatelock", (Object)gridTemplateInfo.isLock());
                    break;
                }
                case "perCardDim": {
                    PersonCardDimInfo personCardDimInfo = (PersonCardDimInfo)eventDataJson.getObject("data", PersonCardDimInfo.class);
                    talentMapConfigInfo.setPerCardDim(personCardDimInfo);
                    this.getModel().setValue("talentmapconfig_tag", (Object)SerializationUtils.toJsonString((Object)talentMapConfigInfo));
                    if (personCardDimInfo.getDimensions() == null || personCardDimInfo.getDimensions().length == 0) {
                        this.getModel().setValue("percarddim", null);
                    }
                    this.getModel().setValue("ispercarddimlock", (Object)personCardDimInfo.isLock());
                    break;
                }
                case "xAxisInfo": {
                    AxisInfo xAxisInfo = (AxisInfo)eventDataJson.getObject("data", AxisInfo.class);
                    talentMapConfigInfo.setxAxisInfo(xAxisInfo);
                    this.getModel().setValue("talentmapconfig_tag", (Object)SerializationUtils.toJsonString((Object)talentMapConfigInfo));
                    String xAxisDimId = xAxisInfo.getId();
                    if (HRStringUtils.isNotEmpty((String)xAxisDimId)) {
                        DynamicObject xReviewDimension = this.reviewDimensionQueryService.getReviewDimension(Long.valueOf(xAxisDimId));
                        this.getModel().setValue("xaxisdim", (Object)xReviewDimension);
                    } else {
                        this.getModel().setValue("xaxisdim", null);
                    }
                    this.getModel().setValue("isxaxisdimlock", (Object)xAxisInfo.isLock());
                    break;
                }
                case "yAxisInfo": {
                    AxisInfo yAxisInfo = (AxisInfo)eventDataJson.getObject("data", AxisInfo.class);
                    talentMapConfigInfo.setyAxisInfo(yAxisInfo);
                    this.getModel().setValue("talentmapconfig_tag", (Object)SerializationUtils.toJsonString((Object)talentMapConfigInfo));
                    String yAxisDimId = yAxisInfo.getId();
                    if (HRStringUtils.isNotEmpty((String)yAxisDimId)) {
                        DynamicObject yReviewDimension = this.reviewDimensionQueryService.getReviewDimension(Long.valueOf(yAxisDimId));
                        this.getModel().setValue("yaxisdim", (Object)yReviewDimension);
                    } else {
                        this.getModel().setValue("yaxisdim", null);
                    }
                    this.getModel().setValue("isyaxisdimlock", (Object)yAxisInfo.isLock());
                    break;
                }
                case "distributionRatio": {
                    MapDistributionRatioInfo distributionRatio = (MapDistributionRatioInfo)eventDataJson.getObject("data", MapDistributionRatioInfo.class);
                    talentMapConfigInfo.setDistributionRatio(distributionRatio);
                    this.getModel().setValue("talentmapconfig_tag", (Object)SerializationUtils.toJsonString((Object)talentMapConfigInfo));
                    break;
                }
                case "gridData": {
                    GridConfigInfo gridData = (GridConfigInfo)eventDataJson.getObject("data", GridConfigInfo.class);
                    talentMapConfigInfo.setGridData(gridData);
                    this.getModel().setValue("talentmapconfig_tag", (Object)SerializationUtils.toJsonString((Object)talentMapConfigInfo));
                    break;
                }
            }
            this.getModel().updateCache();
            this.updateMapDataToParent();
        }
        if (eventName.equals("beforeSelect")) {
            String field;
            JSONObject eventDataJson = (JSONObject)SerializationUtils.fromJsonString((String)eventDataString, JSONObject.class);
            switch (field = (String)eventDataJson.getObject("field", String.class)) {
                case "gridtemplate": {
                    BasedataEdit gridTplEdit = (BasedataEdit)this.getControl("gridtemplate");
                    gridTplEdit.click();
                    break;
                }
                case "percarddim": {
                    BasedataEdit perCardDim = (BasedataEdit)this.getControl("percarddim");
                    List<Long> filterDimensionIds = this.getFilterDimensionIds("percarddim");
                    perCardDim.setQFilter(new QFilter("id", "in", filterDimensionIds));
                    perCardDim.click();
                    break;
                }
                case "xaxisdim": 
                case "yaxisdim": {
                    List reviewDimensions = this.reviewDimensionQueryService.getReviewDimensions(this.getFilterDimensionIds(field));
                    CommonComboInfo[] axisDimOptions = new CommonComboInfo[reviewDimensions.size()];
                    for (int i = 0; i < reviewDimensions.size(); ++i) {
                        CommonComboInfo comboInfo = new CommonComboInfo();
                        DynamicObject dimension = (DynamicObject)reviewDimensions.get(i);
                        comboInfo.setValue(dimension.getString("id"));
                        comboInfo.setName(dimension.getLocaleString("name").toString());
                        axisDimOptions[i] = comboInfo;
                    }
                    CustomControl gridControl = (CustomControl)this.getView().getControl(CONTROL_CUSTOM_CONTROL_AP);
                    Map<String, Object> eventParams = this.getCustomEventParams("updateOptions", "init");
                    HashMap dataMap = Maps.newHashMapWithExpectedSize((int)2);
                    dataMap.put("field", field);
                    dataMap.put("data", axisDimOptions);
                    eventParams.put("data", dataMap);
                    gridControl.setData(eventParams);
                    break;
                }
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        ArrayList propertyNames = Lists.newArrayList();
        propertyNames.add("xaxisdim");
        propertyNames.add("yaxisdim");
        propertyNames.add("percarddim");
        if (propertyNames.contains(name)) {
            List<Long> filterDimensionIds = this.getFilterDimensionIds(name);
            QFilter idFilter = new QFilter("id", "in", filterDimensionIds);
            beforeF7SelectEvent.addCustomQFilter(idFilter);
        }
    }

    private void cacheGridTemplateData(Object oldValue, Object newValue) {
        if (oldValue != null) {
            DynamicObject oldGridTpl = (DynamicObject)oldValue;
            this.getPageCache().put(CACHE_OLD_GRIDTPL_ID, oldGridTpl.getPkValue().toString());
        }
        if (newValue != null) {
            DynamicObject newGridTpl = (DynamicObject)newValue;
            String gridTemplateData = this.gridTemplateQueryService.getGridConfigInfo(Long.valueOf(newGridTpl.getLong("id")));
            this.getPageCache().put(CACHE_NEW_GRID_TPL_CONFIG_DATA, gridTemplateData);
        }
    }

    private void setEnableFromActivity() {
        if (!this.isFromActivity()) {
            return;
        }
        this.getView().setEnable(Boolean.FALSE, new String[]{"referstrategy"});
        if (this.isDefaultMapEditable()) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"isdefaultmap"});
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{"isdefaultmap"});
        }
        this.getView().setEnable(Boolean.TRUE, new String[]{"gridtemplate", "xaxisdim", "yaxisdim", "percarddim"});
        String referStrategy = (String)this.getModel().getValue("referstrategy");
        if (HRStringUtils.equals((String)referStrategy, (String)TalentMapStrategyEnum.ADJUST_UNLOCK.getNumber())) {
            if (this.isDefaultMapEditable()) {
                Boolean isDefaultMapLock = (Boolean)this.getModel().getValue("isdefaultmaplock");
                this.getView().setEnable(Boolean.valueOf(isDefaultMapLock == false), new String[]{"isdefaultmap"});
            }
            Boolean isGridTemplateLock = (Boolean)this.getModel().getValue("isgridtemplatelock");
            this.getView().setEnable(Boolean.valueOf(isGridTemplateLock == false), new String[]{"gridtemplate"});
            Boolean isxAxisDimLock = (Boolean)this.getModel().getValue("isxaxisdimlock");
            this.getView().setEnable(Boolean.valueOf(isxAxisDimLock == false), new String[]{"xaxisdim"});
            Boolean isyAxisDimLock = (Boolean)this.getModel().getValue("isyaxisdimlock");
            this.getView().setEnable(Boolean.valueOf(isyAxisDimLock == false), new String[]{"yaxisdim"});
            Boolean isPerCardDimLock = (Boolean)this.getModel().getValue("ispercarddimlock");
            this.getView().setEnable(Boolean.valueOf(isPerCardDimLock == false), new String[]{"percarddim"});
        }
        if (HRStringUtils.equals((String)referStrategy, (String)TalentMapStrategyEnum.UN_ADJUST.getNumber())) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"isdefaultmap", "gridtemplate", "xaxisdim", "yaxisdim", "percarddim"});
        }
    }

    private void pushResetOldGridTplEvent() {
        this.publishCustomAction(CALLBACK_RESET_OLD_GRID_TPL_DATA);
        String oldGridTplId = this.getPageCache().get(CACHE_OLD_GRIDTPL_ID);
        DynamicObject gridTemplate = this.gridTemplateQueryService.getGridTemplate(Long.valueOf(oldGridTplId));
        this.getModel().setValue("gridtemplate", (Object)gridTemplate);
    }

    private void changeDefaultMap(boolean isSelect) {
        if (this.consumeCustomAction(CALLBACK_CHANGE_DEFAULT_MAP)) {
            return;
        }
        if (isSelect) {
            String showTips = ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u540e\uff0c\u5c06\u5207\u6362\u9ed8\u8ba4\u5bab\u683c\u5730\u56fe\uff0c\u786e\u5b9a\u8981\u7ee7\u7eed\u5417\uff1f", (String)"ReviewTalentMapPlugin_0", (String)"tdc-oatr-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(showTips, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CALLBACK_CHANGE_DEFAULT_MAP, (IFormPlugin)this));
        } else {
            String showTips = ResManager.loadKDString((String)"\u9700\u8bbe\u7f6e\u4e00\u4e2a\u9ed8\u8ba4\u5bab\u683c\u5730\u56fe\u3002", (String)"ReviewTalentMapPlugin_5", (String)"tdc-oatr-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(showTips);
            this.pushDefaultMapChangeAction(true);
        }
    }

    private void gridTemplateChangeFromTemplate() {
        this.loadNewTalentMapData();
    }

    private void gridTemplateChangeFromActivity(Object oldValue, Object newValue) {
        if (oldValue == null) {
            this.loadNewTalentMapData();
            return;
        }
        if (newValue == null) {
            this.clearTalentMapView();
            return;
        }
        if (this.consumeCustomAction(CALLBACK_RESET_OLD_GRID_TPL_DATA)) {
            return;
        }
        this.showGridTemplateChangeConfirm();
    }

    private void publishCustomAction(String actionName) {
        this.getPageCache().put(actionName, "1");
    }

    private boolean isCustomActionProcessing(String actionName) {
        String actionValue = this.getPageCache().get(actionName);
        return HRStringUtils.equals((String)actionValue, (String)"1");
    }

    private boolean consumeCustomAction(String actionName) {
        if (this.isCustomActionProcessing(actionName)) {
            this.getPageCache().remove(actionName);
            return true;
        }
        return false;
    }

    private void showGridTemplateChangeConfirm() {
        String gridTemplateData = this.getPageCache().get(CACHE_NEW_GRID_TPL_CONFIG_DATA);
        String talentMapConfigData = (String)this.getModel().getValue("talentmapconfig_tag");
        if (HRStringUtils.isEmpty((String)talentMapConfigData) || HRStringUtils.isEmpty((String)gridTemplateData)) {
            this.clearTalentMapView();
            return;
        }
        GridConfigInfo gridConfigInfo = (GridConfigInfo)SerializationUtils.fromJsonString((String)gridTemplateData, GridConfigInfo.class);
        int xAxisScales = gridConfigInfo.getxAxisScales();
        int yAxisScales = gridConfigInfo.getyAxisScales();
        TalentMapConfigInfo talentMapConfigInfo = (TalentMapConfigInfo)SerializationUtils.fromJsonString((String)talentMapConfigData, TalentMapConfigInfo.class);
        if (talentMapConfigInfo.getGridData().getxAxisScales() == xAxisScales && talentMapConfigInfo.getGridData().getyAxisScales() == yAxisScales) {
            String showTips = ResManager.loadKDString((String)"\u5207\u6362\u5c06\u66f4\u65b0\u5bab\u683c\u5730\u56fe\u76f8\u5173\u914d\u7f6e\uff0c\u662f\u5426\u786e\u8ba4\u5207\u6362\uff1f", (String)"ReviewTalentMapPlugin_6", (String)"tdc-oatr-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(showTips, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CALLBACK_F7_UPDATE_GRID_TPL_DATA, (IFormPlugin)this));
        } else {
            String showTips = ResManager.loadKDString((String)"\u5207\u6362\u5c06\u6e05\u7a7a\u5bab\u683c\u5730\u56fe\u76f8\u5173\u914d\u7f6e\uff0c\u662f\u5426\u786e\u8ba4\u5207\u6362\uff1f", (String)"ReviewTalentMapPlugin_7", (String)"tdc-oatr-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(showTips, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CALLBACK_F7_COVER_GRID_TPL_DATA, (IFormPlugin)this));
        }
    }

    private void updateTalentMapDataAndReturnParent(String talentMapData) {
        this.getModel().setValue("talentmapconfig_tag", (Object)talentMapData);
        this.updateMapDataToParent();
    }

    private void handleGridTemplateUpdateEvent(String mapConfigData) {
        String gridConfigData = this.getPageCache().get(CACHE_NEW_GRID_TPL_CONFIG_DATA);
        if (HRStringUtils.isEmpty((String)mapConfigData) || HRStringUtils.isEmpty((String)gridConfigData)) {
            return;
        }
        GridConfigInfo gridConfigInfo = (GridConfigInfo)SerializationUtils.fromJsonString((String)gridConfigData, GridConfigInfo.class);
        gridConfigInfo.getGridBlocks().forEach(block -> block.setCustomNumber(HRStringUtils.isEmpty((String)block.getCustomNumber()) ? "" : block.getCustomNumber()));
        TalentMapConfigInfo mapConfigInfo = (TalentMapConfigInfo)SerializationUtils.fromJsonString((String)mapConfigData, TalentMapConfigInfo.class);
        mapConfigInfo.setGridData(gridConfigInfo);
        this.setAxisNameAndValue(mapConfigInfo);
        this.updateTalentMapDataAndReturnParent(SerializationUtils.toJsonString((Object)mapConfigInfo));
        this.loadTalentMapView(mapConfigInfo);
    }

    private void handlePerCardDimChangeEvent(String mapConfigData) {
        if (HRStringUtils.isEmpty((String)mapConfigData)) {
            return;
        }
        TalentMapConfigInfo mapConfigInfo = (TalentMapConfigInfo)SerializationUtils.fromJsonString((String)mapConfigData, TalentMapConfigInfo.class);
        this.setPerCardDimInfo(mapConfigInfo);
        this.updateTalentMapDataAndReturnParent(SerializationUtils.toJsonString((Object)mapConfigInfo));
        this.loadTalentMapView(mapConfigInfo);
    }

    private void handleReferStrategyChangeEvent(String mapConfigData) {
        if (HRStringUtils.isEmpty((String)mapConfigData)) {
            return;
        }
        TalentMapConfigInfo mapConfigInfo = (TalentMapConfigInfo)SerializationUtils.fromJsonString((String)mapConfigData, TalentMapConfigInfo.class);
        String referStrategy = (String)this.getModel().getValue("referstrategy");
        boolean isLockIconVisible = HRStringUtils.equals((String)referStrategy, (String)TalentMapStrategyEnum.ADJUST_UNLOCK.getNumber());
        mapConfigInfo.setLockIconVisible(isLockIconVisible);
        mapConfigInfo.getxAxisInfo().getDivideScale().setLock(false);
        mapConfigInfo.getxAxisInfo().getValueType().setLock(false);
        mapConfigInfo.getyAxisInfo().getDivideScale().setLock(false);
        mapConfigInfo.getyAxisInfo().getValueType().setLock(false);
        mapConfigInfo.getDistributionRatio().setLock(false);
        this.getModel().setValue("isdefaultmaplock", (Object)false);
        this.getModel().setValue("isgridtemplatelock", (Object)false);
        this.getModel().setValue("isxaxisdimlock", (Object)false);
        this.getModel().setValue("isyaxisdimlock", (Object)false);
        this.getModel().setValue("ispercarddimlock", (Object)false);
        this.updateTalentMapDataAndReturnParent(SerializationUtils.toJsonString((Object)mapConfigInfo));
        this.loadTalentMapView(mapConfigInfo);
    }

    private void pushDefaultMapChangeAction(boolean value) {
        this.publishCustomAction(CALLBACK_CHANGE_DEFAULT_MAP);
        this.getModel().setValue("isdefaultmap", (Object)value);
    }

    private void setVisibleFromActivity() {
        if (!this.isFromActivity()) {
            return;
        }
        String referStrategy = (String)this.getModel().getValue("referstrategy");
        if (HRStringUtils.isEmpty((String)referStrategy)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"referstrategy"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"referstrategy"});
        }
    }

    private boolean isDefaultMapEditable() {
        boolean isEditable = true;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        boolean isLock = (Boolean)customParams.get("islockdefaultmap");
        if (isLock) {
            isEditable = false;
        }
        return isEditable;
    }

    private void loadNewTalentMapData() {
        String gridConfigData = this.getPageCache().get(CACHE_NEW_GRID_TPL_CONFIG_DATA);
        if (HRStringUtils.isEmpty((String)gridConfigData)) {
            this.clearTalentMapView();
            return;
        }
        TalentMapConfigInfo mapConfigInfo = this.createNewTalentMap(gridConfigData);
        if (mapConfigInfo == null) {
            this.clearTalentMapView();
            return;
        }
        this.setGridTemplateInfo(mapConfigInfo);
        this.setPerCardDimInfo(mapConfigInfo);
        this.setAxisNameAndValue(mapConfigInfo);
        this.loadTalentMapView(mapConfigInfo);
        this.getModel().setValue("gridtplselecttime", (Object)new Date());
        this.getModel().setValue("isupdatetpl", (Object)false);
        this.updateTalentMapDataAndReturnParent(SerializationUtils.toJsonString((Object)mapConfigInfo));
    }

    private void updateMapDataToParent() {
        this.getModel().updateCache();
        OperateOption option = OperateOption.create();
        option.setVariableValue("interactAction", "actionUpdateTalentMapData");
        this.getView().getParentView().invokeOperation("mapinteract", option);
        this.getView().sendFormAction(this.getView().getParentView());
    }

    private void setDefaultMap(TalentMapConfigInfo mapConfigInfo) {
        DynamicObject mapInfo = this.getModel().getDataEntity();
        boolean isDefaultMap = mapInfo.getBoolean("isdefaultmap");
        boolean isDefaultMapLock = mapInfo.getBoolean("isdefaultmaplock");
        DefaultMapInfo defaultMapInfo = new DefaultMapInfo();
        defaultMapInfo.setValue(isDefaultMap);
        defaultMapInfo.setLock(isDefaultMapLock);
        mapConfigInfo.setDefaultMap(defaultMapInfo);
    }

    private void setReferStrategy(TalentMapConfigInfo mapConfigInfo) {
        DynamicObject mapInfo = this.getModel().getDataEntity();
        String referStrategy = mapInfo.getString("referstrategy");
        boolean isLockIconVisible = HRStringUtils.equals((String)referStrategy, (String)TalentMapStrategyEnum.ADJUST_UNLOCK.getNumber());
        mapConfigInfo.setLockIconVisible(isLockIconVisible);
        ReferStrategyInfo referStrategyInfo = new ReferStrategyInfo();
        referStrategyInfo.setNumber(HRStringUtils.isEmpty((String)referStrategy) ? "" : referStrategy);
        referStrategyInfo.setName(TalentMapStrategyEnum.getValueByNumber((String)referStrategy));
        referStrategyInfo.setVisible(this.isFromTemplate());
        referStrategyInfo.setHelpText(ResManager.loadKDString((String)"\u5141\u8bb8\u8c03\u6574\uff1a\u6d3b\u52a8\u5f15\u7528\u540e\uff0c\u53ef\u57fa\u4e8e\u6a21\u677f\u81ea\u7531\u8c03\u6574\u53c2\u6570\u3002\r\n\u4ec5\u53ef\u8c03\u6574\u672a\u9501\u5b9a\u6761\u4ef6\uff1a\u6d3b\u52a8\u5f15\u7528\u540e\uff0c\u4ec5\u53ef\u57fa\u4e8e\u6a21\u677f\u8c03\u6574\u672a\u9501\u5b9a\u53c2\u6570\u3002\r\n\u4e0d\u5141\u8bb8\u8c03\u6574\uff1a\u6d3b\u52a8\u5b8c\u5168\u5f15\u7528\u6a21\u677f\u914d\u7f6e\uff0c\u4e0d\u53ef\u8c03\u6574\u3002", (String)"ReviewTalentMapPlugin_8", (String)"tdc-oatr-formplugin", (Object[])new Object[0]));
        TalentMapStrategyEnum[] strategyEnums = TalentMapStrategyEnum.values();
        CommonComboInfo[] strategyTypeInfos = new CommonComboInfo[strategyEnums.length];
        for (int i = 0; i < strategyEnums.length; ++i) {
            TalentMapStrategyEnum strategyEnum = strategyEnums[i];
            CommonComboInfo strategyInfo = new CommonComboInfo();
            strategyInfo.setValue(strategyEnum.getNumber());
            strategyInfo.setName(strategyEnum.getValue());
            strategyTypeInfos[i] = strategyInfo;
        }
        referStrategyInfo.setStrategyTypeInfos(strategyTypeInfos);
        mapConfigInfo.setReferStrategy(referStrategyInfo);
    }

    private void setPerCardDimInfo(TalentMapConfigInfo mapConfigInfo) {
        DynamicObjectCollection perCardDims = (DynamicObjectCollection)this.getModel().getValue("percarddim");
        boolean isPerCardDimLock = (Boolean)this.getModel().getValue("ispercarddimlock");
        PersonCardDimInfo personCardDimInfo = new PersonCardDimInfo();
        CommonComboInfo[] dimensions = new CommonComboInfo[]{};
        if (!CollectionUtils.isEmpty((Collection)perCardDims)) {
            dimensions = new CommonComboInfo[perCardDims.size()];
            List perCardDimIds = perCardDims.stream().map(perCardDim -> perCardDim.getLong("fbasedataid_id")).collect(Collectors.toList());
            for (int i = 0; i < perCardDimIds.size(); ++i) {
                DynamicObject perCardDim2 = this.reviewDimensionQueryService.getReviewDimension((Long)perCardDimIds.get(i));
                CommonComboInfo perDimension = new CommonComboInfo();
                perDimension.setValue(String.valueOf(HRDyObjectPropUtil.getId((DynamicObject)perCardDim2)));
                perDimension.setName(HRDyObjectPropUtil.getName((DynamicObject)perCardDim2));
                dimensions[i] = perDimension;
            }
        }
        personCardDimInfo.setDimensions(dimensions);
        personCardDimInfo.setLock(isPerCardDimLock);
        personCardDimInfo.setHelpText(ResManager.loadKDString((String)"\u5176\u4ed6\u7ef4\u5ea6\u5c06\u4f5c\u4e3a\u6807\u7b7e\u5448\u73b0\u5728\u6821\u51c6\u4eba\u5458\u5361\u7247\u3002", (String)"ReviewTalentMapPlugin_9", (String)"tdc-oatr-formplugin", (Object[])new Object[0]));
        mapConfigInfo.setPerCardDim(personCardDimInfo);
    }

    private void setGridTemplateInfo(TalentMapConfigInfo mapConfigInfo) {
        DynamicObject gridTemplate = (DynamicObject)this.getModel().getValue("gridtemplate");
        boolean isGridTemplateLock = (Boolean)this.getModel().getValue("isgridtemplatelock");
        GridTemplateInfo gridTemplateInfo = mapConfigInfo.getGridTemplate() == null ? new GridTemplateInfo() : mapConfigInfo.getGridTemplate();
        String gridTplId = HRDyObjectPropUtil.getString((DynamicObject)gridTemplate, (String)"id");
        gridTemplateInfo.setId(HRStringUtils.isEmpty((String)gridTplId) ? "" : gridTplId);
        String gridName = HRDyObjectPropUtil.getName((DynamicObject)gridTemplate);
        gridTemplateInfo.setName(HRStringUtils.isEmpty((String)gridName) ? "" : gridName);
        gridTemplateInfo.setLock(isGridTemplateLock);
        mapConfigInfo.setGridTemplate(gridTemplateInfo);
    }

    private void setAxisNameAndValue(TalentMapConfigInfo mapConfigInfo) {
        if (mapConfigInfo == null) {
            return;
        }
        GridConfigInfo gridData = mapConfigInfo.getGridData() == null ? new GridConfigInfo() : mapConfigInfo.getGridData();
        AxisInfo xAxisInfo = mapConfigInfo.getxAxisInfo() == null ? new AxisInfo() : mapConfigInfo.getxAxisInfo();
        DynamicObject xAxisDim = (DynamicObject)this.getModel().getValue("xaxisdim");
        if (xAxisDim != null) {
            xAxisInfo.setId(String.valueOf(xAxisDim.getPkValue()));
            String xAxisDimName = HRObjectUtils.isEmpty((Object)xAxisDim) ? "" : HRDyObjectPropUtil.getName((DynamicObject)xAxisDim);
            xAxisInfo.setName(xAxisDimName);
            xAxisInfo.setAxisInfos(new CommonComboInfo[0]);
            int xAxisScales = gridData.getxAxisScales();
            AxisDivideScaleInfo xDivideScale = xAxisInfo.getDivideScale();
            AxisDivideScaleInfo axisDivideScaleInfo = xDivideScale = xDivideScale == null ? new AxisDivideScaleInfo() : xDivideScale;
            if (xDivideScale.getValues() == null || xAxisScales != xDivideScale.getValues().length || HRStringUtils.isEmpty((String)xAxisDimName)) {
                Object[] xAxisValues = new String[xAxisScales];
                Arrays.fill(xAxisValues, "");
                xDivideScale.setValues((String[])xAxisValues);
            }
        } else if (mapConfigInfo.getxAxisInfo() == null) {
            xAxisInfo = this.getInitAxisInfo(gridData.getxAxisScales());
        } else {
            xAxisInfo.setId("");
            xAxisInfo.setName("");
        }
        mapConfigInfo.setxAxisInfo(xAxisInfo);
        AxisInfo yAxisInfo = mapConfigInfo.getyAxisInfo() == null ? new AxisInfo() : mapConfigInfo.getyAxisInfo();
        DynamicObject yAxisDim = (DynamicObject)this.getModel().getValue("yaxisdim");
        if (yAxisDim != null) {
            String yAxisDimName = HRObjectUtils.isEmpty((Object)yAxisDim) ? "" : HRDyObjectPropUtil.getName((DynamicObject)yAxisDim);
            yAxisInfo.setId(String.valueOf(yAxisDim.getPkValue()));
            yAxisInfo.setName(yAxisDimName);
            yAxisInfo.setAxisInfos(new CommonComboInfo[0]);
            int yAxisScales = gridData.getyAxisScales();
            AxisDivideScaleInfo yDivideScale = yAxisInfo.getDivideScale();
            AxisDivideScaleInfo axisDivideScaleInfo = yDivideScale = yDivideScale == null ? new AxisDivideScaleInfo() : yDivideScale;
            if (yDivideScale.getValues() == null || yAxisScales != yDivideScale.getValues().length || HRStringUtils.isEmpty((String)yAxisDimName)) {
                Object[] yAxisValues = new String[yAxisScales];
                Arrays.fill(yAxisValues, "");
                yDivideScale.setValues((String[])yAxisValues);
            }
        } else if (mapConfigInfo.getyAxisInfo() == null) {
            yAxisInfo = this.getInitAxisInfo(gridData.getyAxisScales());
        } else {
            yAxisInfo.setId("");
            yAxisInfo.setName("");
        }
        mapConfigInfo.setyAxisInfo(yAxisInfo);
    }

    private void loadTalentMapView(TalentMapConfigInfo mapConfigInfo) {
        if (this.isFromActivity() && mapConfigInfo != null) {
            mapConfigInfo.setLockIconVisible(false);
        }
        CustomControl gridControl = (CustomControl)this.getView().getControl(CONTROL_CUSTOM_CONTROL_AP);
        Map<String, Object> mapData = this.getCustomEventParams("loadData", "init");
        mapData.put("data", mapConfigInfo);
        gridControl.setData(mapData);
    }

    private void confirmChangeDefaultMap() {
        CustomControl gridControl = (CustomControl)this.getControl(CONTROL_CUSTOM_CONTROL_AP);
        Map<String, Object> mapData = this.getCustomEventParams(CALLBACK_CHANGE_DEFAULT_MAP, "update");
        gridControl.setData(mapData);
    }

    private void clearTalentMapView() {
        TalentMapConfigInfo talentMapConfigInfo = this.initTalentMapConfigInfo(false);
        this.loadTalentMapView(talentMapConfigInfo);
    }

    private void initTalentMap() {
        this.initTalentMapData();
        this.initTalentMapView();
    }

    private void initTalentMapData() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (CollectionUtils.isEmpty((Map)customParams) || !customParams.containsKey("referstrategy")) {
            return;
        }
        String referStrategy = (String)customParams.get("referstrategy");
        boolean isDefaultMap = (Boolean)customParams.get("isdefaultmap");
        boolean isDefaultMapLock = (Boolean)customParams.get("isdefaultmaplock");
        Long gridTemplateId = Long.valueOf((String)customParams.get("gridtemplate"));
        boolean isGridTemplateLock = (Boolean)customParams.get("isgridtemplatelock");
        Long xAxisDimId = Long.valueOf((String)customParams.get("xaxisdim"));
        boolean isXAxisDimLock = (Boolean)customParams.get("isxaxisdimlock");
        Long yAxisDimId = Long.valueOf((String)customParams.get("yaxisdim"));
        boolean isYAxisDimLock = (Boolean)customParams.get("isyaxisdimlock");
        String perCardDimJsonStr = (String)customParams.get("percarddim");
        if (HRStringUtils.isEmpty((String)perCardDimJsonStr)) {
            perCardDimJsonStr = "";
        }
        String[] perCardDimIdArray = (String[])SerializationUtils.fromJsonString((String)perCardDimJsonStr, String[].class);
        Object[] perCardDimIds = (Long[])Arrays.stream(perCardDimIdArray).map(Long::valueOf).toArray(Long[]::new);
        boolean isPerCardDimLock = (Boolean)customParams.get("ispercarddimlock");
        boolean isUpdateTpl = (Boolean)customParams.get("isupdatetpl");
        String mapConfigData = (String)customParams.get("talentmapconfig_tag");
        String gridUpdateTimeStr = (String)customParams.get("gridtplselecttime");
        Date gridTplSelectTime = null;
        try {
            gridTplSelectTime = HRDateTimeUtils.parseDate((String)gridUpdateTimeStr);
        }
        catch (ParseException e) {
            LOG.error("ReviewTalentMapPlugin.initTalentMapData: the String value of {} parse to Date error!", (Object)gridUpdateTimeStr, (Object)e);
        }
        this.getModel().beginInit();
        this.getModel().setValue("referstrategy", (Object)referStrategy);
        this.getModel().setValue("isdefaultmap", (Object)isDefaultMap);
        this.getModel().setValue("isdefaultmaplock", (Object)isDefaultMapLock);
        this.setBaseDataFieldValue("gridtemplate", gridTemplateId);
        this.getModel().setValue("isgridtemplatelock", (Object)isGridTemplateLock);
        this.setBaseDataFieldValue("xaxisdim", xAxisDimId);
        this.getModel().setValue("isxaxisdimlock", (Object)isXAxisDimLock);
        this.setBaseDataFieldValue("yaxisdim", yAxisDimId);
        this.getModel().setValue("isyaxisdimlock", (Object)isYAxisDimLock);
        perCardDimIds = HRArrayUtils.isEmpty((Object[])perCardDimIds) ? null : perCardDimIds;
        this.getModel().setValue("percarddim", (Object)perCardDimIds);
        this.getModel().setValue("ispercarddimlock", (Object)isPerCardDimLock);
        this.getModel().setValue("isupdatetpl", (Object)isUpdateTpl);
        this.getModel().setValue("talentmapconfig_tag", (Object)mapConfigData);
        this.getModel().setValue("gridtplselecttime", (Object)gridTplSelectTime);
        this.getModel().endInit();
    }

    private void initTalentMapView() {
        TalentMapConfigInfo mapConfigInfo;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (CollectionUtils.isEmpty((Map)customParams) || !customParams.containsKey("referstrategy")) {
            return;
        }
        String mapConfigData = (String)customParams.get("talentmapconfig_tag");
        if (!HRStringUtils.isEmpty((String)mapConfigData)) {
            mapConfigInfo = (TalentMapConfigInfo)SerializationUtils.fromJsonString((String)mapConfigData, TalentMapConfigInfo.class);
            this.setReferStrategy(mapConfigInfo);
            this.setGridTemplateInfo(mapConfigInfo);
            this.setDefaultMap(mapConfigInfo);
            this.setAxisNameAndValue(mapConfigInfo);
            this.setPerCardDimInfo(mapConfigInfo);
        } else {
            mapConfigInfo = this.initTalentMapConfigInfo(true);
        }
        if (this.isFromActivity()) {
            mapConfigInfo.getReferStrategy().setVisible(false);
        }
        this.getModel().setValue("talentmapconfig_tag", (Object)SerializationUtils.toJsonString((Object)mapConfigInfo));
        this.loadTalentMapView(mapConfigInfo);
    }

    private void setBaseDataFieldValue(String fieldName, Long pkId) {
        if (pkId == 0L) {
            this.getModel().setValue(fieldName, null);
        } else {
            this.getModel().setValue(fieldName, (Object)pkId);
        }
    }

    private Map<String, Object> getCustomEventParams(String eventName, String eventStatus) {
        HashMap mapData = Maps.newHashMapWithExpectedSize((int)10);
        mapData.put("code", 200);
        mapData.put("success", true);
        mapData.put("eventName", eventName);
        mapData.put("eventStatus", eventStatus);
        mapData.put("times", System.currentTimeMillis());
        mapData.put("pageStatus", "edit");
        if (!this.isEditable()) {
            mapData.put("pageStatus", "view");
        }
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        mapData.put("pageSource", customParams.get("pageSource"));
        return mapData;
    }

    private boolean isEditable() {
        String referStrategy;
        if (this.isFromActivity() && HRStringUtils.equals((String)(referStrategy = (String)this.getModel().getValue("referstrategy")), (String)TalentMapStrategyEnum.UN_ADJUST.getNumber())) {
            return false;
        }
        CustomControl gridControl = (CustomControl)this.getView().getControl(CONTROL_CUSTOM_CONTROL_AP);
        String lock = gridControl.getLock();
        int statusValue = this.getBillStatusValue();
        return !this.isLock(statusValue, lock);
    }

    private int getBillStatusValue() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String billStatusValue = (String)customParams.get("billStatusValue");
        if (HRStringUtils.isEmpty((String)billStatusValue)) {
            return 0;
        }
        return Integer.parseInt(billStatusValue);
    }

    boolean isLock(int status, String lock) {
        if (HRStringUtils.isEmpty((String)lock)) {
            return false;
        }
        return BillOperationStatus.ADDNEW.getValue() == status && lock.contains("new") || BillOperationStatus.EDIT.getValue() == status && lock.contains("edit") || BillOperationStatus.VIEW.getValue() == status && lock.contains("view") || BillOperationStatus.SUBMIT.getValue() == status && lock.contains("submit") || BillOperationStatus.AUDIT.getValue() == status && lock.contains("audit");
    }

    private TalentMapConfigInfo createNewTalentMap(String gridTemplateData) {
        if (HRStringUtils.isEmpty((String)gridTemplateData)) {
            return null;
        }
        GridConfigInfo gridConfigInfo = (GridConfigInfo)SerializationUtils.fromJsonString((String)gridTemplateData, GridConfigInfo.class);
        int xAxisScales = gridConfigInfo.getxAxisScales();
        int yAxisScales = gridConfigInfo.getyAxisScales();
        gridConfigInfo.getGridBlocks().forEach(block -> block.setCustomNumber(HRStringUtils.isEmpty((String)block.getCustomNumber()) ? "" : block.getCustomNumber()));
        String talentMapConfig = (String)this.getModel().getValue("talentmapconfig_tag");
        TalentMapConfigInfo mapConfigInfo = HRStringUtils.isEmpty((String)talentMapConfig) ? this.initTalentMapConfigInfo(true) : (TalentMapConfigInfo)SerializationUtils.fromJsonString((String)talentMapConfig, TalentMapConfigInfo.class);
        AxisInfo xAxisInfo = this.getInitAxisInfo(xAxisScales);
        mapConfigInfo.setxAxisInfo(xAxisInfo);
        AxisInfo yAxisInfo = this.getInitAxisInfo(yAxisScales);
        mapConfigInfo.setyAxisInfo(yAxisInfo);
        MapDistributionRatioInfo distributionRatioInfo = this.getInitDistributionRatioInfo(xAxisScales, yAxisScales);
        mapConfigInfo.setDistributionRatio(distributionRatioInfo);
        mapConfigInfo.setGridData(gridConfigInfo);
        return mapConfigInfo;
    }

    private AxisInfo getInitAxisInfo(int scaleNumbers) {
        AxisInfo axisInfo = new AxisInfo();
        axisInfo.setId("");
        axisInfo.setName("");
        AxisValueTypeInfo valueTypeInfo = new AxisValueTypeInfo();
        valueTypeInfo.setType(MapAxisValueTypeEnum.SCORE.getValue());
        valueTypeInfo.setLock(false);
        axisInfo.setValueType(valueTypeInfo);
        AxisDivideScaleInfo divideScale = new AxisDivideScaleInfo();
        divideScale.setRange(MapRangeEnum.LEFT.getValue());
        Object[] values = new String[scaleNumbers];
        Arrays.fill(values, "");
        divideScale.setValues((String[])values);
        divideScale.setLock(false);
        axisInfo.setDivideScale(divideScale);
        axisInfo.setAxisInfos(new CommonComboInfo[0]);
        return axisInfo;
    }

    private MapDistributionRatioInfo getInitDistributionRatioInfo(int xScaleNumbers, int yScaleNumbers) {
        MapDistributionRatioInfo distributionRatioInfo = new MapDistributionRatioInfo();
        distributionRatioInfo.setLock(false);
        int mapNum = xScaleNumbers * yScaleNumbers;
        MapBlockRatioInfo[] values = new MapBlockRatioInfo[mapNum];
        for (int i = 0; i < mapNum; ++i) {
            MapBlockRatioInfo mapBlockRatioInfo = new MapBlockRatioInfo();
            mapBlockRatioInfo.setGridBlockNo(String.valueOf(i + 1));
            mapBlockRatioInfo.setRatio("");
            values[i] = mapBlockRatioInfo;
        }
        distributionRatioInfo.setValues(values);
        return distributionRatioInfo;
    }

    private List<Long> getFilterDimensionIds(String currentDimFieldName) {
        List<Object> dimensionIds = Lists.newArrayListWithExpectedSize((int)10);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String parentDimEntityName = (String)customParams.get("dimEntityName");
        String parentDimFieldName = (String)customParams.get("dimFieldName");
        String parentDimStatusName = (String)customParams.get("dimStatusName");
        IFormView parentView = this.getView().getParentView();
        if (HRStringUtils.isEmpty((String)parentDimEntityName) || HRStringUtils.isEmpty((String)parentDimFieldName) || HRStringUtils.isEmpty((String)parentDimStatusName) || parentView == null) {
            return dimensionIds;
        }
        IDataModel model = parentView.getModel();
        DynamicObjectCollection entryEntity = model.getEntryEntity(parentDimEntityName);
        dimensionIds = entryEntity.stream().map(entity -> HRDyObjectPropUtil.getId((DynamicObject)entity.getDynamicObject(parentDimFieldName))).collect(Collectors.toList());
        this.removeSelectedDimId(currentDimFieldName, "xaxisdim", dimensionIds);
        this.removeSelectedDimId(currentDimFieldName, "yaxisdim", dimensionIds);
        this.removeSelectedPerCardDimId(currentDimFieldName, dimensionIds);
        return dimensionIds;
    }

    private void removeSelectedDimId(String currentDimFieldName, String dimFieldName, List<Long> dimensionIds) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        if (!dimFieldName.equals(currentDimFieldName)) {
            DynamicObject dimDy = dataEntity.getDynamicObject(dimFieldName);
            if (HRObjectUtils.isEmpty((Object)dimDy)) {
                return;
            }
            Long DimId = HRDyObjectPropUtil.getId((DynamicObject)dimDy);
            dimensionIds.remove(DimId);
        }
    }

    private void removeSelectedPerCardDimId(String currentDimFieldName, List<Long> dimensionIds) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        if (!"percarddim".equals(currentDimFieldName)) {
            DynamicObjectCollection dimDys = dataEntity.getDynamicObjectCollection("percarddim");
            if (CollectionUtils.isEmpty((Collection)dimDys)) {
                return;
            }
            List perCardDimIds = dimDys.stream().map(dim -> dim.getLong("fbasedataid_id")).collect(Collectors.toList());
            dimensionIds.removeAll(perCardDimIds);
        }
    }

    private boolean isFromActivity() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String pageSource = (String)customParams.get("pageSource");
        return pageSource.equals(TalentMapPageSourceTypeEnum.ACTIVITY.getNumber());
    }

    private boolean isFromTemplate() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String pageSource = (String)customParams.get("pageSource");
        return pageSource.equals(TalentMapPageSourceTypeEnum.TEMPLATE.getNumber());
    }

    private TalentMapConfigInfo initTalentMapConfigInfo(boolean isNeedDefaultValue) {
        String mapDefaultValue = this.getPageCache().get("mapdefaultvalue");
        Map<String, Object> defaultValueMap = Maps.newHashMapWithExpectedSize((int)16);
        if (HRStringUtils.isNotEmpty((String)mapDefaultValue)) {
            defaultValueMap = (Map)SerializationUtils.fromJsonString((String)mapDefaultValue, Map.class);
        }
        if (isNeedDefaultValue && this.isDefaultValMatchSource(defaultValueMap)) {
            Object tplId = defaultValueMap.getOrDefault(IReviewTalentMapExtendService.InfoKey.GRID_TEMPLATE_ID.getPropKey(), null);
            if (tplId != null && StringUtils.isNumeric((String)tplId.toString())) {
                this.getModel().setValue("gridtemplate", (Object)Long.valueOf(tplId.toString()));
            }
            String referStrategy = defaultValueMap.getOrDefault(IReviewTalentMapExtendService.InfoKey.REFER_STRATEGY.getPropKey(), "");
            this.getModel().setValue("referstrategy", (Object)referStrategy);
        }
        DynamicObject mapInfo = this.getModel().getDataEntity();
        DynamicObject gridTpl = mapInfo.getDynamicObject("gridtemplate");
        boolean isGridTplLock = mapInfo.getBoolean("isgridtemplatelock");
        TalentMapConfigInfo talentMapConfigInfo = new TalentMapConfigInfo();
        this.setDefaultMap(talentMapConfigInfo);
        this.setReferStrategy(talentMapConfigInfo);
        GridTemplateInfo gridTemplateInfo = new GridTemplateInfo();
        if (gridTpl != null) {
            gridTemplateInfo.setId(gridTpl.getString("id"));
            gridTemplateInfo.setName(HRDyObjectPropUtil.getName((DynamicObject)gridTpl));
        } else {
            gridTemplateInfo.setId("");
            gridTemplateInfo.setName("");
        }
        gridTemplateInfo.setLock(isGridTplLock);
        talentMapConfigInfo.setGridTemplate(gridTemplateInfo);
        this.setPerCardDimInfo(talentMapConfigInfo);
        this.setAxisNameAndValue(talentMapConfigInfo);
        MapDistributionRatioInfo distributionRatioInfo = this.getInitDistributionRatioInfo(0, 0);
        talentMapConfigInfo.setDistributionRatio(distributionRatioInfo);
        if (gridTpl != null) {
            String gridTemplateData = this.gridTemplateQueryService.getGridConfigInfo(Long.valueOf(gridTpl.getLong("id")));
            talentMapConfigInfo.setGridData((GridConfigInfo)SerializationUtils.fromJsonString((String)gridTemplateData, GridConfigInfo.class));
        } else {
            talentMapConfigInfo.setGridData(new GridConfigInfo());
        }
        if (isNeedDefaultValue && this.isDefaultValMatchSource(defaultValueMap)) {
            List blockInfoList;
            Object yDivValue;
            String yType;
            Object xDivValue;
            String xType = (String)defaultValueMap.getOrDefault(IReviewTalentMapExtendService.InfoKey.X_AXIS_TYPE.getPropKey(), "");
            if (HRStringUtils.isNotEmpty((String)xType)) {
                talentMapConfigInfo.getxAxisInfo().getValueType().setType(xType);
            }
            if ((xDivValue = defaultValueMap.getOrDefault(IReviewTalentMapExtendService.InfoKey.X_AXIS_DIV_VALUE.getPropKey(), null)) != null) {
                if (xDivValue instanceof List) {
                    List xDivValuesList = xDivValue;
                    String[] xDivValues = xDivValuesList.toArray(new String[0]);
                    talentMapConfigInfo.getxAxisInfo().getDivideScale().setValues(xDivValues);
                }
                if (xDivValue instanceof String[]) {
                    String[] xDivValues = xDivValue;
                    talentMapConfigInfo.getxAxisInfo().getDivideScale().setValues(xDivValues);
                }
            }
            if (HRStringUtils.isNotEmpty((String)(yType = (String)defaultValueMap.getOrDefault(IReviewTalentMapExtendService.InfoKey.Y_AXIS_TYPE.getPropKey(), "")))) {
                talentMapConfigInfo.getyAxisInfo().getValueType().setType(yType);
            }
            if ((yDivValue = defaultValueMap.getOrDefault(IReviewTalentMapExtendService.InfoKey.Y_AXIS_DIV_VALUE.getPropKey(), null)) != null) {
                if (yDivValue instanceof List) {
                    List yDivValuesList = yDivValue;
                    String[] yDivValues = yDivValuesList.toArray(new String[0]);
                    talentMapConfigInfo.getyAxisInfo().getDivideScale().setValues(yDivValues);
                }
                if (yDivValue instanceof String[]) {
                    String[] yDivValues = yDivValue;
                    talentMapConfigInfo.getyAxisInfo().getDivideScale().setValues(yDivValues);
                }
            }
            if ((blockInfoList = (List)defaultValueMap.getOrDefault(IReviewTalentMapExtendService.InfoKey.GRID_BLOCK.getPropKey(), null)) != null && !blockInfoList.isEmpty()) {
                Map<String, GridBlockInfo> gridBlockInfoMap = talentMapConfigInfo.getGridData().getGridBlocks().stream().collect(Collectors.toMap(GridBlockInfo::getNumber, gridBlockInfo -> gridBlockInfo, (v1, v2) -> v2));
                if (distributionRatioInfo.getValues().length == 0) {
                    MapBlockRatioInfo[] values = new MapBlockRatioInfo[blockInfoList.size()];
                    for (int i = 0; i < blockInfoList.size(); ++i) {
                        MapBlockRatioInfo mapBlockRatioInfo2 = new MapBlockRatioInfo();
                        mapBlockRatioInfo2.setGridBlockNo(String.valueOf(i + 1));
                        mapBlockRatioInfo2.setRatio("");
                        values[i] = mapBlockRatioInfo2;
                    }
                    distributionRatioInfo.setValues(values);
                    talentMapConfigInfo.setDistributionRatio(distributionRatioInfo);
                }
                Map<String, MapBlockRatioInfo> blockRatioInfoMap = Arrays.stream(talentMapConfigInfo.getDistributionRatio().getValues()).collect(Collectors.toMap(MapBlockRatioInfo::getGridBlockNo, mapBlockRatioInfo -> mapBlockRatioInfo, (v1, v2) -> v2));
                for (Map blockInfo : blockInfoList) {
                    String number = blockInfo.getOrDefault(IReviewTalentMapExtendService.InfoKey.BLOCK_SYS_NUMBER.getPropKey(), "");
                    if (HRStringUtils.isEmpty((String)number)) continue;
                    String blockNumber = blockInfo.getOrDefault(IReviewTalentMapExtendService.InfoKey.BLOCK_NUMBER.getPropKey(), "");
                    String blockColor = blockInfo.getOrDefault(IReviewTalentMapExtendService.InfoKey.BLOCK_COLOR.getPropKey(), "");
                    String blockPercent = blockInfo.getOrDefault(IReviewTalentMapExtendService.InfoKey.BLOCK_PERCENT.getPropKey(), "");
                    String nameText = blockInfo.getOrDefault(IReviewTalentMapExtendService.InfoKey.BLOCK_NAME_TEXT.getPropKey(), "");
                    String nameTextColor = blockInfo.getOrDefault(IReviewTalentMapExtendService.InfoKey.BLOCK_NAME_COLOR.getPropKey(), "");
                    String descText = blockInfo.getOrDefault(IReviewTalentMapExtendService.InfoKey.BLOCK_DESC_TEXT.getPropKey(), "");
                    String descTextColor = blockInfo.getOrDefault(IReviewTalentMapExtendService.InfoKey.BLOCK_DESC_COLOR.getPropKey(), "");
                    GridBlockInfo gridBlockInfo2 = gridBlockInfoMap.get(number);
                    gridBlockInfo2.setCustomNumber(blockNumber);
                    gridBlockInfo2.setBackColor(blockColor);
                    gridBlockInfo2.getName().setText(nameText);
                    gridBlockInfo2.getName().setFontColor(nameTextColor);
                    gridBlockInfo2.getDesc().setText(descText);
                    gridBlockInfo2.getDesc().setFontColor(descTextColor);
                    if (blockRatioInfoMap.isEmpty() || blockRatioInfoMap.get(number) == null) continue;
                    blockRatioInfoMap.get(number).setRatio(blockPercent);
                }
                this.getModel().setValue("talentmapconfig_tag", (Object)SerializationUtils.toJsonString((Object)talentMapConfigInfo));
                this.getModel().updateCache();
                this.updateMapDataToParent();
            }
        }
        return talentMapConfigInfo;
    }

    private boolean isDefaultValMatchSource(Map<String, Object> defaultValueMap) {
        if (defaultValueMap.isEmpty()) {
            return false;
        }
        String sourceFlag = (String)defaultValueMap.getOrDefault(IReviewTalentMapExtendService.InfoKey.SCOPE.getPropKey(), "all");
        if ("all".equals(sourceFlag)) {
            return true;
        }
        return this.isFromTemplate() ? "tpl".equals(sourceFlag) : "act".equals(sourceFlag);
    }
}

