/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.formplugin.web.common;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Consumer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tdc.oatr.common.constants.enums.ManagerItemEnum;
import kd.tdc.oatr.common.utils.PropUtils;

public abstract class ManagerItemUtil {
    public static boolean checkPermByManagerItem(ManagerItemEnum managerItemEnum, Object activityId) {
        return ManagerItemUtil.checkPermByManagerItem(managerItemEnum, activityId, null);
    }

    public static boolean checkPermByManagerItem(ManagerItemEnum managerItemEnum, Object activityId, Consumer<Boolean> consumer) {
        long currUserId = RequestContext.get().getCurrUserId();
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("oatr_reviewgroup");
        QFilter qFilter = new QFilter("reviewactivity", "=", activityId);
        DynamicObject[] dynamicObjects = serviceHelper.query("entryentity,colstatus,collaborator", new QFilter[]{qFilter});
        boolean isCollaborator = Arrays.stream(dynamicObjects).map(dy -> dy.getDynamicObjectCollection("entryentity")).flatMap(Collection::stream).filter(dy -> HRStringUtils.equals((String)dy.getString("colstatus"), (String)"1")).map(dy -> dy.getLong(PropUtils.getIdDot((String)"collaborator"))).anyMatch(userId -> userId == currUserId);
        if (!isCollaborator) {
            if (Objects.nonNull(consumer)) {
                consumer.accept((Object)Boolean.FALSE);
            }
            return false;
        }
        return true;
    }

    public static List<Long> getCollaborateGroup(Object activityId) {
        long currUserId = RequestContext.get().getCurrUserId();
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("oatr_reviewgroup");
        QFilter qFilter = new QFilter("reviewactivity", "=", activityId);
        DynamicObject[] dynamicObjects = serviceHelper.query("entryentity,colstatus,collaborator", new QFilter[]{qFilter});
        return Arrays.stream(dynamicObjects).filter(dynamicObject -> dynamicObject.getDynamicObjectCollection("entryentity").stream().anyMatch(dy -> HRStringUtils.equals((String)dy.getString("colstatus"), (String)"1") && dy.getLong(PropUtils.getIdDot((String)"collaborator")) == currUserId)).map(dy -> dy.getLong("id")).collect(Collectors.toList());
    }

    public static boolean isCollaboratorPage(IFormView formView) {
        Object isCollaborationPage = formView.getFormShowParameter().getCustomParam("collaboration_flag");
        if (Objects.isNull(isCollaborationPage)) {
            return false;
        }
        return HRStringUtils.equals((String)String.valueOf(isCollaborationPage), (String)"1");
    }

    public static boolean isCollaboratorPage(FormShowParameter showParameter) {
        Object isCollaborationPage = showParameter.getCustomParam("collaboration_flag");
        if (Objects.isNull(isCollaborationPage)) {
            return false;
        }
        return HRStringUtils.equals((String)String.valueOf(isCollaborationPage), (String)"1");
    }
}

