/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.formplugin.web.common;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.ButtonAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.control.HRButtonAp;
import kd.hr.hbp.common.control.HRFlexPanelAp;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.sdk.tdc.oatr.reviewobject.IReviewObjectTreeListExtendService;
import kd.tdc.oatr.bussiness.ServiceFactory;
import kd.tdc.oatr.bussiness.application.ReviewActivityApplicationService;
import kd.tdc.oatr.bussiness.queryservice.ReviewActivityQueryService;
import kd.tdc.oatr.common.constants.enums.ObjectStatusEnum;
import kd.tdc.oatr.common.utils.PropUtils;

public abstract class ReviewActivityTreeUtil {
    private static final Log LOG = LogFactory.getLog(ReviewActivityTreeUtil.class);
    private static final ReviewActivityQueryService activityQueryService = (ReviewActivityQueryService)ServiceFactory.getService(ReviewActivityQueryService.class);
    private static final ReviewActivityApplicationService activityApplicationService = (ReviewActivityApplicationService)ServiceFactory.getService(ReviewActivityApplicationService.class);
    private static final List<String> PARENT_NODE = Arrays.asList("calibration", "collaborationtool", "reviewobject");

    public static List<Map<String, Object>> buildReviewObjectTree(Object activityId, String collaborate) {
        if (activityId == null) {
            return new ArrayList<Map<String, Object>>(10);
        }
        boolean isCollaborator = "1".equals(collaborate);
        DynamicObject[] reviewObjectDOArr = ReviewActivityTreeUtil.getReviewObject(activityId);
        long currUserId = RequestContext.get().getCurrUserId();
        DynamicObject[] groupInfos = ReviewActivityTreeUtil.getGroupInfo(activityId, currUserId, isCollaborator);
        List groupIdList = Arrays.stream(groupInfos).map(dy -> dy.getLong("id")).collect(Collectors.toList());
        long activityIdLong = Long.parseLong(activityId.toString());
        Map<String, Object> extFilterReviewObjectIdMap = ReviewActivityTreeUtil.getExtFilterReviewObjectId(activityIdLong, currUserId, isCollaborator);
        DynamicObject[] alrJoinReviewObjDOArr = (DynamicObject[])Arrays.stream(reviewObjectDOArr).filter(dy -> groupIdList.contains(dy.getLong(PropUtils.getIdDot((String)"reviewgroup")))).filter(dy -> {
            Boolean isFilter = (Boolean)extFilterReviewObjectIdMap.get("isFilter");
            if (isFilter.booleanValue()) {
                List extFilterReviewObjectIdList = (List)extFilterReviewObjectIdMap.get("reviewObjectId");
                return extFilterReviewObjectIdList.contains(dy.getLong("id"));
            }
            return true;
        }).toArray(DynamicObject[]::new);
        ArrayList<Map<String, Object>> treeData = new ArrayList<Map<String, Object>>(10);
        HashMap<String, Object> alreadyJoinNode = new HashMap<String, Object>(16);
        alreadyJoinNode.put("id", "alreadyjoin");
        alreadyJoinNode.put("text", ReviewActivityTreeUtil.getAlreadyJoinName(alrJoinReviewObjDOArr));
        alreadyJoinNode.put("parentId", "root");
        ArrayList childrenNodeList = new ArrayList(10);
        for (DynamicObject groupInfo : groupInfos) {
            HashMap<String, Object> childTreeNode = new HashMap<String, Object>(16);
            childTreeNode.put("id", String.valueOf(groupInfo.getLong("id")));
            childTreeNode.put("text", ReviewActivityTreeUtil.getReviewGroupName(alrJoinReviewObjDOArr, groupInfo));
            childTreeNode.put("parentId", "alreadyjoin");
            childTreeNode.put("showEditBtn", true);
            childTreeNode.put("showDeleteBtn", true);
            childrenNodeList.add(childTreeNode);
        }
        alreadyJoinNode.put("children", childrenNodeList);
        alreadyJoinNode.put("showEditBtn", false);
        alreadyJoinNode.put("showDeleteBtn", false);
        treeData.add(alreadyJoinNode);
        DynamicObject reviewActivity = activityQueryService.getReviewActivity(activityId);
        if (HRObjectUtils.isEmpty((Object)reviewActivity)) {
            return treeData;
        }
        boolean showNotJoinNode = activityApplicationService.activityConfigPersonScope(reviewActivity.getString("perscopefilter_tag"));
        if (showNotJoinNode) {
            HashMap<String, Object> notJoinNode = new HashMap<String, Object>(16);
            notJoinNode.put("id", "notjoin");
            notJoinNode.put("text", ReviewActivityTreeUtil.getNotJoinName(reviewObjectDOArr));
            notJoinNode.put("parentId", "root");
            notJoinNode.put("showEditBtn", false);
            notJoinNode.put("showDeleteBtn", false);
            treeData.add(notJoinNode);
        }
        return treeData;
    }

    public static TreeNode buildReviewObjTree(Object activityId, String collaborate) {
        TreeNode rootNode = new TreeNode(null, "root", "", true);
        rootNode.setIsOpened(true);
        if (activityId == null) {
            return rootNode;
        }
        boolean isCollaborator = "1".equals(collaborate);
        DynamicObject[] reviewObjectDOArr = ReviewActivityTreeUtil.getReviewObject(activityId);
        long currUserId = RequestContext.get().getCurrUserId();
        DynamicObject[] groupInfos = ReviewActivityTreeUtil.getGroupInfo(activityId, currUserId, isCollaborator);
        List groupIdList = Arrays.stream(groupInfos).map(dy -> dy.getLong("id")).collect(Collectors.toList());
        long activityIdLong = Long.parseLong(activityId.toString());
        Map<String, Object> extFilterReviewObjectIdMap = ReviewActivityTreeUtil.getExtFilterReviewObjectId(activityIdLong, currUserId, isCollaborator);
        DynamicObject[] alrJoinReviewObjDOArr = (DynamicObject[])Arrays.stream(reviewObjectDOArr).filter(dy -> groupIdList.contains(dy.getLong(PropUtils.getIdDot((String)"reviewgroup")))).filter(dy -> {
            Boolean isFilter = (Boolean)extFilterReviewObjectIdMap.get("isFilter");
            if (isFilter.booleanValue()) {
                List extFilterReviewObjectIdList = (List)extFilterReviewObjectIdMap.get("reviewObjectId");
                return extFilterReviewObjectIdList.contains(dy.getLong("id"));
            }
            return true;
        }).toArray(DynamicObject[]::new);
        TreeNode alreadyJoinNode = new TreeNode("root", "alreadyjoin", ReviewActivityTreeUtil.getAlreadyJoinName(alrJoinReviewObjDOArr));
        alreadyJoinNode.setIsOpened(true);
        rootNode.addChild(alreadyJoinNode);
        for (DynamicObject groupInfo : groupInfos) {
            TreeNode treeNode = new TreeNode("alreadyjoin", String.valueOf(groupInfo.getLong("id")), ReviewActivityTreeUtil.getReviewGroupName(alrJoinReviewObjDOArr, groupInfo));
            alreadyJoinNode.addChild(treeNode);
        }
        DynamicObject reviewActivity = activityQueryService.getReviewActivity(activityId);
        boolean showNotJoinNode = activityApplicationService.activityConfigPersonScope(reviewActivity.getString("perscopefilter_tag"));
        if (showNotJoinNode) {
            TreeNode notJoinNode = new TreeNode("root", "notjoin", ReviewActivityTreeUtil.getNotJoinName(reviewObjectDOArr));
            rootNode.addChild(notJoinNode);
        }
        return rootNode;
    }

    public static TreeNode buildReviewObjF7Tree(Object activityId, String collaborate) {
        TreeNode rootNode = new TreeNode(null, "alreadyjoin", ReviewActivityTreeUtil.getAlreadyJoinName(new DynamicObject[0]), true);
        if (activityId == null) {
            return rootNode;
        }
        boolean isCollaborator = "1".equals(collaborate);
        DynamicObject[] reviewObjectDOArr = ReviewActivityTreeUtil.getReviewObject(activityId);
        long currUserId = RequestContext.get().getCurrUserId();
        DynamicObject[] groupInfos = ReviewActivityTreeUtil.getGroupInfo(activityId, currUserId, isCollaborator);
        List groupIdList = Arrays.stream(groupInfos).map(dy -> dy.getLong("id")).collect(Collectors.toList());
        long activityIdLong = Long.parseLong(activityId.toString());
        Map<String, Object> extFilterReviewObjectIdMap = ReviewActivityTreeUtil.getExtFilterReviewObjectId(activityIdLong, currUserId, isCollaborator);
        DynamicObject[] alrJoinReviewObjDOArr = (DynamicObject[])Arrays.stream(reviewObjectDOArr).filter(dy -> groupIdList.contains(dy.getLong(PropUtils.getIdDot((String)"reviewgroup")))).filter(dy -> {
            Boolean isFilter = (Boolean)extFilterReviewObjectIdMap.get("isFilter");
            if (isFilter.booleanValue()) {
                List extFilterReviewObjectIdList = (List)extFilterReviewObjectIdMap.get("reviewObjectId");
                return extFilterReviewObjectIdList.contains(dy.getLong("id"));
            }
            return true;
        }).toArray(DynamicObject[]::new);
        rootNode = new TreeNode(null, "alreadyjoin", ReviewActivityTreeUtil.getAlreadyJoinName(alrJoinReviewObjDOArr), true);
        rootNode.setIsOpened(true);
        for (DynamicObject groupInfo : groupInfos) {
            TreeNode treeNode = new TreeNode("alreadyjoin", String.valueOf(groupInfo.getLong("id")), ReviewActivityTreeUtil.getReviewGroupName(alrJoinReviewObjDOArr, groupInfo));
            rootNode.addChild(treeNode);
        }
        return rootNode;
    }

    private static Map<String, Object> getExtFilterReviewObjectId(long activity, long userId, boolean isCollaborator) {
        ArrayList reviewObjectIdList = new ArrayList(10);
        HashMap<String, Boolean> isFilterMap = new HashMap<String, Boolean>(1);
        isFilterMap.put("isFilter", false);
        HRPluginProxy pluginProxy = HRPlugInProxyFactory.create(null, IReviewObjectTreeListExtendService.class, (String)"kd.sdk.tdc.oatr.reviewobject.IReviewObjectTreeListExtendService", null);
        pluginProxy.callReplaceIfPresent(plugin -> {
            boolean isNeedFilter;
            if (plugin != null && (isNeedFilter = plugin.enableTreeListNumberFilter(activity, userId, isCollaborator))) {
                List reviewObjIds = plugin.getTreeListNumberFilterReviewObjectId(activity, userId, isCollaborator);
                if (HRCollUtil.isNotEmpty((Collection)reviewObjIds)) {
                    reviewObjectIdList.addAll(reviewObjIds);
                }
                isFilterMap.put("isFilter", true);
            }
            return null;
        });
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        result.put("isFilter", isFilterMap.get("isFilter"));
        result.put("reviewObjectId", reviewObjectIdList);
        return result;
    }

    private static DynamicObject[] getReviewObject(Object activityId) {
        return activityQueryService.getReviewObjectWithPerm(activityId);
    }

    public static DynamicObject[] getGroupInfo(Object activityId, long currUserId, boolean isCollaborator) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("oatr_reviewgroup");
        QFilter activityQF = new QFilter("reviewactivity", "=", activityId);
        QFilter userQF = null;
        if (isCollaborator) {
            userQF = new QFilter("entryentity.collaborator", "=", (Object)currUserId);
            userQF.and(new QFilter("entryentity.colstatus", "=", (Object)"1"));
        }
        QFilter dataRuleFilter = PermissionServiceHelper.getDataRule((long)RequestContext.get().getCurrUserId(), (String)"32J2T2KEXE6T", (String)"oatr_reviewgroup", (String)"47150e89000000ac");
        return serviceHelper.queryOriginalArray("number,name,id,sortnum", new QFilter[]{activityQF, userQF, dataRuleFilter}, "sortnum desc,number asc");
    }

    private static DynamicObject[] getGroupInfo(Object activityId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("oatr_reviewgroup");
        QFilter activityQF = new QFilter("reviewactivity", "=", activityId);
        return serviceHelper.queryOriginalArray("number,name,id,sortnum", activityQF.toArray(), "sortnum desc,number asc");
    }

    public static DynamicObject getGroupInfo(String groupId, Object activityId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("oatr_reviewgroup");
        QFilter activityQF = new QFilter("reviewactivity", "=", activityId);
        QFilter numberQF = new QFilter("id", "=", (Object)Long.valueOf(groupId));
        return serviceHelper.queryOriginalOne("number,name,id,sortnum", new QFilter[]{activityQF, numberQF});
    }

    public static FlexPanelAp buildNavigation(FormShowParameter showParameter, Object activityId, boolean isCollaborator) {
        FlexPanelAp nodeFlexPanelAp = new HRFlexPanelAp.Builder("nodeflexpanelap").setWrap(true).setDirection("column").build();
        ArrayList flexList = Lists.newArrayList();
        ArrayList buttonList = Lists.newArrayList();
        ReviewActivityTreeUtil.buildChildrenNodeAp(activityId, isCollaborator, nodeFlexPanelAp, flexList, buttonList);
        showParameter.setCustomParam("flexList", (Object)flexList);
        showParameter.setCustomParam("buttonList", (Object)buttonList);
        return nodeFlexPanelAp;
    }

    public static void updateChildrenNode(IFormView formView, Object activityId, boolean isCollaborator) {
        DynamicObject[] reviewGroupDOArr = ReviewActivityTreeUtil.getGroupInfo(activityId, RequestContext.get().getCurrUserId(), isCollaborator);
        List groupIdList = Arrays.stream(reviewGroupDOArr).map(dy -> dy.getLong("id")).collect(Collectors.toList());
        DynamicObject[] reviewObjectDOArr = ReviewActivityTreeUtil.getReviewObject(activityId);
        DynamicObject[] alrJoinReviewObjDOArr = (DynamicObject[])Arrays.stream(reviewObjectDOArr).filter(dy -> groupIdList.contains(dy.getLong(PropUtils.getIdDot((String)"reviewgroup")))).toArray(DynamicObject[]::new);
        HashMap map = Maps.newHashMapWithExpectedSize((int)1);
        LocaleString localeString = new LocaleString(ReviewActivityTreeUtil.getAlreadyJoinName(alrJoinReviewObjDOArr));
        map.put("text", localeString);
        formView.updateControlMetadata("alreadyjoin", (Map)map);
        for (DynamicObject groupInfo : reviewGroupDOArr) {
            String id = groupInfo.getString("id");
            map = Maps.newHashMapWithExpectedSize((int)1);
            localeString = new LocaleString(ReviewActivityTreeUtil.getReviewGroupName(alrJoinReviewObjDOArr, groupInfo));
            map.put("text", localeString);
            formView.updateControlMetadata(id, (Map)map);
        }
        map = Maps.newHashMapWithExpectedSize((int)1);
        localeString = new LocaleString(ReviewActivityTreeUtil.getNotJoinName(reviewObjectDOArr));
        map.put("text", localeString);
        formView.updateControlMetadata("notjoin", (Map)map);
    }

    private static void buildNodeFlexAp(FlexPanelAp nodeFlexPanelAp, String nodeNumber, String nodeName, int nodeLevel) {
        FlexPanelAp flexAp = new HRFlexPanelAp.Builder(nodeNumber + "_flex").setWrap(true).setDirection("column").setAlignItems("stretch").setHeight("40px").build();
        ButtonAp buttonAp = ((HRButtonAp.Builder)((HRButtonAp.Builder)((HRButtonAp.Builder)((HRButtonAp.Builder)((HRButtonAp.Builder)((HRButtonAp.Builder)new HRButtonAp.Builder(nodeNumber).setName(nodeName).setGrow(1).setMarginBottom("0px")).setMarginTop("0px")).setMarginLeft("0px")).setMarginRight("0px")).setWidth("100%").setPaddingLeft(20 * nodeLevel + "px")).setPaddingRight("20px")).build();
        buttonAp.setButtonStyle(1);
        buttonAp.setCustomeStyles("eyJ0eXBlIjowLCJjb250ZW50IjoiwqAvKiogXG4qIOagt+S+i1xuKiDmlK/mjIHljp/nlJ9jc3PmoLflvI/lhpnms5Vcbiog5b2T5YmN5YWD57Sg55qEY2xhc3NOYW1l5L2/55SoIFwiJFwiIOS7o+abv++8jOS4jeaUr+aMgeiHquWumuS5ieWFg+e0oGNsYXNzTmFtZVxuKiDnm67liY3mj5DkvpvkuInkuKrmoLfmnb/vvIzmiZPlvIDms6jph4rljbPlj6/kvb/nlKhcbiog5rOo6YeK5YaF5a655Lya6KKr6L+H5ruk5LiN5bGV56S6XG4qIOWmgumcgOS9v+eUqOW5s+WPsOS4u+mimOiJsu+8jOWPr+S7peS9v+eUqCd0aGVtZUNvbG9yJ+adpeS7o+aMh1xuICovXG4vKipcbiog5b2T5YmN5YWD57Sg6IOM5pmv6aKc6Imy6Lef6ZqP5Li76aKY6ImyXG4qL1xuLyoqXG4kIHtcbsKgwqBiYWNrZ3JvdW5kOid0aGVtZUNvbG9yJztcbsKgfVxuKi9cbsKgLyoqXG4qIOS/ruaUueW9k+WJjeWFg+e0oOiDjOaZr+minOiJslxuKi9cbi8qKlxuJCB7XG7CoMKgYmFja2dyb3VuZDpyZWQ7XG7CoH1cbiovXG7CoC8qKlxuKiDkv67mlLnlvZPliY3lhYPntKBob3ZlcuaViOaenFxuwqAgKi9cbi8qKlxuJDpob3ZlciB7XG7CoMKgYmFja2dyb3VuZDpyZWQ7XG7CoH1cbiovXG4vKipcbiAqIOS/ruaUueW9k+WJjeWFg+e0oOS4umRpduagh+etvuWtkOWFg+e0oFxuKi9cbi8qKlxuJCA+IGRpdiB7XG7CoGJhY2tncm91bmQ6cmVkO1xuwqB9XG4gKi9cbi8qKlxuICog6K6+572u5oyJ6ZKu5paH5pys6Z2g5bemXG4qL1xuJHtcbiBqdXN0aWZ5LWNvbnRlbnQ6IGZsZXgtc3RhcnQhaW1wb3J0YW50O1xufVxuIn0=");
        flexAp.getItems().add(buttonAp);
        nodeFlexPanelAp.getItems().add(flexAp);
    }

    private static void buildChildrenNodeAp(Object activityId, boolean isCollaborator, FlexPanelAp nodeFlexPanelAp, List<String> flexList, List<String> buttonList) {
        DynamicObject[] reviewGroupDOArr = ReviewActivityTreeUtil.getGroupInfo(activityId, RequestContext.get().getCurrUserId(), isCollaborator);
        List groupIdList = Arrays.stream(reviewGroupDOArr).map(dy -> dy.getLong("id")).collect(Collectors.toList());
        DynamicObject[] reviewObjectDOArr = ReviewActivityTreeUtil.getReviewObject(activityId);
        DynamicObject[] alrJoinReviewObjDOArr = (DynamicObject[])Arrays.stream(reviewObjectDOArr).filter(dy -> groupIdList.contains(dy.getLong(PropUtils.getIdDot((String)"reviewgroup")))).toArray(DynamicObject[]::new);
        flexList.add("alreadyjoin_flex");
        buttonList.add("alreadyjoin");
        ReviewActivityTreeUtil.buildNodeFlexAp(nodeFlexPanelAp, "alreadyjoin", ReviewActivityTreeUtil.getAlreadyJoinName(alrJoinReviewObjDOArr), 2);
        for (DynamicObject groupInfo : reviewGroupDOArr) {
            String id = groupInfo.getString("id");
            flexList.add(id + "_flex");
            buttonList.add(id);
            ReviewActivityTreeUtil.buildNodeFlexAp(nodeFlexPanelAp, id, ReviewActivityTreeUtil.getReviewGroupName(alrJoinReviewObjDOArr, groupInfo), 3);
        }
        DynamicObject reviewActivity = activityQueryService.getReviewActivity(activityId);
        boolean showNotJoinNode = activityApplicationService.activityConfigPersonScope(reviewActivity.getString("perscopefilter_tag"));
        if (showNotJoinNode) {
            flexList.add("notjoin_flex");
            buttonList.add("notjoin");
            ReviewActivityTreeUtil.buildNodeFlexAp(nodeFlexPanelAp, "notjoin", ReviewActivityTreeUtil.getNotJoinName(reviewObjectDOArr), 2);
        }
    }

    public static void setNavigationStyle(String openKey, IFormView view) {
        List childrenButton = (List)view.getFormShowParameter().getCustomParam("buttonList");
        if (StringUtils.equals((CharSequence)openKey, (CharSequence)"calibration") || StringUtils.equals((CharSequence)openKey, (CharSequence)"collaborationtool")) {
            ReviewActivityTreeUtil.setFocusNodeStyle(openKey, view, false);
            for (String node : PARENT_NODE) {
                if (StringUtils.equals((CharSequence)openKey, (CharSequence)node)) continue;
                ReviewActivityTreeUtil.setNotFocusNodeStyle(node, view);
            }
            for (String node : childrenButton) {
                ReviewActivityTreeUtil.setNotFocusNodeStyle(node, view);
            }
            view.setVisible(Boolean.FALSE, new String[]{"nodeflexpanelap"});
        } else {
            ReviewActivityTreeUtil.setFocusNodeStyle("reviewobject", view, false);
            for (String node : PARENT_NODE) {
                if (StringUtils.equals((CharSequence)"reviewobject", (CharSequence)node)) continue;
                ReviewActivityTreeUtil.setNotFocusNodeStyle(node, view);
            }
            view.setVisible(Boolean.TRUE, new String[]{"nodeflexpanelap"});
            if (StringUtils.equals((CharSequence)openKey, (CharSequence)"reviewobject")) {
                openKey = "alreadyjoin";
            }
            for (String node : childrenButton) {
                if (StringUtils.equals((CharSequence)openKey, (CharSequence)node)) {
                    ReviewActivityTreeUtil.setFocusNodeStyle(node, view, true);
                    continue;
                }
                ReviewActivityTreeUtil.setNotFocusNodeStyle(node, view);
            }
        }
    }

    private static void setFocusNodeStyle(String openKey, IFormView view, boolean isChildNode) {
        HashMap propertyMap = Maps.newHashMapWithExpectedSize((int)3);
        HashMap border = Maps.newHashMapWithExpectedSize((int)4);
        border.put("t", "0px");
        border.put("b", "0px");
        if (isChildNode) {
            border.put("l", "0px");
        } else {
            border.put("l", "2px_solid_themeColor");
        }
        border.put("r", "0px");
        HashMap styleMap = Maps.newHashMapWithExpectedSize((int)1);
        styleMap.put("b", border);
        propertyMap.put("s", styleMap);
        if (!StringUtils.equals((CharSequence)openKey, (CharSequence)"reviewobject")) {
            propertyMap.put("bc", "#ffffff");
        } else {
            propertyMap.put("bc", "#F5F7F9");
        }
        view.updateControlMetadata(openKey + "_flex", (Map)propertyMap);
        propertyMap = Maps.newHashMapWithExpectedSize((int)1);
        propertyMap.put("fc", "themeColor");
        view.updateControlMetadata(openKey, (Map)propertyMap);
    }

    private static void setNotFocusNodeStyle(String node, IFormView view) {
        HashMap propertyMap = Maps.newHashMapWithExpectedSize((int)3);
        HashMap border = Maps.newHashMapWithExpectedSize((int)4);
        border.put("t", "0px");
        border.put("b", "0px");
        border.put("l", "0px");
        border.put("r", "0px");
        HashMap styleMap = Maps.newHashMapWithExpectedSize((int)1);
        styleMap.put("b", border);
        propertyMap.put("s", styleMap);
        propertyMap.put("fc", "#333333");
        propertyMap.put("bc", "#F5F7F9");
        view.updateControlMetadata(node + "_flex", (Map)propertyMap);
        propertyMap = Maps.newHashMapWithExpectedSize((int)1);
        propertyMap.put("fc", "#333333");
        view.updateControlMetadata(node, (Map)propertyMap);
    }

    private static String getNotJoinName(DynamicObject[] reviewObjectDOArr) {
        return String.join((CharSequence)"", ResManager.loadKDString((String)"\u672a\u52a0\u5165\u76d8\u70b9\u5bf9\u8c61", (String)"ReviewObjectNavigationPlugin_4", (String)"tdc-oatr-formplugin", (Object[])new Object[0]), "(", Arrays.stream(reviewObjectDOArr).filter(dy -> Objects.isNull(dy.get("reviewgroup"))).count() + "", ")");
    }

    private static String getReviewGroupName(DynamicObject[] reviewObjectDOArr, DynamicObject groupInfo) {
        return String.join((CharSequence)"", groupInfo.getString("name"), "(" + Arrays.stream(reviewObjectDOArr).filter(dy -> Arrays.asList(ObjectStatusEnum.WAIT_START.getCode(), ObjectStatusEnum.GOING_UNCHECK.getCode(), ObjectStatusEnum.GOING_CHECK.getCode(), ObjectStatusEnum.END.getCode()).contains(dy.getString("reviewstatus"))).filter(dy -> dy.getLong(PropUtils.getIdDot((String)"reviewgroup")) == groupInfo.getLong("id")).count() + "", ")");
    }

    private static String getAlreadyJoinName(DynamicObject[] alrJoinReviewObjDOArr) {
        return String.join((CharSequence)"", ResManager.loadKDString((String)"\u5df2\u52a0\u5165\u76d8\u70b9\u5bf9\u8c61", (String)"ReviewObjectNavigationPlugin_5", (String)"tdc-oatr-formplugin", (Object[])new Object[0]), "(", Arrays.stream(alrJoinReviewObjDOArr).filter(dy -> Objects.nonNull(dy.get("reviewgroup"))).filter(dy -> Arrays.asList(ObjectStatusEnum.WAIT_START.getCode(), ObjectStatusEnum.GOING_UNCHECK.getCode(), ObjectStatusEnum.GOING_CHECK.getCode(), ObjectStatusEnum.END.getCode()).contains(dy.getString("reviewstatus"))).count() + "", ")");
    }
}

