/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.formplugin.web.configure;

import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDyObjectPropUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.tdc.oatr.bussiness.ServiceFactory;
import kd.tdc.oatr.bussiness.queryservice.EvaluationItemQueryService;

public class ReviewToolSchemeEdit
extends HRDataBaseEdit {
    private final EvaluationItemQueryService evaluationItemQueryService = (EvaluationItemQueryService)ServiceFactory.getService(EvaluationItemQueryService.class);

    public void afterLoadData(EventObject evt) {
        super.afterLoadData(evt);
        this.initCapacityItem();
    }

    private void initCapacityItem() {
        int entryRowCount = this.getModel().getEntryRowCount("entryentity");
        this.getModel().beginInit();
        for (int i = 0; i < entryRowCount; ++i) {
            DynamicObject evaluationItem = (DynamicObject)this.getModel().getValue("evaluationitem", i);
            long capacityItemId = evaluationItem.getLong("capacityitem.id");
            this.getModel().setValue("capacityitem", (Object)capacityItemId, i);
        }
        this.getModel().endInit();
        this.getView().updateView("entryentity");
        this.getModel().setDataChanged(false);
    }

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        String isOnlyView = (String)this.getView().getFormShowParameter().getCustomParam("isOnlyView");
        if (HRStringUtils.equals((String)isOnlyView, (String)"1")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_modify", "bar_disable", "bar_submit", "bar_audit"});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String key = source.getOperateKey();
        if (HRStringUtils.equals((String)key, (String)"addrow")) {
            args.setCancel(true);
            DynamicObject createOrg = (DynamicObject)this.getModel().getValue("createorg");
            long orgId = HRDyObjectPropUtil.getId((DynamicObject)createOrg);
            ListShowParameter showListForm = ShowFormHelper.createShowListForm((String)"oatr_evaluationitem", (boolean)true);
            showListForm.setUseOrgId(orgId);
            List<Long> itemIds = this.getExistItemIds();
            if (!CollectionUtils.isEmpty(itemIds)) {
                showListForm.setSelectedRows(itemIds.toArray());
            }
            showListForm.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "action_addEvaluationItem"));
            this.getView().showForm((FormShowParameter)showListForm);
        }
    }

    private List<Long> getExistItemIds() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        return entryEntity.stream().map(entity -> entity.getLong("evaluationitem.id")).collect(Collectors.toList());
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if (HRStringUtils.equals((String)actionId, (String)"action_addEvaluationItem") && evt.getReturnData() != null) {
            ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)evt.getReturnData();
            List returnItemIds = selectedRows.stream().map(selectedRow -> Long.valueOf(selectedRow.getPrimaryKeyValue().toString())).collect(Collectors.toList());
            List<Long> existItemIds = this.getExistItemIds();
            returnItemIds.removeAll(existItemIds);
            if (returnItemIds.isEmpty()) {
                return;
            }
            DynamicObject[] evaluationItemObjs = this.evaluationItemQueryService.queryEvaluationItem(returnItemIds);
            Map<Long, Long> capacityItemIdMap = Arrays.stream(evaluationItemObjs).collect(Collectors.toMap(evaluationItem -> evaluationItem.getLong("id"), evaluationItem -> evaluationItem.getLong("capacityitem.id"), (v1, v2) -> v2));
            this.getModel().beginInit();
            int[] newEntryRow = this.getModel().batchCreateNewEntryRow("entryentity", returnItemIds.size());
            for (int i = 0; i < newEntryRow.length; ++i) {
                int row = newEntryRow[i];
                Long itemId = (Long)returnItemIds.get(i);
                this.getModel().setValue("evaluationitem", (Object)itemId, row);
                this.getModel().setValue("capacityitem", (Object)capacityItemIdMap.get(itemId), row);
            }
            this.getModel().endInit();
            this.getView().updateView("entryentity");
        }
    }
}

