/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.formplugin.web.configure.gridtemplate;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.tdc.oatr.common.bo.gridtemplate.GridBlockInfo;
import kd.tdc.oatr.common.bo.gridtemplate.GridConfigInfo;
import kd.tdc.oatr.common.bo.gridtemplate.GridTextInfo;
import kd.tdc.tdcs.bussiness.ServiceFactory;
import kd.tdc.tdcs.bussiness.formservice.FormCommonService;

public class GridTemplateEdit
extends HRDataBaseEdit {
    private static final String CONTROL_GRIDCONFIGCTL = "gridconfigctl";
    private static final String CUSTOM_EVENT_LOAD_DATA = "loadData";
    private static final String CUSTOM_EVENT_STATUS_INIT = "init";
    private static final String CUSTOM_EVENT_SUBMIT_DATA = "submitGridTemplateData";
    private static final String CUSTOM_EVENT_STATUS_UPDATE = "update";
    private static final String OP_OPTION_IS_CONFIRM_SAVE = "isConfirmSave";
    private static final String CACHE_CURRENT_OP_KEY = "currentOpKey";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initGridData();
        this.getModel().setDataChanged(false);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        this.saveAndSubmitOpBefore(args);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (operationResult != null && operationResult.isSuccess()) {
            String operateKey = afterDoOperationEventArgs.getOperateKey();
            if (HRStringUtils.equals((String)operateKey, (String)"save")) {
                return;
            }
            this.getView().invokeOperation("refresh");
        }
    }

    public void beforeClosed(BeforeClosedEvent event) {
        super.beforeClosed(event);
        FormCommonService commonService = (FormCommonService)ServiceFactory.getService(FormCommonService.class);
        commonService.setPropertyNotDataChanged(this.getModel(), new String[]{"updatetime"});
    }

    private void saveAndSubmitOpBefore(BeforeDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        OperateOption option = operate.getOption();
        String isConfirmSave = option.getVariableValue(OP_OPTION_IS_CONFIRM_SAVE, "0");
        ArrayList opKeyList = Lists.newArrayList();
        opKeyList.add("save");
        opKeyList.add("submit");
        if (opKeyList.contains(operateKey) && HRStringUtils.equals((String)isConfirmSave, (String)"0")) {
            args.setCancel(true);
            this.getPageCache().put(CACHE_CURRENT_OP_KEY, operateKey);
            CustomControl gridControl = (CustomControl)this.getControl(CONTROL_GRIDCONFIGCTL);
            Map<String, Object> mapData = this.getCustomEventParams(CUSTOM_EVENT_SUBMIT_DATA, CUSTOM_EVENT_STATUS_UPDATE);
            gridControl.setData(mapData);
            this.getModel().setValue("updatetime", (Object)new Date());
        }
    }

    public void customEvent(CustomEventArgs eventArgs) {
        super.customEvent(eventArgs);
        String eventName = eventArgs.getEventName();
        if (eventName.equals(CUSTOM_EVENT_SUBMIT_DATA)) {
            String opKey = this.getPageCache().get(CACHE_CURRENT_OP_KEY);
            if (HRStringUtils.isEmpty((String)opKey)) {
                return;
            }
            this.getPageCache().remove(CACHE_CURRENT_OP_KEY);
            String data = eventArgs.getEventArgs();
            this.getModel().setValue("gridconfig_tag", (Object)data);
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue(OP_OPTION_IS_CONFIRM_SAVE, "1");
            this.getView().invokeOperation(opKey, operateOption);
        }
    }

    private void initGridData() {
        CustomControl gridControl = (CustomControl)this.getView().getControl(CONTROL_GRIDCONFIGCTL);
        Map<String, Object> mapData = this.getCustomEventParams(CUSTOM_EVENT_LOAD_DATA, CUSTOM_EVENT_STATUS_INIT);
        String gridConfig = (String)this.getModel().getValue("gridconfig_tag");
        if (!HRStringUtils.isEmpty((String)gridConfig)) {
            GridConfigInfo gridConfigInfo = (GridConfigInfo)SerializationUtils.fromJsonString((String)gridConfig, GridConfigInfo.class);
            mapData.put("data", gridConfigInfo);
        } else {
            this.buildNewGridData(mapData);
        }
        gridControl.setData(mapData);
    }

    private void buildNewGridData(Map<String, Object> mapData) {
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (!status.equals((Object)OperationStatus.ADDNEW)) {
            return;
        }
        int xAS = 3;
        int yAS = 3;
        GridConfigInfo configInfo = new GridConfigInfo();
        configInfo.setColorScheme("#276FF5");
        configInfo.setxAxisScales(xAS);
        configInfo.setyAxisScales(yAS);
        ArrayList gridBlockList = Lists.newArrayList();
        int num = 0;
        for (int i = 0; i < xAS; ++i) {
            for (int j = 0; j < yAS; ++j) {
                GridBlockInfo blockInfo = new GridBlockInfo();
                blockInfo.setNumber(String.valueOf(++num));
                GridTextInfo nameInfo = new GridTextInfo();
                String defaultName = ResManager.loadKDString((String)"{0}\u53f7\u683c\u5b50", (String)"GridTemplateEdit_0", (String)"tdc-oatr-formplugin", (Object[])new Object[]{num});
                nameInfo.setText(defaultName);
                nameInfo.setFontColor("#212121");
                blockInfo.setName(nameInfo);
                GridTextInfo descInfo = new GridTextInfo();
                descInfo.setText("");
                descInfo.setFontColor("#999999");
                blockInfo.setDesc(descInfo);
                BigDecimal diaValue = BigDecimal.valueOf(0.1).add(BigDecimal.valueOf(0.02).multiply(BigDecimal.valueOf(num - 1)));
                blockInfo.setBackColor("rgba(39,111,245, " + diaValue.doubleValue() + ")");
                gridBlockList.add(blockInfo);
            }
        }
        configInfo.setGridBlocks((List)gridBlockList);
        mapData.put("data", configInfo);
        this.getModel().setValue("gridnum", (Object)num);
    }

    private Map<String, Object> getCustomEventParams(String eventName, String eventStatus) {
        HashMap mapData = Maps.newHashMap();
        mapData.put("code", 200);
        mapData.put("success", true);
        mapData.put("eventName", eventName);
        mapData.put("eventStatus", eventStatus);
        mapData.put("times", System.currentTimeMillis());
        mapData.put("pageStatus", "edit");
        if (!this.isEditable()) {
            mapData.put("pageStatus", "view");
        }
        return mapData;
    }

    private boolean isEditable() {
        CustomControl gridControl = (CustomControl)this.getView().getControl(CONTROL_GRIDCONFIGCTL);
        String lock = gridControl.getLock();
        int statusValue = this.getBillStatusValue();
        return !this.isLock(statusValue, lock);
    }

    private int getBillStatusValue() {
        BaseShowParameter formShowParameter = (BaseShowParameter)this.getView().getFormShowParameter();
        return formShowParameter.getBillStatus().getValue();
    }

    boolean isLock(int status, String lock) {
        if (HRStringUtils.isEmpty((String)lock)) {
            return false;
        }
        return BillOperationStatus.ADDNEW.getValue() == status && lock.contains("new") || BillOperationStatus.EDIT.getValue() == status && lock.contains("edit") || BillOperationStatus.VIEW.getValue() == status && lock.contains("view") || BillOperationStatus.SUBMIT.getValue() == status && lock.contains("submit") || BillOperationStatus.AUDIT.getValue() == status && lock.contains("audit");
    }
}

