/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.formplugin.web.formservice;

import com.google.common.collect.Lists;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.param.AppParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.hr.hbp.common.util.HRDyObjectPropUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tdc.oatr.bussiness.ServiceFactory;
import kd.tdc.oatr.bussiness.queryservice.ReviewActivityQueryService;
import kd.tdc.oatr.common.constants.enums.ActivityStatusEnum;
import kd.tdc.oatr.common.utils.PermItemName;
import kd.tdc.oatr.common.utils.ReviewPermUtils;
import kd.tdc.oatr.formplugin.web.common.ManagerItemUtil;

public class ReviewActivityFormService {
    private static final Log LOGGER = LogFactory.getLog(ReviewActivityFormService.class);
    private final ReviewActivityQueryService activityQueryService = (ReviewActivityQueryService)ServiceFactory.getService(ReviewActivityQueryService.class);
    public static final List<String> opColumnList = Lists.newArrayList((Object[])new String[]{"openreviewgroup", "openreviewprocess", "opencalibratesession"});

    public void checkPermAndShowView(String opKey, Object activityId, String entityId, AbstractFormPlugin formPlugin) {
        IFormView view = formPlugin.getView();
        if (!opColumnList.contains(opKey)) {
            return;
        }
        String billFormId = "";
        String checkPermFormId = "";
        String caption = "";
        switch (opKey) {
            case "openreviewgroup": {
                boolean isColPage = "oatr_colreviewactivity".equals(entityId);
                checkPermFormId = isColPage ? "oatr_colreviewgroup" : "oatr_reviewgroup";
                billFormId = "oatr_reviewobject";
                caption = ResManager.loadKDString((String)"%s-\u76d8\u70b9\u5bf9\u8c61\u53ca\u5206\u7ec4", (String)"ReviewActivityFormService_0", (String)"tdc-oatr-formplugin", (Object[])new Object[0]);
                break;
            }
            case "openreviewprocess": {
                checkPermFormId = "oatr_reviewobject";
                billFormId = "oatr_reviewobject";
                caption = ResManager.loadKDString((String)"%s-\u76d8\u70b9\u8fc7\u7a0b", (String)"ReviewActivityFormService_1", (String)"tdc-oatr-formplugin", (Object[])new Object[0]);
                break;
            }
            case "opencalibratesession": {
                checkPermFormId = "oatr_calibratesession";
                billFormId = "oatr_calibratesession";
                caption = ResManager.loadKDString((String)"%s-\u6821\u51c6\u4f1a", (String)"ReviewActivityFormService_2", (String)"tdc-oatr-formplugin", (Object[])new Object[0]);
                break;
            }
        }
        ReviewPermUtils permUtils = ReviewPermUtils.getInstance();
        boolean hasQueryPerm = permUtils.hasPerm(checkPermFormId);
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)checkPermFormId);
        if (!hasQueryPerm) {
            String noPermTip = permUtils.getNoPermTip(dataEntityType.getDisplayName().toString(), PermItemName.QUERY.getName());
            view.showErrorNotification(noPermTip);
            return;
        }
        boolean isColPage = "oatr_colreviewactivity".equals(entityId);
        if (!this.checkCollaboratorPerm(activityId, isColPage, view)) {
            return;
        }
        ListShowParameter showParameter = new ListShowParameter();
        String pageType = "oatr_reviewactivity";
        if (isColPage) {
            pageType = "oatr_colreviewactivity";
        }
        String paramKey = pageType + opKey + activityId;
        String openedPageId = (String)view.getFormShowParameter().getCustomParam(paramKey);
        IFormView appHomeView = this.getAppHomeView(view);
        if (HRStringUtils.isEmpty((String)openedPageId) && appHomeView != null) {
            openedPageId = (String)appHomeView.getFormShowParameter().getCustomParam(paramKey);
        }
        if (!HRStringUtils.isEmpty((String)openedPageId)) {
            showParameter.setPageId(openedPageId);
        } else {
            view.getFormShowParameter().setCustomParam(paramKey, (Object)showParameter.getPageId());
            view.cacheFormShowParameter();
            if (appHomeView != null) {
                appHomeView.getFormShowParameter().setCustomParam(paramKey, (Object)showParameter.getPageId());
                appHomeView.cacheFormShowParameter();
            }
        }
        DynamicObject activity = this.activityQueryService.getReviewActivity(activityId);
        if (activity == null) {
            return;
        }
        showParameter.setCaption(String.format(caption, HRDyObjectPropUtil.getName((DynamicObject)activity)));
        if (HRStringUtils.equals((String)"oatr_reviewgroup", (String)checkPermFormId) || HRStringUtils.equals((String)"oatr_colreviewgroup", (String)checkPermFormId)) {
            showParameter.setFormId("oatr_reviewobjecttreelist");
        } else if (HRStringUtils.equals((String)"oatr_reviewobject", (String)checkPermFormId)) {
            showParameter.setFormId("bos_templatetreelist");
        } else {
            showParameter.setFormId("bos_list");
        }
        showParameter.setBillFormId(billFormId);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCustomParam("activityId", activityId);
        showParameter.setCustomParam("collaboration_flag", (Object)(isColPage ? "1" : "0"));
        showParameter.setCustomParam("openKey", (Object)checkPermFormId);
        showParameter.setCustomParam("createorg", (Object)activity.getLong("createorg.id"));
        showParameter.setHasRight(true);
        view.showForm((FormShowParameter)showParameter);
    }

    private IFormView getAppHomeView(IFormView view) {
        IFormView parentView = view.getParentView();
        for (int i = 5; i > 0 && parentView != null && !parentView.getFormShowParameter().getFormId().contains("apphome"); parentView = parentView.getParentView(), --i) {
        }
        if (parentView != null && parentView.getFormShowParameter().getFormId().contains("apphome")) {
            return parentView;
        }
        return null;
    }

    public void setOpColVisible(DynamicObject rowData, List<OperationColItem> operationColItems) {
        for (OperationColItem operationColItem : operationColItems) {
            String operationKey;
            String activityStatus = rowData.getString("activitystatus");
            if (!HRStringUtils.equals((String)ActivityStatusEnum.WAIT_START.getCode(), (String)activityStatus) || !"opencalibratesession".equalsIgnoreCase(operationKey = operationColItem.getOperationKey()) && !"openreviewprocess".equalsIgnoreCase(operationKey)) continue;
            operationColItem.setVisible(false);
        }
    }

    public boolean isHideBtnByPagePerm(String operationKey) {
        boolean noPermHideBtn = false;
        switch (operationKey) {
            case "openreviewgroup": {
                noPermHideBtn = this.isNoPermHideBtn("oatr_reviewgroup");
                break;
            }
            case "openreviewprocess": {
                noPermHideBtn = this.isNoPermHideBtn("oatr_reviewobject");
                break;
            }
            case "opencalibratesession": {
                noPermHideBtn = this.isNoPermHideBtn("oatr_calibratesession");
                break;
            }
        }
        LOGGER.info("ReviewActivityFormService#operationKey:{}, noPermHideBtn:{}", (Object)operationKey, (Object)noPermHideBtn);
        return noPermHideBtn;
    }

    public boolean isNoPermHideBtn(String pageKey) {
        boolean hasQueryPerm = ReviewPermUtils.getInstance().hasPerm(pageKey);
        LOGGER.info("ReviewActivityFormService#pageKey:{}, hasQueryPerm:{}", (Object)pageKey, (Object)hasQueryPerm);
        String appId = AppMetadataCache.getAppInfo((String)"base").getId();
        AppParam appParam = new AppParam(appId, "15", Long.valueOf(OrgUnitServiceHelper.getRootOrgId()), Long.valueOf(0L));
        Boolean paramNoPermBtnHide = (Boolean)SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam, (String)"enable_nopermbtnhide");
        LOGGER.info("ReviewActivityFormService#paramNoPermBtnHide:{}", (Object)paramNoPermBtnHide);
        return !hasQueryPerm && paramNoPermBtnHide != null && paramNoPermBtnHide != false;
    }

    private boolean checkCollaboratorPerm(Object activityId, boolean isColPage, IFormView view) {
        if (!isColPage) {
            return true;
        }
        if (!ManagerItemUtil.checkPermByManagerItem(null, activityId)) {
            view.showConfirm(ResManager.loadKDString((String)"\u4f60\u7684\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u5237\u65b0\u6216\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"ReviewActivityDetailCommon_0", (String)"tdc-oatr-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK);
            return false;
        }
        return true;
    }
}

