/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.formplugin.web.reviewplan;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.model.AuthorizedOrgResult;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.tdc.oatr.bussiness.ServiceFactory;
import kd.tdc.oatr.bussiness.application.ext.PermissionExternalService;
import kd.tdc.oatr.formplugin.web.activity.ReviewActivityBillList;
import org.apache.commons.lang3.StringUtils;

public class ReviewPlanEdit
extends HRDataBaseEdit
implements ReviewActivityBillList,
BeforeF7SelectListener,
AfterF7SelectListener {
    public static final String KEY_EVENT_NEW = "keyeventnew";
    public static final String KEY_EVENT_EDIT = "keyeventedit";
    public static final String KEY_EVENT_DELETE = "keyeventdelete";
    public static final String TIME_LINES_LABEL_AP = "timelineslabelap";
    public static final String CARD_ENTRY_FLEX_PANEL_AP_DESC = "cardentryflexpanelapdesc";
    public static final String KEY_EVENT_ENTRY_NEW = "keyevententrynew";
    public static final String KEY_EVENT_ENTRY_EDIT = "keyevententryedit";
    public static final String KEY_EVENT_ENTRY_DEL = "keyevententrydel";
    public static final String KEY_NEW_ORG_ENTRY = "neworgentry";
    public static final String PDHD_FLEX = "pdhd_flex";
    public static final String GJSJ_FLEX = "gjsj_flex";
    private static final String FIELD_KEY_ADFFMINORGSELECT = "adminorgselect";
    private static final String ENTRY_ADMINORGENTRY = "adminorgentry";
    private static final String ENTRY_FIELD_ADMINORGVID = "adminorgvid";
    public static final String BTN_ADD_ORG = "btnaddorg";
    public static final String BTN_DELETE_ORG = "btndeleteorg";
    private final PermissionExternalService permissionExternalService = (PermissionExternalService)ServiceFactory.getService(PermissionExternalService.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_EVENT_NEW, KEY_EVENT_EDIT, KEY_EVENT_DELETE});
        MulBasedataEdit adminOrgHREdit = (MulBasedataEdit)this.getControl(FIELD_KEY_ADFFMINORGSELECT);
        adminOrgHREdit.addAfterF7SelectListener((AfterF7SelectListener)this);
        adminOrgHREdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        DynamicObjectCollection entryEntity = this.getKeyEventEntry();
        this.refreshTimeLines();
        this.refreshCardEntryDesc((Iterable<DynamicObject>)entryEntity);
        this.sortEntryData();
    }

    private DynamicObjectCollection getKeyEventEntry() {
        return this.getModel().getDataEntity(true).getDynamicObjectCollection("keyevententity");
    }

    private void refreshTimeLines() {
        DynamicObjectCollection keyEventEntry = this.getKeyEventEntry();
        CardEntry cardEntry = (CardEntry)this.getView().getControl("keyevententity");
        if (keyEventEntry.size() > 1) {
            cardEntry.setChildVisible(true, keyEventEntry.size() - 2, new String[]{TIME_LINES_LABEL_AP});
        }
        cardEntry.setChildVisible(false, keyEventEntry.size() - 1, new String[]{TIME_LINES_LABEL_AP});
    }

    private void refreshCardEntryDesc(Iterable<DynamicObject> collect) {
        int i = 0;
        for (DynamicObject keyEventDataEntity : collect) {
            boolean descBlank = StringUtils.isBlank((CharSequence)keyEventDataEntity.getString("eventdesc"));
            this.getKeyEventCardEntry().setChildVisible(!descBlank, i, new String[]{CARD_ENTRY_FLEX_PANEL_AP_DESC});
            ++i;
        }
    }

    private void sortEntryData() {
        DynamicObjectCollection entryEntity = this.getKeyEventEntry();
        Comparator<DynamicObject> eventDateCompare = Comparator.comparing(entryEntity1 -> entryEntity1.getDate("eventdate"), Comparator.reverseOrder());
        Comparator<DynamicObject> modifyDateCompare = Comparator.comparing(entryEntity1 -> entryEntity1.getDate("eventmodifydate"), Comparator.reverseOrder());
        List collect = entryEntity.stream().sorted(eventDateCompare.thenComparing(modifyDateCompare)).collect(Collectors.toList());
        for (int i = 0; i < collect.size(); ++i) {
            entryEntity.set(i, collect.get(i));
        }
        this.getView().updateView("keyevententity");
    }

    private CardEntry getKeyEventCardEntry() {
        return (CardEntry)this.getView().getControl("keyevententity");
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("oatr_keyeventdlg".equals(actionId) && !Objects.isNull(returnData = closedCallBackEvent.getReturnData())) {
            Map returnDataMap = (Map)returnData;
            this.setKeyEventDataToCardEntry(returnDataMap);
        }
    }

    public boolean eventDataEmpty() {
        DynamicObjectCollection keyEventEntry = this.getKeyEventEntry();
        return keyEventEntry.size() == 0;
    }

    public void eventDataFlexVisible(String dataFlex) {
        boolean dataEmpty = this.eventDataEmpty();
        this.getView().setVisible(Boolean.valueOf(!dataEmpty), new String[]{dataFlex});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        CardEntry control = (CardEntry)this.getView().getControl("keyevententity");
        DynamicObjectCollection entryEntity = this.getKeyEventEntry();
        for (int rowIndex = 0; rowIndex < entryEntity.size(); ++rowIndex) {
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(rowIndex);
            String eventDesc = dynamicObject.getString("eventdesc");
            if (StringUtils.isBlank((CharSequence)eventDesc)) {
                control.setChildVisible(Boolean.FALSE.booleanValue(), rowIndex, new String[]{CARD_ENTRY_FLEX_PANEL_AP_DESC});
                continue;
            }
            control.setChildVisible(Boolean.TRUE.booleanValue(), rowIndex, new String[]{CARD_ENTRY_FLEX_PANEL_AP_DESC});
        }
        BillShowParameter formShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        OperationStatus status = formShowParameter.getStatus();
        if (OperationStatus.VIEW == status) {
            this.hiddenEntryBtn();
        }
        this.showReviewActivityBillList(this.getView());
        this.eventDataFlexVisible(GJSJ_FLEX);
    }

    private void hiddenEntryBtn() {
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_EVENT_NEW, BTN_ADD_ORG, BTN_DELETE_ORG});
        this.visibleCardEntryBtn();
    }

    private void visibleCardEntryBtn() {
        CardEntry entry = (CardEntry)this.getControl("keyevententity");
        int size = this.getKeyEventEntry().size();
        for (int i = 0; i < size; ++i) {
            entry.setChildVisible(false, i, new String[]{KEY_EVENT_EDIT, KEY_EVENT_DELETE});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DynamicObjectCollection adminorgEntry;
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (source instanceof Save && HRCollUtil.isEmpty((Collection)(adminorgEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_ADMINORGENTRY)))) {
            String tips = ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u9002\u7528\u7ec4\u7ec7\u8303\u56f4\u201d", (String)"ReviewPlanEdit_0", (String)"tdc-oatr-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(tips);
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (KEY_EVENT_ENTRY_NEW.equals(operateKey)) {
            this.showNewKeyEventDlg();
        }
        if (KEY_EVENT_ENTRY_EDIT.equals(operateKey)) {
            this.showEditKeyEventDlg();
        }
        if (KEY_EVENT_ENTRY_DEL.equals(operateKey)) {
            this.refreshTimeLines();
        }
        if (KEY_NEW_ORG_ENTRY.equals(operateKey)) {
            MulBasedataEdit adminOrgHREdit = (MulBasedataEdit)this.getControl(FIELD_KEY_ADFFMINORGSELECT);
            MulBasedataProp mulBasedataProp = (MulBasedataProp)adminOrgHREdit.getProperty();
            mulBasedataProp.setMustInput(true);
            adminOrgHREdit.click();
            mulBasedataProp.setMustInput(false);
        }
        if ("save".equals(operateKey) && operationResult.isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
    }

    private void showNewKeyEventDlg() {
        FormShowParameter showParameter = this.getKeyEventFormParameter();
        showParameter.setCustomParam("key_event_entry_row", (Object)-1);
        this.getView().showForm(showParameter);
    }

    private void showEditKeyEventDlg() {
        FormShowParameter showParameter = this.getKeyEventFormParameter();
        int currentRowIndex = this.getModel().getEntryCurrentRowIndex("keyevententity");
        Map<String, Object> customParam = this.getCurrentRowData(currentRowIndex);
        customParam.put("key_event_entry_row", this.getModel().getEntryCurrentRowIndex("keyevententity"));
        showParameter.getCustomParams().putAll(customParam);
        showParameter.setStatus(OperationStatus.EDIT);
        this.showKeyEventDlg(showParameter);
    }

    private FormShowParameter getKeyEventFormParameter() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("oatr_keyeventdlg");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setSendToClient(true);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "oatr_keyeventdlg"));
        return showParameter;
    }

    private Map<String, Object> getCurrentRowData(int currentRowIndex) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObject curRowObj = (DynamicObject)dataEntity.getDynamicObjectCollection("keyevententity").get(currentRowIndex);
        HashMap customParam = Maps.newHashMapWithExpectedSize((int)5);
        customParam.put("eventdate", curRowObj.get("eventdate"));
        customParam.put("eventname", curRowObj.get("eventname"));
        customParam.put("eventdesc", curRowObj.get("eventdesc"));
        customParam.put("eventmodify", curRowObj.get("eventmodify"));
        customParam.put("eventmodifydate", curRowObj.get("eventmodifydate"));
        return customParam;
    }

    private void showKeyEventDlg(FormShowParameter showParameter) {
        this.getView().showForm(showParameter);
    }

    private void setKeyEventDataToCardEntry(Map<String, Object> returnDataMap) {
        int entryRow = (Integer)returnDataMap.get("key_event_entry_row");
        DynamicObject keyEventDataEntity = (DynamicObject)returnDataMap.get("key_event_data");
        int appendRowIndex = entryRow == -1 ? this.getView().getModel().createNewEntryRow("keyevententity", 0, null) : entryRow;
        this.getView().getModel().setValue("eventdate", keyEventDataEntity.get("eventdate"), appendRowIndex);
        this.getView().getModel().setValue("eventname", keyEventDataEntity.get("eventname"), appendRowIndex);
        this.getView().getModel().setValue("eventdesc", keyEventDataEntity.get("eventdesc"), appendRowIndex);
        this.getView().getModel().setValue("eventmodify", keyEventDataEntity.get("eventmodify"), appendRowIndex);
        this.getView().getModel().setValue("eventmodifydate", keyEventDataEntity.get("eventmodifydate"), appendRowIndex);
        this.refreshTimeLines();
        this.refreshCardEntryDesc((Iterable<DynamicObject>)this.getKeyEventEntry());
        this.eventDataFlexVisible(GJSJ_FLEX);
    }

    @Override
    public String getContainerKey() {
        return PDHD_FLEX;
    }

    @Override
    public String getListFilter() {
        long pk = this.getModel().getDataEntity().getLong("id");
        if (pk == 0L) {
            pk = -1L;
        }
        QFilter qFilter = new QFilter("reviewplan.id", "=", (Object)pk);
        return qFilter.toSerializedString();
    }

    public void afterF7Select(AfterF7SelectEvent afterF7SelectEvent) {
        Control source = (Control)afterF7SelectEvent.getSource();
        String key = source.getKey();
        if (FIELD_KEY_ADFFMINORGSELECT.equals(key)) {
            this.updateEntry(ENTRY_ADMINORGENTRY, ENTRY_FIELD_ADMINORGVID, key);
        }
    }

    private void updateEntry(String entry, String field, String selectF7Name) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        DynamicObjectCollection entityEntity = model.getEntityEntity(entry);
        DynamicObjectCollection adminOrgEntryDyCol = this.getModel().getDataEntity().getDynamicObjectCollection(selectF7Name);
        ArrayList orgIdList = Lists.newArrayListWithCapacity((int)adminOrgEntryDyCol.size());
        for (DynamicObject adminOrgEntryDy : adminOrgEntryDyCol) {
            DynamicObject dynamicObject = adminOrgEntryDy.getDynamicObject("fbasedataid");
            orgIdList.add(dynamicObject.getLong("id"));
        }
        if (CollectionUtils.isEmpty((Collection)entityEntity)) {
            model.deleteEntryData(entry);
            int newEntryRowCount = adminOrgEntryDyCol.size();
            if (newEntryRowCount > 0) {
                int[] newEntryRow = model.batchCreateNewEntryRow(entry, newEntryRowCount);
                model.beginInit();
                for (int i = 0; i < adminOrgEntryDyCol.size(); ++i) {
                    DynamicObject adminOrg = ((DynamicObject)adminOrgEntryDyCol.get(i)).getDynamicObject("fbasedataid");
                    model.setValue(field, (Object)adminOrg, newEntryRow[i]);
                }
                model.endInit();
                this.getView().updateView(entry);
                model.setDataChanged(Boolean.TRUE.booleanValue());
            }
        } else {
            ArrayList<Integer> deleteIndex = new ArrayList<Integer>(10);
            for (int i = 0; i < entityEntity.size(); ++i) {
                DynamicObject entryDyn = (DynamicObject)entityEntity.get(i);
                DynamicObject entryOrg = entryDyn.getDynamicObject(field);
                if (null == entryOrg || orgIdList.contains(entryOrg.getLong("id"))) continue;
                deleteIndex.add(i);
            }
            int[] delIntArrays = deleteIndex.stream().mapToInt(idx -> idx).toArray();
            model.deleteEntryRows(entry, delIntArrays);
            List entryOrgIdList = entityEntity.stream().map(entryRow -> entryRow.getDynamicObject(field).getLong("id")).collect(Collectors.toList());
            ArrayList newOrgIdList = new ArrayList(orgIdList);
            newOrgIdList.removeAll(entryOrgIdList);
            if (HRCollUtil.isNotEmpty(newOrgIdList)) {
                int newEntryRowCount = newOrgIdList.size();
                int[] newEntryRow = model.batchCreateNewEntryRow(entry, newEntryRowCount);
                for (int i = 0; i < newEntryRowCount; ++i) {
                    Long adminOrgId = (Long)newOrgIdList.get(i);
                    model.setValue(field, (Object)adminOrgId, newEntryRow[i]);
                }
            }
            model.updateEntryCache(entityEntity);
            this.getView().updateView(entry);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        if (FIELD_KEY_ADFFMINORGSELECT.equals(name)) {
            ArrayList<QFilter> f7Filters = new ArrayList<QFilter>(10);
            AuthorizedOrgResult userAdminOrgs = this.permissionExternalService.getUserAdminOrgs("oatr_reviewplans", "47150e89000000ac", ENTRY_FIELD_ADMINORGVID, (Map)Maps.newHashMapWithExpectedSize((int)0));
            if (!userAdminOrgs.isHasAllOrgPerm()) {
                List hasPermOrgIds = userAdminOrgs.getHasPermOrgs();
                f7Filters.add(new QFilter("id", "in", (Object)hasPermOrgIds));
            }
            beforeF7SelectEvent.getCustomQFilters().addAll(f7Filters);
            this.getView().getFormShowParameter().setCustomParam("customHREntityNumber", (Object)"oatr_reviewplans");
            this.getView().getFormShowParameter().setCustomParam("custom_parent_f7_prop", (Object)ENTRY_FIELD_ADMINORGVID);
            this.getView().getFormShowParameter().setCustomParam("customHRPermItemId", (Object)"47150e89000000ac");
            this.getView().cacheFormShowParameter();
            DynamicObjectCollection adminOrgEntryDyCol = this.getModel().getDataEntity().getDynamicObjectCollection(ENTRY_ADMINORGENTRY);
            ArrayList orgIdList = Lists.newArrayListWithCapacity((int)adminOrgEntryDyCol.size());
            for (DynamicObject adminOrgEntryDy : adminOrgEntryDyCol) {
                DynamicObject dynamicObject = adminOrgEntryDy.getDynamicObject(ENTRY_FIELD_ADMINORGVID);
                orgIdList.add(dynamicObject.getLong("id"));
            }
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            formShowParameter.setSelectedRows(orgIdList.toArray());
        }
    }
}

