/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.talp.mservice;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.tdc.talp.business.application.service.EntryExitPoolApplicationService;
import kd.tdc.talp.business.application.service.RecommendApplicationService;
import kd.tdc.talp.mservice.api.ILeaveExitPoolService;
import kd.tdc.tdcs.bussiness.ServiceFactory;
import kd.tdc.tdcs.bussiness.application.TalentPoolApplicationService;
import kd.tdc.tdcs.bussiness.application.external.ExternalService;
import kd.tdc.tdcs.bussiness.servicehelper.TDCConsumerServiceHelper;
import kd.tdc.tdcs.common.constants.coordination.CoordTaskStatusEnum;

public class LeaveExitPoolService
implements ILeaveExitPoolService {
    private static final Set<Long> QUIT_SET = Stream.of(1180L, 1020L).collect(Collectors.toSet());
    private static final Log LOG = LogFactory.getLog(LeaveExitPoolService.class);
    private final ExternalService externalService = (ExternalService)ServiceFactory.getServiceNoNeedRegister(ExternalService.class);
    private final EntryExitPoolApplicationService entryExitPoolApplicationService = (EntryExitPoolApplicationService)kd.tdc.talp.business.ServiceFactory.getService(EntryExitPoolApplicationService.class);
    private final RecommendApplicationService recommendApplicationService = (RecommendApplicationService)kd.tdc.talp.business.ServiceFactory.getService(RecommendApplicationService.class);
    private final TalentPoolApplicationService talentPoolApplicationService = (TalentPoolApplicationService)ServiceFactory.getServiceNoNeedRegister(TalentPoolApplicationService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consumeMsg(DynamicObject coordinationMsg, Map<String, Object> coordinationMap) {
        Map msgContent = (Map)SerializationUtils.deSerializeFromBase64((String)coordinationMsg.getString("msgcontent"));
        LOG.info("LeaveExitPoolService.consumeMsg execute info : msgContent = {}", (Object)msgContent);
        long recordId = Long.parseLong(String.valueOf(msgContent.get("recordId")));
        DLock lock = DLock.create((String)MessageFormat.format("LeaveExitPoolService_{0}", recordId));
        TXHandle txHandle = TX.required();
        try {
            if (lock.tryLock(60000L)) {
                Map perIdMap;
                Map empMap;
                Object chgCategoryIdOb = msgContent.get("chgcategoryId");
                if (chgCategoryIdOb == null || !QUIT_SET.contains(Long.parseLong(String.valueOf(chgCategoryIdOb)))) {
                    LOG.info("LeaveExitPoolService.consumeMsg execute info : chgCategoryId is not in QUIT_SET");
                    this.buildResultMap(coordinationMap, CoordTaskStatusEnum.FALSE, ResManager.loadKDString((String)"\u53d8\u52a8\u7c7b\u578b\u4e0d\u662f\u201c\u79bb\u804c\u201d\uff0c\u65e0\u9700\u5904\u7406\u3002", (String)"LeaveExitPoolService_01", (String)"tdc-talp-mservice", (Object[])new Object[0]));
                    return;
                }
                Map chgRecordIdMap = this.externalService.getPerIdByChgRecordId(Long.valueOf(recordId));
                LOG.info("LeaveExitPoolService.consumeMsg execute info : chgRecordIdMap = {}", (Object)chgRecordIdMap);
                if (CollectionUtils.isEmpty((Map)chgRecordIdMap) || !((Boolean)chgRecordIdMap.get("success")).booleanValue()) {
                    LOG.info("LeaveExitPoolService.consumeMsg execute error : errorMsg = {}", chgRecordIdMap.get("errorMsg"));
                    this.buildResultMap(coordinationMap, CoordTaskStatusEnum.FALSE, ResManager.loadKDString((String)"\u67e5\u8be2\u201c\u4eba\u4e8b\u4e8b\u52a1\u53d8\u52a8\u8bb0\u5f55\u4fe1\u606f\u201d\u5931\u8d25\u3002", (String)"LeaveExitPoolService_02", (String)"tdc-talp-mservice", (Object[])new Object[0]));
                    return;
                }
                Long employee = null;
                Map data = (Map)chgRecordIdMap.get("data");
                LOG.info("LeaveExitPoolService.consumeMsg execute info : data = {}", (Object)data);
                String billNo = (String)data.get("billNo");
                List perIdList = (List)data.get("data");
                if (!CollectionUtils.isEmpty((Collection)perIdList) && !CollectionUtils.isEmpty((Map)(empMap = (Map)(perIdMap = (Map)perIdList.get(0)).get("hrpi_employee"))) && empMap.get("boid") != null && (Long)empMap.get("boid") != 0L) {
                    employee = (Long)empMap.get("boid");
                }
                if (employee == null) {
                    LOG.info("LeaveExitPoolService.consumeMsg execute error : get employee from chgRecord fail");
                    this.buildResultMap(coordinationMap, CoordTaskStatusEnum.FALSE, ResManager.loadKDString((String)"\u4ece\u4eba\u4e8b\u4e8b\u52a1\u53d8\u52a8\u8bb0\u5f55\u4e2d\u83b7\u53d6\u201c\u4f01\u4e1a\u4eba\u4fe1\u606f\u201d\u5931\u8d25\u3002", (String)"LeaveExitPoolService_03", (String)"tdc-talp-mservice", (Object[])new Object[0]));
                    return;
                }
                this.talentPoolApplicationService.leaveExitPool(employee, billNo);
                this.recommendApplicationService.leaveIgnoreRecommend(employee);
                this.entryExitPoolApplicationService.leaveStopEntryExitBill(employee);
                this.buildResultMap(coordinationMap, CoordTaskStatusEnum.SUCCESS, ResManager.loadKDString((String)"\u79bb\u804c\u81ea\u52a8\u51fa\u6c60\u6210\u529f\u3002", (String)"LeaveExitPoolService_06", (String)"tdc-talp-mservice", (Object[])new Object[0]));
            }
        }
        catch (Exception exception) {
            txHandle.markRollback();
            this.buildResultMap(coordinationMap, CoordTaskStatusEnum.FALSE, ResManager.loadKDString((String)"\u79bb\u804c\u81ea\u52a8\u51fa\u6c60\u5931\u8d25\u3002%s", (String)"LeaveExitPoolService_04", (String)"tdc-talp-mservice", (Object[])new Object[]{exception.getMessage()}));
            LOG.error("LeaveExitPoolService. execute error coordinationMap:{} ", coordinationMap, (Object)exception);
        }
        finally {
            txHandle.close();
            lock.unlock();
            TDCConsumerServiceHelper.callBackResult((DynamicObject)coordinationMsg, coordinationMap);
        }
    }
}

